/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model.deserializers;

import com.dmi.sdccore.api.model.invoice.InvoiceType;
import com.dmi.sdccore.utils.StringUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class InvoiceTypeDeserializer
extends JsonDeserializer<InvoiceType> {
    public InvoiceType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        InvoiceType invoiceType = null;
        if (jsonParser.getCurrentToken().isNumeric()) {
            invoiceType = InvoiceType.getByValue(jsonParser.getIntValue());
        } else {
            try {
                String invoiceTypeString = jsonParser.getValueAsString();
                if (StringUtil.isNumeric(invoiceTypeString)) {
                    invoiceType = InvoiceType.getByValue(Integer.parseInt(invoiceTypeString));
                } else {
                    String typeName = StringUtils.capitalize((String)invoiceTypeString.toLowerCase());
                    invoiceType = InvoiceType.valueOf(typeName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return invoiceType;
    }
}

