/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model.deserializers;

import com.dmi.sdccore.api.model.invoice.InvoicePaymentType;
import com.dmi.sdccore.utils.StringUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class InvoicePaymentTypeDeserializer
extends JsonDeserializer<InvoicePaymentType> {
    public InvoicePaymentType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        InvoicePaymentType paymentType = null;
        if (jsonParser.getCurrentToken().isNumeric()) {
            paymentType = InvoicePaymentType.getByValue(jsonParser.getIntValue());
        } else {
            try {
                String paymentTypeString = jsonParser.getValueAsString();
                if (StringUtil.isNumeric(paymentTypeString)) {
                    paymentType = InvoicePaymentType.getByValue(Integer.parseInt(paymentTypeString));
                } else {
                    String typeName = StringUtils.capitalize((String)paymentTypeString.toLowerCase());
                    if (paymentTypeString.equalsIgnoreCase("wiretransfer")) {
                        typeName = InvoicePaymentType.WireTransfer.name();
                    } else if (paymentTypeString.equalsIgnoreCase("mobilemoney")) {
                        typeName = InvoicePaymentType.MobileMoney.name();
                    }
                    paymentType = InvoicePaymentType.valueOf(typeName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return paymentType;
    }
}

