/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model;

import java.util.HashMap;
import java.util.Map;

public enum ApiErrCode {
    OK("0000", "info"),
    PinOk("0100", "info"),
    InternetAvailable("0210", "info"),
    InternetNotAvailable("0220", "info"),
    Storage90PercentFull("1100", "warning"),
    SmartCardNotPresent("1300", "warning"),
    AuditRequired("1400", "warning"),
    PinCodeRequired("1500", "warning"),
    UndefinedWarning("1999", "warning"),
    PinNotOk("2100", "error"),
    CardLocked("2110", "error"),
    SecureElementLocked("2210", "error"),
    CardCommFailed("2220", "error"),
    CardProtocolMismatch("2230", "error"),
    InvalidTaxLabels("2310", "error"),
    DeviceNotConfigured("2400", "error"),
    FieldValueMissing("2800", "error"),
    FieldValueTooLong("2801", "error"),
    FieldValueTooShort("2802", "error"),
    InvalidFieldValueLength("2803", "error"),
    FieldValueOutOfRange("2804", "error"),
    InvalidFieldValue("2805", "error"),
    InvalidDataFormat("2806", "error"),
    ListTooLong("2807", "error"),
    ListTooShort("2808", "error"),
    UndefinedError("2999", "error"),
    SdcSerialNumberNotDefined("3200", "error"),
    SdcDateTimeNotValid("3201", "error"),
    SdcLicenseNotValid("3202", "error");

    private final String code;
    private final String type;
    private static final Map<String, ApiErrCode> byValue;

    private ApiErrCode(String code, String type) {
        this.code = code;
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public static ApiErrCode getByValue(String code) {
        return byValue.get(code);
    }

    static {
        byValue = new HashMap<String, ApiErrCode>();
        for (ApiErrCode p : ApiErrCode.values()) {
            if (byValue.put(p.getCode(), p) == null) continue;
            throw new IllegalArgumentException("duplicated value: " + p.code);
        }
    }
}

