/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.endpoints.v3;

import com.dmi.sdccore.AppSettings;
import com.dmi.sdccore.AppState;
import com.dmi.sdccore.Constants;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.api.model.ApiErrCode;
import com.dmi.sdccore.api.model.AuditPackage;
import com.dmi.sdccore.api.model.ModelError;
import com.dmi.sdccore.api.model.TaxRateGroup;
import com.dmi.sdccore.api.model.invoice.Invoice;
import com.dmi.sdccore.api.model.invoice.InvoiceRequest;
import com.dmi.sdccore.api.model.invoice.InvoiceResult;
import com.dmi.sdccore.api.model.invoice.InvoiceTransactionType;
import com.dmi.sdccore.api.model.invoice.InvoiceType;
import com.dmi.sdccore.api.model.invoice.LatestInvoice;
import com.dmi.sdccore.model.invoice.CalculatedInvoice;
import com.dmi.sdccore.model.invoice.SignInvoiceResponse;
import com.dmi.sdccore.protocols.taxapi.AuditExecutor;
import com.dmi.sdccore.protocols.taxcard.CardCommand;
import com.dmi.sdccore.protocols.taxcard.CardOpCode;
import com.dmi.sdccore.protocols.taxcard.CardResponse;
import com.dmi.sdccore.utils.ApduUtil;
import com.dmi.sdccore.utils.DateTimeUtil;
import com.dmi.sdccore.utils.FsUtil;
import com.dmi.sdccore.utils.HttpUtil;
import com.dmi.sdccore.utils.TaxReceiptUtil;
import com.dmi.sdccore.utils.TaxUtil;
import com.dmi.sdccore.utils.ValidationUtil;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="v3/invoices")
public class SdcInvoicesController {
    private static final Logger logger = LogManager.getLogger(SdcInvoicesController.class);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response signInvoice(InvoiceRequest invoiceRequest, @Context HttpHeaders httpHeaders) {
        TaxRateGroup taxRateGroup;
        logger.info("Local API-Signing Invoice");
        MultivaluedMap headers = httpHeaders.getRequestHeaders();
        List<String> acceptLanguageHttpHeaders = HttpUtil.getHttpHeaders((MultivaluedMap<String, String>)headers, "Accept-Language");
        if (acceptLanguageHttpHeaders != null && !acceptLanguageHttpHeaders.isEmpty()) {
            boolean requestedLanguageFound = false;
            for (String acceptLanguageHttpHeader : acceptLanguageHttpHeaders) {
                if (!StringUtils.isNotBlank((CharSequence)acceptLanguageHttpHeader) || !Constants.SDC_SUPPORTED_LANGUAGES.contains(acceptLanguageHttpHeader)) continue;
                requestedLanguageFound = true;
            }
            if (!requestedLanguageFound) {
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)new ModelError("Not acceptable")).build();
            }
        }
        String httpHeaderPosRequestId = HttpUtil.getHttpHeader((MultivaluedMap<String, String>)headers, "RequestId");
        AppState appState = AppState.getInstance();
        if (!appState.isCardInserted()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.SmartCardNotPresent)).build();
        }
        if (!appState.isTaxCardInfoRead()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.SmartCardNotPresent)).build();
        }
        if (!appState.isCardPinCodeEntered()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.PinCodeRequired)).build();
        }
        if (!appState.isSdcInitialized()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.DeviceNotConfigured)).build();
        }
        if (AppState.getInstance().isAuditRequired()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.SecureElementLocked)).build();
        }
        if (DateTimeUtil.isSdcDatetimeMessedUp(appState.getLastSdcTimestamp(), ZonedDateTime.now().toEpochSecond())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.SdcDateTimeNotValid)).build();
        }
        if (!appState.isSdcLicenceValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.SdcLicenseNotValid)).build();
        }
        if (!appState.isSdcSerialNumberDefined()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.SdcSerialNumberNotDefined)).build();
        }
        ModelError modelError = ValidationUtil.validateInvoiceRequest(invoiceRequest, appState.getTaxCardCertificate().getSubject().getSerialNumber());
        if (modelError.hasErrors()) {
            modelError.setMessage(Response.Status.BAD_REQUEST.toString());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)modelError).build();
        }
        if (InvoiceTransactionType.Refund.equals((Object)invoiceRequest.getTransactionType()) || InvoiceType.Copy.equals((Object)invoiceRequest.getInvoiceType())) {
            ZonedDateTime refDocDateTime = DateTimeUtil.stringToZonedDateTime(invoiceRequest.getReferentDocumentDT(), ZoneId.systemDefault());
            taxRateGroup = TaxUtil.getTaxRateGroup(AppState.getInstance().getAllTaxRateGroups(), refDocDateTime);
        } else {
            taxRateGroup = TaxUtil.getCurrentTaxRateGroup(AppState.getInstance().getAllTaxRateGroups());
        }
        if (taxRateGroup != null) {
            // empty if block
        }
        if ((modelError = ValidationUtil.validateInvoiceRequestItemsAndTaxRates(invoiceRequest, taxRateGroup)).hasErrors()) {
            modelError.setMessage(Response.Status.BAD_REQUEST.toString());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)modelError).build();
        }
        CalculatedInvoice calculatedInvoice = TaxUtil.calculateInvoice(invoiceRequest, taxRateGroup);
        calculatedInvoice.setTaxRateGroup(taxRateGroup);
        modelError = ValidationUtil.validateCalculatedInvoice(calculatedInvoice);
        if (modelError.hasErrors()) {
            modelError.setMessage(Response.Status.BAD_REQUEST.toString());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)modelError).build();
        }
        byte[] apduInvoiceRequest = ApduUtil.convertInvoiceRequestToApduBytes(invoiceRequest, calculatedInvoice, AppState.getInstance().getTaxCardCertificate().getTaxpayerTin(), ZonedDateTime.now());
        CardResponse cardResponse = CardCommand.getInstance().signInvoice(apduInvoiceRequest);
        if (CardOpCode.CardAppletNotSelected == cardResponse.getOpCode() || CardOpCode.CardSwClaNotSelected == cardResponse.getOpCode() || CardOpCode.PinVerificationRequired == cardResponse.getOpCode()) {
            CardCommand.getInstance().selectApplet();
            CardCommand.getInstance().verifyPin(AppState.getInstance().getPinCode());
            cardResponse = CardCommand.getInstance().signInvoice(apduInvoiceRequest);
        }
        if (CardOpCode.OK == cardResponse.getOpCode()) {
            try {
                SignInvoiceResponse signInvoiceResponse = TaxUtil.parseSignInvoiceCardResponse(cardResponse.getData());
                InvoiceResult invoiceResult = TaxUtil.createInvoiceResult(AppState.getInstance(), invoiceRequest, calculatedInvoice, signInvoiceResponse);
                invoiceResult.setMessages("SUCCESS");
                Invoice invoice = new Invoice(invoiceRequest, invoiceResult);
                if (!invoiceRequest.shouldOmitTextualRepresentation()) {
                    String journal = TaxReceiptUtil.createReceiptPrintout(invoice, 40);
                    invoice.getResult().setJournal(journal);
                }
                AuditPackage auditPackage = TaxUtil.createAuditPackage(invoice, appState.getAuditPublicKey());
                FsUtil.saveAuditPackage(auditPackage, appState.getTaxCardCertificate().getSubject().getSerialNumber(), (long)invoiceResult.getTotalCounter().intValue());
                logger.info("Saved: {}", (Object)invoiceResult.getInvoiceNumber());
                if (!invoiceRequest.shouldOmitTextualRepresentation()) {
                    String journal = TaxReceiptUtil.createReceiptPrintout(invoice, Integer.parseInt(AppSettings.getInstance().getPosPrinterLineWidthChars()));
                    invoice.getResult().setJournal(journal);
                }
                TaxUtil.addQRCodeToResultIfNeeded(invoice);
                int currentPercents = appState.getCardAmountPercents();
                CardCommand.getInstance().getCardAmountStatus(appState);
                if (currentPercents != appState.getCardAmountPercents()) {
                    EventManager.getInstance().postUpdateUIEvent();
                }
                AuditExecutor.getInstance().adjustAuditInterval(appState);
                if (appState.isAuditRequired()) {
                    appState.setShouldStartRemoteAuditNow(true);
                }
                AppState.getInstance().setLastInvoiceNumber(invoiceResult.getInvoiceNumber());
                FsUtil.saveLastInvoiceNumber(invoiceResult.getSignedBy(), invoiceResult.getInvoiceNumber());
                long sdcTimestampSeconds = signInvoiceResponse.getSdcDateTime().toEpochSecond();
                FsUtil.writeFile(FsUtil.FN_LAST_SDC_TIMESTAMP, String.valueOf(sdcTimestampSeconds));
                AppState.getInstance().setLastSdcTimestamp(sdcTimestampSeconds);
                logger.info("Sent to POS: {}", (Object)invoiceResult.getInvoiceNumber());
                if (StringUtils.isNotBlank((CharSequence)httpHeaderPosRequestId)) {
                    FsUtil.saveLatestInvoice(new LatestInvoice(invoiceResult.getSignedBy(), httpHeaderPosRequestId, invoiceResult));
                    return Response.ok((Object)invoiceResult).header("RequestId", (Object)httpHeaderPosRequestId).build();
                }
                return Response.ok((Object)invoiceResult).build();
            }
            catch (Exception e) {
                logger.error("Sign invoice error", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.UndefinedError)).build();
            }
        }
        if (CardOpCode.AllowedPinEntriesExceeded == cardResponse.getOpCode()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.CardLocked)).build();
        }
        if (CardOpCode.PinVerificationRequired == cardResponse.getOpCode()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.PinCodeRequired)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.UndefinedError)).build();
    }

    @GET
    @Path(value="/{requestId}")
    @Produces(value={"application/json"})
    public Response getLastSignedInvoice(@PathParam(value="requestId") String requestId) throws IOException {
        LatestInvoice latestInvoice;
        AppState appState = AppState.getInstance();
        if (!appState.isCardInserted()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ModelError(Response.Status.BAD_REQUEST.name(), ApiErrCode.SmartCardNotPresent)).build();
        }
        if (!appState.isCardPinCodeEntered()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.PinCodeRequired.getCode()).build();
        }
        if (appState.isTaxCardInfoRead() && (latestInvoice = FsUtil.getLatestInvoice(requestId, appState.getTaxCardCertificate().getSubject().getSerialNumber())) != null) {
            return Response.ok().entity((Object)latestInvoice.getInvoiceResult()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ModelError("Not found")).build();
    }
}

