/*
 * Decompiled with CFR 0.152.
 */
package com.dustinredmond.fxtrayicon;

import com.dustinredmond.fxtrayicon.AWTUtils;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class FXTrayIcon {
    private final ActionListener stageShowListener = e -> {
        if (this.parentStage != null) {
            Platform.runLater(() -> ((Stage)this.parentStage).show());
        }
    };
    private final SystemTray tray;
    private Stage parentStage;
    private String appTitle;
    private final TrayIcon trayIcon;
    private final PopupMenu popupMenu = new PopupMenu();
    private boolean addExitMenuItem = false;
    private boolean addTitleMenuItem = false;
    private final boolean isMac;

    public FXTrayIcon(Stage parentStage, URL iconImagePath, int iconWidth, int iconHeight) {
        this(iconImagePath, iconWidth, iconHeight, parentStage);
    }

    public FXTrayIcon(Stage parentStage, URL iconImagePath) {
        this(iconImagePath, 16, 16, parentStage);
    }

    private FXTrayIcon(URL iconImagePath, int iconWidth, int iconHeight, Stage parentStage) {
        if (!SystemTray.isSupported()) {
            throw new UnsupportedOperationException("SystemTray icons are not supported by the current desktop environment.");
        }
        this.isMac = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
        this.tray = SystemTray.getSystemTray();
        Platform.setImplicitExit((boolean)false);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        try {
            Image iconImage = ImageIO.read(iconImagePath).getScaledInstance(iconWidth, iconHeight, 4);
            this.parentStage = parentStage;
            this.trayIcon = new TrayIcon(iconImage, parentStage.getTitle(), this.popupMenu);
        }
        catch (IOException e2) {
            throw new IllegalStateException("Unable to read the Image at the provided path.");
        }
    }

    public void show() {
        SwingUtilities.invokeLater(() -> {
            try {
                this.tray.add(this.trayIcon);
                if (this.addTitleMenuItem) {
                    String miTitle = this.appTitle != null ? this.appTitle : (this.parentStage != null && this.parentStage.getTitle() != null && !this.parentStage.getTitle().isEmpty() ? this.parentStage.getTitle() : "Show Application");
                    java.awt.MenuItem miStage = new java.awt.MenuItem(miTitle);
                    miStage.setFont(Font.decode(null).deriveFont(1));
                    miStage.addActionListener(e -> Platform.runLater(() -> {
                        if (this.parentStage != null) {
                            this.parentStage.show();
                        }
                    }));
                    this.popupMenu.insert(miStage, 0);
                }
                if (this.addExitMenuItem) {
                    java.awt.MenuItem miExit = new java.awt.MenuItem("Exit Application");
                    miExit.addActionListener(e -> {
                        this.tray.remove(this.trayIcon);
                        Platform.exit();
                    });
                    this.popupMenu.add(miExit);
                }
                this.trayIcon.addActionListener(this.stageShowListener);
            }
            catch (AWTException e2) {
                throw new IllegalStateException("Unable to add TrayIcon", e2);
            }
        });
    }

    public void setOnAction(EventHandler<ActionEvent> e) {
        if (this.trayIcon.getMouseListeners().length >= 1) {
            this.trayIcon.removeMouseListener(this.trayIcon.getMouseListeners()[0]);
        }
        this.trayIcon.addMouseListener(this.getPrimaryClickListener(e));
    }

    public void addExitItem(boolean addExitMenuItem) {
        this.addExitMenuItem = addExitMenuItem;
    }

    public void addTitleItem(boolean addTitleMenuItem) {
        this.addTitleMenuItem = addTitleMenuItem;
    }

    public void removeMenuItem(int index) {
        EventQueue.invokeLater(() -> this.popupMenu.remove(index));
    }

    public void removeMenuItem(MenuItem fxMenuItem) {
        EventQueue.invokeLater(() -> {
            java.awt.MenuItem toBeRemoved = null;
            for (int i = 0; i < this.popupMenu.getItemCount(); ++i) {
                java.awt.MenuItem awtItem = this.popupMenu.getItem(i);
                if (!awtItem.getLabel().equals(fxMenuItem.getText()) && !awtItem.getName().equals(fxMenuItem.getText())) continue;
                toBeRemoved = awtItem;
            }
            if (toBeRemoved != null) {
                this.popupMenu.remove(toBeRemoved);
            }
        });
    }

    public void addSeparator() {
        EventQueue.invokeLater(this.popupMenu::addSeparator);
    }

    public void insertSeparator(int index) {
        EventQueue.invokeLater(() -> this.popupMenu.insertSeparator(index));
    }

    public void addMenuItem(MenuItem menuItem) {
        EventQueue.invokeLater(() -> {
            if (menuItem instanceof Menu) {
                this.addMenu((Menu)menuItem);
                return;
            }
            if (this.isNotUnique(menuItem)) {
                throw new UnsupportedOperationException("Menu Item labels must be unique.");
            }
            this.popupMenu.add(AWTUtils.convertFromJavaFX(menuItem));
        });
    }

    public void insertMenuItem(MenuItem menuItem, int index) {
        EventQueue.invokeLater(() -> {
            if (this.isNotUnique(menuItem)) {
                throw new UnsupportedOperationException("Menu Item labels must be unique.");
            }
            this.popupMenu.insert(AWTUtils.convertFromJavaFX(menuItem), index);
        });
    }

    public java.awt.MenuItem getMenuItem(int index) {
        return this.popupMenu.getItem(index);
    }

    public void setTrayIconTooltip(String tooltip) {
        EventQueue.invokeLater(() -> this.trayIcon.setToolTip(tooltip));
    }

    public void setApplicationTitle(String title) {
        this.appTitle = title;
    }

    public void hide() {
        EventQueue.invokeLater(() -> {
            this.tray.remove(this.trayIcon);
            Platform.setImplicitExit((boolean)true);
        });
    }

    public boolean isMenuShowing() {
        Iterator it = Arrays.stream(this.tray.getTrayIcons()).iterator();
        while (it.hasNext()) {
            TrayIcon ti = (TrayIcon)it.next();
            if (!ti.equals(this.trayIcon)) continue;
            return ti.getPopupMenu().isEnabled();
        }
        return false;
    }

    public boolean isShowing() {
        return Arrays.stream(this.tray.getTrayIcons()).collect(Collectors.toList()).contains(this.trayIcon);
    }

    public void showInfoMessage(String title, String message) {
        if (this.isMac) {
            this.showMacAlert(title, message, "Information");
        } else {
            EventQueue.invokeLater(() -> this.trayIcon.displayMessage(title, message, TrayIcon.MessageType.INFO));
        }
    }

    public void showInfoMessage(String message) {
        this.showInfoMessage(null, message);
    }

    public void showWarningMessage(String title, String message) {
        if (this.isMac) {
            this.showMacAlert(title, message, "Warning");
        } else {
            EventQueue.invokeLater(() -> this.trayIcon.displayMessage(title, message, TrayIcon.MessageType.WARNING));
        }
    }

    public void showWarningMessage(String message) {
        this.showWarningMessage(null, message);
    }

    public void showErrorMessage(String title, String message) {
        if (this.isMac) {
            this.showMacAlert(title, message, "Error");
        } else {
            EventQueue.invokeLater(() -> this.trayIcon.displayMessage(title, message, TrayIcon.MessageType.ERROR));
        }
    }

    public void showErrorMessage(String message) {
        this.showErrorMessage(null, message);
    }

    public void showMessage(String title, String message) {
        if (this.isMac) {
            this.showMacAlert(title, message, "Message");
        } else {
            EventQueue.invokeLater(() -> this.trayIcon.displayMessage(title, message, TrayIcon.MessageType.NONE));
        }
    }

    public void showMessage(String message) {
        this.showMessage(null, message);
    }

    public void clear() {
        EventQueue.invokeLater(this.popupMenu::removeAll);
    }

    public static boolean isSupported() {
        return Desktop.isDesktopSupported() && SystemTray.isSupported();
    }

    public int getMenuItemCount() {
        return this.popupMenu.getItemCount();
    }

    public void setGraphic(javafx.scene.image.Image img) {
        BufferedImage bufferedImage = SwingFXUtils.fromFXImage((javafx.scene.image.Image)img, null);
        this.trayIcon.setImage(bufferedImage);
    }

    public void setTooltip(String tooltip) {
        this.trayIcon.setToolTip(tooltip);
    }

    private void showMacAlert(String subTitle, String message, String title) {
        String execute = String.format("display notification \"%s\" with title \"%s\" subtitle \"%s\"", message != null ? message : "", title != null ? title : "", subTitle != null ? subTitle : "");
        try {
            Runtime.getRuntime().exec(new String[]{"osascript", "-e", execute});
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot run osascript with given parameters.");
        }
    }

    private void addMenu(Menu menu) {
        EventQueue.invokeLater(() -> {
            java.awt.Menu awtMenu = new java.awt.Menu(menu.getText());
            menu.getItems().forEach(subItem -> awtMenu.add(AWTUtils.convertFromJavaFX(subItem)));
            this.popupMenu.add(awtMenu);
        });
    }

    private boolean isNotUnique(MenuItem fxItem) {
        boolean result = true;
        for (int i = 0; i < this.popupMenu.getItemCount(); ++i) {
            if (!this.popupMenu.getItem(i).getLabel().equals(fxItem.getText())) continue;
            result = false;
            break;
        }
        return !result;
    }

    private MouseListener getPrimaryClickListener(final EventHandler<ActionEvent> e) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Platform.runLater(() -> e.handle((Event)new ActionEvent()));
            }

            @Override
            public void mousePressed(MouseEvent ignored) {
            }

            @Override
            public void mouseReleased(MouseEvent ignored) {
            }

            @Override
            public void mouseEntered(MouseEvent ignored) {
            }

            @Override
            public void mouseExited(MouseEvent ignored) {
            }
        };
    }
}

