/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.HashMap;
import java.util.jar.JarFile;
import sun.net.util.URLUtil;
import sun.net.www.protocol.jar.URLJarFile;

class JarFileFactory
implements URLJarFile.URLJarFileCloseController {
    private static final HashMap<String, JarFile> fileCache = new HashMap();
    private static final HashMap<JarFile, URL> urlCache = new HashMap();
    private static final JarFileFactory instance = new JarFileFactory();

    private JarFileFactory() {
    }

    public static JarFileFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URLConnection getConnection(JarFile jarFile) throws IOException {
        URL uRL;
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            uRL = urlCache.get(jarFile);
        }
        if (uRL != null) {
            return uRL.openConnection();
        }
        return null;
    }

    public JarFile get(URL uRL) throws IOException {
        return this.get(uRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarFile getOrCreate(URL uRL, boolean bl) throws IOException {
        JarFile jarFile;
        if (!bl) {
            return this.get(uRL, false);
        }
        URL uRL2 = this.urlFor(uRL);
        if (!URLJarFile.isFileURL(uRL2)) {
            return this.get(uRL, bl);
        }
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            jarFile = this.getCachedJarFile(uRL2);
        }
        if (jarFile == null) {
            jarFile = URLJarFile.getJarFile(uRL2, this);
        }
        if (jarFile == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeIfNotCached(URL uRL, JarFile jarFile) throws IOException {
        JarFile jarFile2;
        uRL = this.urlFor(uRL);
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            jarFile2 = this.getCachedJarFile(uRL);
        }
        if (jarFile2 != jarFile) {
            jarFile.close();
        }
        return jarFile2 != jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cacheIfAbsent(URL uRL, JarFile jarFile) {
        JarFile jarFile2;
        try {
            uRL = this.urlFor(uRL);
        }
        catch (IOException iOException) {
            return false;
        }
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            String string = URLUtil.urlNoFragString(uRL);
            jarFile2 = fileCache.get(string);
            if (jarFile2 == null) {
                fileCache.put(string, jarFile);
                urlCache.put(jarFile, uRL);
            }
        }
        return jarFile2 == null || jarFile2 == jarFile;
    }

    private URL urlFor(URL uRL) throws IOException {
        String string;
        if (uRL.getProtocol().equalsIgnoreCase("file") && (string = uRL.getHost()) != null && !string.equals("") && !string.equalsIgnoreCase("localhost")) {
            uRL = new URL("file", "", "//" + string + uRL.getPath());
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarFile get(URL uRL, boolean bl) throws IOException {
        JarFile jarFile;
        uRL = this.urlFor(uRL);
        if (bl) {
            JarFileFactory jarFileFactory = instance;
            synchronized (jarFileFactory) {
                jarFile = this.getCachedJarFile(uRL);
            }
            if (jarFile == null) {
                JarFile jarFile2 = URLJarFile.getJarFile(uRL, this);
                jarFileFactory = instance;
                synchronized (jarFileFactory) {
                    jarFile = this.getCachedJarFile(uRL);
                    if (jarFile == null) {
                        fileCache.put(URLUtil.urlNoFragString(uRL), jarFile2);
                        urlCache.put(jarFile2, uRL);
                        jarFile = jarFile2;
                    } else if (jarFile2 != null) {
                        jarFile2.close();
                    }
                }
            }
        } else {
            jarFile = URLJarFile.getJarFile(uRL, this);
        }
        if (jarFile == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(JarFile jarFile) {
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            URL uRL = urlCache.remove(jarFile);
            if (uRL != null) {
                fileCache.remove(URLUtil.urlNoFragString(uRL));
            }
        }
    }

    private JarFile getCachedJarFile(URL uRL) {
        SecurityManager securityManager;
        Permission permission;
        assert (Thread.holdsLock(instance));
        JarFile jarFile = fileCache.get(URLUtil.urlNoFragString(uRL));
        if (jarFile != null && (permission = this.getPermission(jarFile)) != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
        return jarFile;
    }

    private Permission getPermission(JarFile jarFile) {
        try {
            URLConnection uRLConnection = this.getConnection(jarFile);
            if (uRLConnection != null) {
                return uRLConnection.getPermission();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

