/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import com.dmi.sdccore.utils.helpers.FileDrive;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.EnumVariant;
import com.jacob.com.JacobObject;
import com.jacob.com.Variant;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemDrives {
    private static final Logger logger = LogManager.getLogger(SystemDrives.class);

    private static <T extends Enum<T>> T fromNative(Class<T> clazz, int value) {
        for (Enum c : (Enum[])clazz.getEnumConstants()) {
            if (((HasNativeValue)((Object)c)).getNativeValue() != value) continue;
            return (T)c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileDrive> getAvailableDrives(boolean removableOnly) {
        ArrayList<FileDrive> result = new ArrayList<FileDrive>();
        ActiveXComponent axWMI = new ActiveXComponent("winmgmts://");
        try {
            Variant devices = axWMI.invoke("ExecQuery", new Variant[]{new Variant((Object)"Select DeviceID,VolumeName,DriveType,FileSystem from Win32_LogicalDisk")});
            EnumVariant deviceList = new EnumVariant(devices.toDispatch());
            while (deviceList.hasMoreElements()) {
                Dispatch item = deviceList.nextElement().toDispatch();
                String drive = Dispatch.call((Dispatch)item, (String)"DeviceID").toString().toUpperCase();
                String name = Dispatch.call((Dispatch)item, (String)"VolumeName").toString().toUpperCase();
                String rootPath = drive + File.separator;
                DriveTypeEnum driveType = SystemDrives.fromNative(DriveTypeEnum.class, Dispatch.call((Dispatch)item, (String)"DriveType").getInt());
                String fileSystem = Dispatch.call((Dispatch)item, (String)"FileSystem").toString();
                FileDrive fileDrive = new FileDrive(name, rootPath, driveType != null ? driveType.name() : "", fileSystem);
                fileDrive.setRemovable(fileDrive.getDriveType().toLowerCase().contains("removable"));
                if (removableOnly) {
                    if (!fileDrive.isRemovable()) continue;
                    result.add(fileDrive);
                    continue;
                }
                result.add(fileDrive);
            }
            ArrayList<FileDrive> arrayList = result;
            return arrayList;
        }
        catch (Exception exc) {
            logger.error("getAvailableDrives", (Throwable)exc);
        }
        finally {
            SystemDrives.closeQuietly((JacobObject)axWMI);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRemovableDrivePresent() {
        ActiveXComponent axWMI = new ActiveXComponent("winmgmts://");
        try {
            Variant devices = axWMI.invoke("ExecQuery", new Variant[]{new Variant((Object)"Select DriveType from Win32_LogicalDisk")});
            EnumVariant deviceList = new EnumVariant(devices.toDispatch());
            while (deviceList.hasMoreElements()) {
                Dispatch item = deviceList.nextElement().toDispatch();
                int driveType = Dispatch.call((Dispatch)item, (String)"DriveType").getInt();
                if (driveType != 2) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exc) {
            logger.error("isRemovableDrivePresent", (Throwable)exc);
        }
        finally {
            SystemDrives.closeQuietly((JacobObject)axWMI);
        }
        return false;
    }

    private static void closeQuietly(JacobObject jacobObject) {
        try {
            jacobObject.safeRelease();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static enum DriveTypeEnum implements HasNativeValue
    {
        Unknown(0),
        NoRootDirectory(1),
        RemovableDisk(2),
        LocalDisk(3),
        NetworkDrive(4),
        CompactDisc(5),
        RAMDisk(6);

        public final int nativeValue;

        private DriveTypeEnum(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        @Override
        public int getNativeValue() {
            return this.nativeValue;
        }
    }

    public static interface HasNativeValue {
        public int getNativeValue();
    }
}

