/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateTimeUtil {
    private static final Logger logger = LogManager.getLogger(DateTimeUtil.class);
    public static final String FILE_NAME_DATE_TIME_FORMAT = "ddMMyyyy_HHmmss";
    public static DateTimeFormatter ZONED_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("[yyyy-MM-dd'T'HH:mm:ssZ][yyyy-MM-dd HH:mm:ssZ]");
    public static DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("[yyyy-MM-dd'T'HH:mm:ss][yyyy-MM-dd HH:mm:ss]");
    private static final long ALLOWED_SDC_TIME_DIFF_SECONDS = 14400L;

    public static LocalDateTime dateToLocalDateTime(Date dateToConvert) {
        return Instant.ofEpochMilli(dateToConvert.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static boolean isValidLocalDateTime(String localDateTimeAsString) {
        try {
            LocalDateTime.parse(localDateTimeAsString, LOCAL_DATE_TIME_FORMATTER);
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean isValidZonedDateTime(String zonedDateTimeAsString) {
        try {
            ZonedDateTime.parse(zonedDateTimeAsString);
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static ZonedDateTime toZonedDateTime(String localDateTimeAsString, ZoneId zoneId) {
        LocalDateTime ldt = LocalDateTime.parse(localDateTimeAsString);
        return ldt.atZone(zoneId);
    }

    public static ZonedDateTime toZonedUtcDateTime(String localDateTimeAsString) {
        return DateTimeUtil.toZonedDateTime(localDateTimeAsString, ZoneId.of("UTC"));
    }

    public static ZonedDateTime stringToZonedDateTime(String dateTimeAsString, ZoneId zoneId) {
        if (DateTimeUtil.isValidLocalDateTime(dateTimeAsString)) {
            LocalDateTime localDateTime = LocalDateTime.parse(dateTimeAsString, LOCAL_DATE_TIME_FORMATTER);
            return localDateTime.atZone(zoneId);
        }
        if (DateTimeUtil.isValidZonedDateTime(dateTimeAsString)) {
            return ZonedDateTime.parse(dateTimeAsString);
        }
        return null;
    }

    public static String toLocalDateTimeString(String dateTimeAsString, ZoneId zoneId) {
        if (DateTimeUtil.isValidLocalDateTime(dateTimeAsString)) {
            LocalDateTime localDateTime = LocalDateTime.parse(dateTimeAsString, LOCAL_DATE_TIME_FORMATTER);
            return localDateTime.format(DateTimeFormatter.ofPattern("dd.MM.yyyy. HH:mm:ss"));
        }
        if (DateTimeUtil.isValidZonedDateTime(dateTimeAsString)) {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateTimeAsString).withZoneSameInstant(zoneId);
            return zonedDateTime.toLocalDateTime().format(DateTimeFormatter.ofPattern("dd.MM.yyyy. HH:mm:ss"));
        }
        return "";
    }

    public static String toReceiptDateTimeString(String dateTimeAsString) {
        return DateTimeUtil.toLocalDateTimeString(dateTimeAsString, ZoneId.systemDefault());
    }

    public static String toReceiptDateTimeString(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern("dd.MM.yyyy. HH:mm:ss"));
    }

    public static String toFileNameDateTimeString(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern(FILE_NAME_DATE_TIME_FORMAT));
    }

    public static String toFormattedString(ZonedDateTime zonedDateTime, String pattern) {
        return zonedDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String toFormattedString(ZonedDateTime zonedDateTime) {
        return DateTimeUtil.toFormattedString(zonedDateTime, "yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public static boolean isSdcDatetimeMessedUp(long previousInSeconds, long currentInSeconds) {
        boolean messedUp;
        boolean bl = messedUp = previousInSeconds - currentInSeconds > 14400L;
        if (messedUp) {
            logger.info("SDC time messed up: current={}, previous={}", (Object)currentInSeconds, (Object)previousInSeconds);
        }
        return messedUp;
    }
}

