/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.ui;

import com.dmi.sdccore.I18N;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;

public class UiUtil {
    public static int DEFAULT_ICON_SIZE = 16;

    public static TextFlow createLabelAndValue(String label, String value) {
        TextFlow textFlow = new TextFlow();
        Text labelText = new Text(label + ": ");
        labelText.setStyle("-fx-font-weight: bold;");
        Text valueText = new Text(value);
        valueText.setStyle("-fx-font-weight: normal;");
        textFlow.getChildren().addAll((Object[])new Node[]{labelText, valueText});
        return textFlow;
    }

    public static VBox createLabelAndValueVer2(String labelText, String valueText) {
        VBox vBox = new VBox(3.0);
        Text label = UiUtil.createLabelBold(labelText);
        Text value = UiUtil.createValueNormal(valueText);
        vBox.getChildren().addAll((Object[])new Node[]{label, value});
        vBox.setAlignment(Pos.CENTER);
        return vBox;
    }

    public static Glyph createIcon(FontAwesome.Glyph fontAwesomeGlyph, Color color, int fontSize) {
        Glyph glyph = new FontAwesome().create((Enum)fontAwesomeGlyph);
        glyph.setColor(color);
        glyph.setFontSize((double)fontSize);
        return glyph;
    }

    public static Glyph createWarningIcon() {
        return UiUtil.createIcon(FontAwesome.Glyph.WARNING, Color.ORANGERED, DEFAULT_ICON_SIZE);
    }

    public static Glyph createInfoIcon() {
        return UiUtil.createIcon(FontAwesome.Glyph.INFO_CIRCLE, Color.BLUE, DEFAULT_ICON_SIZE);
    }

    public static Glyph createBooleanIcon(boolean isTrue) {
        FontAwesome.Glyph fontAwesomeGlyph = isTrue ? FontAwesome.Glyph.CHECK : FontAwesome.Glyph.TIMES;
        Color color = isTrue ? Color.GREEN : Color.RED;
        return UiUtil.createIcon(fontAwesomeGlyph, color, DEFAULT_ICON_SIZE);
    }

    public static Text createLabelBold(String text) {
        return UiUtil.createTextShape(text, "-fx-font-weight: bold;");
    }

    public static Text createValueNormal(String text) {
        return UiUtil.createTextShape(text, "-fx-font-weight: normal;");
    }

    public static Text createTextShape(String value, String fxStyle) {
        Text textShape = new Text(value);
        textShape.setStyle(fxStyle);
        return textShape;
    }

    public static Alert createAlertDialog(Alert.AlertType type, String title, String headerText, String contentText) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        if (type != null) {
            alert.setAlertType(type);
        }
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().add((Object)new Image(UiUtil.class.getResource("/com/dmi/sdccore/logo.png").toString()));
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        alert.setContentText(contentText);
        alert.getDialogPane().getStyleClass().add((Object)"root");
        alert.getDialogPane().getStylesheets().add((Object)UiUtil.class.getResource("/styles/application.css").toExternalForm());
        return alert;
    }

    public static Alert createAlertInfoDialog(String title, String headerText) {
        return UiUtil.createAlertDialog(Alert.AlertType.INFORMATION, title, headerText, null);
    }

    public static Alert createAlertInfoDialog(String headerText) {
        return UiUtil.createAlertDialog(Alert.AlertType.INFORMATION, I18N.text("text.title.info"), headerText, null);
    }

    public static Alert createAlertWarnDialog(String headerText) {
        return UiUtil.createAlertDialog(Alert.AlertType.WARNING, I18N.text("text.title.warning"), headerText, null);
    }

    public static Alert createAlertErrorDialog(String headerText) {
        return UiUtil.createAlertDialog(Alert.AlertType.ERROR, I18N.text("text.title.error"), headerText, null);
    }

    public static Alert createAlertInfoDialog(String title, String headerText, String contentText) {
        return UiUtil.createAlertDialog(Alert.AlertType.INFORMATION, title, headerText, contentText);
    }

    public static Tooltip createToolTip(String text) {
        Tooltip tooltip = new Tooltip(text);
        tooltip.setWidth(200.0);
        tooltip.setWrapText(true);
        return tooltip;
    }

    public static Alert createConfirmationDialog(String title, String headerText, String contentText) {
        return UiUtil.createAlertDialog(Alert.AlertType.CONFIRMATION, title, headerText, contentText);
    }

    public static Alert createConfirmationDialog(String headerText) {
        return UiUtil.createConfirmationDialog(I18N.text("text.title.confirmation"), headerText, null);
    }
}

