/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.ui;

import com.dmi.sdccore.AppSettings;
import com.dmi.sdccore.AppState;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.events.SystemEventType;
import com.dmi.sdccore.protocols.taxcard.CardReader;
import com.dmi.sdccore.ui.CardReaderChooser;
import com.dmi.sdccore.ui.UiUtil;
import com.dmi.sdccore.utils.FsUtil;
import com.dmi.sdccore.utils.helpers.OrderedProperties;
import com.dmi.sdccore.utils.helpers.SystemCardTerminal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;

public class SettingsDialog
extends Dialog<OrderedProperties> {
    private static final Logger logger = LogManager.getLogger(SettingsDialog.class);
    OrderedProperties currentProperties;
    OrderedProperties properties;
    TextField txtSdcSerial;
    TextField txtDefaultSmartCardReaderName;
    Spinner<Integer> spinnerPosPrinterWidthChars;
    Spinner<Integer> spinnerSdcTcpPort;
    Spinner<Integer> spinnerSdcLcdPort;
    TextField txtSdcLicense;

    public SettingsDialog(OrderedProperties currentProperties) {
        this.currentProperties = currentProperties;
        this.properties = this.copyProperties(currentProperties);
        this.initStyle(StageStyle.DECORATED);
        try {
            ((Stage)this.getDialogPane().getScene().getWindow()).getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("/com/dmi/sdccore/logo.png").toString()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getDialogPane().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/application.css").toExternalForm());
        this.setContentText(null);
        this.setHeaderText(null);
        this.setTitle(I18N.text("text.menu.item.settings"));
        try {
            this.createComponents();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createComponents() throws IOException {
        Label lblSdcSerial = new Label(I18N.text("text.label.sdcserialnumber"));
        String propertyValue = this.properties.getProperty("sdcSerialNumber");
        Glyph iconSdcSerialInfo = UiUtil.createIcon(FontAwesome.Glyph.INFO_CIRCLE, Color.ORANGERED, 20);
        iconSdcSerialInfo.setTooltip(new Tooltip(I18N.text("message.sdcserialnumber.not.editable")));
        iconSdcSerialInfo.setVisible(false);
        this.txtSdcSerial = new TextField(propertyValue);
        this.txtSdcSerial.setMaxWidth(150.0);
        if (StringUtils.isNotBlank((CharSequence)FsUtil.readLastInvoiceNumberFromFs())) {
            this.txtSdcSerial.setEditable(false);
            iconSdcSerialInfo.setVisible(true);
        }
        HBox panelSdcSerial = new HBox(5.0);
        panelSdcSerial.getChildren().addAll((Object[])new Node[]{this.txtSdcSerial, iconSdcSerialInfo});
        Label lblPosPrinterWidthChars = new Label(I18N.text("text.label.posprinterlinewidthchars"));
        propertyValue = this.properties.getProperty("posPrinterLineWidthChars");
        if (StringUtils.isBlank((CharSequence)propertyValue) || !StringUtils.isNumeric((CharSequence)propertyValue)) {
            propertyValue = "57";
        }
        this.spinnerPosPrinterWidthChars = new Spinner(1, 999, Integer.parseInt(propertyValue));
        this.spinnerPosPrinterWidthChars.setPrefWidth(75.0);
        Label lblSmartCardReaderName = new Label(I18N.text("text.label.smartcardreadername"));
        propertyValue = this.properties.getProperty("smartCardReaderName");
        this.txtDefaultSmartCardReaderName = new TextField(propertyValue);
        this.txtDefaultSmartCardReaderName.setPrefWidth(300.0);
        this.txtDefaultSmartCardReaderName.setMinWidth(300.0);
        Button btnChooseCardReader = new Button(I18N.text("text.button.choose"));
        btnChooseCardReader.setTooltip(new Tooltip(I18N.text("message.cardreader.choose")));
        btnChooseCardReader.setOnAction(e -> this.chooseCardReader());
        HBox panelCardReader = new HBox(5.0);
        panelCardReader.getChildren().addAll((Object[])new Node[]{this.txtDefaultSmartCardReaderName, btnChooseCardReader});
        Label lblSdcTcpPort = new Label(I18N.text("text.label.sdctcpport"));
        Label lcdSdcTcpPort = new Label("\u041f\u043e\u0440\u0442 \u043b\u0446\u0434");
        propertyValue = this.properties.getProperty("sdcTcpPort");
        if (StringUtils.isBlank((CharSequence)propertyValue) || !StringUtils.isNumeric((CharSequence)propertyValue)) {
            propertyValue = "8085";
        }
        this.spinnerSdcTcpPort = new Spinner(8080, 9999, Integer.parseInt(propertyValue));
        this.spinnerSdcTcpPort.setPrefWidth(75.0);
        this.spinnerSdcLcdPort = new Spinner(1, 100, 3);
        this.spinnerSdcLcdPort.setPrefWidth(75.0);
        Button btnSave = new Button(I18N.text("text.button.save.all"));
        btnSave.setTooltip(new Tooltip(I18N.text("text.tooltip.settings.save")));
        btnSave.setOnAction(e -> this.saveProperties());
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(5.0);
        int rowIndex = 0;
        gridPane.addRow(rowIndex++, new Node[]{lblSdcSerial, panelSdcSerial});
        gridPane.addRow(rowIndex++, new Node[]{lblSmartCardReaderName, panelCardReader});
        gridPane.addRow(rowIndex++, new Node[]{lblSdcTcpPort, this.spinnerSdcTcpPort});
        gridPane.addRow(rowIndex++, new Node[]{lcdSdcTcpPort, this.spinnerSdcLcdPort});
        gridPane.addRow(rowIndex++, new Node[]{lblPosPrinterWidthChars, this.spinnerPosPrinterWidthChars});
        gridPane.addRow(rowIndex++, new Node[]{new HBox(), new HBox()});
        gridPane.addRow(rowIndex++, new Node[]{btnSave, new HBox()});
        VBox vBox = new VBox(10.0);
        vBox.getChildren().addAll((Object[])new Node[]{gridPane, new Separator(), btnSave});
        this.getDialogPane().setContent((Node)vBox);
        ButtonType buttonTypeCancel = new ButtonType(I18N.text("text.button.close"), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeCancel});
        this.setResultConverter(param -> null);
    }

    private void saveProperties() {
        if (this.arePropertiesValid()) {
            this.fillPropertiesFromInputs();
            try {
                AppSettings.getInstance().setProperties(this.properties);
                AppSettings.getInstance().saveProperties();
                logger.info("Settings saved");
                AppSettings.getInstance().loadProperties();
                logger.info("Settings reloaded");
                AppState appState = AppState.getInstance();
                CardReader.getInstance().setCardTerminal(null);
                appState.setTerminalConnected(false);
                appState.clearDataOnCardRemoval();
                CardReader.getInstance().getCardPresenceNotifier().setFirstPass(true);
                EventManager.getInstance().postSystemEvent(SystemEventType.RestartApiServer);
                UiUtil.createAlertInfoDialog(I18N.text("text.title.info"), I18N.text("message.settings.saved")).showAndWait();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            UiUtil.createAlertWarnDialog(I18N.text("message.settings.not.valid")).showAndWait();
        }
    }

    private boolean arePropertiesValid() {
        boolean valid = true;
        return valid;
    }

    private void fillPropertiesFromInputs() {
        String value = this.txtSdcSerial.getText();
        this.properties.setProperty("sdcSerialNumber", value);
        value = String.valueOf(this.spinnerPosPrinterWidthChars.getValue());
        this.properties.setProperty("posPrinterLineWidthChars", value);
        value = this.txtDefaultSmartCardReaderName.getText();
        this.properties.setProperty("smartCardReaderName", value);
        value = String.valueOf(this.spinnerSdcTcpPort.getValue());
        this.properties.setProperty("sdcTcpPort", value);
        this.properties.setProperty("sdcLicense", value);
        value = String.valueOf(this.spinnerSdcLcdPort.getValue());
        this.properties.setProperty("sdcLcdPort", value);
    }

    private OrderedProperties copyProperties(OrderedProperties source) {
        OrderedProperties destination = new OrderedProperties();
        Enumeration<Object> keys = source.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            destination.setProperty(key, source.getProperty(key));
        }
        return destination;
    }

    private void chooseCardReader() {
        try {
            ArrayList<SystemCardTerminal> terminals = new ArrayList<SystemCardTerminal>();
            List<CardTerminal> cardTerminals = CardReader.getCardTerminals();
            if (!cardTerminals.isEmpty()) {
                for (CardTerminal cardTerminal : cardTerminals) {
                    terminals.add(new SystemCardTerminal(cardTerminal.getName(), cardTerminal.isCardPresent()));
                }
                Optional optSystemCardTerminal = new CardReaderChooser(terminals).showAndWait();
                optSystemCardTerminal.ifPresent(systemCardTerminal -> this.txtDefaultSmartCardReaderName.setText(systemCardTerminal.getName()));
            } else {
                UiUtil.createAlertWarnDialog(I18N.text("message.card.terminal.not.present")).showAndWait();
            }
        }
        catch (CardException e) {
            UiUtil.createAlertErrorDialog(I18N.text("message.card.terminal.list.error")).showAndWait();
        }
    }
}

