/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.ui;

import com.dmi.sdccore.I18N;
import com.dmi.sdccore.utils.helpers.FileDrive;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;

public class SelectDriveChooser
extends Dialog<FileDrive> {
    private final List<FileDrive> drives;

    public SelectDriveChooser(List<FileDrive> drives) {
        this.drives = drives;
        this.initStyle(StageStyle.DECORATED);
        try {
            ((Stage)this.getDialogPane().getScene().getWindow()).getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("/com/dmi/sdccore/logo.png").toString()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getDialogPane().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/application.css").toExternalForm());
        this.setContentText(null);
        this.setHeaderText(null);
        this.setTitle(I18N.text("text.drive.chooser.title"));
        this.createComponents();
    }

    private void createComponents() {
        Label label = new Label(I18N.text("text.drive.chooser.label"));
        ObservableList drivesList = FXCollections.observableArrayList();
        drivesList.addAll(this.drives);
        TableView tableView = new TableView(drivesList);
        TableColumn column1 = new TableColumn(I18N.text("text.drive.name"));
        column1.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        column1.setPrefWidth(150.0);
        TableColumn column2 = new TableColumn(I18N.text("text.drive.path"));
        column2.setCellValueFactory((Callback)new PropertyValueFactory("rootPath"));
        column2.setPrefWidth(150.0);
        column2.setStyle("-fx-alignment: CENTER;");
        tableView.getColumns().addAll((Object[])new TableColumn[]{column1, column2});
        tableView.setPrefHeight((double)((drivesList.size() + 2) * 24));
        tableView.getSelectionModel().selectFirst();
        this.getDialogPane().setContent((Node)new VBox(10.0, new Node[]{label, tableView}));
        ButtonType buttonTypeSelect = new ButtonType(I18N.text("text.button.confirm"));
        ButtonType buttonTypeCancel = new ButtonType(I18N.text("text.button.cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeSelect, buttonTypeCancel});
        this.setResultConverter(param -> {
            if (param == buttonTypeSelect) {
                return (FileDrive)tableView.getSelectionModel().getSelectedItem();
            }
            return null;
        });
    }
}

