/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.protocols.taxcard;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.model.TaxCardCertificate;
import com.dmi.sdccore.protocols.taxcard.CardOpCode;
import com.dmi.sdccore.protocols.taxcard.CardReader;
import com.dmi.sdccore.protocols.taxcard.CardResponse;
import com.dmi.sdccore.utils.ApduUtil;
import com.dmi.sdccore.utils.CertificateUtil;
import com.dmi.sdccore.utils.CryptoUtil;
import com.dmi.sdccore.utils.StringUtil;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CardCommand {
    private static final Logger logger = LogManager.getLogger(CardCommand.class);
    private static final CardCommand INSTANCE = new CardCommand();

    private CardCommand() {
    }

    public static CardCommand getInstance() {
        return INSTANCE;
    }

    public CardResponse selectApplet() {
        return this.sendCardCommand("00A4040010A000000748464A492D546178436F726500");
    }

    public CardResponse getCardSecureElementVersion(AppState appState) {
        CardResponse cardResponse = this.sendCardCommand("8809040000");
        if (CardOpCode.OK == cardResponse.opCode && appState != null) {
            appState.setCardApiVersion(ApduUtil.parseApiVersion(cardResponse.getData()));
        }
        return cardResponse;
    }

    public CardResponse forwardCardSecureElementDirective(byte[] directive) {
        CommandAPDU commandAPDU = new CommandAPDU(136, 64, 4, 0, directive);
        String command = Hex.encodeHexString((byte[])commandAPDU.getBytes());
        return this.sendCardCommand(command);
    }

    @Deprecated
    public CardResponse getCardAuditVersion(AppState appState) {
        CardResponse cardResponse = this.sendCardCommand("880A040000");
        if (CardOpCode.OK == cardResponse.opCode && appState != null) {
            appState.setCardAuditVersion(ApduUtil.parseApiVersion(cardResponse.getData()));
        }
        return cardResponse;
    }

    public CardResponse exportCertificate(AppState appState) throws CertificateException {
        CardResponse cardResponse = this.sendCardCommand("88040400000000");
        if (CardOpCode.OK == cardResponse.opCode && appState != null) {
            TaxCardCertificate taxCardCertificate = CertificateUtil.toTaxCardCertificate(cardResponse.getData());
            appState.setTaxCardCertificate(taxCardCertificate);
        }
        return cardResponse;
    }

    public CardResponse exportTaxCorePublicKey(AppState appState) throws Exception {
        CardResponse cardResponse = this.sendCardCommand("88070400000000");
        if (CardOpCode.OK == cardResponse.opCode && appState != null) {
            byte[] modulusBytes = ApduUtil.copyOfRange(cardResponse.getData(), 0, 256);
            byte[] exponentBytes = ApduUtil.copyOfRange(cardResponse.getData(), 256, 259);
            RSAPublicKey publicKey = (RSAPublicKey)CryptoUtil.parseRsaPublicKey(new BigInteger(Hex.encodeHexString((byte[])modulusBytes), 16), new BigInteger(Hex.encodeHexString((byte[])exponentBytes), 16));
            appState.setAuditPublicKey(publicKey);
        }
        return cardResponse;
    }

    public CardResponse exportInternalData(AppState appState) {
        CardResponse cardResponse = this.sendCardCommand("88120400000000");
        if (CardOpCode.OK != cardResponse.opCode || appState != null) {
            // empty if block
        }
        return cardResponse;
    }

    public CardResponse startAudit() {
        logger.info("Start audit APDU command");
        return this.sendCardCommand("88210400000000");
    }

    public CardResponse endAudit(byte[] endAuditApdu) {
        logger.info("End audit APDU command");
        CommandAPDU commandAPDU = new CommandAPDU(136, 32, 4, 0, endAuditApdu);
        String commandHex = Hex.encodeHexString((byte[])commandAPDU.getBytes());
        logger.info("End audit APDU command: {}", (Object)commandHex);
        CardResponse cardResponse = this.sendCardCommand(commandHex);
        return cardResponse;
    }

    public CardResponse getCardAmountStatus(AppState appState) {
        CardResponse cardResponse = this.sendCardCommand("8814040000");
        if (CardOpCode.OK == cardResponse.opCode && appState != null) {
            long maxAmountLong;
            long currentAmountLong = ApduUtil.bytesBEToLong(ApduUtil.copyOfRange(cardResponse.getData(), 0, 7), true);
            double ratio = (double)currentAmountLong / (double)(maxAmountLong = ApduUtil.bytesBEToLong(ApduUtil.copyOfRange(cardResponse.getData(), 7, 14), true));
            boolean isAuditRequired = ratio >= 1.0;
            int cardAmountPercents = (int)(ratio * 100.0);
            appState.setCardAmountPercents(cardAmountPercents);
            appState.setCardAmountPercentsMoreThen75(cardAmountPercents >= 75);
            appState.setAuditRequired(isAuditRequired);
            appState.setCardCurrentAmount(currentAmountLong);
            appState.setCardMaxAmount(maxAmountLong);
        }
        return cardResponse;
    }

    public CardResponse verifyPin(String cardPinCode) {
        if (!StringUtil.isNumeric(cardPinCode)) {
            return new CardResponse(CardOpCode.WrongPinSize, null);
        }
        byte[] pinCodeBytes = ApduUtil.getApduPin(cardPinCode);
        CommandAPDU commandAPDU = new CommandAPDU(136, 17, 4, 0, pinCodeBytes);
        String command = Hex.encodeHexString((byte[])commandAPDU.getBytes());
        return this.sendCardCommand(command);
    }

    public CardResponse signInvoice(byte[] invoiceRequestApdu) {
        CommandAPDU commandAPDU = new CommandAPDU(136, 19, 4, 0, invoiceRequestApdu);
        String command = Hex.encodeHexString((byte[])commandAPDU.getBytes());
        return this.sendCardCommand(command);
    }

    private synchronized CardResponse sendCardCommand(String commandHexString) {
        ResponseAPDU responseAPDU;
        CardResponse cardResponse = CardReader.getInstance().isCardPresent() ? ((responseAPDU = CardReader.getInstance().sendCommand(commandHexString)) != null ? new CardResponse(CardOpCode.getByCode(responseAPDU.getSW()), responseAPDU.getData()) : new CardResponse(CardOpCode.NoReply, null)) : new CardResponse(CardOpCode.CardNotPresent, null);
        if (CardOpCode.OK != cardResponse.opCode) {
            CardCommand.debug(cardResponse);
        }
        return cardResponse;
    }

    private static void debug(CardResponse cardResponse) {
        logger.error("APDU response -> Op Code: {}, len: {}, data: {}\n", (Object)cardResponse.getOpCode().name(), (Object)(cardResponse.getData() != null ? String.valueOf(cardResponse.getData().length) : ""), (Object)(cardResponse.getData() != null ? Hex.encodeHexString((byte[])cardResponse.getData()) : ""));
    }
}

