/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.protocols.sdcapi;

import com.dmi.sdccore.protocols.taxapi.model.ApiResponse;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SdcApiClient {
    private static final Logger logger = LogManager.getLogger(SdcApiClient.class);
    private static SdcApiClient instance = new SdcApiClient();
    private String sdcApiBaseUrl;
    private OkHttpClient client;

    private SdcApiClient() {
    }

    public static SdcApiClient getInstance() {
        return instance;
    }

    public void initialize(String sdcApiBaseUrl) {
        this.sdcApiBaseUrl = sdcApiBaseUrl;
        this.client = new OkHttpClient();
    }

    public ApiResponse verifyPin(String pinCode) {
        logger.info("SDC API verify pin");
        String url = this.sdcApiBaseUrl.concat("/api/v3/pin");
        RequestBody requestBody = RequestBody.create((String)pinCode, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).headers(this.createHeaders()).post(requestBody).build();
        return this.getTaxApiResponse(this.client, request);
    }

    private ApiResponse getTaxApiResponse(OkHttpClient httpClient, Request request) {
        ApiResponse response = null;
        try {
            Response serverResponse = httpClient.newCall(request).execute();
            if (200 != serverResponse.code()) {
                logger.warn("SDC Api response not OK {}", (Object)serverResponse.toString());
            }
            response = new ApiResponse(serverResponse.code(), serverResponse.body() != null ? serverResponse.body().string() : null);
            serverResponse.close();
        }
        catch (Exception exception) {
            response = new ApiResponse();
            if (exception instanceof UnknownHostException || exception instanceof SocketTimeoutException) {
                logger.warn("SDC API is not available");
            }
            logger.error("SDC API request failed: " + request.toString(), (Throwable)exception);
        }
        return response;
    }

    private Headers createHeaders() {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Host", "");
        headersMap.put("Accept", "application/json");
        headersMap.put("Content-type", "application/json");
        return Headers.of(headersMap);
    }

    private Headers createHeadersForInvoice() {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Host", "");
        headersMap.put("Accept", "application/json");
        headersMap.put("Content-type", "application/json");
        headersMap.put("RequestId", "123Unique");
        return Headers.of(headersMap);
    }

    public ApiResponse sendInvoice(String invoiceRequestJson) {
        logger.info("SDC API send invoice");
        String url = this.sdcApiBaseUrl.concat("/api/v3/invoices");
        RequestBody requestBody = RequestBody.create((String)invoiceRequestJson, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).headers(this.createHeadersForInvoice()).post(requestBody).build();
        return this.getTaxApiResponse(this.client, request);
    }
}

