/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.printimage;

import com.dmi.sdccore.printimage.SliceImage;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.image.RasterBitImageWrapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class EsPosPrinterStandardOldPrint {
    protected static final int FONT_SIZE = 24;
    protected static final int NUMBER_CHAR_SET = 30;
    public static final String FISKLANI_RACUN = "FISKALNI RA\u010cUN";
    public static final String NE_FISKLANI_RACUN = "OVO NIJE FISKALNI RA\u010cUN";
    protected static final String REFUNDACIJA = "REFUNDACIJA";

    public BufferedImage convert(String text, String endBill, int numberCharSet, EscPos escPos, String invoice, StringBuilder stringBuilder) throws Exception {
        String[] arrayAndBill = endBill.split("\n");
        String[] text_array = text.split("[\n]");
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D graphics = img.createGraphics();
        int fontSize = 24;
        if (numberCharSet <= 30) {
            fontSize = 24;
        }
        Font font = new Font("Consolas", 0, fontSize);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        int width = (int)font.getStringBounds(EsPosPrinterStandardOldPrint.getLongestLine(text_array), frc).getWidth();
        int lines = EsPosPrinterStandardOldPrint.getLineCount(text);
        BufferedImage imageBufferedImage = numberCharSet < 35 ? this.generateQRCodeImage57(arrayAndBill[0], 444, 444) : this.generateQRCodeImage(arrayAndBill[0], 450, 450);
        int hightQ = imageBufferedImage.getHeight();
        int height = fontMetrics.getHeight() * lines + hightQ;
        if (arrayAndBill.length > 3) {
            height += 70;
        }
        if (stringBuilder != null && !stringBuilder.toString().isEmpty()) {
            height += 100;
        }
        graphics.dispose();
        img = new BufferedImage(width, height - lines * 7, 2);
        graphics = img.createGraphics();
        graphics.setFont(font);
        fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.BLACK);
        graphics.setBackground(Color.WHITE);
        graphics.clearRect(0, 0, width, height);
        int y = this.drawingText(graphics, numberCharSet, text_array, lines, font, fontMetrics, 1);
        System.out.println("Vrednost 1.y je " + y);
        RasterBitImageWrapper imageWrapper = new RasterBitImageWrapper();
        imageWrapper.setJustification(EscPosConst.Justification.Center);
        int xValue = 50;
        if (numberCharSet <= 30) {
            xValue = -30;
        }
        graphics.drawImage((Image)imageBufferedImage, xValue, y - 5, null);
        graphics.drawString(arrayAndBill[1], 0, y + hightQ - 10);
        this.arrayAndBill(graphics, y, hightQ, xValue, arrayAndBill);
        System.out.println("Vrednost 2.y je " + y);
        this.avans(lines, y, hightQ, font, text_array, graphics, stringBuilder, text, fontMetrics);
        System.out.println("Vrednost 3.y je " + y + hightQ);
        System.out.println("Stampa u toku");
        int imageX = 85;
        if (numberCharSet <= 30) {
            imageX = 7;
        }
        if (stringBuilder != null && !stringBuilder.toString().isEmpty()) {
            BufferedImage image = SliceImage.getCompanyUs();
            graphics.drawImage((Image)image, imageX, y + hightQ + 80, null);
        } else {
            BufferedImage image = SliceImage.getCompanyUs();
            graphics.drawImage((Image)image, imageX, y + hightQ, null);
        }
        graphics.dispose();
        return img;
    }

    private String containttext(String[] text_array) {
        for (int i = 0; i < text_array.length; ++i) {
            if (!"PFR broj".contains(text_array[i]) && !text_array[i].contains("PFR broj")) continue;
            String red = text_array[i];
            String[] newRed = red.split(":");
            return newRed[1];
        }
        return "prazan";
    }

    public BufferedImage generateQRCodeImage1(String barcodeText, int width, int height, int margin) throws WriterException {
        QRCodeWriter barcodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
        hints.put(EncodeHintType.MARGIN, margin);
        BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, width, height, hints);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    private int drawingText(Graphics2D graphics, int numberCharSet, String[] text_array, int lines, Font font, FontMetrics fontMetrics, int y) {
        boolean fisklaniRacun = false;
        for (int i = 1; i <= lines; ++i) {
            y = fontMetrics.getAscent() * i;
            if (text_array[i - 1].contains("Ukupan iznos:")) {
                if (numberCharSet >= 40) {
                    graphics.setFont(new Font("Consolas", 1, 30));
                } else {
                    graphics.setFont(new Font("Consolas", 1, 25));
                }
                graphics.drawString(text_array[i - 1], 0, y);
                continue;
            }
            if (text_array[i - 1].contains(FISKLANI_RACUN)) {
                fisklaniRacun = true;
            }
            if (text_array[i - 1].contains(NE_FISKLANI_RACUN) && i >= 2) {
                if (numberCharSet <= 30) {
                    graphics.setFont(new Font("Consolas", 1, 26));
                } else {
                    graphics.setFont(new Font("Consolas", 1, 27));
                }
                graphics.drawString(text_array[i - 1], 0, y);
                continue;
            }
            graphics.setFont(font);
            graphics.drawString(text_array[i - 1], 0, y);
        }
        return y;
    }

    private void arrayAndBill(Graphics2D graphics, int y, int hightQ, int xValue, String[] arrayAndBill) {
        if (arrayAndBill.length == 3) {
            System.out.println("Vrednost niza je 3" + arrayAndBill[2]);
            graphics.drawString(arrayAndBill[2], xValue - 100, y + hightQ - 20);
        }
        if (arrayAndBill.length > 3) {
            y = y + hightQ - 20;
            for (int i = 2; i < arrayAndBill.length; ++i) {
                graphics.drawString(arrayAndBill[i], xValue, y);
                y += 30;
            }
        }
    }

    private void avans(int lines, int y, int hightQ, Font font, String[] text_array, Graphics2D graphics, StringBuilder stringBuilder, String text, FontMetrics fontMetrics) {
        boolean isAvans = false;
        if (stringBuilder != null && !stringBuilder.toString().isEmpty() && text != null && !text.contains(REFUNDACIJA)) {
            int z = y + hightQ;
            lines = EsPosPrinterStandardOldPrint.getLineCount(stringBuilder.toString());
            text_array = stringBuilder.toString().split("[\n]");
            for (int i = 1; i <= lines; ++i) {
                if (text_array[i - 1].contains("Ukupan iznos:")) {
                    graphics.setFont(new Font("Consolas", 1, 25));
                    graphics.drawString(text_array[i - 1], 0, y);
                    continue;
                }
                y = fontMetrics.getAscent() * i + z;
                graphics.setFont(font);
                graphics.drawString(text_array[i - 1], 0, y);
                y += 30;
            }
            isAvans = true;
            System.out.println("Usao u deo za kreiranje footera " + y);
        }
    }

    public static String getLongestLine(String[] arr) {
        String max = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (max.length() >= arr[i].length()) continue;
            max = arr[i];
        }
        return max;
    }

    public BufferedImage generateQRCodeImage(String barcodeText, int width, int height) throws Exception {
        QRCodeWriter barcodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, width, height);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public static BufferedImage generateEAN13BarcodeImage(String barcodeText, int weight, int height) throws Exception {
        BitMatrix bitMatrix = new MultiFormatWriter().encode(barcodeText, BarcodeFormat.CODE_93, weight, height);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public BufferedImage generateQRCodeImage55(String barcodeText, int width, int height) throws WriterException {
        int adjustedWidth = width;
        int adjustedHeight = height;
        QRCodeWriter barcodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, adjustedWidth, adjustedHeight);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public BufferedImage generateQRCodeImage57(String barcodeText, int width, int height) throws WriterException {
        System.out.println("Qr code 57");
        QRCodeWriter barcodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, width, height);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public static int getLineCount(String text) {
        return text.split("[\n]").length;
    }
}

