/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.endpoints.v3;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.api.model.ApiErrCode;
import com.dmi.sdccore.protocols.taxapi.OnlineStatusNotifier;
import com.dmi.sdccore.protocols.taxcard.CardCommand;
import com.dmi.sdccore.protocols.taxcard.CardOpCode;
import com.dmi.sdccore.protocols.taxcard.CardResponse;
import com.dmi.sdccore.utils.FsUtil;
import com.dmi.sdccore.utils.helpers.OrderedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="v3/pin")
public class VerifyPinController {
    private static final Logger logger = LogManager.getLogger(VerifyPinController.class);
    private static String PROPERTIES_FILE_NAME = "";

    public void saveProperties(OrderedProperties properties) throws IOException {
        File file = new File(PROPERTIES_FILE_NAME);
        logger.info("Stigao u save");
        FileOutputStream fr = new FileOutputStream(file);
        properties.store(fr, "SDC properties");
        fr.close();
    }

    public OrderedProperties loadProperties() {
        try {
            AppState appState = AppState.getInstance();
            PROPERTIES_FILE_NAME = "../" + appState.getTaxCardCertificate().getSubject().getSerialNumber() + ".properties";
            File file = new File(PROPERTIES_FILE_NAME);
            OrderedProperties properties = new OrderedProperties();
            if (file.exists()) {
                FileInputStream fi = new FileInputStream(file);
                properties.load(fi);
                fi.close();
            }
            return properties;
        }
        catch (Exception e) {
            logger.error("Dogodila se greska na citanju fajla");
            return new OrderedProperties();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public synchronized Response verifyPin(String taxCardPinCode) {
        logger.info("Local API-Verifying pin");
        AppState appState = AppState.getInstance();
        try {
            OrderedProperties properties = this.loadProperties();
            logger.info("Prosledjen pogresan treci request verify atomic ");
            if (Integer.valueOf(properties.getProperty("atomic")) >= 2) {
                logger.error("Prosledjen pogresan treci request verify");
                EventManager.getInstance().postUpdateUIEvent();
                return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.PinNotOk.getCode()).build();
            }
            logger.info("Properties " + properties.toString());
            if (properties != null && properties.getProperty("pin") == null) {
                logger.error("verify - Verovatno je prosledjen request iz aplikacije a treba prvo logovanje da bude sa lprfa" + properties.getProperty("pin") + "," + taxCardPinCode);
                int atomic = Integer.valueOf(properties.getProperty("atomic")) + 1;
                properties.setProperty("atomic", String.valueOf(atomic));
                this.saveProperties(properties);
                EventManager.getInstance().postUpdateUIEvent();
                return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.PinNotOk.getCode()).build();
            }
            if (properties != null && properties.getProperty("pin") != null && !"1".equals(properties.getProperty("pin")) && !taxCardPinCode.equals(properties.getProperty("pin"))) {
                logger.error("verify - !taxCardPinCode.equals(properties.getProperty(\"pin\")" + properties.getProperty("pin") + "," + taxCardPinCode);
                EventManager.getInstance().postUpdateUIEvent();
                return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.PinNotOk.getCode()).build();
            }
        }
        catch (Exception e) {
            logger.error("Puklo je citanje fajla");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiErrCode.PinNotOk).build();
        }
        if (!appState.isCardInserted()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.SmartCardNotPresent.getCode()).build();
        }
        if (!appState.isTaxCardInfoRead()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.CardCommFailed.getCode()).build();
        }
        if (!appState.isSdcLicenceValid()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.SdcLicenseNotValid.getCode()).build();
        }
        if (!appState.isSdcSerialNumberDefined()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.SdcSerialNumberNotDefined.getCode()).build();
        }
        CardResponse cardResponse = CardCommand.getInstance().selectApplet();
        if (CardOpCode.OK != cardResponse.getOpCode()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.CardCommFailed.getCode()).build();
        }
        cardResponse = CardCommand.getInstance().verifyPin(taxCardPinCode);
        if (CardOpCode.CardAppletNotSelected == cardResponse.getOpCode()) {
            CardCommand.getInstance().selectApplet();
            cardResponse = CardCommand.getInstance().verifyPin(taxCardPinCode);
        }
        if (CardOpCode.OK == cardResponse.getOpCode()) {
            boolean initSuccess;
            logger.info("Pin OK");
            appState.setPinCode(taxCardPinCode);
            if (appState.isSdcInitialized()) {
                EventManager.getInstance().postInfoNotification(I18N.text("message.sdc.ready.to.sign.invoices"));
                if (appState.isAuditRequired()) {
                    appState.setShouldStartRemoteAuditNow(true);
                }
                appState.setCardPinCodeEntered(true);
                EventManager.getInstance().postUpdateUIEvent();
            } else if (appState.isInternetAvailable()) {
                initSuccess = false;
                try {
                    initSuccess = OnlineStatusNotifier.initializeSDC(appState);
                }
                catch (Exception e) {
                    logger.warn("SDC init failed", (Throwable)e);
                }
                if (!initSuccess) {
                    try {
                        initSuccess = FsUtil.initializeSdcFromFs(appState);
                    }
                    catch (Exception e) {
                        logger.warn("SDC init from fs failed", (Throwable)e);
                    }
                }
                appState.setCardPinCodeEntered(true);
                if (initSuccess) {
                    EventManager.getInstance().postInfoNotification(I18N.text("message.sdc.init.success"));
                } else {
                    logger.error("PIN is valid but SDC initialization failed.");
                    EventManager.getInstance().postErrorNotification(I18N.text("message.sdc.init.failed"));
                }
            } else {
                initSuccess = false;
                try {
                    initSuccess = FsUtil.initializeSdcFromFs(appState);
                }
                catch (Exception e) {
                    logger.warn("SDC init from fs failed", (Throwable)e);
                }
                appState.setCardPinCodeEntered(true);
                if (initSuccess) {
                    EventManager.getInstance().postInfoNotification(I18N.text("message.sdc.init.success"));
                } else {
                    logger.error("PIN is valid but SDC initialization failed.");
                    EventManager.getInstance().postErrorNotification(I18N.text("message.sdc.init.failed"));
                }
            }
            OrderedProperties properties = this.loadProperties();
            logger.info("Ucitani podaci");
            if (properties != null && "1".equals(properties.getProperty("pin"))) {
                properties.setProperty("pin", taxCardPinCode);
                try {
                    this.saveProperties(properties);
                }
                catch (IOException e) {
                    logger.error("Dogodila se greska pri cuvanju ");
                }
            }
            return Response.ok((Object)ApiErrCode.PinOk.getCode()).build();
        }
        OrderedProperties properties = this.loadProperties();
        int atomic = Integer.valueOf(properties.getProperty("atomic")) + 1;
        properties.setProperty("atomic", String.valueOf(atomic));
        try {
            this.saveProperties(properties);
        }
        catch (IOException e) {
            logger.error("Dogodila se greska pri cuvanju ");
        }
        appState.setCardPinCodeEntered(false);
        appState.setPinCode(null);
        ApiErrCode errCode = CardOpCode.WrongPinCode == cardResponse.getOpCode() || CardOpCode.WrongPinSize == cardResponse.getOpCode() ? ApiErrCode.PinNotOk : (CardOpCode.AllowedPinEntriesExceeded == cardResponse.getOpCode() ? ApiErrCode.CardLocked : ApiErrCode.UndefinedError);
        logger.warn("Verify pin error: {}", (Object)errCode);
        EventManager.getInstance().postUpdateUIEvent();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)errCode.getCode()).build();
    }
}

