/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore;

import com.dmi.sdccore.AppSettings;
import com.dmi.sdccore.Constants;
import com.dmi.sdccore.api.model.ApiErrCode;
import com.dmi.sdccore.api.model.SdcStatus;
import com.dmi.sdccore.api.model.TaxCoreApiToken;
import com.dmi.sdccore.api.model.TaxCoreCommand;
import com.dmi.sdccore.api.model.TaxCoreConfiguration;
import com.dmi.sdccore.api.model.TaxRateGroup;
import com.dmi.sdccore.model.TaxCardCertificate;
import com.dmi.sdccore.utils.FsUtil;
import com.dmi.sdccore.utils.TaxUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class AppState {
    private static final AppState INSTANCE = new AppState();
    private boolean isMessageFile;
    TaxCardCertificate taxCardCertificate;
    private String cardApiVersion;
    private String cardAuditVersion;
    private long cardCurrentAmount;
    private long cardMaxAmount;
    private boolean auditRequired;
    int cardAmountPercents;
    private boolean cardAmountPercentsMoreThen75;
    private boolean shouldStartRemoteAuditNow = false;
    private RSAPublicKey auditPublicKey;
    private boolean terminalConnected = false;
    private boolean cardInserted = false;
    private boolean taxCardInfoRead = false;
    private boolean cardPinCodeEntered = false;
    private String pinCode;
    private boolean taxApiSslInitialized = false;
    private boolean operationInProgress = false;
    private boolean auditInProgress = false;
    private long lastRemoteAuditStartTime = 0L;
    private boolean internetAvailable = true;
    private boolean externalDiskPresent = false;
    TaxCoreConfiguration taxCoreConfiguration;
    TaxCoreApiToken taxCoreApiToken;
    List<TaxCoreCommand> latestTaxCoreCommands;
    List<TaxRateGroup> allTaxRateGroups;
    String taxCoreVerificationUrl;
    String ntpServerUrl;
    private String lastInvoiceNumber;
    private long lastSdcTimestamp = 0L;
    ByteArrayOutputStream secureKeyStoreOutputStream;
    byte[] secureKeyStoreByteArray;

    private AppState() {
    }

    public static AppState getInstance() {
        return INSTANCE;
    }

    public boolean isTerminalConnected() {
        return this.terminalConnected;
    }

    public void setTerminalConnected(boolean terminalConnected) {
        this.terminalConnected = terminalConnected;
    }

    public boolean isCardInserted() {
        return this.cardInserted;
    }

    public void setCardInserted(boolean cardInserted) {
        this.cardInserted = cardInserted;
    }

    public boolean isTaxCardInfoRead() {
        return this.taxCardInfoRead;
    }

    public void setTaxCardInfoRead(boolean taxCardInfoRead) {
        this.taxCardInfoRead = taxCardInfoRead;
    }

    public boolean isCardPinCodeEntered() {
        return this.cardPinCodeEntered;
    }

    public void setCardPinCodeEntered(boolean cardPinCodeEntered) {
        this.cardPinCodeEntered = cardPinCodeEntered;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public boolean isTaxApiSslInitialized() {
        return this.taxApiSslInitialized;
    }

    public void setTaxApiSslInitialized(boolean taxApiSslInitialized) {
        this.taxApiSslInitialized = taxApiSslInitialized;
    }

    public boolean isOperationInProgress() {
        return this.operationInProgress;
    }

    public void setOperationInProgress(boolean operationInProgress) {
        this.operationInProgress = operationInProgress;
    }

    public boolean isAuditInProgress() {
        return this.auditInProgress;
    }

    public void setAuditInProgress(boolean auditInProgress) {
        this.auditInProgress = auditInProgress;
    }

    public boolean isInternetAvailable() {
        return this.internetAvailable;
    }

    public boolean isExternalDiskPresent() {
        return this.externalDiskPresent;
    }

    public void setExternalDiskPresent(boolean externalDiskPresent) {
        this.externalDiskPresent = externalDiskPresent;
    }

    public void setInternetAvailable(boolean internetAvailable) {
        this.internetAvailable = internetAvailable;
    }

    public long getLastRemoteAuditStartTime() {
        return this.lastRemoteAuditStartTime;
    }

    public void setLastRemoteAuditStartTime(long lastRemoteAuditStartTime) {
        this.lastRemoteAuditStartTime = lastRemoteAuditStartTime;
        try {
            FsUtil.writeFile(FsUtil.FN_LAST_REMOTE_AUDIT_TIME, String.valueOf(lastRemoteAuditStartTime));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TaxCardCertificate getTaxCardCertificate() {
        return this.taxCardCertificate;
    }

    public void setTaxCardCertificate(TaxCardCertificate taxCardCertificate) {
        this.taxCardCertificate = taxCardCertificate;
    }

    public String getCardApiVersion() {
        return this.cardApiVersion;
    }

    public void setCardApiVersion(String cardApiVersion) {
        this.cardApiVersion = cardApiVersion;
    }

    public String getCardAuditVersion() {
        return this.cardAuditVersion;
    }

    public void setCardAuditVersion(String cardAuditVersion) {
        this.cardAuditVersion = cardAuditVersion;
    }

    public long getCardCurrentAmount() {
        return this.cardCurrentAmount;
    }

    public void setCardCurrentAmount(long cardCurrentAmount) {
        this.cardCurrentAmount = cardCurrentAmount;
    }

    public long getCardMaxAmount() {
        return this.cardMaxAmount;
    }

    public void setCardMaxAmount(long cardMaxAmount) {
        this.cardMaxAmount = cardMaxAmount;
    }

    public boolean isAuditRequired() {
        return this.auditRequired;
    }

    public void setAuditRequired(boolean auditRequired) {
        this.auditRequired = auditRequired;
    }

    public int getCardAmountPercents() {
        return this.cardAmountPercents;
    }

    public void setCardAmountPercents(int cardAmountPercents) {
        this.cardAmountPercents = cardAmountPercents;
    }

    public boolean isCardAmountPercentsMoreThen75() {
        return this.cardAmountPercentsMoreThen75;
    }

    public void setCardAmountPercentsMoreThen75(boolean cardAmountPercentsMoreThen75) {
        this.cardAmountPercentsMoreThen75 = cardAmountPercentsMoreThen75;
    }

    public boolean isShouldStartRemoteAuditNow() {
        return this.shouldStartRemoteAuditNow;
    }

    public void setShouldStartRemoteAuditNow(boolean shouldStartRemoteAuditNow) {
        this.shouldStartRemoteAuditNow = shouldStartRemoteAuditNow;
    }

    public RSAPublicKey getAuditPublicKey() {
        return this.auditPublicKey;
    }

    public void setAuditPublicKey(RSAPublicKey auditPublicKey) {
        this.auditPublicKey = auditPublicKey;
    }

    public TaxCoreApiToken getTaxCoreApiToken() {
        return this.taxCoreApiToken;
    }

    public void setTaxCoreApiToken(TaxCoreApiToken taxCoreApiToken) {
        this.taxCoreApiToken = taxCoreApiToken;
    }

    public List<TaxCoreCommand> getLatestTaxCoreCommands() {
        return this.latestTaxCoreCommands;
    }

    public void setLatestTaxCoreCommands(List<TaxCoreCommand> latestTaxCoreCommands) {
        this.latestTaxCoreCommands = latestTaxCoreCommands;
    }

    public TaxCoreConfiguration getTaxCoreConfiguration() {
        return this.taxCoreConfiguration;
    }

    public void setTaxCoreConfiguration(TaxCoreConfiguration taxCoreConfiguration) {
        this.taxCoreConfiguration = taxCoreConfiguration;
    }

    public List<TaxRateGroup> getAllTaxRateGroups() {
        return this.allTaxRateGroups;
    }

    public void setAllTaxRateGroups(List<TaxRateGroup> allTaxRateGroups) {
        this.allTaxRateGroups = allTaxRateGroups;
    }

    public String getTaxCoreVerificationUrl() {
        return this.taxCoreVerificationUrl;
    }

    public void setTaxCoreVerificationUrl(String taxCoreVerificationUrl) {
        this.taxCoreVerificationUrl = taxCoreVerificationUrl;
    }

    public String getNtpServerUrl() {
        return this.ntpServerUrl;
    }

    public void setNtpServerUrl(String ntpServerUrl) {
        this.ntpServerUrl = ntpServerUrl;
    }

    public String getLastInvoiceNumber() {
        return this.lastInvoiceNumber;
    }

    public void setLastInvoiceNumber(String lastInvoiceNumber) {
        this.lastInvoiceNumber = lastInvoiceNumber;
    }

    public long getLastSdcTimestamp() {
        return this.lastSdcTimestamp;
    }

    public void setLastSdcTimestamp(long lastSdcTimestamp) {
        this.lastSdcTimestamp = lastSdcTimestamp;
    }

    public ByteArrayOutputStream getSecureKeyStoreOutputStream() {
        return this.secureKeyStoreOutputStream;
    }

    public void setSecureKeyStoreOutputStream(ByteArrayOutputStream secureKeyStoreOutputStream) {
        this.secureKeyStoreOutputStream = secureKeyStoreOutputStream;
    }

    public byte[] getSecureKeyStoreByteArray() {
        return this.secureKeyStoreByteArray;
    }

    public void setSecureKeyStoreByteArray(byte[] secureKeyStoreByteArray) {
        this.secureKeyStoreByteArray = secureKeyStoreByteArray;
    }

    public boolean isSdcInitialized() {
        return this.isSdcSerialNumberDefined() && this.getTaxCoreConfiguration() != null && this.getTaxCoreVerificationUrl() != null && this.getAllTaxRateGroups() != null && this.getNtpServerUrl() != null;
    }

    public void removeTaxCoreConfigurationData() {
        this.setTaxCoreConfiguration(null);
        this.setTaxCoreVerificationUrl(null);
        this.setAllTaxRateGroups(null);
        this.setNtpServerUrl(null);
    }

    public void clearDataOnCardRemoval() {
        this.setCardInserted(false);
        this.setTaxCardInfoRead(false);
        this.setCardPinCodeEntered(false);
        this.setPinCode(null);
        this.setTaxCoreApiToken(null);
        this.removeTaxCoreConfigurationData();
        this.setTaxApiSslInitialized(false);
        this.setSecureKeyStoreOutputStream(null);
        this.setSecureKeyStoreByteArray(null);
        this.setTaxCardCertificate(null);
        this.setCardApiVersion(null);
        this.setAuditRequired(false);
    }

    public boolean isSdcSerialNumberDefined() {
        return StringUtils.isNotBlank((CharSequence)AppSettings.getInstance().getSdcSerialNumber());
    }

    public boolean isSdcLicenceValid() {
        if (this.isTaxCardInfoRead()) {
            String pib = this.getTaxCardCertificate().getTaxpayerTin();
            return true;
        }
        return false;
    }

    public static synchronized SdcStatus getSdcStatus() {
        AppState appState = AppState.getInstance();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> msscErrors = new ArrayList<String>();
        if (!appState.isSdcLicenceValid()) {
            msscErrors.add(ApiErrCode.SdcLicenseNotValid.getCode());
        }
        if (!appState.isSdcSerialNumberDefined()) {
            msscErrors.add(ApiErrCode.SdcSerialNumberNotDefined.getCode());
        }
        if (!appState.isCardInserted()) {
            errors.add(ApiErrCode.SmartCardNotPresent.getCode());
        }
        if (!appState.isCardPinCodeEntered()) {
            errors.add(ApiErrCode.PinCodeRequired.getCode());
        } else {
            if (!appState.isSdcInitialized()) {
                errors.add(ApiErrCode.DeviceNotConfigured.getCode());
            }
            errors.add(ApiErrCode.PinOk.getCode());
        }
        if (!appState.isInternetAvailable()) {
            errors.add(ApiErrCode.InternetNotAvailable.getCode());
        } else {
            errors.add(ApiErrCode.InternetAvailable.getCode());
        }
        if (appState.isCardAmountPercentsMoreThen75()) {
            errors.add(ApiErrCode.AuditRequired.getCode());
        }
        if (appState.isAuditRequired()) {
            errors.add(ApiErrCode.SecureElementLocked.getCode());
        }
        SdcStatus sdcStatus = new SdcStatus();
        sdcStatus.setGsc(errors);
        sdcStatus.setMssc(msscErrors);
        sdcStatus.setIsPinRequired(!appState.isCardPinCodeEntered());
        sdcStatus.setAuditRequired(appState.isCardAmountPercentsMoreThen75());
        sdcStatus.setSdcDateTime(ZonedDateTime.now());
        sdcStatus.setProtocolVersion("1.0.0.0");
        sdcStatus.setSoftwareVersion("1.1");
        sdcStatus.setHardwareVersion("");
        sdcStatus.setSecureElementVersion(appState.getCardApiVersion());
        sdcStatus.setDeviceSerialNumber(AppSettings.getInstance().getDeviceSerialNumberMrc());
        sdcStatus.setMake("Master Software doo");
        sdcStatus.setModel("Master LPFR");
        sdcStatus.setMssc(Collections.emptyList());
        sdcStatus.setSupportedLanguages(Constants.SDC_SUPPORTED_LANGUAGES);
        TaxCardCertificate taxCardCertificate = appState.getTaxCardCertificate();
        if (taxCardCertificate != null) {
            String cardSerialUid = taxCardCertificate.getSubject().getSerialNumber();
            sdcStatus.setUid(cardSerialUid);
            sdcStatus.setTaxCoreApi(taxCardCertificate.getTaxApiServerBaseUrl());
            try {
                sdcStatus.setLastInvoiceNumber(FsUtil.readLastInvoiceNumberFromFs(cardSerialUid));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        sdcStatus.setAllTaxRates(appState.getAllTaxRateGroups());
        sdcStatus.setCurrentTaxRates(TaxUtil.getCurrentTaxRateGroup(appState.getAllTaxRateGroups()));
        return sdcStatus;
    }

    public boolean isMessageFile() {
        return this.isMessageFile;
    }
}

