/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.escpos.image;

import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import java.io.ByteArrayOutputStream;

public class GraphicsImageWrapper
implements EscPosConst,
ImageWrapperInterface {
    protected EscPosConst.Justification justification = EscPosConst.Justification.Left_Default;
    protected GraphicsImageBxBy graphicsImageBxBy = GraphicsImageBxBy.Normal_Default;

    public GraphicsImageWrapper setJustification(EscPosConst.Justification justification) {
        this.justification = justification;
        return this;
    }

    public GraphicsImageWrapper setGraphicsImageBxBy(GraphicsImageBxBy graphicsImageBxBy) {
        this.graphicsImageBxBy = graphicsImageBxBy;
        return this;
    }

    @Override
    public byte[] getBytes(EscPosImage image) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(27);
        bytes.write(97);
        bytes.write(this.justification.value);
        int paramSize = image.getRasterSizeInBytes() + 10;
        int pL = paramSize & 0xFF;
        int pH = (paramSize & 0xFF00) >> 8;
        bytes.write(29);
        bytes.write(40);
        bytes.write(76);
        bytes.write(pL);
        bytes.write(pH);
        bytes.write(48);
        bytes.write(112);
        bytes.write(48);
        bytes.write(this.graphicsImageBxBy.bx);
        bytes.write(this.graphicsImageBxBy.by);
        bytes.write(49);
        int horizontalBits = image.getWidthOfImageInBits();
        int xL = horizontalBits & 0xFF;
        int xH = (horizontalBits & 0xFF00) >> 8;
        int verticalBits = image.getHeightOfImageInBits();
        int yL = verticalBits & 0xFF;
        int yH = (verticalBits & 0xFF00) >> 8;
        bytes.write(xL);
        bytes.write(xH);
        bytes.write(yL);
        bytes.write(yH);
        byte[] rasterBytes = image.getRasterBytes().toByteArray();
        bytes.write(rasterBytes, 0, rasterBytes.length);
        bytes.write(29);
        bytes.write(40);
        bytes.write(76);
        bytes.write(2);
        bytes.write(0);
        bytes.write(48);
        bytes.write(50);
        return bytes.toByteArray();
    }

    public static enum GraphicsImageBxBy {
        Normal_Default(1, 1),
        DoubleWidth(2, 1),
        DoubleHeight(1, 2),
        Quadruple(2, 2);

        public int bx;
        public int by;

        private GraphicsImageBxBy(int bx, int by) {
            this.bx = bx;
            this.by = by;
        }
    }
}

