/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtil {
    public static final int AES_BLOCK_SIZE_BITS = 128;
    public static final int AES_BLOCK_SIZE_BYTES = 16;
    public static final int AES_256_KEY_SIZE_BYTES = 32;
    public static final int AES_256_KEY_SIZE_BITS = 256;
    public static final int TAX_CARD_RSA_KEY_SIZE_BITS = 2048;

    private CryptoUtil() {
    }

    private void generateRsaKeyPairExampleUsage() throws NoSuchAlgorithmException {
        KeyPair keyPair = CryptoUtil.generateRsaKeyPair(2048);
        byte[] publicKey = keyPair.getPublic().getEncoded();
        byte[] privateKey = keyPair.getPrivate().getEncoded();
        String rsaPublicKeyBase64 = new String(Base64.getEncoder().encode(publicKey));
        String rsaPrivateKeyBase64 = new String(Base64.getEncoder().encode(privateKey));
    }

    public static KeyPair generateRsaKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(keySize);
        return keyGen.genKeyPair();
    }

    public static PublicKey parseRsaPublicKey(String base64PublicKey) throws Exception {
        byte[] publicKey = Base64.getDecoder().decode(base64PublicKey);
        return CryptoUtil.parseRsaPublicKey(publicKey);
    }

    public static PublicKey parseRsaPublicKey(BigInteger modulus, BigInteger publicExponent) throws Exception {
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, publicExponent);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    public static PublicKey parseRsaPublicKey(byte[] publicKeyBytes) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey parseRsaPrivateKey(String base64PrivateKey) throws Exception {
        byte[] privateKey = Base64.getDecoder().decode(base64PrivateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    public static byte[] decodeWithRSA(byte[] data, RSAPrivateKey rsaPrivateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, rsaPrivateKey);
        return cipher.doFinal(data);
    }

    public static byte[] encodeWithRSA(byte[] data, RSAPublicKey rsaPublicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, rsaPublicKey);
        return cipher.doFinal(data);
    }

    public static byte[] decodeWithAES(byte[] data, byte[] aesKey, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)new SecretKeySpec(aesKey, "AES"), new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    public static byte[] encodeWithAES(byte[] data, byte[] aesKey, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.getBlockSize();
        cipher.init(1, (Key)new SecretKeySpec(aesKey, "AES"), new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    public static SecretKey generateRandomAES256SecretKey() throws NoSuchAlgorithmException {
        SecureRandom rand = new SecureRandom();
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256, rand);
        return keyGen.generateKey();
    }

    public static byte[] generateRandomIVForAES() throws NoSuchAlgorithmException {
        SecureRandom randomSecureRandom = new SecureRandom();
        byte[] iv = new byte[16];
        randomSecureRandom.nextBytes(iv);
        return iv;
    }

    public static byte[] generateMD5Hash(byte[] bArray) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        return md.digest(bArray);
    }

    public static String getCustomHash(String text) {
        long hash = 11L;
        for (int i = 0; i < text.length(); ++i) {
            hash = hash * 13L + (long)text.charAt(i);
        }
        return String.valueOf(hash);
    }
}

