/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.protocols.taxapi;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.api.model.AuditDataStatus;
import com.dmi.sdccore.api.model.AuditDataStatusType;
import com.dmi.sdccore.api.model.TaxCoreApiToken;
import com.dmi.sdccore.api.model.TaxCoreCommand;
import com.dmi.sdccore.api.model.TaxCoreCommandResponse;
import com.dmi.sdccore.api.model.TaxCoreCommandType;
import com.dmi.sdccore.api.model.TaxCoreConfiguration;
import com.dmi.sdccore.api.model.TaxRateGroup;
import com.dmi.sdccore.protocols.taxapi.OnlineStatusNotifier;
import com.dmi.sdccore.protocols.taxapi.model.ApiResponse;
import com.dmi.sdccore.protocols.taxapi.model.ProofOfAuditRequest;
import com.dmi.sdccore.protocols.taxapi.model.SubmitAuditPackageResponse;
import com.dmi.sdccore.protocols.taxapi.model.TaxRates;
import com.dmi.sdccore.protocols.taxcard.CardCommand;
import com.dmi.sdccore.protocols.taxcard.CardOpCode;
import com.dmi.sdccore.protocols.taxcard.CardResponse;
import com.dmi.sdccore.ui.StatusTabPanel;
import com.dmi.sdccore.utils.FsUtil;
import com.dmi.sdccore.utils.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaxApiClient {
    private static final Logger logger = LogManager.getLogger(TaxApiClient.class);
    private static TaxApiClient instance = new TaxApiClient();
    private String taxApiBaseUrl;
    private OkHttpClient cardProtectedClient;
    private OkHttpClient client;
    OnlineStatusNotifier onlineStatusNotifier;
    private static final ConnectionPool cardProtectedConnectionPool = new ConnectionPool(2, 10L, TimeUnit.MINUTES);
    private static final ConnectionPool globalConnectionPool = new ConnectionPool(4, 10L, TimeUnit.MINUTES);

    private TaxApiClient() {
    }

    public static TaxApiClient getInstance() {
        return instance;
    }

    public void initializeCardProtectedSsl(final AppState appState) throws Exception {
        logger.info("Init card protected SSL");
        if (this.cardProtectedClient != null) {
            this.cardProtectedClient.connectionPool().evictAll();
            this.cardProtectedClient = null;
        }
        this.taxApiBaseUrl = appState.getTaxCardCertificate().getTaxApiServerBaseUrl();
        SSLContext sslContextCardProtected = SSLContext.getInstance("TLS");
        KeyStore otherKeyStore = KeyStore.getInstance("PKCS11");
        otherKeyStore.load(new ByteArrayInputStream(appState.getSecureKeyStoreByteArray()), appState.getPinCode().toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(otherKeyStore, appState.getPinCode().toCharArray());
        TrustManager[] trustManagers = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[]{appState.getTaxCardCertificate().getX509Certificate()};
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        sslContextCardProtected.init(keyManagerFactory.getKeyManagers(), trustManagers, null);
        this.cardProtectedClient = new OkHttpClient.Builder().protocols(Util.immutableListOf((Object[])new Protocol[]{Protocol.HTTP_1_1})).sslSocketFactory(sslContextCardProtected.getSocketFactory(), (X509TrustManager)trustManagers[0]).retryOnConnectionFailure(false).connectionPool(cardProtectedConnectionPool).build();
    }

    public void initializeSsl(final AppState appState) throws Exception {
        logger.info("Init SSL");
        if (this.client != null) {
            this.client.connectionPool().evictAll();
            this.client = null;
        }
        this.taxApiBaseUrl = appState.getTaxCardCertificate().getTaxApiServerBaseUrl();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagers = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[]{appState.getTaxCardCertificate().getX509Certificate()};
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        sslContext.init(null, trustManagers, null);
        this.client = new OkHttpClient.Builder().protocols(Util.immutableListOf((Object[])new Protocol[]{Protocol.HTTP_1_1})).sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]).readTimeout(15L, TimeUnit.SECONDS).retryOnConnectionFailure(false).connectTimeout(15L, TimeUnit.SECONDS).connectionPool(globalConnectionPool).build();
    }

    private ApiResponse getTaxApiResponse(OkHttpClient httpClient, Request request, AppState appState, boolean logErrors) {
        ApiResponse response = null;
        Response serverResponse = null;
        try {
            serverResponse = httpClient.newCall(request).execute();
            if (logErrors && 200 != serverResponse.code()) {
                logger.warn("Api response not OK {}", (Object)serverResponse.toString());
            }
            response = new ApiResponse(serverResponse.code(), serverResponse.body() != null ? serverResponse.body().string() : null);
            serverResponse.close();
            if (!appState.isInternetAvailable()) {
                logger.warn("Internet became available");
                EventManager.getInstance().postUpdateUIEvent();
            }
            appState.setInternetAvailable(true);
        }
        catch (Exception exception) {
            response = new ApiResponse();
            if (exception instanceof UnknownHostException || exception instanceof NoRouteToHostException || exception instanceof SocketTimeoutException) {
                if (appState.isInternetAvailable()) {
                    logger.warn("Internet (or API server) is not available");
                    logger.error("Tax API request failed: {}, error: {}", (Object)request.toString(), (Object)exception.getClass().getCanonicalName());
                    EventManager.getInstance().postUpdateUIEvent();
                }
                appState.setInternetAvailable(false);
            } else {
                logger.error("Tax API request failed: " + request.toString(), (Throwable)exception);
            }
            try {
                if (serverResponse != null) {
                    logger.info("Closing connection");
                    serverResponse.close();
                    serverResponse = null;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                if (httpClient != null) {
                    logger.info("Conn pool count: {}, idle: {}", (Object)httpClient.connectionPool().connectionCount(), (Object)httpClient.connectionPool().idleConnectionCount());
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        return response;
    }

    private ApiResponse getTaxApiResponse(OkHttpClient httpClient, Request request, AppState appState) {
        return this.getTaxApiResponse(httpClient, request, appState, true);
    }

    public ApiResponse getTaxCoreApiToken(AppState appState) throws Exception {
        logger.info("Get tax API token");
        String url = this.taxApiBaseUrl.concat("/api/v3/sdc/token");
        Request request = new Request.Builder().url(url).build();
        ApiResponse response = this.getTaxApiResponse(this.cardProtectedClient, request, appState);
        if (response == null) {
            return null;
        }
        if (200 == response.getCode()) {
            String responseBody = response.getResponseBody();
            TaxCoreApiToken taxCoreApiToken = (TaxCoreApiToken)new Gson().fromJson(responseBody, TaxCoreApiToken.class);
            String tokenDate = taxCoreApiToken.getExpiresAt();
            logger.info("Token expires at " + tokenDate);
            if (tokenDate.contains(" ")) {
                tokenDate = tokenDate.replace(" ", "T");
            }
            taxCoreApiToken.setExpiresAtDate(ZonedDateTime.parse(tokenDate));
            appState.setTaxCoreApiToken(taxCoreApiToken);
        }
        return response;
    }

    public ApiResponse getTaxRates(AppState appState) throws Exception {
        logger.info("Get tax API tax rates");
        String url = this.taxApiBaseUrl.concat("/api/v3/tax-rates");
        Request request = new Request.Builder().url(url).headers(this.createHeaders()).build();
        ApiResponse response = this.getTaxApiResponse(this.client, request, appState);
        if (response == null) {
            return null;
        }
        if (200 == response.getCode()) {
            String responseBody = response.getResponseBody();
            TaxRates taxRates = (TaxRates)JsonUtil.gsonBuilderWithZonedDtDeser.create().fromJson(responseBody, TaxRates.class);
            appState.setAllTaxRateGroups(taxRates.getAllTaxRates());
        }
        return response;
    }

    public ApiResponse getConfiguration(AppState appState) throws Exception {
        logger.info("Get tax API configuration");
        String url = this.taxApiBaseUrl.concat("/api/v3/configuration");
        Request request = new Request.Builder().url(url).headers(this.createHeaders()).build();
        ApiResponse response = this.getTaxApiResponse(this.client, request, appState);
        if (response == null) {
            return null;
        }
        if (200 == response.getCode()) {
            String responseBody = response.getResponseBody();
            TaxCoreConfiguration coreConfiguration = (TaxCoreConfiguration)new Gson().fromJson(responseBody, TaxCoreConfiguration.class);
            appState.setTaxCoreConfiguration(coreConfiguration);
            appState.setNtpServerUrl(coreConfiguration.getNtpServer());
            appState.setTaxCoreVerificationUrl(coreConfiguration.getEndpoints().get("root"));
        }
        return response;
    }

    public void initializeSdcViaTaxCoreApi(AppState appState) {
        try {
            TaxApiClient.getInstance().getEnvironments(appState);
            if (appState.isInternetAvailable()) {
                TaxApiClient.getInstance().getTaxRates(appState);
                TaxApiClient.getInstance().getConfiguration(appState);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApiResponse getEnvironments(AppState appState) throws Exception {
        logger.info("Get tax API environments");
        String url = this.taxApiBaseUrl.concat("/api/v3/environments");
        Request request = new Request.Builder().url(url).headers(this.createHeaders()).build();
        ApiResponse response = this.getTaxApiResponse(this.client, request, appState);
        if (response == null) {
            return null;
        }
        if (200 == response.getCode()) {
            String string = response.getResponseBody();
        }
        return response;
    }

    public ApiResponse getInitializationCommands(String taxApiToken, AppState appState) throws Exception {
        logger.info("Get tax API init commands");
        String url = this.taxApiBaseUrl.concat("/api/v3/sdc/commands");
        Request request = new Request.Builder().url(url).headers(this.createHeaders(taxApiToken)).build();
        ApiResponse response = this.getTaxApiResponse(this.client, request, appState);
        if (response == null) {
            return null;
        }
        if (200 == response.getCode()) {
            logger.info("SDC init OK");
            String responseBody = response.getResponseBody();
            this.executeTaxCoreCommands(responseBody, taxApiToken, appState);
        }
        return response;
    }

    public ApiResponse notifyOnlineStatus(boolean isOnline, String taxApiToken, AppState appState) throws Exception {
        String url = this.taxApiBaseUrl.concat("/api/v3/sdc/status");
        RequestBody requestBody = RequestBody.create((byte[])String.valueOf(isOnline).getBytes(StandardCharsets.UTF_8));
        Request request = new Request.Builder().url(url).headers(this.createHeaders(taxApiToken)).put(requestBody).build();
        ApiResponse response = this.getTaxApiResponse(this.client, request, appState, false);
        if (response == null) {
            return null;
        }
        if (200 == response.getCode()) {
            String responseBody = response.getResponseBody();
            this.executeTaxCoreCommands(responseBody, taxApiToken, appState);
        }
        return response;
    }

    public ApiResponse notifyCommandProcessed(TaxCoreCommandResponse commandResponse, String taxApiToken, AppState appState) {
        logger.info("Tax API notify command processed");
        String url = this.taxApiBaseUrl.concat("/api/v3/sdc/commands/".concat(commandResponse.getCommandId()));
        RequestBody requestBody = RequestBody.create((byte[])String.valueOf(commandResponse.getSuccess()).getBytes(StandardCharsets.UTF_8));
        Request request = new Request.Builder().url(url).headers(this.createHeaders(taxApiToken)).put(requestBody).build();
        return this.getTaxApiResponse(this.client, request, appState);
    }

    public ApiResponse submitAuditRequestPayload(ProofOfAuditRequest proofOfAuditRequest, String taxApiToken, AppState appState) throws Exception {
        logger.info("Tax API submitAuditRequestPayload");
        String url = this.taxApiBaseUrl.concat("/api/v3/sdc/audit-proof");
        String proofOfAuditRequestJson = new Gson().toJson((Object)proofOfAuditRequest);
        RequestBody requestBody = RequestBody.create((String)proofOfAuditRequestJson, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).headers(this.createHeaders(taxApiToken)).post(requestBody).build();
        return this.getTaxApiResponse(this.client, request, appState);
    }

    public SubmitAuditPackageResponse submitAuditPackage(File auditPackageFile, String taxApiToken, AppState appState) throws Exception {
        logger.info("Tax API submit audit package " + auditPackageFile.getName());
        String url = this.taxApiBaseUrl.concat("/api/v3/sdc/audit");
        byte[] fileBytes = FileUtils.readFileToByteArray((File)auditPackageFile);
        RequestBody requestBody = RequestBody.create((byte[])fileBytes);
        Request request = new Request.Builder().url(url).headers(this.createHeaders(taxApiToken)).post(requestBody).build();
        ApiResponse response = this.getTaxApiResponse(this.client, request, appState);
        if (200 == response.getCode()) {
            String responseBody = response.getResponseBody();
            AuditDataStatus auditDataStatus = (AuditDataStatus)JsonUtil.gsonBuilderWithZonedDtDeser.create().fromJson(responseBody, AuditDataStatus.class);
            if (auditDataStatus != null && AuditDataStatusType.InvoiceIsVerified.getValue() != auditDataStatus.getStatus().intValue()) {
                AuditDataStatusType auditDataStatusType = AuditDataStatusType.getByValue(auditDataStatus.getStatus());
                if (auditDataStatusType == null) {
                    logger.warn("Submit audit package error status: {} ({}) ", (Object)auditDataStatus.getStatus(), (Object)"unknown");
                } else {
                    logger.warn("Submit audit package error status: {} ({}) ", (Object)auditDataStatus.getStatus(), (Object)auditDataStatusType.name());
                }
            }
            if (auditDataStatus != null && !auditDataStatus.getCommands().isEmpty()) {
                this.executeTaxCoreCommands(auditDataStatus.getCommands(), taxApiToken, appState, true);
            }
            return new SubmitAuditPackageResponse(response.getCode(), auditDataStatus);
        }
        return new SubmitAuditPackageResponse(response.getCode(), null);
    }

    public List<TaxCoreCommandResponse> executeTaxCoreCommands(String responseBody, String taxApiToken, AppState appState, boolean onlineMode) {
        List taxCoreCommands = (List)JsonUtil.gsonBuilderWithZonedDtDeser.create().fromJson(responseBody, new TypeToken<List<TaxCoreCommand>>(){}.getType());
        return this.executeTaxCoreCommands(taxCoreCommands, taxApiToken, appState, onlineMode);
    }

    public List<TaxCoreCommandResponse> executeTaxCoreCommands(String responseBody, String taxApiToken, AppState appState) {
        return this.executeTaxCoreCommands(responseBody, taxApiToken, appState, true);
    }

    public List<TaxCoreCommandResponse> executeTaxCoreCommands(List<TaxCoreCommand> taxCoreCommands, String taxApiToken, AppState appState, boolean onlineMode) {
        if (taxCoreCommands.isEmpty()) {
            return new ArrayList<TaxCoreCommandResponse>();
        }
        logger.info("Executing tax core commands");
        ArrayList<TaxCoreCommandResponse> commandResponses = new ArrayList<TaxCoreCommandResponse>();
        appState.setLatestTaxCoreCommands(taxCoreCommands);
        for (TaxCoreCommand taxCoreCommand : taxCoreCommands) {
            CardResponse cardResponse;
            byte[] directive;
            TaxCoreCommandResponse commandResponse;
            boolean commandSuccess;
            if (TaxCoreCommandType.AllTaxRates.getValue() == taxCoreCommand.getType().intValue()) {
                commandSuccess = false;
                try {
                    List allTaxRateGroups = (List)JsonUtil.gsonBuilderWithZonedDtDeser.create().fromJson(taxCoreCommand.getPayload(), new TypeToken<List<TaxRateGroup>>(){}.getType());
                    appState.setAllTaxRateGroups(allTaxRateGroups);
                    FsUtil.writeConfigFile(taxCoreCommand.getUid(), "tc_tax_groups", taxCoreCommand.getPayload());
                    commandSuccess = true;
                }
                catch (Exception e) {
                    logger.error("Save tax rate groups error", (Throwable)e);
                }
                commandResponse = new TaxCoreCommandResponse(taxCoreCommand.getCommandId(), commandSuccess);
                commandResponses.add(commandResponse);
                if (!onlineMode) continue;
                TaxApiClient.getInstance().notifyCommandProcessed(commandResponse, taxApiToken, appState);
                continue;
            }
            if (TaxCoreCommandType.TaxCoreConfiguration.getValue() == taxCoreCommand.getType().intValue()) {
                commandSuccess = false;
                try {
                    TaxCoreConfiguration taxCoreConfiguration = (TaxCoreConfiguration)new Gson().fromJson(taxCoreCommand.getPayload(), TaxCoreConfiguration.class);
                    appState.setTaxCoreConfiguration(taxCoreConfiguration);
                    FsUtil.writeConfigFile(taxCoreCommand.getUid(), "tc_environment", taxCoreCommand.getPayload());
                    commandSuccess = true;
                }
                catch (Exception e) {
                    logger.error("Save tax core config error", (Throwable)e);
                }
                commandResponse = new TaxCoreCommandResponse(taxCoreCommand.getCommandId(), commandSuccess);
                commandResponses.add(commandResponse);
                if (!onlineMode) continue;
                TaxApiClient.getInstance().notifyCommandProcessed(commandResponse, taxApiToken, appState);
                continue;
            }
            if (TaxCoreCommandType.UpdateVerificationURL.getValue() == taxCoreCommand.getType().intValue()) {
                commandSuccess = false;
                try {
                    appState.setTaxCoreVerificationUrl(taxCoreCommand.getPayload());
                    FsUtil.writeConfigFile(taxCoreCommand.getUid(), "tc_verification_url", taxCoreCommand.getPayload());
                    commandSuccess = true;
                }
                catch (Exception e) {
                    logger.error("save verification url error", (Throwable)e);
                }
                commandResponse = new TaxCoreCommandResponse(taxCoreCommand.getCommandId(), commandSuccess);
                commandResponses.add(commandResponse);
                if (!onlineMode) continue;
                TaxApiClient.getInstance().notifyCommandProcessed(commandResponse, taxApiToken, appState);
                continue;
            }
            if (TaxCoreCommandType.UpdateNTPServiceUrl.getValue() == taxCoreCommand.getType().intValue()) {
                commandSuccess = false;
                try {
                    appState.setNtpServerUrl(taxCoreCommand.getPayload());
                    FsUtil.writeConfigFile(taxCoreCommand.getUid(), "ntp_server_url", taxCoreCommand.getPayload());
                    commandSuccess = true;
                }
                catch (Exception e) {
                    logger.error("Save NTP server URL error", (Throwable)e);
                }
                commandResponse = new TaxCoreCommandResponse(taxCoreCommand.getCommandId(), commandSuccess);
                commandResponses.add(commandResponse);
                if (!onlineMode) continue;
                TaxApiClient.getInstance().notifyCommandProcessed(commandResponse, taxApiToken, appState);
                continue;
            }
            if (TaxCoreCommandType.SecureElementCommand.getValue() == taxCoreCommand.getType().intValue()) {
                logger.info("Executing secure element command");
                commandSuccess = false;
                try {
                    directive = Base64.getDecoder().decode(taxCoreCommand.getPayload());
                    cardResponse = CardCommand.getInstance().forwardCardSecureElementDirective(directive);
                    if (CardOpCode.OK == cardResponse.getOpCode()) {
                        commandSuccess = true;
                    } else {
                        logger.warn("Secure element command failed");
                    }
                }
                catch (Exception e) {
                    logger.error("Secure element command error", (Throwable)e);
                }
                commandResponse = new TaxCoreCommandResponse(taxCoreCommand.getCommandId(), commandSuccess);
                commandResponses.add(commandResponse);
                if (!onlineMode) continue;
                TaxApiClient.getInstance().notifyCommandProcessed(commandResponse, taxApiToken, appState);
                continue;
            }
            if (TaxCoreCommandType.EndProofOfAudit.getValue() == taxCoreCommand.getType().intValue()) {
                block27: {
                    logger.info("Executing end proof of audit command");
                    commandSuccess = false;
                    try {
                        directive = Base64.getDecoder().decode(taxCoreCommand.getPayload());
                        cardResponse = CardCommand.getInstance().endAudit(directive);
                        if (CardOpCode.OK != cardResponse.getOpCode()) {
                            CardCommand.getInstance().selectApplet();
                            cardResponse = CardCommand.getInstance().endAudit(directive);
                        }
                        if (CardOpCode.OK == cardResponse.getOpCode()) {
                            commandSuccess = true;
                            logger.info("End proof of audit command executed successfully");
                            CardCommand.getInstance().getCardAmountStatus(appState);
                            EventManager.getInstance().postUpdateUIEvent();
                            try {
                                if (!onlineMode) {
                                    FsUtil.backUpAuditPackagesAfterSuccessfulLocalAudit(taxCoreCommand.getUid());
                                    break block27;
                                }
                                FsUtil.deleteAuditPackagesAfterSuccessfulRemoteAudit(taxCoreCommand.getUid());
                            }
                            catch (Exception exception) {
                                logger.error("Backup/delete audit package error", (Throwable)exception);
                            }
                            break block27;
                        }
                        logger.warn("End audit command failed");
                        CardCommand.getInstance().selectApplet();
                    }
                    catch (Exception e) {
                        logger.error("End audit command error", (Throwable)e);
                        EventManager.getInstance().postErrorNotification(I18N.text("message.audit.end.proof.of.audit.command.failed"));
                    }
                }
                commandResponse = new TaxCoreCommandResponse(taxCoreCommand.getCommandId(), commandSuccess);
                commandResponses.add(commandResponse);
                if (!onlineMode) continue;
                TaxApiClient.getInstance().notifyCommandProcessed(commandResponse, taxApiToken, appState);
                continue;
            }
            logger.error("Unknown tax core command: {}", (Object)taxCoreCommand.toString());
        }
        return commandResponses;
    }

    private Headers createHeaders(String apiToken) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Accept", "application/json");
        headersMap.put("Content-type", "application/json");
        if (apiToken != null) {
            headersMap.put("TaxCoreAuthenticationToken", apiToken);
        }
        return Headers.of(headersMap);
    }

    private Headers createHeaders() {
        return this.createHeaders(null);
    }

    public void startOnlineNotifier(StatusTabPanel statusTabPanel) {
        this.onlineStatusNotifier = new OnlineStatusNotifier(statusTabPanel);
        this.onlineStatusNotifier.start();
    }

    public void stop() {
        this.onlineStatusNotifier.setSdcOnline(false);
        this.onlineStatusNotifier.setRunning(false);
    }

    public String getTaxApiBaseUrl() {
        return this.taxApiBaseUrl;
    }

    public void setTaxApiBaseUrl(String taxApiBaseUrl) {
        this.taxApiBaseUrl = taxApiBaseUrl;
    }

    public OkHttpClient getCardProtectedClient() {
        return this.cardProtectedClient;
    }

    public void setCardProtectedClient(OkHttpClient cardProtectedClient) {
        this.cardProtectedClient = cardProtectedClient;
    }
}

