/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.protocols.taxapi;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.api.model.AuditDataStatusType;
import com.dmi.sdccore.protocols.taxapi.TaxApiClient;
import com.dmi.sdccore.protocols.taxapi.model.ApiResponse;
import com.dmi.sdccore.protocols.taxapi.model.ProofOfAuditRequest;
import com.dmi.sdccore.protocols.taxapi.model.SubmitAuditPackageResponse;
import com.dmi.sdccore.protocols.taxcard.CardCommand;
import com.dmi.sdccore.protocols.taxcard.CardOpCode;
import com.dmi.sdccore.protocols.taxcard.CardResponse;
import com.dmi.sdccore.utils.FsUtil;
import java.io.File;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuditExecutor {
    private static final Logger logger = LogManager.getLogger(AuditExecutor.class);
    private static final AuditExecutor INSTANCE = new AuditExecutor();
    private static final long LONG_AUDIT_INTERVAL_MS = 1800000L;
    private static final long MEDIUM_AUDIT_INTERVAL_MS = 600000L;
    private static final long SHORT_AUDIT_INTERVAL_MS = 300000L;
    private long auditIntervalMs = 1800000L;

    private AuditExecutor() {
    }

    public static AuditExecutor getInstance() {
        return INSTANCE;
    }

    public synchronized boolean tryRemoteAuditStart(AppState appState) throws Exception {
        if (appState.isAuditInProgress() || !appState.isInternetAvailable()) {
            return false;
        }
        boolean auditSuccess = false;
        logger.info("Remote audit start");
        String cardSerialNumber = appState.getTaxCardCertificate().getSubject().getSerialNumber();
        File[] availableAuditPackages = FsUtil.getCandidateAuditPackagesForDeletingByUid(cardSerialNumber);
        String lastInvoiceNumber = FsUtil.getLastInvoiceNumber(availableAuditPackages);
        if (lastInvoiceNumber == null) {
            logger.info("No invoices for deleting");
            appState.setLastRemoteAuditStartTime(System.currentTimeMillis());
            return true;
        }
        logger.info("Last invoice for deleting: " + lastInvoiceNumber);
        FsUtil.writeFile(FsUtil.FN_REMOTE_AUDIT_LATEST_INVOICE + "_" + cardSerialNumber, lastInvoiceNumber);
        CardResponse cardResponse = CardCommand.getInstance().getCardAmountStatus(appState);
        if (CardOpCode.CardAppletNotSelected == cardResponse.getOpCode()) {
            CardCommand.getInstance().selectApplet();
            cardResponse = CardCommand.getInstance().getCardAmountStatus(appState);
        }
        EventManager.getInstance().postUpdateUIEvent();
        if (CardOpCode.OK == cardResponse.getOpCode()) {
            cardResponse = CardCommand.getInstance().startAudit();
            if (CardOpCode.CardAppletNotSelected == cardResponse.getOpCode()) {
                CardCommand.getInstance().selectApplet();
                cardResponse = CardCommand.getInstance().startAudit();
            }
            if (CardOpCode.OK == cardResponse.getOpCode()) {
                String auditRequestPayloadBase64 = Base64.getEncoder().encodeToString(cardResponse.getData());
                ProofOfAuditRequest proofOfAuditRequest = new ProofOfAuditRequest(auditRequestPayloadBase64, appState.getCardCurrentAmount(), appState.getCardMaxAmount());
                ApiResponse submitResponse = TaxApiClient.getInstance().submitAuditRequestPayload(proofOfAuditRequest, appState.getTaxCoreApiToken().getToken(), appState);
                if (200 == submitResponse.getCode()) {
                    auditSuccess = true;
                    appState.setLastRemoteAuditStartTime(System.currentTimeMillis());
                }
            }
        }
        return auditSuccess;
    }

    public boolean canRemoteAuditStart() {
        boolean start;
        AppState appState = AppState.getInstance();
        boolean intervalReached = System.currentTimeMillis() - appState.getLastRemoteAuditStartTime() > this.auditIntervalMs;
        boolean bl = start = intervalReached || appState.isShouldStartRemoteAuditNow();
        if (appState.isShouldStartRemoteAuditNow()) {
            appState.setShouldStartRemoteAuditNow(false);
        }
        return start;
    }

    public synchronized void tryAuditPackagesSubmit(AppState appState) throws Exception {
        File[] availableAuditPackages = FsUtil.getAuditPackagesForSubmittingByUid(appState.getTaxCardCertificate().getSubject().getSerialNumber());
        if (availableAuditPackages != null && availableAuditPackages.length > 0) {
            for (File auditPackageFile : availableAuditPackages) {
                SubmitAuditPackageResponse submitAuditPackageResponse = TaxApiClient.getInstance().submitAuditPackage(auditPackageFile, appState.getTaxCoreApiToken().getToken(), appState);
                if (200 != submitAuditPackageResponse.getResponseHttpStatusCode() || submitAuditPackageResponse.getAuditDataStatus() == null) continue;
                if (AuditDataStatusType.InvoiceIsVerified.getValue() == submitAuditPackageResponse.getAuditDataStatus().getStatus().intValue()) {
                    try {
                        FsUtil.backUpAuditPackage(auditPackageFile, appState.getTaxCardCertificate().getSubject().getSerialNumber());
                    }
                    catch (Exception exc) {
                        logger.error("Audit package backup failed ", (Throwable)exc);
                    }
                    continue;
                }
                logger.error("Audit package upload not verified: {} ({})", (Object)AuditDataStatusType.getByValue(submitAuditPackageResponse.getAuditDataStatus().getStatus()), (Object)submitAuditPackageResponse.getAuditDataStatus().getStatus());
            }
        }
    }

    public long getAuditIntervalMs() {
        return this.auditIntervalMs;
    }

    public void setAuditIntervalMs(long auditIntervalMs) {
        this.auditIntervalMs = auditIntervalMs;
    }

    public void setLongAuditIntervalMs() {
        this.auditIntervalMs = 1800000L;
    }

    public void setMediumAuditIntervalMs() {
        this.auditIntervalMs = 600000L;
    }

    public void adjustAuditInterval(AppState appState) {
        this.auditIntervalMs = appState.isCardAmountPercentsMoreThen75() ? 600000L : 1800000L;
    }
}

