/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.printimage;

import com.dmi.sdccore.api.model.invoice.InvoicePayment;
import com.dmi.sdccore.api.model.invoice.InvoiceResultTaxItem;
import com.dmi.sdccore.api.model.invoice.InvoiceTransactionType;
import com.dmi.sdccore.api.model.invoice.InvoiceType;
import com.dmi.sdccore.api.model.invoice.PrinterResponse;
import com.dmi.sdccore.api.model.printer.InvoiceReusultItem;
import com.dmi.sdccore.api.model.printer.Person;
import com.dmi.sdccore.api.model.printer.PrintInvoice;
import com.dmi.sdccore.api.model.report.FiscalBill;
import com.dmi.sdccore.printimage.ContentProporties;
import com.dmi.sdccore.printimage.EscPosPrinterStandard;
import com.dmi.sdccore.printimage.NPrintUtil;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.output.PrinterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.print.PrintService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NarrowPosPrintFiscalReceipt
extends ContentProporties {
    private static final Logger logger = LogManager.getLogger(NarrowPosPrintFiscalReceipt.class);

    public PrinterResponse fiscalBillContent(PrintInvoice invoiceType) {
        try {
            StringBuilder vrednost = this.header(invoiceType);
            this.fiscalBillItems(invoiceType, vrednost);
            if (this.isInvoiceTypeCopy(invoiceType) || this.isInvoiceTypeTraining(invoiceType) || this.isInvoiceTypeProforma(invoiceType)) {
                logger.info("Stigao u kpiju ili trening");
                this.notFiscal1(invoiceType, vrednost);
            }
            this.taxRates(invoiceType, vrednost);
            this.footer(invoiceType, vrednost);
            String code1 = invoiceType.getInvoiceResult().getVerificationUrl();
            String endBilll = NarrowPosPrintFiscalReceipt.textInTheMiddleWithSigns(" " + invoiceType.getInvoiceFooter() + " ", '=', invoiceType.getNumOfCharacters());
            StringBuilder stringBuilder = new StringBuilder();
            String footerCustomer = invoiceType.getPerson() != null ? this.footerCustomer(invoiceType, invoiceType.getPerson()) : "";
            StringBuilder footerPo = new StringBuilder();
            if (this.isInvoiceTypeRefund(invoiceType) && !this.isInvoiceTypeAdvance(invoiceType)) {
                footerPo.append("Potpis kupca:");
                footerPo.append(NarrowPosPrintFiscalReceipt.makeLineWithChar('_', invoiceType.getNumOfCharacters() - footerPo.length()) + "\n\n");
                stringBuilder.append(code1).append(NarrowPosPrintFiscalReceipt.newRow()).append((CharSequence)footerPo).append(NarrowPosPrintFiscalReceipt.newRow()).append(endBilll).append(NarrowPosPrintFiscalReceipt.newRow());
            } else {
                stringBuilder.append(code1).append(NarrowPosPrintFiscalReceipt.newRow()).append(endBilll).append(NarrowPosPrintFiscalReceipt.newRow());
            }
            if (invoiceType.getPerson() != null) {
                stringBuilder.append(footerCustomer);
            }
            String endBillAndCode = stringBuilder.toString();
            StringBuilder avans = new StringBuilder();
            if (this.isInvoiceTypeAdvance(invoiceType) && !this.isInvoiceTypeRefund(invoiceType)) {
                System.out.println("Avans je u pitanju");
                this.addFootrerAvansProductName(avans, invoiceType);
            } else if (invoiceType.getInvoiceResult().getRefLastAvansNumber() != null) {
                System.out.println("nalazim se u footeru konacnog racuna :)");
                avans.append("*Poslednji avansni ra\u010dun ").append("\n").append(invoiceType.getInvoiceResult().getRefLastAvansNumber()).append("\n").append(" " + LocalDate.now());
            }
            logger.info("Slika je " + vrednost.toString());
            PrinterResponse response = this.printFiscalBill(invoiceType, vrednost, endBillAndCode, avans);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            PrinterResponse printerResponse = new PrinterResponse();
            printerResponse.setResponse("NOk");
            return printerResponse;
        }
    }

    private void addFootrerAvansProductName(StringBuilder avans, PrintInvoice invoice) {
        for (InvoiceReusultItem item : invoice.getInvoiceResult().getResultItems()) {
            String nameProduct = item.getProductName();
            Double price = item.getPrice();
            if (this.isProductAvansName(nameProduct)) continue;
            avans.append(nameProduct).append(" ").append(price).append("\n");
        }
    }

    private boolean isProductAvansName(String productName) {
        return productName.contains("Avans");
    }

    private boolean isInvoiceTypeAdvance(PrintInvoice invoiceType) {
        return 4 == invoiceType.getInvoiceType().getValue();
    }

    public PrinterResponse printFiscalBill(PrintInvoice invoiceTyp, StringBuilder vrednost, String endBillAndCode, StringBuilder avans) {
        PrintService service = PrinterOutputStream.getPrintServiceByName((String)invoiceTyp.getServerName());
        try {
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            EscPosPrinterStandard escPosPrinter = new EscPosPrinterStandard(escPos);
            if (invoiceTyp.getIsImage().booleanValue()) {
                return escPosPrinter.printImage(invoiceTyp, vrednost, endBillAndCode, invoiceTyp.getNumberOfCharacters(), escPos, invoiceTyp.getInvoiceResult().getInvoiceNumber(), avans);
            }
            escPosPrinter.printImage(invoiceTyp, vrednost, endBillAndCode, invoiceTyp.getNumberOfCharacters(), escPos, invoiceTyp.getInvoiceResult().getInvoiceNumber(), avans);
            this.endOfFiscalBill1(escPos, escPosPrinter);
            PrinterResponse printerResponse = new PrinterResponse();
            printerResponse.setResponse("Ok");
            return printerResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            PrinterResponse printerResponse = new PrinterResponse();
            printerResponse.setResponse("NOk");
            return printerResponse;
        }
    }

    private void endOfFiscalBill1(EscPos escPos, EscPosPrinterStandard escPosPrinter) throws IOException {
        escPosPrinter.printBlankLines(5);
        escPos.cut(EscPos.CutMode.FULL);
        escPos.close();
    }

    private void footer(PrintInvoice invoice, StringBuilder stringBuilder) {
        String prfNumber;
        String pfrDate = NPrintUtil.textDatefromISO8601(invoice.getInvoiceResult().getSdcDateTime());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.makeLineWithChar('=', invoice.getNumOfCharacters())).append(NarrowPosPrintFiscalReceipt.newRow());
        String prfvreme = NarrowPosPrintFiscalReceipt.textWithSpaceBetween("PFR vreme:", pfrDate, invoice.getNumOfCharacters());
        stringBuilder.append(prfvreme.length() <= invoice.getNumOfCharacters() - 1 ? prfvreme : prfvreme.substring(0, invoice.getNumOfCharacters() - 1) + "\n").append(prfvreme.length() > invoice.getNumOfCharacters() - 1 ? prfvreme.substring(invoice.getNumOfCharacters() - 1, prfvreme.length()) : "");
        if (prfvreme.length() >= invoice.getNumOfCharacters() - 1) {
            stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow());
        }
        stringBuilder.append((prfNumber = NarrowPosPrintFiscalReceipt.textWithSpaceBetween("PFR broj ra\u010duna:", invoice.getInvoiceResult().getInvoiceNumber(), invoice.getNumOfCharacters())).length() <= invoice.getNumOfCharacters() - 1 ? prfNumber : prfNumber.substring(0, invoice.getNumOfCharacters() - 1) + "\n").append(prfNumber.length() > invoice.getNumOfCharacters() - 1 ? prfNumber.substring(invoice.getNumOfCharacters() - 1, prfNumber.length()) : "");
        if (prfNumber.length() >= invoice.getNumOfCharacters() - 1) {
            stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow());
        }
        String label = " Broja\u010d ra\u010duna:";
        stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween(label.trim(), invoice.getInvoiceResult().getInvoiceCounter(), invoice.getNumOfCharacters())).append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.makeLineWithChar('=', invoice.getNumOfCharacters())).append(NarrowPosPrintFiscalReceipt.newRow()).append(NarrowPosPrintFiscalReceipt.newRow());
    }

    private void taxRates(PrintInvoice invoice, StringBuilder stringBuilder) {
        String rate = "";
        String rateAmount = "";
        BigDecimal totalRateAmount = BigDecimal.valueOf(0.0);
        stringBuilder.append(NarrowPosPrintFiscalReceipt.makeLineWithChar('=', invoice.getNumOfCharacters())).append(NarrowPosPrintFiscalReceipt.newRow());
        if (invoice.getNumOfCharacters() <= 30) {
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Oznaka   Ime", "Stopa    Porez", invoice.getNumOfCharacters())).append(NarrowPosPrintFiscalReceipt.newRow());
        } else {
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Oznaka    Ime", "Stopa       Porez", invoice.getNumOfCharacters())).append(NarrowPosPrintFiscalReceipt.newRow());
        }
        List<InvoiceResultTaxItem> rates = invoice.getInvoiceResult().getTaxItems();
        int i = 0;
        for (InvoiceResultTaxItem r : rates) {
            rate = String.valueOf(r.getRate());
            rateAmount = String.valueOf(r.getAmount());
            totalRateAmount = totalRateAmount.add(r.getAmount());
            String vr = NarrowPosPrintFiscalReceipt.textWithSpaceBetween(NarrowPosPrintFiscalReceipt.taxMarkNameLineImage(r.getLabel(), r.getCategoryName(), invoice.getNumOfCharacters()), NarrowPosPrintFiscalReceipt.taxRateVatLineImage(rate, rateAmount, invoice.getNumOfCharacters()), invoice.getNumOfCharacters());
            stringBuilder.append(vr);
            if (rates.size() == ++i) continue;
            stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow());
        }
        stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow()).append(NarrowPosPrintFiscalReceipt.makeLineWithChar('-', invoice.getNumOfCharacters())).append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Ukupan iznos poreza:", NarrowPosPrintFiscalReceipt.formatOnTwo(totalRateAmount.doubleValue()), invoice.getNumOfCharacters())).append(NarrowPosPrintFiscalReceipt.newRow());
    }

    private void notFiscal1(PrintInvoice invoiceType, StringBuilder sb) {
        String vrednost;
        sb.append(NarrowPosPrintFiscalReceipt.makeLineWithChar('=', invoiceType.getNumOfCharacters()) + "\n");
        String string = vrednost = invoiceType.getInvoiceFooter().length() < invoiceType.getNumOfCharacters() ? invoiceType.getInvoiceFooter() : invoiceType.getInvoiceFooter().substring(0, invoiceType.getNumOfCharacters() - 1);
        if (invoiceType.getInvoiceFooter().length() > invoiceType.getNumOfCharacters()) {
            vrednost = vrednost + "\n" + invoiceType.getInvoiceFooter().substring(invoiceType.getNumOfCharacters() - 1, invoiceType.getInvoiceFooter().length());
        }
        sb.append(NarrowPosPrintFiscalReceipt.contentInTheMiddle(vrednost, invoiceType.getNumOfCharacters()) + "\n");
    }

    private boolean isInvoiceTranasactionType(PrintInvoice invoice) {
        return 1 == invoice.getInvoiceTransactionType().getValue();
    }

    private boolean isInvoiceTypeProforma(PrintInvoice invoiceType) {
        return 1 == invoiceType.getInvoiceType().getValue();
    }

    private boolean isInvoiceTypeTraining(PrintInvoice invoiceType) {
        return 3 == invoiceType.getInvoiceType().getValue();
    }

    private boolean isInvoiceTypeCopy(PrintInvoice invoiceType) {
        return 2 == invoiceType.getInvoiceType().getValue();
    }

    private void fiscalBillItems(PrintInvoice invoiceType, StringBuilder stringBuilder) {
        this.insertFiscalItemsHeader1(invoiceType, stringBuilder);
        this.insertFiscalItems1(stringBuilder, invoiceType);
        this.insertFiscalItemsTotal1(invoiceType, stringBuilder);
    }

    private void insertFiscalItemsTotal1(PrintInvoice invoiceType, StringBuilder stringBuilder) {
        double total = invoiceType.getInvoiceResult().getTotalAmount().doubleValue();
        stringBuilder.append("\n" + NarrowPosPrintFiscalReceipt.makeLineWithChar('-', invoiceType.getNumOfCharacters()) + "\n");
        if (this.isInvoiceTypeRefund(invoiceType) && !this.isInvoiceTypeAdvance(invoiceType)) {
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Ukupna refundacija:", NarrowPosPrintFiscalReceipt.formatOnTwo(total), invoiceType.getNumOfCharacters()) + "\n");
        } else {
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Ukupan iznos:", NarrowPosPrintFiscalReceipt.formatOnTwo(total), invoiceType.getNumOfCharacters() > 30 ? invoiceType.getNumOfCharacters() - 10 : invoiceType.getNumOfCharacters() - 3));
            stringBuilder.append("\n" + NarrowPosPrintFiscalReceipt.makeLineWithChar('-', invoiceType.getNumOfCharacters()) + "\n");
            if (invoiceType.getInvoiceResult().getPaidFinishdBill() != null && invoiceType.getInvoiceResult().getTaxFinishTotal() != null) {
                stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Pla\u0107eno avansom:", NarrowPosPrintFiscalReceipt.formatOnTwo(invoiceType.getInvoiceResult().getPaidFinishdBill().doubleValue()), invoiceType.getNumOfCharacters()) + "\n");
                stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Pdv na avans:", NarrowPosPrintFiscalReceipt.formatOnTwo(invoiceType.getInvoiceResult().getTaxFinishTotal().doubleValue()), invoiceType.getNumOfCharacters()) + "\n");
            }
        }
        if (this.isInvoiceTypeCopy(invoiceType)) {
            this.insertCopyPayments1(invoiceType, stringBuilder);
        } else {
            this.insertPayments1(invoiceType, stringBuilder);
        }
    }

    private boolean isInvoiceTypeRefund(PrintInvoice invoiceType) {
        return 1 == invoiceType.getInvoiceTransactionType().getValue();
    }

    private void insertPayments1(PrintInvoice invoiceType, StringBuilder stringBuilder) {
        String methodName = "";
        String methodAmount = "";
        double paid = 0.0;
        double moneyRefund = 0.0;
        for (InvoicePayment set : invoiceType.getInvoiceResult().getInvoicePayments()) {
            methodName = NarrowPosPrintFiscalReceipt.methodName(set.getPaymentType().name());
            methodAmount = NarrowPosPrintFiscalReceipt.formatOnTwo(set.getAmount().doubleValue());
            paid += set.getAmount().doubleValue();
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween(methodName, methodAmount, invoiceType.getNumOfCharacters()) + "\n");
        }
        logger.info("Payment " + stringBuilder.toString());
        moneyRefund = paid - invoiceType.getInvoiceResult().getTotalAmount().doubleValue();
        if (!this.isInvoiceTypeRefund(invoiceType) && invoiceType.getInvoiceResult().getPaidFinishdBill() == null) {
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Povra\u0107aj:", NarrowPosPrintFiscalReceipt.formatOnTwo(moneyRefund), invoiceType.getNumOfCharacters()) + "\n");
        } else if (this.isInvoiceTypeRefund(invoiceType) && invoiceType.getInvoiceResult().getPaidFinishdBill() == null) {
            logger.info("Payment refund  " + stringBuilder.toString());
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Povra\u0107aj:", NarrowPosPrintFiscalReceipt.formatOnTwo(moneyRefund), invoiceType.getNumOfCharacters()) + "\n");
        } else {
            moneyRefund = invoiceType.getInvoiceResult().getTotalAmount().doubleValue() - paid - invoiceType.getInvoiceResult().getPaidFinishdBill().doubleValue();
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Preostalo za pla\u0107anje:", NarrowPosPrintFiscalReceipt.formatOnTwo(moneyRefund), invoiceType.getNumOfCharacters()) + "\n");
        }
    }

    private void insertCopyPayments1(PrintInvoice invoice, StringBuilder stringBuilder) {
        logger.info("Stigao insertCopyPayments1");
        String methodName = "";
        String methodAmount = "";
        for (InvoicePayment payment : invoice.getInvoiceResult().getInvoicePayments()) {
            methodName = NarrowPosPrintFiscalReceipt.methodName(payment.getPaymentType().name());
            methodAmount = NarrowPosPrintFiscalReceipt.formatOnTwo(payment.getAmount().doubleValue());
            stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween(methodName, methodAmount, invoice.getNumOfCharacters()) + "\n");
        }
    }

    private void insertFiscalItems1(StringBuilder stringBuilder, PrintInvoice invoiceType) {
        logger.info("Stigao item");
        String vatCode = "";
        String productName = "";
        String unitName = "";
        String price = "";
        String quantity = "";
        String value = "";
        int i = 0;
        if (this.isInvoiceTypeAdvance(invoiceType)) {
            for (InvoiceReusultItem item : invoiceType.getInvoiceResult().getResultItemsAdvance()) {
                vatCode = item.getVatCode();
                productName = item.getProductName();
                quantity = NarrowPosPrintFiscalReceipt.formatOnThree(item.getQuantity());
                price = NarrowPosPrintFiscalReceipt.formatOnTwo(item.getPrice());
                value = NarrowPosPrintFiscalReceipt.formatOnTwo(item.getValue());
                String productCombination = " " + productName + "(" + vatCode + ")/";
                String productNameTemp = (productCombination.length() <= invoiceType.getNumberOfCharacters() - 1 ? productCombination : productCombination.substring(0, invoiceType.getNumberOfCharacters() - 1)) + "\n";
                productNameTemp = productNameTemp + (productCombination.length() > invoiceType.getNumberOfCharacters() - 1 ? productCombination.substring(invoiceType.getNumberOfCharacters() - 1, productCombination.length()) + "\n" : "");
                stringBuilder.append(productNameTemp);
                if (this.isInvoiceTypeRefund(invoiceType)) {
                    stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween(NarrowPosPrintFiscalReceipt.priceLine("", price), NarrowPosPrintFiscalReceipt.qunatitySumLine(quantity, "-" + value), invoiceType.getNumberOfCharacters()));
                } else {
                    stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween(NarrowPosPrintFiscalReceipt.priceLine("", price), NarrowPosPrintFiscalReceipt.qunatitySumLine(quantity, value), invoiceType.getNumberOfCharacters()));
                }
                stringBuilder.append("\n");
            }
            logger.info("Vrednost stringbuilder " + stringBuilder.toString());
        } else {
            for (InvoiceReusultItem item : invoiceType.getInvoiceResult().getResultItems()) {
                String text;
                vatCode = item.getVatCode();
                productName = item.getProductName();
                unitName = item.getUnitName();
                quantity = NarrowPosPrintFiscalReceipt.formatOnThree(item.getQuantity());
                price = NarrowPosPrintFiscalReceipt.formatOnTwo(item.getPrice());
                logger.info("Refund je ");
                if (this.isInvoiceTypeRefund(invoiceType)) {
                    value = NarrowPosPrintFiscalReceipt.formatOnTwo(item.getValue() * -1.0);
                    logger.info("Refund je " + value);
                } else {
                    value = NarrowPosPrintFiscalReceipt.formatOnTwo(item.getValue());
                }
                String productCombination = " " + productName + "(" + vatCode + ")/" + unitName;
                String productNameTemp = (productCombination.length() <= invoiceType.getNumOfCharacters() - 1 ? productCombination : productCombination.substring(0, invoiceType.getNumOfCharacters() - 1)) + "\n";
                productNameTemp = productNameTemp + (productCombination.length() > invoiceType.getNumOfCharacters() - 1 ? productCombination.substring(invoiceType.getNumOfCharacters() - 1, productCombination.length()) + "\n" : "");
                stringBuilder.append(productNameTemp);
                if (this.isInvoiceTypeProforma(invoiceType)) {
                    value = "0.0";
                }
                if ((text = NarrowPosPrintFiscalReceipt.textWithSpaceBetween(NarrowPosPrintFiscalReceipt.priceLine("", price), NarrowPosPrintFiscalReceipt.qunatitySumLine(quantity, value), invoiceType.getNumOfCharacters())).length() > invoiceType.getNumOfCharacters()) {
                    String text1 = text.substring(0, invoiceType.getNumOfCharacters());
                    String text2 = text.substring(invoiceType.getNumberOfCharacters(), text.length());
                    text = text1 + "\n" + text2;
                }
                stringBuilder.append(text);
                logger.info("Item " + stringBuilder.toString());
                if (invoiceType.getInvoiceResult().getResultItems().size() == ++i) continue;
                stringBuilder.append("\n");
            }
        }
    }

    private void insertFiscalItemsHeader1(PrintInvoice invoiceType, StringBuilder stringBuilder) {
        logger.info("Stigao uheader");
        stringBuilder.append(NarrowPosPrintFiscalReceipt.textInTheMiddleWithSigns(" " + invoiceType.getHeadLine() + " ", '-', invoiceType.getNumOfCharacters()));
        stringBuilder.append("\n");
        stringBuilder.append(NarrowPosPrintFiscalReceipt.contentInTheMiddle("Artikli", invoiceType.getNumOfCharacters()));
        stringBuilder.append("\n");
        stringBuilder.append(NarrowPosPrintFiscalReceipt.makeLineWithChar('=', invoiceType.getNumOfCharacters()));
        stringBuilder.append("\n");
        stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Naziv   Cena", " Kol.     Ukupno", invoiceType.getNumOfCharacters()));
        stringBuilder.append("\n");
    }

    private StringBuilder header(PrintInvoice invoiceType) {
        String businessName;
        double length;
        logger.info("Stigao u header");
        StringBuilder sb = new StringBuilder();
        sb.append(NarrowPosPrintFiscalReceipt.textInTheMiddleWithSigns(invoiceType.getInvoiceHeader() + " ", '=', invoiceType.getNumOfCharacters()));
        sb.append(NarrowPosPrintFiscalReceipt.newRow());
        if (invoiceType.getInvoiceResult().getTin() != null) {
            sb.append(NarrowPosPrintFiscalReceipt.contentInTheMiddle(invoiceType.getInvoiceResult().getTin(), invoiceType.getNumOfCharacters()));
            sb.append(NarrowPosPrintFiscalReceipt.newRow());
        }
        if ((length = this.isLength(businessName = NarrowPosPrintFiscalReceipt.contentInTheMiddle(invoiceType.getInvoiceResult().getBusinessName(), invoiceType.getNumOfCharacters()), invoiceType.getNumOfCharacters())) <= 2.0) {
            String businessNameTemp = (businessName.length() <= invoiceType.getNumOfCharacters() - 1 ? businessName : businessName.substring(0, invoiceType.getNumOfCharacters() - 1)) + "\n";
            businessNameTemp = businessNameTemp + (businessName.length() > invoiceType.getNumOfCharacters() - 1 ? businessName.substring(invoiceType.getNumOfCharacters() - 1, businessName.length()) + "\n" : "");
            sb.append(businessNameTemp);
        } else {
            this.shareitString(sb, businessName, length, invoiceType.getNumOfCharacters());
        }
        String locationName = NarrowPosPrintFiscalReceipt.contentInTheMiddle(invoiceType.getInvoiceResult().getLocationName(), invoiceType.getNumOfCharacters());
        length = this.isLength(locationName, invoiceType.getNumOfCharacters());
        if (length <= 2.0) {
            String locationNameTemp = (locationName.length() <= invoiceType.getNumOfCharacters() - 1 ? locationName : locationName.substring(0, invoiceType.getNumOfCharacters() - 1)) + "\n";
            locationNameTemp = locationNameTemp + (locationName.length() > invoiceType.getNumOfCharacters() - 1 ? locationName.substring(invoiceType.getNumOfCharacters() - 1, locationName.length()) + "\n" : "");
            sb.append(locationNameTemp);
        } else {
            this.shareitString(sb, locationName, length, invoiceType.getNumOfCharacters());
        }
        String address = NarrowPosPrintFiscalReceipt.contentInTheMiddle(invoiceType.getInvoiceResult().getAddress(), invoiceType.getNumOfCharacters());
        length = this.isLength(address, invoiceType.getNumOfCharacters());
        if (length <= 2.0) {
            String addressTemp = (address.length() <= invoiceType.getNumOfCharacters() - 1 ? address : address.substring(0, invoiceType.getNumOfCharacters() - 1)) + "\n";
            addressTemp = addressTemp + (address.length() > invoiceType.getNumOfCharacters() - 1 ? address.substring(invoiceType.getNumOfCharacters() - 1, address.length()) + "\n" : "");
            sb.append(addressTemp);
        } else {
            this.shareitString(sb, address, length, invoiceType.getNumOfCharacters());
        }
        String district = NarrowPosPrintFiscalReceipt.contentInTheMiddle(invoiceType.getInvoiceResult().getDistrict(), invoiceType.getNumOfCharacters());
        sb.append(district.length() <= invoiceType.getNumOfCharacters() ? district : district.substring(0, invoiceType.getNumOfCharacters()) + "\n").append(district.length() > invoiceType.getNumOfCharacters() ? district.substring(invoiceType.getNumberOfCharacters(), district.length()) : "");
        sb.append(NarrowPosPrintFiscalReceipt.newRow());
        sb.append(NarrowPosPrintFiscalReceipt.makeLineWithString("-", invoiceType.getNumOfCharacters()));
        sb.append(NarrowPosPrintFiscalReceipt.newRow());
        sb.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Kasir:", invoiceType.getUserId(), invoiceType.getNumOfCharacters()));
        sb.append(NarrowPosPrintFiscalReceipt.newRow());
        if (invoiceType.getBayerId() != null) {
            sb.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Id kupca:", invoiceType.getBayerId(), invoiceType.getNumOfCharacters()));
            sb.append(NarrowPosPrintFiscalReceipt.newRow());
        }
        if (invoiceType.getBayerConstId() != null) {
            sb.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Opciono polje kupca:", invoiceType.getBayerConstId(), invoiceType.getNumOfCharacters()));
            sb.append(NarrowPosPrintFiscalReceipt.newRow());
        }
        sb.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Esir broj:", invoiceType.getEsirInvoiceNumber(), invoiceType.getNumOfCharacters()) + "\n");
        if (invoiceType.getInvoiceResult().getSdcDateTime() != null && invoiceType.getInvoiceType() == InvoiceType.Advance && invoiceType.getInvoiceTransactionType() != InvoiceTransactionType.Refund) {
            sb.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Esir vreme:", invoiceType.getInvoiceResult().getSdcDateTime(), invoiceType.getNumOfCharacters()));
            sb.append(NarrowPosPrintFiscalReceipt.newRow());
        }
        if (invoiceType.getRefDateAndTime() != null) {
            sb.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Ref. vreme:", invoiceType.getRefDateAndTime(), invoiceType.getNumOfCharacters()));
            sb.append(NarrowPosPrintFiscalReceipt.newRow());
            sb.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Ref. broj:", invoiceType.getRefNumber(), invoiceType.getNumOfCharacters()));
            sb.append(NarrowPosPrintFiscalReceipt.newRow());
        }
        logger.info("");
        return sb;
    }

    private String footerCustomer(PrintInvoice invoice, Person person) {
        StringBuilder stringBuilder = new StringBuilder();
        int num = invoice.getNumOfCharacters() - 5;
        stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow()).append(NarrowPosPrintFiscalReceipt.contentInTheMiddle("NEFISKALNA \u0160TAMPA", num)).append(NarrowPosPrintFiscalReceipt.newRow()).append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append("Podaci kupca:").append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.makeLineWithChar('=', num));
        stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Naziv:", person.getName(), num));
        stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Adresa:", person.getAddress(), num));
        stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("PIB:", person.getPIB(), num));
        stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.textWithSpaceBetween("Mati\u010dni:", person.getMB(), num));
        stringBuilder.append(NarrowPosPrintFiscalReceipt.newRow());
        stringBuilder.append(NarrowPosPrintFiscalReceipt.makeLineWithChar('=', num)).append(NarrowPosPrintFiscalReceipt.newRow());
        return stringBuilder.toString();
    }

    private double isLength(String name, int numOfCharacters) {
        double a = name.length();
        return a / (double)numOfCharacters;
    }

    private void shareitString(StringBuilder stringBuilder, String locationName, double a, int numberOfCharachter) {
        int temp = 0;
        int tempnumberOfCharachter = numberOfCharachter;
        for (double i = 0.0; i < a; i += 1.0) {
            if (tempnumberOfCharachter > locationName.length()) {
                tempnumberOfCharachter = locationName.length();
            }
            String locationNameTemp = locationName.substring(temp, tempnumberOfCharachter);
            temp += numberOfCharachter;
            tempnumberOfCharachter += numberOfCharachter;
            stringBuilder.append(locationNameTemp);
            stringBuilder.append("\n");
        }
    }

    private FiscalBill build(PrintInvoice invoiceType) {
        if (invoiceType.getInvoiceType().getValue() == InvoiceType.Normal.getValue() && invoiceType.getInvoiceTransactionType().getValue() == InvoiceTransactionType.Sale.getValue() || invoiceType.getInvoiceType().getValue() == InvoiceType.Training.getValue() && invoiceType.getInvoiceTransactionType().getValue() == InvoiceTransactionType.Sale.getValue() || invoiceType.getInvoiceType().getValue() == InvoiceType.Advance.getValue() && invoiceType.getInvoiceTransactionType().getValue() == InvoiceTransactionType.Sale.getValue() || invoiceType.getInvoiceType().getValue() == InvoiceType.Copy.getValue() && invoiceType.getInvoiceTransactionType().getValue() == InvoiceTransactionType.Sale.getValue() || invoiceType.getInvoiceType().getValue() == InvoiceType.Normal.getValue() && invoiceType.getInvoiceTransactionType().getValue() == InvoiceTransactionType.Refund.getValue() || invoiceType.getInvoiceType().getValue() == InvoiceType.Training.getValue() && invoiceType.getInvoiceTransactionType().getValue() == InvoiceTransactionType.Refund.getValue() || invoiceType.getInvoiceType().getValue() == InvoiceType.Advance.getValue() && invoiceType.getInvoiceTransactionType().getValue() == InvoiceTransactionType.Refund.getValue() || invoiceType.getInvoiceType().getValue() != InvoiceType.Copy.getValue() || invoiceType.getInvoiceTransactionType().getValue() == InvoiceTransactionType.Refund.getValue()) {
            // empty if block
        }
        return new FiscalBill("", "", "");
    }
}

