/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.model;

import com.dmi.sdccore.model.TaxCardCertificateIssuer;
import com.dmi.sdccore.model.TaxCardCertificateSubject;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;

public class TaxCardCertificate {
    private X509Certificate x509Certificate;
    private TaxCardCertificateSubject subject;
    private TaxCardCertificateIssuer issuer;
    private String serialNumber;
    private String algorithm;
    private String version;
    private LocalDateTime validFrom;
    private LocalDateTime validTo;
    private RSAPublicKey rsaPublicKey;
    private String taxApiServerBaseUrl;
    private String taxpayerTin;

    public TaxCardCertificateSubject getSubject() {
        return this.subject;
    }

    public void setSubject(TaxCardCertificateSubject subject) {
        this.subject = subject;
    }

    public TaxCardCertificateIssuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(TaxCardCertificateIssuer issuer) {
        this.issuer = issuer;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public LocalDateTime getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(LocalDateTime validFrom) {
        this.validFrom = validFrom;
    }

    public LocalDateTime getValidTo() {
        return this.validTo;
    }

    public void setValidTo(LocalDateTime validTo) {
        this.validTo = validTo;
    }

    public RSAPublicKey getRsaPublicKey() {
        return this.rsaPublicKey;
    }

    public void setRsaPublicKey(RSAPublicKey rsaPublicKey) {
        this.rsaPublicKey = rsaPublicKey;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public String getTaxApiServerBaseUrl() {
        return this.taxApiServerBaseUrl;
    }

    public void setTaxApiServerBaseUrl(String taxApiServerBaseUrl) {
        this.taxApiServerBaseUrl = taxApiServerBaseUrl;
    }

    public String getTaxpayerTin() {
        return this.taxpayerTin;
    }

    public void setTaxpayerTin(String taxpayerTin) {
        this.taxpayerTin = taxpayerTin;
    }

    public boolean isCardCertificateExpired() {
        if (this.validFrom == null || this.validTo == null) {
            return true;
        }
        LocalDateTime now = LocalDateTime.now();
        return now.isBefore(this.validFrom) || now.isAfter(this.validTo);
    }

    public String toString() {
        return "TaxCardCertificate{subject=" + this.subject + ", issuer=" + this.issuer + ", serialNumber='" + this.serialNumber + '\'' + ", algorithm='" + this.algorithm + '\'' + ", version='" + this.version + '\'' + ", validFrom=" + this.validFrom + ", validTo=" + this.validTo + ", rsaPublicKey=" + this.rsaPublicKey + ", taxApiServerBaseUrl='" + this.taxApiServerBaseUrl + '\'' + ", taxpayerTin='" + this.taxpayerTin + '\'' + '}';
    }
}

