/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model.deserializers;

import com.dmi.sdccore.api.model.invoice.InvoiceTransactionType;
import com.dmi.sdccore.utils.StringUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class InvoiceTransactionTypeDeserializer
extends JsonDeserializer<InvoiceTransactionType> {
    public InvoiceTransactionType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        InvoiceTransactionType invoiceTransactionType = null;
        if (jsonParser.getCurrentToken().isNumeric()) {
            invoiceTransactionType = InvoiceTransactionType.getByValue(jsonParser.getIntValue());
        } else {
            try {
                String invoiceTransactionTypeString = jsonParser.getValueAsString();
                if (StringUtil.isNumeric(invoiceTransactionTypeString)) {
                    invoiceTransactionType = InvoiceTransactionType.getByValue(Integer.parseInt(invoiceTransactionTypeString));
                } else {
                    String typeName = StringUtils.capitalize((String)invoiceTransactionTypeString.toLowerCase());
                    invoiceTransactionType = InvoiceTransactionType.valueOf(typeName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return invoiceTransactionType;
    }
}

