/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.endpoints.v3;

import com.dmi.sdccore.api.model.invoice.PrinterResponse;
import com.dmi.sdccore.api.model.lcd.CustomerDisplay;
import com.dmi.sdccore.api.model.printer.PrintInvoice;
import com.dmi.sdccore.api.model.printer.StateReport;
import com.dmi.sdccore.api.model.report.Report;
import com.dmi.sdccore.api.model.report.ReportSettings;
import com.dmi.sdccore.printimage.NarrowPosPrintCurrentSales;
import com.dmi.sdccore.printimage.NarrowPosPrintFiscalReceipt;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="v3/printers")
public class SdcPrintersControler {
    private static final Logger logger = LogManager.getLogger(SdcPrintersControler.class);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response printInvoice(PrintInvoice printInvoice) {
        logger.info("Local API-print start idemo");
        try {
            NarrowPosPrintFiscalReceipt narrowPosPrintFiscalReceipt = new NarrowPosPrintFiscalReceipt();
            PrinterResponse response = narrowPosPrintFiscalReceipt.fiscalBillContent(printInvoice);
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Greska prilikom stampe " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path(value="/state")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response printProducts(StateReport stateReport) {
        logger.info("Local API-print start idemo");
        try {
            NarrowPosPrintCurrentSales narrowPosPrintFiscalReceipt = new NarrowPosPrintCurrentSales();
            narrowPosPrintFiscalReceipt.printState(stateReport);
            return Response.ok((Object)"Success").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Greska prilikom stampe " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path(value="/report")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response printReport(Report report) {
        logger.info("Local API-print start");
        try {
            NarrowPosPrintCurrentSales narrowPosPrintFiscalReceipt = new NarrowPosPrintCurrentSales();
            narrowPosPrintFiscalReceipt.printReport(report);
        }
        catch (Exception e) {
            logger.error("Greska prilikom stampe " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)"Success").build();
    }

    @POST
    @Path(value="/text")
    @Produces(value={"application/json", "text/plain"})
    @Consumes(value={"application/json"})
    public Response printImageReport(ReportSettings report) {
        logger.info("Local API-print start");
        try {
            NarrowPosPrintCurrentSales narrowPosPrintFiscalReceipt = new NarrowPosPrintCurrentSales();
            narrowPosPrintFiscalReceipt.printImageReport(report);
            return Response.ok((Object)"Success").build();
        }
        catch (Exception e) {
            logger.error("Greska prilikom stampe " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path(value="/lcd")
    @Produces(value={"application/json", "text/plain"})
    @Consumes(value={"application/json"})
    public Response printCustomerDispaly(CustomerDisplay customerDisplay) {
        logger.info("lcd print start" + customerDisplay.toString());
        try {
            NarrowPosPrintCurrentSales narrowPosPrintFiscalReceipt = new NarrowPosPrintCurrentSales();
            narrowPosPrintFiscalReceipt.printCustomerDispaly(customerDisplay);
            return Response.ok((Object)"Success").build();
        }
        catch (Exception e) {
            logger.error("Greska prilikom stampe " + e.getMessage());
            return Response.ok((Object)e.getMessage()).status(Response.Status.BAD_REQUEST).build();
        }
    }
}

