/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.AbstractMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLAuthentication;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.SupportedGroupsExtension;

enum X509Authentication implements SSLAuthentication
{
    RSA("RSA", new X509PossessionGenerator(new String[]{"RSA"})),
    RSASSA_PSS("RSASSA-PSS", new X509PossessionGenerator(new String[]{"RSASSA-PSS"})),
    RSA_OR_PSS("RSA_OR_PSS", new X509PossessionGenerator(new String[]{"RSA", "RSASSA-PSS"})),
    DSA("DSA", new X509PossessionGenerator(new String[]{"DSA"})),
    EC("EC", new X509PossessionGenerator(new String[]{"EC"}));

    final String keyType;
    final SSLPossessionGenerator possessionGenerator;

    private X509Authentication(String string2, SSLPossessionGenerator sSLPossessionGenerator) {
        this.keyType = string2;
        this.possessionGenerator = sSLPossessionGenerator;
    }

    static X509Authentication valueOf(SignatureScheme signatureScheme) {
        for (X509Authentication x509Authentication : X509Authentication.values()) {
            if (!x509Authentication.keyType.equals(signatureScheme.keyAlgorithm)) continue;
            return x509Authentication;
        }
        return null;
    }

    @Override
    public SSLPossession createPossession(HandshakeContext handshakeContext) {
        return this.possessionGenerator.createPossession(handshakeContext);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_REQUEST};
        }
        return new SSLHandshake[0];
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLHandshake>(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE)};
        }
        return new Map.Entry[0];
    }

    static final class X509Credentials
    implements SSLCredentials {
        final X509Certificate[] popCerts;
        final PublicKey popPublicKey;

        X509Credentials(PublicKey publicKey, X509Certificate[] x509CertificateArray) {
            this.popCerts = x509CertificateArray;
            this.popPublicKey = publicKey;
        }
    }

    static final class X509Possession
    implements SSLPossession {
        final X509Certificate[] popCerts;
        final PrivateKey popPrivateKey;

        X509Possession(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.popCerts = x509CertificateArray;
            this.popPrivateKey = privateKey;
        }

        ECParameterSpec getECParameterSpec() {
            PublicKey publicKey;
            if (this.popPrivateKey == null || !"EC".equals(this.popPrivateKey.getAlgorithm())) {
                return null;
            }
            if (this.popPrivateKey instanceof ECKey) {
                return ((ECKey)((Object)this.popPrivateKey)).getParams();
            }
            if (this.popCerts != null && this.popCerts.length != 0 && (publicKey = this.popCerts[0].getPublicKey()) instanceof ECKey) {
                return ((ECKey)((Object)publicKey)).getParams();
            }
            return null;
        }
    }

    private static final class X509PossessionGenerator
    implements SSLPossessionGenerator {
        private final String[] keyTypes;

        private X509PossessionGenerator(String[] stringArray) {
            this.keyTypes = stringArray;
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            if (handshakeContext.sslConfig.isClientMode) {
                for (String string : this.keyTypes) {
                    SSLPossession sSLPossession = this.createClientPossession((ClientHandshakeContext)handshakeContext, string);
                    if (sSLPossession == null) continue;
                    return sSLPossession;
                }
            } else {
                for (String string : this.keyTypes) {
                    SSLPossession sSLPossession = this.createServerPossession((ServerHandshakeContext)handshakeContext, string);
                    if (sSLPossession == null) continue;
                    return sSLPossession;
                }
            }
            return null;
        }

        private SSLPossession createClientPossession(ClientHandshakeContext clientHandshakeContext, String string) {
            X509ExtendedKeyManager x509ExtendedKeyManager = clientHandshakeContext.sslContext.getX509KeyManager();
            String string2 = null;
            if (clientHandshakeContext.conContext.transport instanceof SSLSocketImpl) {
                string2 = x509ExtendedKeyManager.chooseClientAlias(new String[]{string}, clientHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])clientHandshakeContext.peerSupportedAuthorities.clone(), (SSLSocket)((Object)clientHandshakeContext.conContext.transport));
            } else if (clientHandshakeContext.conContext.transport instanceof SSLEngineImpl) {
                string2 = x509ExtendedKeyManager.chooseEngineClientAlias(new String[]{string}, clientHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])clientHandshakeContext.peerSupportedAuthorities.clone(), (SSLEngine)((Object)clientHandshakeContext.conContext.transport));
            }
            if (string2 == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("No X.509 cert selected for " + string, new Object[0]);
                }
                return null;
            }
            PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string2);
            if (privateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest(string2 + " is not a private key entry", new Object[0]);
                }
                return null;
            }
            X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string2);
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest(string2 + " is a private key entry with no cert chain stored", new Object[0]);
                }
                return null;
            }
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            if (!privateKey.getAlgorithm().equals(string) || !publicKey.getAlgorithm().equals(string)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine(string2 + " private or public key is not of " + string + " algorithm", new Object[0]);
                }
                return null;
            }
            return new X509Possession(privateKey, x509CertificateArray);
        }

        private SSLPossession createServerPossession(ServerHandshakeContext serverHandshakeContext, String string) {
            X509ExtendedKeyManager x509ExtendedKeyManager = serverHandshakeContext.sslContext.getX509KeyManager();
            String string2 = null;
            if (serverHandshakeContext.conContext.transport instanceof SSLSocketImpl) {
                string2 = x509ExtendedKeyManager.chooseServerAlias(string, serverHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])serverHandshakeContext.peerSupportedAuthorities.clone(), (SSLSocket)((Object)serverHandshakeContext.conContext.transport));
            } else if (serverHandshakeContext.conContext.transport instanceof SSLEngineImpl) {
                string2 = x509ExtendedKeyManager.chooseEngineServerAlias(string, serverHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])serverHandshakeContext.peerSupportedAuthorities.clone(), (SSLEngine)((Object)serverHandshakeContext.conContext.transport));
            }
            if (string2 == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("No X.509 cert selected for " + string, new Object[0]);
                }
                return null;
            }
            PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string2);
            if (privateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest(string2 + " is not a private key entry", new Object[0]);
                }
                return null;
            }
            X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string2);
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest(string2 + " is not a certificate entry", new Object[0]);
                }
                return null;
            }
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            if (!privateKey.getAlgorithm().equals(string) || !publicKey.getAlgorithm().equals(string)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine(string2 + " private or public key is not of " + string + " algorithm", new Object[0]);
                }
                return null;
            }
            if (!serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec() && string.equals("EC")) {
                if (!(publicKey instanceof ECPublicKey)) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                        SSLLogger.warning(string2 + " public key is not an instance of ECPublicKey", new Object[0]);
                    }
                    return null;
                }
                ECParameterSpec eCParameterSpec = ((ECPublicKey)publicKey).getParams();
                SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec);
                if (namedGroup == null || !SupportedGroupsExtension.SupportedGroups.isSupported(namedGroup) || serverHandshakeContext.clientRequestedNamedGroups != null && !serverHandshakeContext.clientRequestedNamedGroups.contains((Object)namedGroup)) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                        SSLLogger.warning("Unsupported named group (" + (Object)((Object)namedGroup) + ") used in the " + string2 + " certificate", new Object[0]);
                    }
                    return null;
                }
            }
            return new X509Possession(privateKey, x509CertificateArray);
        }
    }
}

