/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.protocols.taxcard;

import java.util.HashMap;
import java.util.Map;

public enum CardOpCode {
    OK("9000"),
    PinVerificationRequired("6301"),
    WrongPinCode("6302"),
    WrongPinSize("6303"),
    MaxNumberOfCategoriesExceeded("6304"),
    MaxTaxAmountExceeded("6305"),
    AuditNotStartedYet("6306"),
    InvoiceSigningDisabled("6307"),
    AllowedPinEntriesExceeded("6310"),
    OperationOverflow("63FF"),
    DataNot256BytesLong("6700"),
    AuditIdentificationNotValid("6A80"),
    CardAppletNotSelected("6882"),
    CardSwClaNotSelected("6E00"),
    Unknown("unknown"),
    CardNotPresent("card_not_present"),
    NoReply("no_reply");

    private static final Map<String, CardOpCode> byId;
    private String code;

    private CardOpCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static CardOpCode getByCode(String code) {
        return byId.get(code);
    }

    public static CardOpCode getByCode(int intCode) {
        CardOpCode cardOpCode = byId.get(Integer.toHexString(intCode).toUpperCase());
        if (cardOpCode == null) {
            return Unknown;
        }
        return cardOpCode;
    }

    static {
        byId = new HashMap<String, CardOpCode>();
        for (CardOpCode e : CardOpCode.values()) {
            if (byId.put(e.getCode(), e) == null) continue;
            throw new IllegalArgumentException("duplicate code: " + e.getCode());
        }
    }
}

