/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.printimage;

import com.dmi.sdccore.api.model.report.Report;
import com.dmi.sdccore.printimage.ContentProporties;
import com.dmi.sdccore.printimage.EscPosPrinterStandard;
import com.dmi.sdccore.printimage.NPrintUtil;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.output.PrinterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import javax.print.PrintService;

public class NarrowPosPrintCurrentSales
extends ContentProporties {
    public void printReport(Report report) {
        StringBuilder sales = this.makeContent(report);
        this.printFiscalBill(report, sales);
    }

    private StringBuilder makeContent(Report report) {
        String val;
        String reportDate = report.getDateFrom();
        String header = report.getReportHeader();
        if (report.getDateTo() != null && !report.getDateTo().isEmpty()) {
            reportDate = reportDate + "-" + report.getDateTo();
        }
        String pattern = "###,##0.00";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(this.makeMultiRowContent("PIB:" + report.getPib(), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(this.makeMultiRowContent(report.getCompanyName(), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(this.makeMultiRowContent(report.getAddress(), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(this.makeMultiRowContent(report.getCityName(), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.contentInTheMiddle(header + " " + reportDate, report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Gotovina:", decimalFormat.format(report.getReportPayment().get("Gotovina")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Kartica:", decimalFormat.format(report.getReportPayment().get("Platna Kartica")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Cek:", decimalFormat.format(report.getReportPayment().get("\u010cek")), report.getNumOfCharacters()) + "\n");
        BigDecimal value = report.getReportPayment().get("Prenos na ra\u010dun") != null ? report.getReportPayment().get("Prenos na ra\u010dun") : report.getReportPayment().get("Faktura");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Faktura:", decimalFormat.format(value), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Vau\u010der:", decimalFormat.format(report.getReportPayment().get("Vau\u010der")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Instant placanje:", decimalFormat.format(report.getReportPayment().get("Instant pla\u0107anje")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Ostalo:", decimalFormat.format(report.getReportPayment().get("Ostalo")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Ukupno:", decimalFormat.format(report.getReportPayment().get("Ukupno")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        for (Map.Entry<String, BigDecimal> entry : report.getBasic().entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween(val, decimalFormat.format(entry.getValue()), report.getNumOfCharacters()) + "\n");
        }
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append("Osnovice po stopama \n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        for (Map.Entry<String, BigDecimal> entry : report.getBasic().entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween(val, decimalFormat.format(entry.getValue()), report.getNumOfCharacters()) + "\n");
        }
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append("Pdv po stopama \n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        for (Map.Entry<String, BigDecimal> entry : report.getPdv().entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween(val, decimalFormat.format(entry.getValue()), report.getNumOfCharacters()) + "\n");
        }
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("*Avans uplaceno :", decimalFormat.format(report.getReportPayment().get("Avans")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("*Predracun uplaceno :", decimalFormat.format(report.getReportPayment().get("Predracun")), report.getNumOfCharacters()) + "\n");
        return stringBuilder;
    }

    public void printFiscalBill(Report report, StringBuilder sales) {
        PrintService service = PrinterOutputStream.getPrintServiceByName((String)report.getServerName());
        try {
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            EscPosPrinterStandard escPosPrinter = new EscPosPrinterStandard(escPos);
            escPosPrinter.printImage(sales, null, report.getNumOfCharacters(), escPos, null, new StringBuilder());
            escPosPrinter.printBlankLines(5);
            escPos.cut(EscPos.CutMode.FULL);
            escPos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

