/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.printimage;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.CoffeeImage;
import com.github.anastaciocintra.escpos.image.CoffeeImageImpl;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImageHelper {
    final int maxWidth;
    final int maxHeight;
    final int idiupm = 12;

    public ImageHelper(int width) {
        this(width, 12);
    }

    public ImageHelper(int maxWidth, int maxHeight) {
        if (maxHeight < 24) {
            maxHeight = 12;
        }
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public List<BufferedImage> sliceImage(BufferedImage coffeeImage) {
        ArrayList<BufferedImage> listImages = new ArrayList<BufferedImage>();
        int x = 0;
        int y = 0;
        int x_offset = this.maxWidth;
        int y_offset = this.maxHeight;
        do {
            if (x > coffeeImage.getWidth() - 1) {
                x = coffeeImage.getWidth() - 1;
            }
            if (x + x_offset > coffeeImage.getWidth()) {
                x_offset = coffeeImage.getWidth() - x;
            }
            if (y >= coffeeImage.getHeight() - 1) {
                y = coffeeImage.getHeight() - 1;
            }
            if (y + y_offset > coffeeImage.getHeight()) {
                y_offset = coffeeImage.getHeight() - y;
            }
            BufferedImage tmp = coffeeImage.getSubimage(0, y, x_offset, y_offset);
            listImages.add(tmp);
        } while ((y += y_offset) < coffeeImage.getHeight());
        return listImages;
    }

    public void write(EscPos escPos, BufferedImage image, ImageWrapperInterface wrapper, Bitonal bitonalAlgorithm) throws IOException, IOException {
        List<BufferedImage> images = this.sliceImage(image);
        for (BufferedImage img : images) {
            escPos.write(wrapper, new EscPosImage((CoffeeImage)new CoffeeImageImpl(img), bitonalAlgorithm));
        }
    }
}

