/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.printimage;

import com.dmi.sdccore.printimage.CodePageConverterUtil;
import com.dmi.sdccore.printimage.FormaterUtil;
import com.dmi.sdccore.printimage.ImageHelper;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.BitonalThreshold;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import com.github.anastaciocintra.escpos.image.RasterBitImageWrapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class EscPosPrinterStandard {
    private static final String PRINTER_NAME_TRADER = "TRADER";
    private static final String PRINTER_NAME_BIRCH_A530 = "BIRCH-A530";
    private static final String PRINTER_NAME_BIRCH_CPQ1UN = "BIRCH-CPQ1UN";
    public static final String PRINTER_NAME_EPSON = "EPSON";
    private final EscPos escPos;
    private int defaultCodePage;
    private String defaultCharsetName;
    private int latinCodePage;
    private String latinCharsetName;
    private int cyrCodePage;
    private String cyrCharsetName;
    private String printerServerName;

    public EscPosPrinterStandard(EscPos escPos) {
        this.defaultCodePage = EscPos.CharacterCodeTable.CP852_Latin2.value;
        this.defaultCharsetName = EscPos.CharacterCodeTable.CP852_Latin2.charsetName;
        this.latinCodePage = EscPos.CharacterCodeTable.CP852_Latin2.value;
        this.latinCharsetName = EscPos.CharacterCodeTable.CP852_Latin2.charsetName;
        this.cyrCodePage = 36;
        this.cyrCharsetName = "cp855";
        this.escPos = escPos;
    }

    public EscPosPrinterStandard(EscPos escPos, String printerServerName) {
        this.defaultCodePage = EscPos.CharacterCodeTable.CP852_Latin2.value;
        this.defaultCharsetName = EscPos.CharacterCodeTable.CP852_Latin2.charsetName;
        this.latinCodePage = EscPos.CharacterCodeTable.CP852_Latin2.value;
        this.latinCharsetName = EscPos.CharacterCodeTable.CP852_Latin2.charsetName;
        this.cyrCodePage = 36;
        this.cyrCharsetName = "cp855";
        this.escPos = escPos;
        this.printerServerName = printerServerName;
        if (this.isPrinterTrader()) {
            this.latinCodePage = 32;
            this.latinCharsetName = "cp852";
            this.cyrCodePage = 38;
            this.cyrCharsetName = "cp855";
        }
        if (this.isPrinterBirchCPQ1UN()) {
            this.latinCodePage = 18;
            this.latinCharsetName = "cp852";
            this.cyrCodePage = 60;
            this.cyrCharsetName = "cp855";
        }
        if (this.isPrinterBirchA530()) {
            this.latinCodePage = 32;
            this.latinCharsetName = "cp852";
            this.cyrCodePage = 38;
            this.cyrCharsetName = "cp855";
        }
        if (printerServerName.toUpperCase().contains(PRINTER_NAME_EPSON)) {
            System.out.println("EPSON PRINTER");
            this.latinCodePage = 18;
            this.latinCharsetName = "cp852";
            this.cyrCodePage = 46;
            this.cyrCharsetName = "cp1251";
        }
    }

    public void printBlankLine() throws IOException {
        this.printBlankLines(1);
    }

    public void printBlankLines(int lineCount) throws IOException {
        this.escPos.feed(lineCount);
    }

    public void print(String value) throws IOException {
        this.printWithStyle(value, this.defaultCodePage, this.defaultCharsetName, null);
    }

    public void printLine(String value) throws IOException {
        this.printWithStyle(value, this.defaultCodePage, this.defaultCharsetName, null);
        this.escPos.writeLF("");
    }

    public void print(String value, Integer codePageTable, String charsetName) throws IOException {
        this.printWithStyle(value, codePageTable, charsetName, null);
    }

    public void printWithStyle(String value, Integer codePageTable, String charsetName, Style style) throws IOException {
        if (style != null) {
            byte[] configBytes = style.getConfigBytes();
            this.escPos.write(configBytes, 0, configBytes.length);
        }
        this.escPos.setPrinterCharacterTable(codePageTable.intValue());
        this.escPos.write(CodePageConverterUtil.convertToBytes(value, charsetName), 0, value.length());
    }

    public void printLatin(String value) throws IOException {
        this.print(value, this.latinCodePage, this.latinCharsetName);
    }

    public void printCyrillic(String value) throws IOException {
        this.print(value, this.cyrCodePage, this.cyrCharsetName);
    }

    public void printLine(String value, Integer codePageTable, String charsetName) throws IOException {
        if (!this.canPrintCyrAndLatInOneLine()) {
            this.escPos.flush();
            this.escPos.initializePrinter();
        }
        this.print(value, codePageTable, charsetName);
        this.escPos.writeLF("");
    }

    public void printLineWithStyle(String value, Integer codePageTable, String charsetName, Style style) throws IOException {
        this.printWithStyle(value, codePageTable, charsetName, style);
        this.escPos.writeLF("");
    }

    public void printLineLatinWithStyle(String value, Style style) throws IOException {
        this.printWithStyle(value, this.latinCodePage, this.latinCharsetName, style);
        this.escPos.writeLF("");
    }

    public void printLineLatin(String value) throws IOException {
        if (!this.canPrintCyrAndLatInOneLine()) {
            this.escPos.flush();
            this.escPos.initializePrinter();
        }
        this.printLatin(value);
        this.escPos.writeLF("");
    }

    public void printLineCyrillic(String value) throws IOException {
        if (!this.canPrintCyrAndLatInOneLine()) {
            this.escPos.flush();
            this.escPos.initializePrinter();
        }
        this.printCyrillic(value);
        this.escPos.writeLF("");
    }

    public void printLineAutoDetect(String value) throws IOException {
        if (FormaterUtil.isCyrillic(value)) {
            this.printLineCyrillic(value);
        } else {
            this.printLineLatin(value);
        }
    }

    public int getLatinCodePage() {
        return this.latinCodePage;
    }

    public void setLatinCodePage(int latinCodePage) {
        this.latinCodePage = latinCodePage;
    }

    public String getLatinCharsetName() {
        return this.latinCharsetName;
    }

    public void setLatinCharsetName(String latinCharsetName) {
        this.latinCharsetName = latinCharsetName;
    }

    public int getCyrCodePage() {
        return this.cyrCodePage;
    }

    public void setCyrCodePage(int cyrCodePage) {
        this.cyrCodePage = cyrCodePage;
    }

    public String getCyrCharsetName() {
        return this.cyrCharsetName;
    }

    public void setCyrCharsetName(String cyrCharsetName) {
        this.cyrCharsetName = cyrCharsetName;
    }

    public EscPos getEscPos() {
        return this.escPos;
    }

    public String getPrinterServerName() {
        return this.printerServerName;
    }

    public void setPrinterServerName(String printerServerName) {
        this.printerServerName = printerServerName;
    }

    public boolean isPrinterTrader() {
        if (this.printerServerName == null) {
            return false;
        }
        return this.printerServerName.toUpperCase().contains(PRINTER_NAME_TRADER);
    }

    public boolean isPrinterBirchCPQ1UN() {
        if (this.printerServerName == null) {
            return false;
        }
        return this.printerServerName.toUpperCase().contains(PRINTER_NAME_BIRCH_CPQ1UN);
    }

    public boolean isPrinterBirchA530() {
        if (this.printerServerName == null) {
            return false;
        }
        return this.printerServerName.toUpperCase().contains(PRINTER_NAME_BIRCH_A530);
    }

    public boolean canPrintCyrAndLatInOneLine() {
        return !this.isPrinterTrader() && !this.isPrinterBirchCPQ1UN() && !this.isPrinterBirchA530();
    }

    public void printImage(StringBuilder sb, String endBill, int numberCharset, EscPos escPos, String invoice, StringBuilder stringBuilder) {
        try {
            this.printImage1(sb.toString(), endBill, numberCharset, escPos, invoice, stringBuilder);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void printImage1(String value, String endBill, int numberCharSet, EscPos escPos, String invoice, StringBuilder stringBuilder) throws IOException, Exception {
        BufferedImage imageBufferedImage = endBill != null ? this.convert(value, endBill, numberCharSet, escPos, invoice, stringBuilder) : this.convert(value, numberCharSet, escPos);
        RasterBitImageWrapper imageWrapper = new RasterBitImageWrapper();
        imageWrapper.setJustification(EscPosConst.Justification.Left_Default);
        BitonalThreshold algorithm = new BitonalThreshold();
        ImageHelper helper = new ImageHelper(imageBufferedImage.getWidth());
        helper.write(escPos, imageBufferedImage, (ImageWrapperInterface)imageWrapper, (Bitonal)algorithm);
    }

    public BufferedImage generateQRCodeImage(String barcodeText) throws Exception {
        QRCodeWriter barcodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, 450, 450);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public static BufferedImage generateEAN13BarcodeImage(String barcodeText) throws Exception {
        BitMatrix bitMatrix = new MultiFormatWriter().encode(barcodeText, BarcodeFormat.CODE_93, 450, 100);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public BufferedImage convert(String text, String endBill, int numberCharSet, EscPos escPos, String invoice, StringBuilder stringBuilder) throws Exception {
        String[] arrayAndBill = endBill.split("\n");
        String[] text_array = text.split("[\n]");
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = img.createGraphics();
        int fontSize = 24;
        if (numberCharSet <= 30) {
            fontSize = 24;
        }
        Font font = new Font("Consolas", 0, fontSize);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        int width = (int)font.getStringBounds(EscPosPrinterStandard.getLongestLine(text_array), frc).getWidth();
        int lines = EscPosPrinterStandard.getLineCount(text);
        BufferedImage imageBufferedImage = numberCharSet < 35 ? this.generateQRCodeImage57(arrayAndBill[0]) : this.generateQRCodeImage(arrayAndBill[0]);
        int hightQ = imageBufferedImage.getHeight();
        int height = fm.getHeight() * lines + hightQ;
        if (arrayAndBill.length > 3) {
            height += 70;
        }
        if (stringBuilder != null && !stringBuilder.toString().isEmpty()) {
            height += 100;
        }
        g2d.dispose();
        img = new BufferedImage(width, height - lines * 7, 2);
        g2d = img.createGraphics();
        g2d.setFont(font);
        fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        int y = 1;
        boolean fisklaniRacun = false;
        for (int i = 1; i <= lines; ++i) {
            y = fm.getAscent() * i;
            if (text_array[i - 1].contains("FISKALNI RA\u010cUN")) {
                fisklaniRacun = true;
            }
            if (text_array[i - 1].contains("OVO NIJE FISKALNI RA\u010cUN") && i >= 2) {
                if (numberCharSet <= 30) {
                    g2d.setFont(new Font("Consolas", 1, 26));
                } else {
                    g2d.setFont(new Font("Consolas", 1, 27));
                }
                g2d.drawString(text_array[i - 1], 0, y);
                continue;
            }
            g2d.setFont(font);
            g2d.drawString(text_array[i - 1], 0, y);
        }
        System.out.println("Vrednost 1.y je " + y);
        RasterBitImageWrapper imageWrapper = new RasterBitImageWrapper();
        imageWrapper.setJustification(EscPosConst.Justification.Center);
        int xValue = 50;
        if (numberCharSet <= 30) {
            xValue = -30;
        }
        g2d.drawImage((Image)imageBufferedImage, xValue, y - 5, null);
        g2d.drawString(arrayAndBill[1], 0, y + hightQ - 10);
        if (arrayAndBill.length == 3) {
            System.out.println("Vrednost niza je 3" + arrayAndBill[2]);
            g2d.drawString(arrayAndBill[2], xValue - 100, y + hightQ - 20);
        }
        if (arrayAndBill.length > 3) {
            y = y + hightQ - 20;
            for (int i = 2; i < arrayAndBill.length; ++i) {
                g2d.drawString(arrayAndBill[i], xValue, y);
                y += 30;
            }
        }
        System.out.println("Vrednost 2.y je " + y);
        boolean isAvans = false;
        if (stringBuilder != null && !stringBuilder.toString().isEmpty() && text != null && !text.contains("REFUNDACIJA")) {
            int z = y + hightQ;
            lines = EscPosPrinterStandard.getLineCount(stringBuilder.toString());
            text_array = stringBuilder.toString().split("[\n]");
            for (int i = 1; i <= lines; ++i) {
                y = fm.getAscent() * i + z;
                g2d.setFont(font);
                g2d.drawString(text_array[i - 1], 0, y);
                y += 30;
            }
            isAvans = true;
            System.out.println("Usao u deo za kreiranje footera " + y);
        }
        System.out.println("Vrednost 3.y je " + y + hightQ);
        System.out.println("Stampa u toku");
        g2d.dispose();
        return img;
    }

    private BufferedImage generateQRCodeImage57(String barcodeText) throws WriterException {
        System.out.println("Qr code 57");
        QRCodeWriter barcodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, 444, 444);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public BufferedImage convert(String text, int numberCharSet, EscPos escPos) throws Exception {
        String[] text_array = text.split("[\n]");
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = img.createGraphics();
        int fontSize = 24;
        if (numberCharSet <= 30) {
            fontSize = 23;
        }
        Font font = new Font("Consolas", 0, fontSize);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        int width = (int)font.getStringBounds(EscPosPrinterStandard.getLongestLine(text_array), frc).getWidth() + 10;
        int lines = EscPosPrinterStandard.getLineCount(text);
        int height = fm.getHeight() * lines;
        g2d.dispose();
        img = new BufferedImage(width, height - lines * 7, 2);
        g2d = img.createGraphics();
        g2d.setFont(font);
        fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        int y = 1;
        for (int i = 1; i <= lines; ++i) {
            y = fm.getAscent() * i;
            g2d.drawString(text_array[i - 1], 0, y);
        }
        ImageIO.write((RenderedImage)img, "png", new File("C:\\Users\\dbogi\\OneDrive\\Dokument\\5comKONACNI\\imagedejan.jpg"));
        g2d.dispose();
        return img;
    }

    public static int getLineCount(String text) {
        return text.split("[\n]").length;
    }

    private static String getLongestLine(String[] arr) {
        String max = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (max.length() >= arr[i].length()) continue;
            max = arr[i];
        }
        return max;
    }
}

