/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.endpoints.v3;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.api.model.ApiErrCode;
import com.dmi.sdccore.api.model.TaxCoreConfiguration;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="v3/environment-parameters")
public class EnvParamsController {
    private static final Logger logger = LogManager.getLogger(EnvParamsController.class);

    @GET
    @Produces(value={"application/json"})
    public Response getEnvParams() {
        logger.info("Local API-Get env params");
        AppState appState = AppState.getInstance();
        if (!appState.isCardInserted()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.SmartCardNotPresent.getCode()).build();
        }
        if (!appState.isCardPinCodeEntered()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.PinCodeRequired.getCode()).build();
        }
        if (!appState.isSdcInitialized()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.DeviceNotConfigured.getCode()).build();
        }
        TaxCoreConfiguration environment = AppState.getInstance().getTaxCoreConfiguration();
        if (environment == null) {
            environment = new TaxCoreConfiguration();
        }
        return Response.ok().entity((Object)environment).build();
    }
}

