/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore;

import com.dmi.sdccore.AppSettings;
import com.dmi.sdccore.AppState;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.api.filters.CorsFilter;
import com.dmi.sdccore.api.model.ApiErrCode;
import com.dmi.sdccore.api.model.TaxCoreCommandResponse;
import com.dmi.sdccore.events.NotificationEvent;
import com.dmi.sdccore.events.NotificationSeverity;
import com.dmi.sdccore.events.SystemEvent;
import com.dmi.sdccore.events.SystemEventType;
import com.dmi.sdccore.model.Licenca;
import com.dmi.sdccore.model.TaxCardCertificate;
import com.dmi.sdccore.protocols.sdcapi.SdcApiClient;
import com.dmi.sdccore.protocols.taxapi.TaxApiClient;
import com.dmi.sdccore.protocols.taxapi.model.ApiResponse;
import com.dmi.sdccore.protocols.taxcard.CardCommand;
import com.dmi.sdccore.protocols.taxcard.CardOpCode;
import com.dmi.sdccore.protocols.taxcard.CardReader;
import com.dmi.sdccore.protocols.taxcard.CardResponse;
import com.dmi.sdccore.ui.BoolStatusUiItem;
import com.dmi.sdccore.ui.EnterPinCodeDialog;
import com.dmi.sdccore.ui.MainPanel;
import com.dmi.sdccore.ui.SdcTrayIcon;
import com.dmi.sdccore.ui.SelectDriveChooser;
import com.dmi.sdccore.ui.SettingsDialog;
import com.dmi.sdccore.ui.StatusTabPanel;
import com.dmi.sdccore.ui.UiUtil;
import com.dmi.sdccore.utils.DateTimeUtil;
import com.dmi.sdccore.utils.FsUtil;
import com.dmi.sdccore.utils.JsonUtil;
import com.dmi.sdccore.utils.helpers.FileDrive;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javax.servlet.Servlet;
import javax.swing.Timer;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class Main
extends Application {
    private static final Logger logger = LogManager.getLogger(Main.class);
    Scene mainUiScene;
    MainPanel mainUiPanel;
    SdcTrayIcon trayIcon;
    Server apiServer;
    Thread apiServerThread;

    public void start(Stage stage) throws Exception {
        logger.info("App starting");
        logger.info("Java: {} ({} bit), OS: {} ({})", (Object)System.getProperty("java.version"), (Object)System.getProperty("sun.arch.data.model"), (Object)System.getProperty("os.name"), (Object)System.getProperty("os.version"));
        this.initAppSettings();
        this.initFs();
        EventBus.getDefault().register((Object)this);
        this.buildUi(stage);
        CardReader.getInstance().start();
        TaxApiClient.getInstance().startOnlineNotifier(this.mainUiPanel.getStatusTabPanel());
        this.startApiServer();
        if (this.netIsAvailable()) {
            logger.info("Dostupan internet ");
            Thread.sleep(3000L);
            AppState appState = AppState.getInstance();
            TaxCardCertificate taxCardCertificate = appState.getTaxCardCertificate();
            if (taxCardCertificate != null) {
                logger.info("TaxCardCertificate" + taxCardCertificate.toString());
            } else {
                logger.error("TaxCardCertificate nema karticu umetnutu");
            }
            if (taxCardCertificate != null) {
                ObjectMapper mapper = new ObjectMapper();
                OkHttpClient client = new OkHttpClient();
                System.out.println("Issuer " + taxCardCertificate.getSubject() + " " + taxCardCertificate.getIssuer());
                FormBody formBody = new FormBody.Builder().add("vatNumber", String.valueOf(taxCardCertificate.getTaxpayerTin())).add("validTo", String.valueOf(taxCardCertificate.getValidTo())).add("note", String.valueOf(taxCardCertificate.getSubject().getO() + " ," + taxCardCertificate.getSubject().getStreet()) + ", " + taxCardCertificate.getSubject().getL()).add("cardNumber", taxCardCertificate.getSubject().getSerialNumber()).build();
                Request request = new Request.Builder().url("https://licence.mastersoftware.rs/api/licence/lpfr").post((RequestBody)formBody).header("Authorization", "Bearer 4dd8e53310a2e3be2553893e4ac945dd004577d44a296027d3877c183e200cba").build();
                try {
                    Response response = client.newCall(request).execute();
                    logger.info("Poziv apija " + response.toString() + "," + response.code());
                    if (200 == response.code()) {
                        Licenca licenca = (Licenca)mapper.readValue(response.body().byteStream(), Licenca.class);
                        logger.info(licenca.toString());
                        if (!licenca.getLicence().booleanValue()) {
                            logger.error("Licena je " + licenca);
                            EventManager.getInstance().postNotification("Greska ", licenca.getMessage(), NotificationSeverity.Error);
                            Thread.sleep(15000L);
                            this.exitApplication();
                        } else if (licenca.getMessage() != null && !licenca.getMessage().isEmpty()) {
                            StatusTabPanel statusTabPanel = this.mainUiPanel.getStatusTabPanel();
                            BoolStatusUiItem item1 = statusTabPanel.findItem("text.license.valid.");
                            item1.updateStatus1(true, " Upozorenje :" + licenca.getMessage());
                            item1.setVisible(true);
                            EventManager.getInstance().postNotification("Upozorenje ", "Upozorenje " + licenca.getMessage(), NotificationSeverity.Warning);
                        }
                    } else {
                        EventManager.getInstance().postNotification("Upozorenje ", "Nema odgovora od licence servisa!!!", NotificationSeverity.Warning);
                        logger.error("Greska  " + response.code());
                        logger.error("Response code je " + response.code());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Gresska se dogodila " + e.getMessage());
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)AppSettings.getInstance().getSdcLicense())) {
            stage.show();
        }
    }

    private void startApiServer() {
        this.apiServerThread = new Thread(this::initSdcApiServerAndClient);
        this.apiServerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSdcApiServerAndClient() {
        SdcApiClient.getInstance().initialize("http://localhost:" + AppSettings.getInstance().getSdcTcpPort());
        logger.info("Local API server starting");
        this.apiServer = new Server();
        ServerConnector httpConnector = new ServerConnector(this.apiServer);
        httpConnector.setHost("0.0.0.0");
        httpConnector.setPort(AppSettings.getInstance().getSdcTcpPort());
        httpConnector.setIdleTimeout(30000L);
        this.apiServer.addConnector((Connector)httpConnector);
        ServletContextHandler ctx = new ServletContextHandler(0);
        ctx.setContextPath("/");
        this.apiServer.setHandler((Handler)ctx);
        ResourceConfig rc = new ResourceConfig();
        rc.registerClasses(new Class[]{CorsFilter.class}).packages(new String[]{"com.dmi.sdccore.api.endpoints"});
        ServletHolder sh = new ServletHolder((Servlet)new ServletContainer(rc));
        sh.setInitOrder(1);
        sh.setInitParameter("jersey.config.server.provider.packages", "com.dmi.sdccore.api.endpoints.*");
        ctx.addServlet(sh, "/api/*");
        try {
            this.apiServer.start();
            logger.info("Local API server started");
            this.apiServer.join();
        }
        catch (Exception ex) {
            logger.error("Error starting local API server", (Throwable)ex);
            new Timer(3000, e -> this.exitApplication()).start();
        }
    }

    private void stopApiServer() {
        logger.info("Local API server stopping");
        try {
            this.apiServer.stop();
            this.apiServer.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAppSettings() throws IOException {
        AppSettings.getInstance().createDefaultProperties();
        AppSettings.getInstance().loadProperties();
    }

    private void initFs() {
        logger.info("Init file system");
        FsUtil.createLocalFileStorage();
        FsUtil.createAuditDirectory();
        try {
            AppState.getInstance().setLastRemoteAuditStartTime(FsUtil.readLastRemoteAuditTimeFromFs());
            AppState.getInstance().setLastInvoiceNumber(FsUtil.readLastInvoiceNumberFromFs());
            AppState.getInstance().setLastSdcTimestamp(FsUtil.readLastSdcTimestampFromFs());
        }
        catch (Exception e) {
            logger.error("initFs()", (Throwable)e);
        }
        AppState.getInstance().setExternalDiskPresent(FsUtil.isExternalDiskPresent());
    }

    private void buildUi(Stage stage) {
        this.mainUiPanel = new MainPanel();
        this.mainUiPanel.getMainMenuBar().setStartAuditAction((EventHandler<ActionEvent>)((EventHandler)e -> this.startLocalAudit()));
        this.mainUiPanel.getMainMenuBar().setLoadCommandsAction((EventHandler<ActionEvent>)((EventHandler)e -> this.startLoadCommands()));
        this.mainUiPanel.getMainMenuBar().setExportLogFileAction((EventHandler<ActionEvent>)((EventHandler)e -> this.exportLogFile()));
        this.mainUiPanel.getMainMenuBar().setShowSettingsAction((EventHandler<ActionEvent>)((EventHandler)e -> this.showServiceSettings()));
        this.mainUiPanel.getMainMenuBar().setEnterPinAction((EventHandler<ActionEvent>)((EventHandler)e -> this.showEnterPinCodeDialog()));
        this.mainUiPanel.getMainMenuBar().setEnterrestartAction((EventHandler<ActionEvent>)((EventHandler)e -> this.showRestartSettings()));
        this.mainUiScene = new Scene((Parent)this.mainUiPanel);
        this.mainUiScene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/application.css").toExternalForm());
        this.trayIcon = new SdcTrayIcon(stage, this.getLogoUrl());
        this.trayIcon.setShowScreenAction((EventHandler<ActionEvent>)((EventHandler)e -> this.showStage(stage)));
        this.trayIcon.setExitAppAction((EventHandler<ActionEvent>)((EventHandler)e -> this.exitApplication()));
        stage.setScene(this.mainUiScene);
        stage.getIcons().add((Object)new Image(String.valueOf(this.getLogoUrl())));
        stage.setTitle("Master LPFR ver 1.1");
        stage.sizeToScene();
        this.trayIcon.show();
        if (StringUtils.isBlank((CharSequence)AppSettings.getInstance().getSdcLicense())) {
            stage.show();
        }
    }

    private void showRestartSettings() {
        AppState appState = AppState.getInstance();
        CardReader.getInstance().setCardTerminal(null);
        appState.setTerminalConnected(false);
        appState.clearDataOnCardRemoval();
        CardReader.getInstance().getCardPresenceNotifier().setFirstPass(true);
        EventManager.getInstance().postSystemEvent(SystemEventType.RestartApiServer);
    }

    private void startLocalAudit() {
        AppState appState = AppState.getInstance();
        String drivePath = this.selectAndGetDrivePath();
        if (drivePath == null) {
            return;
        }
        Optional option = UiUtil.createConfirmationDialog(I18N.text("message.audit.confirmation")).showAndWait();
        if (!option.isPresent() || option.get() == ButtonType.CANCEL) {
            return;
        }
        if (appState.isAuditInProgress()) {
            UiUtil.createAlertWarnDialog(I18N.text("message.audit.in.progress")).showAndWait();
            return;
        }
        new Thread(() -> this.doLocalAudit(drivePath)).start();
    }

    private void doLocalAudit(String drivePath) {
        logger.info("Local audit start on drive " + drivePath);
        AppState appState = AppState.getInstance();
        appState.setAuditInProgress(true);
        EventManager.getInstance().postInfoNotification(I18N.text("message.audit.in.progress"));
        boolean auditSuccess = true;
        String commandsFileFullPath = null;
        String cardSerialNumber = null;
        if (appState.isCardInserted() && appState.isTaxCardInfoRead()) {
            cardSerialNumber = appState.getTaxCardCertificate().getSubject().getSerialNumber();
            String destinationAuditDirectory = drivePath + cardSerialNumber;
            if (!FsUtil.fileExists(destinationAuditDirectory)) {
                FsUtil.createDir(destinationAuditDirectory);
            } else {
                FsUtil.deleteFilesFromDirectory(destinationAuditDirectory);
            }
            commandsFileFullPath = drivePath + cardSerialNumber + ".commands";
            String resultsFileFullPath = drivePath + cardSerialNumber + ".results";
            String arpFileFullPath = destinationAuditDirectory + File.separator + cardSerialNumber + ".arp";
            if (FsUtil.fileExists(commandsFileFullPath)) {
                try {
                    String commandsJsonString = FsUtil.readFileToString(commandsFileFullPath);
                    List<TaxCoreCommandResponse> commandResponses = TaxApiClient.getInstance().executeTaxCoreCommands(commandsJsonString, "", appState, false);
                    String commandResponsesJsonString = JsonUtil.gsonBuilderWithZonedDtSer.create().toJson(commandResponses);
                    FsUtil.writeFile(resultsFileFullPath, commandResponsesJsonString);
                }
                catch (Exception exception) {
                    logger.error("Local audit error", (Throwable)exception);
                    auditSuccess = false;
                }
            } else {
                logger.info("Local audit - drive does not have command file");
            }
            CardResponse cardResponse = CardCommand.getInstance().startAudit();
            if (CardOpCode.OK == cardResponse.getOpCode()) {
                byte[] arpBytes = cardResponse.getData();
                try {
                    FsUtil.writeFile(arpFileFullPath, arpBytes);
                    logger.info("ARP file copied to drive at " + arpFileFullPath);
                }
                catch (Exception exception) {
                    logger.error("Local audit error - arp file writing failed", (Throwable)exception);
                    auditSuccess = false;
                }
            } else {
                logger.error("Local audit error - start audit read failed");
                auditSuccess = false;
            }
        }
        if (auditSuccess) {
            try {
                List<File> existingAuditPackageDirectories = FsUtil.getExistingAuditPackageDirectories();
                for (File auditPackageDirectory : existingAuditPackageDirectories) {
                    File[] availableAuditPackages;
                    String cardSerialNumberFromFolderName = auditPackageDirectory.getName();
                    String destinationAuditDirectory = drivePath + cardSerialNumberFromFolderName;
                    if (!FsUtil.fileExists(destinationAuditDirectory)) {
                        FsUtil.createDir(destinationAuditDirectory);
                    }
                    if ((availableAuditPackages = FsUtil.getAuditPackagesForSubmittingByUid(cardSerialNumberFromFolderName)) != null && availableAuditPackages.length > 0) {
                        if (cardSerialNumber != null && cardSerialNumber.equals(cardSerialNumberFromFolderName)) {
                            String lastInvoiceNumber = FsUtil.getLastInvoiceNumber(availableAuditPackages);
                            FsUtil.writeFile(FsUtil.FN_LOCAL_AUDIT_LATEST_INVOICE + "_" + cardSerialNumber, lastInvoiceNumber);
                        }
                        for (File file : availableAuditPackages) {
                            FsUtil.copyFile(file, new File(destinationAuditDirectory));
                        }
                        logger.info("Local audit - {} audit packages copied", (Object)availableAuditPackages.length);
                        continue;
                    }
                    logger.info("Local audit - There are no audit packages to copy.");
                }
            }
            catch (Exception exception) {
                logger.error("Local audit error", (Throwable)exception);
                auditSuccess = false;
            }
        }
        appState.setAuditInProgress(false);
        if (auditSuccess) {
            logger.info("Local audit end OK");
            if (appState.isCardInserted() && appState.isTaxCardInfoRead() && commandsFileFullPath != null && FsUtil.fileExists(commandsFileFullPath)) {
                FsUtil.deleteFile(commandsFileFullPath);
            }
            new Thread(() -> EventManager.getInstance().postInfoNotification(I18N.text("message.audit.end.success"))).start();
        } else {
            logger.error("Local audit end error");
            new Thread(() -> EventManager.getInstance().postInfoNotification(I18N.text("message.audit.end.error"))).start();
        }
    }

    private void startLoadCommands() {
        AppState appState = AppState.getInstance();
        String cardSerialNumber = null;
        String drivePath = this.selectAndGetDrivePath();
        if (drivePath == null) {
            return;
        }
        if (!appState.isTaxCardInfoRead()) {
            logger.info("Load commands - Card is not present");
            UiUtil.createAlertErrorDialog(I18N.text("text.card.connected.false")).showAndWait();
            return;
        }
        cardSerialNumber = appState.getTaxCardCertificate().getSubject().getSerialNumber();
        String cardUid = cardSerialNumber;
        new Thread(() -> this.doLoadCommands(drivePath, cardUid)).start();
    }

    private void doLoadCommands(String drivePath, String cardSerialNumber) {
        logger.info("Load commands start from drive " + drivePath);
        boolean success = true;
        AppState appState = AppState.getInstance();
        String commandsFileFullPath = drivePath + cardSerialNumber + ".commands";
        String resultsFileFullPath = drivePath + cardSerialNumber + ".results";
        if (FsUtil.fileExists(commandsFileFullPath)) {
            try {
                String commandsJsonString = FsUtil.readFileToString(commandsFileFullPath);
                List<TaxCoreCommandResponse> commandResponses = TaxApiClient.getInstance().executeTaxCoreCommands(commandsJsonString, "", appState, false);
                String commandResponsesJsonString = JsonUtil.gsonBuilderWithZonedDtSer.create().toJson(commandResponses);
                FsUtil.writeFile(resultsFileFullPath, commandResponsesJsonString);
            }
            catch (Exception exception) {
                logger.error("Load commands error", (Throwable)exception);
                success = false;
            }
        } else {
            logger.info("Load commands - drive does not have command file");
            new Thread(() -> EventManager.getInstance().postErrorNotification(I18N.text("message.drive.not.have.command.file"))).start();
            Platform.runLater(() -> UiUtil.createAlertErrorDialog(I18N.text("message.drive.not.have.command.file")).showAndWait());
            return;
        }
        if (success) {
            logger.info("Load commands end OK");
            if (appState.isCardInserted() && appState.isTaxCardInfoRead() && commandsFileFullPath != null && FsUtil.fileExists(commandsFileFullPath)) {
                FsUtil.deleteFile(commandsFileFullPath);
            }
            new Thread(() -> EventManager.getInstance().postInfoNotification(I18N.text("message.load.commands.end.success"))).start();
            Platform.runLater(() -> UiUtil.createAlertInfoDialog(I18N.text("message.load.commands.end.success")).showAndWait());
        } else {
            logger.error("Load commands end error");
            new Thread(() -> EventManager.getInstance().postInfoNotification(I18N.text("message.load.commands.end.error"))).start();
            Platform.runLater(() -> UiUtil.createAlertErrorDialog(I18N.text("message.load.commands.end.error")).showAndWait());
        }
    }

    public String selectAndGetDrivePath() {
        List<FileDrive> drives = FsUtil.getAvailableDrives(true);
        if (drives != null && drives.size() == 1) {
            return drives.get(0).getRootPath();
        }
        if (drives != null && drives.size() > 1) {
            Optional selectedDriveOpt = new SelectDriveChooser(drives).showAndWait();
            if (selectedDriveOpt.isPresent()) {
                return ((FileDrive)selectedDriveOpt.get()).getRootPath();
            }
        } else {
            UiUtil.createAlertInfoDialog(I18N.text("text.title.info"), I18N.text("message.drive.not.found")).showAndWait();
        }
        return null;
    }

    public void exportLogFile() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(I18N.text("text.log.history.choose.dir"));
        File selectedFile = directoryChooser.showDialog(this.mainUiScene.getWindow());
        if (selectedFile != null) {
            String folderPath = new File("../logs").getAbsolutePath() + File.separator;
            String zipFileName = "lpfr_izvestaji_" + DateTimeUtil.toFileNameDateTimeString(LocalDateTime.now()) + ".zip";
            String zipFullPath = selectedFile.getAbsolutePath() + File.separator + zipFileName;
            try {
                FsUtil.zipFolder(folderPath, zipFullPath);
                UiUtil.createAlertInfoDialog(I18N.text("message.log.history.export.success")).showAndWait();
            }
            catch (Exception exception) {
                logger.error("Export log file error", (Throwable)exception);
                UiUtil.createAlertErrorDialog(I18N.text("message.log.history.export.error")).showAndWait();
            }
        }
    }

    public void showServiceSettings() {
        try {
            AppSettings.getInstance().loadProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new SettingsDialog(AppSettings.getInstance().getProperties()).showAndWait();
    }

    public void showEnterPinCodeDialog() {
        EnterPinCodeDialog enterPinCodeDialog = new EnterPinCodeDialog();
        Optional pinCodeOpt = enterPinCodeDialog.showAndWait();
        if (pinCodeOpt.isPresent()) {
            String pinCode = (String)pinCodeOpt.get();
            ApiResponse apiResponse = SdcApiClient.getInstance().verifyPin(pinCode);
            String errorMessage = "";
            if (apiResponse != null) {
                if (200 == apiResponse.getCode()) {
                    ApiErrCode apiErrCode = ApiErrCode.getByValue(apiResponse.getResponseBody());
                    if (ApiErrCode.PinOk == apiErrCode) {
                        return;
                    }
                    errorMessage = ApiErrCode.PinNotOk == apiErrCode ? "Pin kod nije ispravan" : (ApiErrCode.CardLocked == apiErrCode ? "Kartica je zakljucana" : (ApiErrCode.SdcLicenseNotValid == apiErrCode ? String.format("Licenca programa nije validna (kod greske: %s)", apiErrCode.getCode()) : String.format("Greska verifikacije PIN koda (kod greske: %s)", apiErrCode.getCode())));
                } else {
                    errorMessage = String.format("Greska komunikacije sa LPFRom (http kod %s)", apiResponse.getCode());
                }
            } else {
                errorMessage = "Nema odgovora od LPFRa";
            }
            UiUtil.createAlertErrorDialog(errorMessage).showAndWait();
        }
    }

    public URL getLogoUrl() {
        return ((Object)((Object)this)).getClass().getResource("logo.png");
    }

    private void showStage(Stage stage) {
        stage.show();
    }

    @Subscribe
    public void onNotificationEvent(NotificationEvent event) {
        if (AppSettings.getInstance().isShowUiNotifications()) {
            if (NotificationSeverity.None == event.getSeverity()) {
                this.trayIcon.showMessage(event.getTitle(), event.getText());
            } else if (NotificationSeverity.Info == event.getSeverity()) {
                this.trayIcon.showInfoMessage(event.getTitle(), event.getText());
            } else if (NotificationSeverity.Warning == event.getSeverity()) {
                this.trayIcon.showWarningMessage(event.getTitle(), event.getText());
            } else if (NotificationSeverity.Error == event.getSeverity()) {
                this.trayIcon.showErrorMessage(event.getTitle(), event.getText());
            }
        }
        Platform.runLater(() -> this.mainUiPanel.update(AppState.getInstance()));
    }

    @Subscribe
    public void onSystemEvent(SystemEvent event) {
        if (SystemEventType.UpdateUI == event.getSystemEventType()) {
            Platform.runLater(() -> this.mainUiPanel.update(AppState.getInstance()));
        } else if (SystemEventType.RestartApiServer == event.getSystemEventType()) {
            this.stopApiServer();
            this.startApiServer();
        }
    }

    private boolean netIsAvailable() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return true;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            return false;
        }
    }

    private void exitApplication() {
        logger.info("App exiting");
        EventManager.getInstance().postWarningNotification(I18N.text("message.sdc.exiting"));
        TaxApiClient.getInstance().stop();
        CardReader.getInstance().stop();
        try {
            this.apiServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.apiServer.destroy();
        this.trayIcon.hide();
        Platform.exit();
        logger.info("App exit");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

