<?php
if ($DirectStop != 'MasterSoftware') {
    header("Location: 404.php");
}
if ($WhatUserCanSee['OtvoreniStolovi'] != 1) {
    header("Location: 404.php");
    die();
}
?>
<!DOCTYPE html>
<html lang="en" class="no-js">
    <!-- BEGIN HEAD -->
    <head>
        <meta charset="utf-8" />
        <title>Otvoreni Stolovi</title>
        <meta content="IE=edge" http-equiv="X-UA-Compatible">
        <meta content="width=device-width, initial-scale=1" name="viewport" />
        <meta content="" name="description" />
        <meta content="" name="author" />
        <link rel="stylesheet" type="text/css" href="//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" />
        <?php include('Partials/HeaderScripts.php'); ?>
        <link rel="shortcut icon" href="<?php echo BASE_URL; ?>/favicon.ico" />
    </head>
    <!-- END HEAD -->
    <!-- BEGIN BODY -->
    <body class="page-header-fixed page-quick-sidebar-over-content page-sidebar-closed">
        <!-- BEGIN HEADER -->
        <?php include('Partials/PageHeader.php'); ?>
        <!-- END HEADER -->
        <div class="clearfix">
        </div>
        <!-- BEGIN CONTAINER -->
        <div class="page-container">
            <!-- BEGIN SIDEBAR -->
            <?php include('Partials/PageSideBar.php'); ?>
            <!-- END SIDEBAR -->
            <!-- BEGIN CONTENT -->
            <div class="page-content-wrapper">
                <div class="page-content">
                    <h3 class="page-title">
                        Otvoreni Stolovi
                    </h3>
                    <div class="page-bar">
                        <ul class="page-breadcrumb">
                            <li>
                                <a href="<?php echo BASE_URL; ?>/?modul=pocetna">Izveštaji</a>
                                <i class="fa fa-angle-right"></i>
                            </li>
                            <li>
                                <a href="#">Otvoreni Stolovi</a>
                            </li>
                        </ul>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN TABLE PORTLET-->
                            <div class="portlet-body">
                                <table id="table1" class="tablesorter">
                                    <thead>
                                        <tr>
                                            <th width="50%"> Broj</th>
                                            <th width="50%"> Iznos</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php
                                        foreach (GetOpenTable() as $item) {
                                            ?>
                                            <tr onclick = "GetOpenedItems('<?php Echo $item['name']; ?>')">
                                                <td class="OpenTables"><?php Echo FindTableName($item['name']); ?></td>
                                                <td class="OpenTables"><?php Echo number_format($item['total'], 2); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>

                                    <tbody class="tablesorter-infoOnly">
                                        <tr>
                                            <th>TOTAL</th>
                                            <th data-math="above-sum" class="OpenTables">Iznos</th>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>
                            <!-- END TABLE PORTLET-->
                            <!-- BEGIN TABLE ITEMS-->
                            <div id="tableList2" class="portlet-body">
                            </div>
                            <!-- END TABLE ITEMS-->
                        </div>
                    </div>
                </div>
            </div>
            <!-- END CONTENT -->
        </div>
        <!-- END CONTAINER -->
        <!-- BEGIN FOOTER -->
        <div class="page-footer">
            <div class="page-footer-inner">
                <p id="date" class="date-left2"></p>
                &copy; Master Izveštaji
                <script>
                    var d = new Date();
                    var n = d.getFullYear();
                    document.getElementById("date").innerHTML = n;
                </script>
            </div>
            <div class="scroll-to-top">
                <i class="icon-arrow-up"></i>
            </div>
        </div>
        <!-- END FOOTER -->
        <?php include('Partials/ReportsScripts.php'); ?>
        <script>
            function GetOpenedItems(sto) {
                var url = "<?php echo BASE_URL; ?>/?modul=reports&item=openeditems&value=" + sto;
                $.get(url, function (data) {
                    $('#tableList2').html(data);
                    $.tablesorter.themes.bootstrap = {
                        table: 'table table-bordered',
                        caption: 'caption',
                        header: 'bootstrap-header',
                        footerRow: '',
                        footerCells: '',
                        icons: '',
                        sortNone: 'bootstrap-icon-unsorted',
                        sortAsc: 'icon-chevron-up glyphicon glyphicon-chevron-up',
                        sortDesc: 'icon-chevron-down glyphicon glyphicon-chevron-down',
                        active: '',
                        hover: '',
                        filterRow: '',
                        even: '',
                        odd: ''
                    };
                    $("table.tablesorter").tablesorter({

                        theme: "bootstrap",

                        headerTemplate: '{content} {icon}', // new in v2.7. Needed to add the bootstrap icon!

                        widgets: ["uitheme", "zebra", "math"],

                        widgetOptions: {
                            math_data: 'math', // data-math attribute
                            math_ignore: [0, 1],
                            math_mask: '#,##0.00',
                            math_complete: function ($cell, wo, result, value, arry) {
                                var txt = '<span class="align-decimal">' + result + '</span>';
                                if ($cell.attr('data-math') === 'all-sum') {
                                    // when the "all-sum" is processed, add a count to the end
                                    return txt + ' (Sum of ' + arry.length + ' cells)';
                                }
                                return txt;
                            }
                        }
                    })
                });
            }
            
        </script>
    </body>
    <!-- END BODY -->
</html>