<?php
if ($DirectStop != 'MasterSoftware') {
    header("Location: 404.php");
}
if ($WhatUserCanSee['UredjivanjePorudzbina'] != 1) {
    header("Location: 404.php");
    die();
}
?>
<!DOCTYPE html>
<html lang="en" class="no-js">
    <!-- BEGIN HEAD -->
    <head>
        <meta charset="utf-8" />
        <title>Uređivanje Otvorenih Porudžbina</title>
        <meta content="IE=edge" http-equiv="X-UA-Compatible">
        <meta content="width=device-width, initial-scale=1" name="viewport" />
        <meta content="" name="description" />
        <meta content="" name="author" />
        <link rel="stylesheet" type="text/css" href="//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" />
        <?php include('Partials/HeaderScripts.php'); ?>
        <link rel="shortcut icon" href="<?php echo BASE_URL; ?>/favicon.ico" />
    </head>
    <!-- END HEAD -->
    <!-- BEGIN BODY -->
    <body class="page-header-fixed page-quick-sidebar-over-content page-sidebar-closed">
        <!-- BEGIN HEADER -->
        <?php include('Partials/PageHeader.php'); ?>
        <!-- END HEADER -->
        <div class="clearfix">
        </div>
        <!-- BEGIN CONTAINER -->
        <div class="page-container">
            <!-- BEGIN SIDEBAR -->
            <?php include('Partials/PageSideBar.php'); ?>
            <!-- END SIDEBAR -->
            <!-- BEGIN CONTENT -->
            <div class="page-content-wrapper">
                <div class="page-content">
                    <h3 class="page-title">
                        Uređivanje Porudžbina
                    </h3>
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $OpenedTable = [];
                            $Waiters = [];
                            $GetTables = mysqli_query($link, 'SELECT r.brojStola FROM racun r, stavkaracuna sr WHERE r.id=sr.RACUN_ID AND r.zatvoren=0 AND r.storniran=0 AND r.zdBroj >= (SELECT MAX(zdBroj) FROM zd WHERE zd.pocetak = 1) GROUP BY r.brojStola');
                            if (mysqli_num_rows($GetTables) != 0) {
                                while ($Tables = mysqli_fetch_array($GetTables)) {
                                    array_push($OpenedTable, array('broj' => $Tables['brojStola']));
                                }
                            }
                            $GetTables = mysqli_query($link, 'SELECT k.id, k.skrIme FROM konobar k, racun r WHERE k.blokiranje=0 r.KONOBAR_ID=k.id AND r.zdBroj >= (SELECT MAX(zdBroj) FROM zd WHERE zd.pocetak = 1) AND r.zatvoren=0 AND r.storniran=0 ORDER BY k.skrIme ASC');
                            if (mysqli_num_rows($GetTables) != 0) {
                                while ($Tables = mysqli_fetch_array($GetTables)) {
                                    array_push($Waiters, array('Konobar' => $Tables['id'], 'Ime' => $Tables['skrIme']));
                                }
                            }
                            ?>
                            <label class="SelectLabel">
                                <div class="LabelText">
                                    Broj stola:
                                </div>
                                <select name="Stolovi" id="StoloviSelect" class="chosenSelect">
                                    <option value="">Svi stolovi</option>
                                    <?php
                                    foreach ($OpenedTable as $Table) {
                                        ?>
                                        <option value="<?php Echo $Table['broj']; ?>">
                                            <?php Echo FindTableNameByNumber($Table['broj']); ?>
                                        </option>    
                                        <?php
                                    }
                                    ?>
                                </select>
                            </label>
                            <label class="SelectLabel">
                                <div class="LabelText">
                                    <?php
                                    if ($WhatUserCanSee['Trade'] == 1) {
                                        Echo "Operater";
                                    } else {
                                        Echo "Konobar";
                                    }
                                    ?>:
                                </div>
                                <select name="Konobari" id="KonobariSelect" class="chosenSelect">
                                    <option value="">Svi <?php
                                                if ($WhatUserCanSee['Trade'] == 1) {
                                                    Echo "Operateri";
                                                } else {
                                                    Echo "Konobari";
                                                }
                                                ?></option>
                                    <?php
                                    foreach ($Waiters as $Waiter) {
                                        ?>
                                        <option value="<?php Echo $Waiter['Konobar']; ?>">
                                            <?php Echo $Waiter['Ime']; ?>
                                        </option>    
                                        <?php
                                    }
                                    ?>
                                </select>
                            </label>
                            <button type="button" class="btn btn-success BottomAlign" onclick="LoadOrderItems()">
                                <i class="fa fa-search"></i> Filtriraj
                            </button>
                        </div>
                        <div class="col-md-12" id="LoadHere">

                            <table id="table-1" class="tablesorter">
                                <thead>
                                    <tr>
                                        <th class="sorter-false tableReviewTh" width="33%"><?php
                                                if ($WhatUserCanSee['Trade'] == 1) {
                                                    Echo "Operater";
                                                } else {
                                                    Echo "Konobar";
                                                }
                                                ?></th>
                                        <th class="sorter-false tableReviewTh th-center" width="34%">Broj stola</th>
                                        <th class="sorter-false tableReviewTh th-center" width="33%">Broj porudzbine</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                            <table id="header-fixed" class="tablesorter"><tbody></tbody></table>
                            <!-- BEGIN TABLE PORTLET-->
                            <?php include('Tables/TableEditOrder.php'); ?>
                            <!-- END TABLE PORTLET-->
                        </div>
                    </div>
                </div>
            </div>
            <!-- END CONTENT -->
        </div>
        <!-- END CONTAINER -->
        <!-- BEGIN FOOTER -->
        <div class="page-footer">
            <div class="page-footer-inner">
                <p id="date" class="date-left2"></p>
                &copy; Master Izveštaji
                <script>
                    var d = new Date();
                    var n = d.getFullYear();
                    document.getElementById("date").innerHTML = n;
                </script>
            </div>
            <div class="scroll-to-top">
                <i class="icon-arrow-up"></i>
            </div>
        </div>
        <!-- END FOOTER -->
        <div class="ModalBox">
            <div class="ModalBoxInner">
                <form onsubmit="return ConfirmDeleteItem()">
                    <h2 class="ImeArtikla"></h2>
                    <label>
                        <input type="number" min="0" value="" placeholder="Količina za storniranje" id="StornoKolicina" DataKolicina="" DataIdStavke="" DataTura="" DataBrojStola="" DataKonobar="">
                    </label>
                    <button class="btn btn-danger" type="submit"><i class="fa fa-trash-o"></i> Storniraj</button>
                    <button class="btn btn-default" onclick="CancelDeleteItem()" type="button"><i class="fa fa-backward"></i> Otkaži</button>
                </form>
            </div>
        </div>
        <!-- BEGIN JAVASCRIPTS -->
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/jquery-1.11.0.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/StockReportTable/js/jquery.tablesorter.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/StockReportTable/js/jquery.tablesorter.widgets.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/StockReportTable/js/select2-3.4.6.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/StockReportTable/js/jquery.tablesorter.widgets-filter-formatter-select2.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/StockReportTable/js/review-of-order.js"></script>
        <!-- BEGIN CORE PLUGINS -->
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/jquery-migrate-1.2.1.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/jquery.blockui.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/jquery.cokie.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/uniform/jquery.uniform.min.js"></script>
        <!-- END CORE PLUGINS -->
        <!-- BEGIN PAGE LEVEL SCRIPTS -->
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/scripts/metronic.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/admin/layout/scripts/layout.js"></script>
        <!-- END PAGE LEVEL SCRIPTS -->
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/jquery-ui/jquery-ui-1.10.3.custom.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/StockReportTable/js/widget-columnSelector.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/StockReportTable/js/jquery.tablesorter.pager.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/StockReportTable/js/prettify.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/widget-math.js"></script>
        <script type="text/javascript" src="<?php echo BASE_URL; ?>/Content/chosen/chosen.jquery.min.js"></script>        
        <script>
                        $(document).ready(function () {
                            $('.Loader').hide(500);
                            $('a').click(function (e) {
                                e.preventDefault;
                                var Where = $(this).attr('href');
                                $('.Loader').show();
                                window.location.href = Where;
                            });
                        });
        </script>
        <script type="text/javascript">
            jQuery(document).ready(function () {
                Metronic.init();
                Layout.init();
            });
        </script>
        <script>
            $(document).ready(function () {
                //setTime(20001);
                $('.chosenSelect').chosen({
                    no_results_text: "Oops, nema rezultata!",
                    allow_single_deselect: true,
                    width: '100%'
                });
            });
            function DeleteCompleteOrder(Tura, Sto, Konobar) {
                if (confirm('Akcija će obrisati celu turu i sve stavke u njoj!!! Da li ste sigurni?')) {
                    var url = "<?php echo BASE_URL; ?>/?modul=reports&item=DeleteCompleteOrder&value=" + Tura;
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: "DeleteCompleteOrder=true&brojStola=" + Sto + "&Konobar=" + Konobar,
                        success: function (data) {
                            if (data.substring(0, 15) == "<!DOCTYPE html>") {
                                alert('Vaša sesija je istekla! Morate se ponovo ulogovati!!!');
                                location.reload();
                            } else if (data == "SveStornirano") {
                                $('table[data-table-delete="' + Tura + '"]').remove();
                            } else {
                                alert(data);
                            }
                        }
                    });
                }
            }
            function DeleteOrderItem(NazivArtikla, KolicinaArtikla, IdStavke, BrojPorudzbine, BrojStola, Konobar) {
                $('.ImeArtikla').html(NazivArtikla);
                $('#StornoKolicina').attr('DataKolicina', KolicinaArtikla);
                $('#StornoKolicina').val(KolicinaArtikla);
                $('#StornoKolicina').attr('DataIdStavke', IdStavke);
                $('#StornoKolicina').attr('DataTura', BrojPorudzbine);
                $('#StornoKolicina').attr('DataBrojStola', BrojStola);
                $('#StornoKolicina').attr('DataKonobar', Konobar);
                $('#StornoKolicina').attr('max', KolicinaArtikla);
                $('.ModalBox').show(500);
            }
            function CancelDeleteItem() {
                $('.ModalBox').hide(500);
            }
            function ConfirmDeleteItem() {
                var KolicinaZaStorno = $('#StornoKolicina').val();
                var StavkaRacuna = $('#StornoKolicina').attr('DataIdStavke');
                var Tura = $('#StornoKolicina').attr('DataTura');
                var BrojStola = $('#StornoKolicina').attr('DataBrojStola');
                var Konobar = $('#StornoKolicina').attr('DataKonobar');
                var MaxKolicina = $('#StornoKolicina').attr('max');
                var Naziv = $('.ModalBox h2').html();
                var ParentTableBody = $('tr[data-item-delete="' + StavkaRacuna + '"]').parent('tbody');
                if (parseFloat(KolicinaZaStorno) <= 0) {
                    alert("Količina za storniranje mora biti veća od 0!!!");
                    return false;
                }
                if (parseFloat(KolicinaZaStorno) > parseFloat(MaxKolicina)) {
                    alert("Ne možete stornirati veću količinu od količine u turi!!!");
                    return false;
                }
                var url = "<?php echo BASE_URL; ?>/?modul=reports&item=DeleteCompleteOrder&value=" + Tura;
                $.ajax({
                    type: "POST",
                    url: url,
                    data: "DeleteCompleteOrder=false&brojStola=" + BrojStola + "&Konobar=" + Konobar + "&StavkaRacuna=" + StavkaRacuna + "&KolicinaZaStorno=" + KolicinaZaStorno,
                    success: function (data) {
                        if (data.substring(0, 15) == "<!DOCTYPE html>") {
                            alert('Vaša sesija je istekla! Morate se ponovo ulogovati!!!');
                            location.reload();
                        } else if (data == "ArtikalStorniran") {
                            if (KolicinaZaStorno >= MaxKolicina) {
                                $('tr[data-item-delete="' + StavkaRacuna + '"]').remove();
                                if (ParentTableBody.children('tr').length <= 0) {
                                    ParentTableBody.parents('table').remove();
                                }
                            } else {
                                var NovaKolicina = parseFloat(MaxKolicina) - parseFloat(KolicinaZaStorno);
                                var NewHtml = NovaKolicina + " X " + Naziv + " <i class='fa fa-trash' onclick=\"DeleteOrderItem('" + Naziv + "', '" + NovaKolicina + "', '" + StavkaRacuna + "', '" + Tura + "', '" + BrojStola + "', '" + Konobar + "')\"></i>";
                                $('tr[data-item-delete="' + StavkaRacuna + '"] td:first-child').html(NewHtml);
                            }

                            CancelDeleteItem();
                        } else if (data == "SveStornirano") {
                            ParentTableBody.parents('table').remove();
                            CancelDeleteItem();
                        } else {
                            alert(data);
                        }
                    }
                });
                return false;
            }
            function LoadOrderItems() {
                var WhichTable = $('#StoloviSelect').val();
                var WhichWaiter = $('#KonobariSelect').val();
                var url = "<?php echo BASE_URL; ?>/?modul=reports&item=LoadOrderByFilter";
                $.ajax({
                    type: "POST",
                    url: url,
                    data: "brojStola=" + WhichTable + "&Konobar=" + WhichWaiter,
                    success: function (data) {
                        if (data.substring(0, 15) == "<!DOCTYPE html>") {
                            alert('Vaša sesija je istekla! Morate se ponovo ulogovati!!!');
                            location.reload();
                        } else {
                            $('#LoadHere').html(data);
                            $.tablesorter.themes.bootstrap = {
                                table: 'table table-bordered',
                                caption: 'caption',
                                header: 'bootstrap-header',
                                footerRow: '',
                                footerCells: '',
                                icons: '',
                                sortNone: 'bootstrap-icon-unsorted',
                                sortAsc: 'icon-chevron-up glyphicon glyphicon-chevron-up',
                                sortDesc: 'icon-chevron-down glyphicon glyphicon-chevron-down',
                                active: '',
                                hover: '',
                                filterRow: '',
                                even: '',
                                odd: ''
                            };
                            $("table").tablesorter({

                                theme: "bootstrap",

                                headerTemplate: '{content} {icon}', // new in v2.7. Needed to add the bootstrap icon!

                                widgets: ["uitheme", "zebra", "math"],

                                //widgetOptions: {
                                //    math_data: 'math', // data-math attribute
                                //    math_ignore: [0, 1],
                                //    math_mask: '#,##0.00',
                                //    math_complete: function ($cell, wo, result, value, arry) {
                                //        var txt = '<span class="align-decimal">' + result + '</span>';
                                //        if ($cell.attr('data-math') === 'all-sum') {
                                //            // when the "all-sum" is processed, add a count to the end
                                //            return txt + ' (Sum of ' + arry.length + ' cells)';
                                //        }
                                //        return txt;
                                //    }
                                //}
                            });
                        }
                    }
                });
            }
        </script>

        <script>
            var tableOffset = $("#table-1").offset().top;
            var $header = $("#table-1 > thead").clone();
            var $fixedHeader = $("#header-fixed").append($header);

            $(window).bind("scroll", function () {
                var offset = $(this).scrollTop();
                if (offset >= tableOffset && $fixedHeader.is(":hidden")) {
                    $fixedHeader.show();
                } else if (offset < tableOffset) {
                    $fixedHeader.hide();
                }
            });
        </script>
    </body>
    <!-- END BODY -->
</html>