<?php
ini_set('memory_limit', '1024M');
require 'escpos/autoload.php';

use Mike42\Escpos\EscposImage;
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;

if ($DirectStop != "CuCaNaBuCaNa") {
    header("Location: ./logout.php");
    die();
}
if (isset($_POST['InsertPINLPFR'])) {
    $LPFRUrl = $KasaData['lpfr_adresa'];
    $Pin = mysqli_real_escape_string($link, $_POST['InsertPINLPFR']);
    if ($Pin != '') {
        $UrlPIN = $LPFRUrl . "/api/v3/pin";
        $cu = curl_init();
        $apiHeader[] = 'Accept: application/json';
        $apiHeader[] = 'Content-Type: application/json';
        $options = array(
            CURLOPT_URL => $UrlPIN,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => false, // true to show header information
            CURLINFO_HEADER_OUT => true,
            CURLOPT_HTTPGET => false,
            CURLOPT_POST => true,
            CURLOPT_FOLLOWLOCATION => false,
            CURLOPT_VERBOSE => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYHOST => false, // true in production
            CURLOPT_SSL_VERIFYPEER => false, // true in production
            CURLOPT_TIMEOUT => 30,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_HTTPHEADER => $apiHeader,
            CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)',
            CURLOPT_HTTPAUTH => CURLAUTH_ANYSAFE, // CURLAUTH_BASIC
            CURLOPT_POSTFIELDS => $Pin,
        );
        curl_setopt_array($cu, $options);
        $outputcu = curl_exec($cu);
        if (curl_errno($cu) > 0) {
            $DoRequest = 0;
            echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri komunikaciji sa LPFR!' . curl_error($cu)));
            die();
        }
        curl_close($cu);
        $Result = json_decode($outputcu);
        if ($Result != "0100") {
            if ($Result == "2100") {
                echo json_encode(array('Status' => 'insertpin', 'Message' => 'PIN koji ste uneli nije ispravan! Pažnja, nakon 3 neuspešna unosa kartica će biti zaključana!'));
            } elseif ($Result == "2110") {
                echo json_encode(array('Status' => 'error', 'Message' => 'Kartica je zaključana!'));
            } elseif ($Result == "2210") {
                echo json_encode(array('Status' => 'error', 'Message' => 'Sigurnosni element je zaključan! Nije moguća fiskalizacija računa!'));
            } elseif ($Result == "2220") {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća komunikacija sa sigurnosnim elementom!'));
            } elseif ($Result == "1300") {
                echo json_encode(array('Status' => 'error', 'Message' => 'Kartica nije umetnuta!'));
            } elseif ($Result->status == "400") {
                echo json_encode(array('Status' => 'error', 'Message' => 'LPFR nije dostupan!'));
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nepoznata greska! Kod:' . $outputcu));
            }
            $DoRequest = 0;
        } else {
            echo json_encode(array('Status' => 'success', 'Message' => 'PIN koji ste uneli je ispravan!'));
        }
    } else {
        echo json_encode(array('Status' => 'insertpin', 'Message' => 'Neophodno je da unesete PIN! Pažnja, nakon 3 neuspešna unosa kartica će biti zaključana!'));
        $DoRequest = 0;
    }
    die();
}
if (isset($_POST['GetLLPFRStatus'])) {
    $LPFRUrl = $KasaData['lpfr_adresa'];
    if ($LPFRUrl != '') {
        $Pin = $KasaData['lpfr_pin'];
        $UrlStatus = $LPFRUrl . "/api/v3/status";
        $DoRequest = 1;
        $cu = curl_init();
        $apiHeader[] = 'Accept: application/json';
        $apiHeader[] = 'Content-Type: application/json';
        $options = array(
            CURLOPT_URL => $UrlStatus,
            CURLOPT_HTTPHEADER => $apiHeader,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET'
        );
        curl_setopt_array($cu, $options);
        $outputcu = curl_exec($cu);
        if (curl_errno($cu) > 0) {
            $DoRequest = 0;
        }
        curl_close($cu);
        $StatusResults = json_decode($outputcu);
        if ($StatusResults->isPinRequired != '') {
            if ($Pin != '') {
                $UrlPIN = $LPFRUrl . "/api/v3/pin";
                $cu = curl_init();
                $options = array(
                    CURLOPT_URL => $UrlPIN,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_HEADER => false, // true to show header information
                    CURLINFO_HEADER_OUT => true,
                    CURLOPT_HTTPGET => false,
                    CURLOPT_POST => true,
                    CURLOPT_FOLLOWLOCATION => false,
                    CURLOPT_VERBOSE => true,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_SSL_VERIFYHOST => false, // true in production
                    CURLOPT_SSL_VERIFYPEER => false, // true in production
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_HTTPHEADER => $apiHeader,
                    CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)',
                    CURLOPT_HTTPAUTH => CURLAUTH_ANYSAFE, // CURLAUTH_BASIC
                    CURLOPT_POSTFIELDS => $Pin,
                );
                curl_setopt_array($cu, $options);
                $outputcu = curl_exec($cu);
                if (curl_errno($cu) > 0) {
                    $DoRequest = 0;
                    echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri komunikaciji sa LPFR!' . curl_error($cu)));
                    die();
                }
                curl_close($cu);
                $Result = json_decode($outputcu);
                if ($Result != "0100") {
                    if ($Result == "2100") {
                        echo json_encode(array('Status' => 'insertpin', 'Message' => 'PIN koji ste uneli nije ispravan! Pažnja, nakon 3 neuspešna unosa kartica će biti zaključana!'));
                    } elseif ($Result == "2110") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Kartica je zaključana!'));
                    } elseif ($Result == "2210") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Sigurnosni element je zaključan! Nije moguća fiskalizacija računa!'));
                    } elseif ($Result == "2220") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća komunikacija sa sigurnosnim elementom!'));
                    } elseif ($Result == "1300") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Kartica nije umetnuta!'));
                    } elseif ($Result->status == "400") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'LPFR nije dostupan!'));
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nepoznata greska! Kod:' . $outputcu));
                    }
                    $DoRequest = 0;
                }
            } else {
                echo json_encode(array('Status' => 'insertpin', 'Message' => 'Neophodno je da unesete PIN! Pažnja, nakon 3 neuspešna unosa kartica će biti zaključana!'));
                $DoRequest = 0;
            }
        } else {
            echo json_encode(array('Status' => 'success', 'Message' => 'LPFR spreman za rad!'));
        }
    } else {
        echo json_encode(array('Status' => 'success', 'Message' => 'LPFR spreman za rad!'));
    }
    die();
}
if (isset($_POST['UradiPrijavuZaSifru'])) {
    $Sifra = mysqli_real_escape_string($link, $_POST['UradiPrijavuZaSifru']);
    $GetZaposleniData = mysqli_query($link, "SELECT * FROM zaposleni WHERE sifra='$Sifra'");
    if (mysqli_num_rows($GetZaposleniData) == 1) {
        $ZaposleniData = mysqli_fetch_array($GetZaposleniData);
        $IdZaposleni = $ZaposleniData['id'];
        $ImeZaposleni = $ZaposleniData['ime'];
        $CenaZaposleni = $ZaposleniData['cenaSata'];
        $GetEvidencija = mysqli_query($link, "SELECT * FROM evidencijazaposlenih WHERE ime='$ImeZaposleni' AND odjavljen=0 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetEvidencija) == 1) {
            $EvidencijaData = mysqli_fetch_array($GetEvidencija);
            $EvidencijaId = $EvidencijaData['id'];
            mysqli_query($link, "UPDATE evidencijazaposlenih SET odjavljen=1, odlazak=now() WHERE id='$EvidencijaId'");
            echo json_encode(array('Status' => 'success', 'Message' => 'Uspešno ste odjavljeni sa posla!', 'Location' => '', 'Action' => ''));
        } else {
            mysqli_query($link, "INSERT INTO evidencijazaposlenih (cenaSata, datum, dolazak, ime, odjavljen) VALUES ('$CenaZaposleni', now(), now(), '$ImeZaposleni', 0)");
            echo json_encode(array('Status' => 'success', 'Message' => 'Uspešno ste prijavljeni na posao!', 'Location' => '', 'Action' => ''));
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Lozinka koju ste poslali ne poklapa sa zaposlenima u sistemu!', 'Location' => '', 'Action' => ''));
    }
    die();
}
$ResThisPosInfo['id'] = '';
$GetThisPosInfo = mysqli_query($link, "SELECT * FROM kasa WHERE hostname = '$KasaName'");
if (mysqli_num_rows($GetThisPosInfo) == 1) {
    $ResThisPosInfo = mysqli_fetch_array($GetThisPosInfo);
} else {
    mysqli_query($link, "DELETE FROM kasa WHERE hostname = '$KasaName'");
    mysqli_query($link, "INSERT INTO kasa (hostname, opis, oznaka, PRODAJNOMESTO_ID) VALUES ('$KasaName', '$KasaName', '$KasaName', '1')");
    $GetThisPosInfo2 = mysqli_query($link, "SELECT * FROM kasa WHERE hostname = '$KasaName'");
    if (mysqli_num_rows($GetThisPosInfo2) == 1) {
        $ResThisPosInfo = mysqli_fetch_array($GetThisPosInfo2);
    }
}
if (isset($_POST['DoClean'])) {
    $DoDatuma = $_POST['DoDatuma'];
    $DoDatuma = date('Y-m-d', strtotime($DoDatuma));
    $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE datum<='$DoDatuma' ORDER BY datum DESC, pocetak ASC LIMIT 1");
    if (mysqli_num_rows($GetZd) == 1) {
        $ZdData = mysqli_fetch_array($GetZd);
        $ZdBroj = $ZdData['zdBroj'];
        mysqli_query($link, "DELETE FROM dnevniutrosak WHERE zdBroj<='$ZdBroj' AND dodatno=1");
        if ($ZdData['pocetak'] == 0) {
            $ZdVreme = $ZdData['zakljucenje'];
        } else {
            $ZdVreme = date('Y-m-d H:i:s');
        }
    } else {
        $ZdVreme = date('Y-m-d H:i:s');
    }
    //mysqli_query($link, "UPDATE dnevnostanje SET crnoIzlaz=0, crnoUlaz=0 WHERE datum<='$ZdVreme'");
    //mysqli_query($link, "DELETE FROM kartica WHERE datum<='$ZdVreme' AND crno!=0");
    $GetAllRacune = mysqli_query($link, "SELECT * FROM racun WHERE datum<='$ZdVreme' AND crnoPlacanje!='' AND crnoPlacanje!='HOTELSKI GOST' AND zatvoren=1");
    if (mysqli_num_rows($GetAllRacune) > 0) {
        while ($rowRacuni = mysqli_fetch_array($GetAllRacune)) {
            $RacunId = $rowRacuni['id'];
            mysqli_query($link, "DELETE FROM stavkaracuna WHERE RACUN_ID='$RacunId'");
            mysqli_query($link, "DELETE FROM tura WHERE RACUN_ID='$RacunId'");
            mysqli_query($link, "DELETE FROM racun WHERE id='$RacunId'");
        }
    }
    $GetAllTrebovanja = mysqli_query($link, "SELECT * FROM trebovanje WHERE datumTrebovanja<='$ZdVreme' AND crno!=0");
    if (mysqli_num_rows($GetAllTrebovanja) > 0) {
        while ($rowTrebovanja = mysqli_fetch_array($GetAllTrebovanja)) {
            $TrebovanjeId = $rowTrebovanja['id'];
            mysqli_query($link, "DELETE FROM trebovanjestavka WHERE TREBOVANJE_ID='$TrebovanjeId'");
            mysqli_query($link, "DELETE FROM trebovanje WHERE id='$TrebovanjeId'");
        }
    }
    $GetAllPrijemnice = mysqli_query($link, "SELECT * FROM prijemnica WHERE datumPrijemnice<='$ZdVreme' AND crno!=0");
    if (mysqli_num_rows($GetAllPrijemnice) > 0) {
        while ($rowPrijemnice = mysqli_fetch_array($GetAllPrijemnice)) {
            $PrijemniceId = $rowPrijemnice['id'];
            mysqli_query($link, "DELETE FROM prijemnicastavka WHERE PRIJEMNICA_ID='$PrijemniceId'");
            mysqli_query($link, "DELETE FROM prijemnica WHERE id='$PrijemniceId'");
        }
    }
    $GetAllProizvodnja = mysqli_query($link, "SELECT * FROM proizvodnja WHERE datum<='$ZdVreme' AND crno!=0");
    if (mysqli_num_rows($GetAllProizvodnja) > 0) {
        while ($rowProizvodnja = mysqli_fetch_array($GetAllProizvodnja)) {
            $ProizvodnjaId = $rowProizvodnja['id'];
            mysqli_query($link, "DELETE FROM proizvodnjastavka WHERE PROIZVODNJA_ID='$ProizvodnjaId'");
            mysqli_query($link, "DELETE FROM proizvodnjautrosak WHERE PROIZVODNJA_ID='$ProizvodnjaId'");
            mysqli_query($link, "DELETE FROM proizvodnja WHERE id='$ProizvodnjaId'");
        }
    }
    $GetAllUtrosak = mysqli_query($link, "SELECT * FROM utrosakdoc WHERE datum<='$ZdVreme' AND crno!=0");
    if (mysqli_num_rows($GetAllUtrosak) > 0) {
        while ($rowUtrosak = mysqli_fetch_array($GetAllUtrosak)) {
            $UtrosakId = $rowUtrosak['id'];
            mysqli_query($link, "DELETE FROM utrosakdocstavke WHERE UTROSAKDOC_ID='$UtrosakId'");
            mysqli_query($link, "DELETE FROM utrosakdocutrosak WHERE UTROSAKDOC_ID='$UtrosakId'");
            mysqli_query($link, "DELETE FROM utrosakdoc WHERE id='$UtrosakId'");
        }
    }
    $GetAllOtpis = mysqli_query($link, "SELECT * FROM otpis WHERE datum<='$ZdVreme' AND crno!=0");
    if (mysqli_num_rows($GetAllOtpis) > 0) {
        while ($rowOtpis = mysqli_fetch_array($GetAllOtpis)) {
            $OtpisId = $rowOtpis['id'];
            mysqli_query($link, "DELETE FROM otpisstavka WHERE OTPIS_ID='$OtpisId'");
            mysqli_query($link, "DELETE FROM otpisutrosak WHERE OTPIS_ID='$OtpisId'");
            mysqli_query($link, "DELETE FROM otpis WHERE id='$OtpisId'");
        }
    }
    $NazivDokumenta = 'IzvestajFIPS' . date('Y-m-d-H-i-s');
    $doc = new DOMDocument('1.0', 'UTF-8');
    $doc->preserveWhiteSpace = false;
    $doc->formatOutput = true;
    $ele = $doc->createElement('Izvestaj');
    $ele->nodeValue = "1";
    $doc->appendChild($ele);
    $doc->save($SaveToReceipt . '/' . $NazivDokumenta . ' .xml');
    RekonstrukcijaStanja($ZdBroj);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = "LOGIN";
    $LogWhat = "Cistacica aktivirana";
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!', 'Location' => '', 'Action' => ''));
    die();
}
if (isset($_POST['CreatePeriodicni'])) {

    $OdDatuma = $_POST['OdDatuma'];
    $DoDatuma = $_POST['DoDatuma'];
    $TipFiscala = GetSettingVal('tipFiskala');
    if ($TipFiscala == 'efiscal') {
        $DatumOd = date('Y-m-d', strtotime($_POST['OdDatuma']));
        $DatumDo = date('Y-m-d', strtotime($_POST['DoDatuma']));
        $ZdVremeOd = "";
        //$ZdVremeDo = date('Y-m-d H:i:s');
        $Vats = [];
        $GetVatData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1 ORDER BY id ASC") or die(mysqli_error($link));
        if (mysqli_num_rows($GetVatData) > 0) {
            while ($rowVatData = mysqli_fetch_array($GetVatData)) {
                $Vats[$rowVatData['oznaka']] = $rowVatData['vrednost'];
            }
        }
        $SaleData = [];
        $RefundData = [];
        $VatData = [];
        $VatRefundData = [];
        $GetZds = mysqli_query($link, "SELECT zakljucenje FROM zd WHERE datum>='$DatumOd' AND datum<='$DatumDo' ORDER BY id ASC") or die(mysqli_error($link));
        if (mysqli_num_rows($GetZds) > 0) {
            $ZdIn = "";
            while ($rowZD = mysqli_fetch_array($GetZds)) {
                if ($ZdVremeOd == "") {
                    $ZdVremeOd = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                }
                if ($rowZD['zakljucenje'] != '') {
                    if (strtotime($rowZD['zakljucenje']) > strtotime($ZdVremeDo)) {
                        $ZdVremeDo = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                    }
                }
            }
            $GetSaleData = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE vremeRacuna>='$ZdVremeOd' AND vremeRacuna<='$ZdVremeDo' AND tipRacuna='Normal'") or die(mysqli_error($link));
            if (mysqli_num_rows($GetSaleData) > 0) {
                while ($rowSale = mysqli_fetch_array($GetSaleData)) {
                    $CurrentTotal = 0;
                    $OldJournalData = unserialize($rowSale['podaciRacuna']);
                    $OldJournalData = json_decode(json_encode($OldJournalData), true);
                    $UbaceniArtikli = $OldJournalData['StavkeProizvoda'];
                    foreach ($UbaceniArtikli as $UbaceniArtikal) {
                        $Vat = $UbaceniArtikal['labels'][0];
                        $Total = $UbaceniArtikal['totalAmount'];
                        if ($Total < 0) {
                            $Total = -1 * $Total;
                        }
                        $VatValue = $Vats[$Vat];
                        $CurrentTotal = $CurrentTotal + $Total;
                        if ($rowSale['tipTransakcije'] == 'Sale') {
                            $VatData[$Vat] = $VatData[$Vat] + $Total;
                        } else {
                            $VatRefundData[$Vat] = $VatRefundData[$Vat] + $Total;
                        }
                    }
                    $UbaciPlacanja = $OldJournalData['StavkePlacanja'];
                    foreach ($UbaciPlacanja as $UbaciPlacanje) {
                        $amount = $UbaciPlacanje['amount'];
                        $paymentType = $UbaciPlacanje['paymentType'];
                        if ($CurrentTotal >= $amount) {
                            if ($rowSale['tipTransakcije'] == 'Sale') {
                                $SaleData[$paymentType] = $SaleData[$paymentType] + $amount;
                            } else {
                                $RefundData[$paymentType] = $RefundData[$paymentType] + $amount;
                            }
                        } else {
                            if ($rowSale['tipTransakcije'] == 'Sale') {
                                $SaleData[$paymentType] = $SaleData[$paymentType] + $CurrentTotal;
                            } else {
                                $RefundData[$paymentType] = $RefundData[$paymentType] + $CurrentTotal;
                            }
                        }
                    }
                }
            }
        }
        $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1") or die(mysqli_error($link));
        if (mysqli_num_rows($GetStampacData) > 0) {
            $StampacData = mysqli_fetch_array($GetStampacData);
            if ($StampacData['tip'] == 'POSBANK80MM') {
                $PrinterLetters = 48;
            } else {
                $PrinterLetters = 32;
            }
            $PrintString = "";
            $PrintString .= "Periodični izveštaj za period: " . $FromDate . "-" . $ToDate . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= str_pad("PRODAJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $UkupnoProdaja = 0;
            foreach ($SaleData as $SaleType => $SaleTypeData) {
                if ($SaleType == 'Cash') {
                    $PaymentPrint = "Gotovina:";
                } elseif ($SaleType == 'Card') {
                    $PaymentPrint = "Platna kartica:";
                } elseif ($SaleType == 'Check') {
                    $PaymentPrint = "Ček:";
                } elseif ($SaleType == 'WireTransfer') {
                    $PaymentPrint = "Prenos na račun:";
                } elseif ($SaleType == 'MobileMoney') {
                    $PaymentPrint = "Mobilni novac:";
                } elseif ($SaleType == 'Voucher') {
                    $PaymentPrint = "Vaučer:";
                } elseif ($SaleType == 'Other') {
                    $PaymentPrint = "Dr. bezgot. plaćanje:";
                }
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                $UkupnoProdaja = $UkupnoProdaja + $SaleTypeData;
            }
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoProdaja, 2, '.', ''));
            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoProdaja, 2, '.', '') . "\n";

            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= str_pad("PDV", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $UkupnoVat = 0;
            foreach ($VatData as $SaleType => $SaleTypeData) {
                $VatValue = $Vats[$SaleType];

                $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                $VatCalcVal = $SaleTypeData / (1 + ($VatValue / 100));
                $VatCalcVal = $SaleTypeData - $VatCalcVal;
                $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                $UkupnoVat = $UkupnoVat + $SaleTypeData;
            }
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoVat, 2, '.', ''));
            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoVat, 2, '.', '') . "\n";

            if (count($RefundData) > 0) {
                $UkupnoRefundacija = 0;
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $PrintString .= str_pad("REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                foreach ($RefundData as $SaleType => $SaleTypeData) {
                    if ($SaleType == 'Cash') {
                        $PaymentPrint = "Gotovina:";
                    } elseif ($SaleType == 'Card') {
                        $PaymentPrint = "Platna kartica:";
                    } elseif ($SaleType == 'Check') {
                        $PaymentPrint = "Ček:";
                    } elseif ($SaleType == 'WireTransfer') {
                        $PaymentPrint = "Prenos na račun:";
                    } elseif ($SaleType == 'MobileMoney') {
                        $PaymentPrint = "Mobilni novac:";
                    } elseif ($SaleType == 'Voucher') {
                        $PaymentPrint = "Vaučer:";
                    } elseif ($SaleType == 'Other') {
                        $PaymentPrint = "Dr. bezgot. plaćanje:";
                    }
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                    $UkupnoRefundacija = $UkupnoRefundacija + $SaleTypeData;
                }
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacija, 2, '.', ''));
                $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacija, 2, '.', '') . "\n";
            }
            if (count($VatRefundData)) {
                $UkupnoRefundacijaVat = 0;
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $PrintString .= str_pad("PDV REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                foreach ($VatRefundData as $SaleType => $SaleTypeData) {
                    $VatValue = $Vats[$SaleType];
                    $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                    $VatCalcVal = $SaleTypeData / (1 + ($VatValue / 100));
                    $VatCalcVal = $SaleTypeData - $VatCalcVal;
                    $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                    $UkupnoRefundacijaVat = $UkupnoRefundacijaVat + $SaleTypeData;
                }
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacijaVat, 2, '.', ''));
                $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacijaVat, 2, '.', '') . "\n";
            }
            try {
                // Enter the share name for your USB printer here
                $NazivStampaca = $StampacData['naziv'];
                if (strpos($NazivStampaca, "/")) {
                    $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                } else {
                    $connector = new WindowsPrintConnector($NazivStampaca);
                }
                $printer = new Printer($connector);
                $printer->pulse(1, 300, 300);
                $printer->setPrintLeftMargin(0);
                $printer->setJustification(Printer::JUSTIFY_LEFT);
                $printer->text($PrintString);
                $printer->feed();
                $printer->cut();
                $printer->close();
            } catch (Exception $e) {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                die();
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za štampu izveštaja!'));
            die();
        }
    } else {
        $doc = new DOMDocument('1.0', 'UTF-8');
        $doc->preserveWhiteSpace = false;
        $doc->formatOutput = true;
        $ele = $doc->createElement('Periodicni');
        $NazivRacuna = 'PeriodicniIzvestaj' . date('Ymd_His');
        $ele2 = $doc->createElement('FromDate');
        $ele2->nodeValue = date('d.m.y', strtotime($OdDatuma));
        $ele->appendChild($ele2);
        $ele2 = $doc->createElement('ToDate');
        $ele2->nodeValue = date('d.m.y', strtotime($DoDatuma));
        $ele->appendChild($ele2);
        $doc->appendChild($ele);
        $doc->save($SaveToReceipt . '/' . $NazivRacuna . '.xml');
    }
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = "LOGIN";
    $LogWhat = "Periodicni izvestaj poslat na stampu";
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!', 'Location' => '', 'Action' => ''));
    die();
}
if (isset($_POST['lozinka'])) {
    $password = mysqli_real_escape_string($link, $_POST['lozinka']);
    $FolderToUse = $SiteName;
    $UserData = "";
    $LoginQuery = mysqli_query($link, "SELECT * FROM konobar WHERE sifra = '$password' AND blokiranje = 0 ORDER BY id DESC LIMIT 1") or die(mysqli_error($link));
    if (mysqli_num_rows($LoginQuery) != 1) {
        $GetSifra = mysqli_query($link, "SELECT * FROM sifra WHERE sifra = '$password'");
        if (mysqli_num_rows($GetSifra) == 1) {
            $StaRadi = mysqli_fetch_array($GetSifra)['sifarnik'];
            if ($StaRadi == 'PRESEK') {
                $TipFiscala = GetSettingVal('tipFiskala');
                if ($TipFiscala == 'efiscal') {
                    $ZdVremeOd = "";
                    $ZdVremeDo = date('Y-m-d H:i:s');
                    $Vats = [];
                    $GetVatData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1 ORDER BY id ASC") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetVatData) > 0) {
                        while ($rowVatData = mysqli_fetch_array($GetVatData)) {
                            $Vats[$rowVatData['oznaka']] = $rowVatData['vrednost'];
                        }
                    }
                    $SaleData = [];
                    $RefundData = [];
                    $VatData = [];
                    $VatRefundData = [];
                    $GetZds = mysqli_query($link, "SELECT zakljucenje, pocetak FROM zd ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetZds) == 1) {

                        $ZdIn = "";
                        $rowZD = mysqli_fetch_array($GetZds);
                        if ($rowZD['pocetak'] == 1) {
                            $ZdVremeOd = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                        } else {
                            $ZdVremeOd = $ZdVremeDo;
                        }
                        $GetSaleData = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE vremeRacuna>='$ZdVremeOd' AND vremeRacuna<='$ZdVremeDo' AND tipRacuna='Normal'") or die(mysqli_error($link));
                        if (mysqli_num_rows($GetSaleData) > 0) {
                            while ($rowSale = mysqli_fetch_array($GetSaleData)) {
                                $CurrentTotal = 0;
                                $OldJournalData = unserialize($rowSale['podaciRacuna']);
                                $OldJournalData = json_decode(json_encode($OldJournalData), true);
                                $UbaceniArtikli = $OldJournalData['StavkeProizvoda'];
                                foreach ($UbaceniArtikli as $UbaceniArtikal) {
                                    $Vat = $UbaceniArtikal['labels'][0];
                                    $Total = $UbaceniArtikal['totalAmount'];
                                    if ($Total < 0) {
                                        $Total = -1 * $Total;
                                    }
                                    $VatValue = $Vats[$Vat];
                                    $CurrentTotal = $CurrentTotal + $Total;
                                    if ($rowSale['tipTransakcije'] == 'Sale') {
                                        $VatData[$Vat] = $VatData[$Vat] + $Total;
                                    } else {
                                        $VatRefundData[$Vat] = $VatRefundData[$Vat] + $Total;
                                    }
                                }
                                $UbaciPlacanja = $OldJournalData['StavkePlacanja'];
                                foreach ($UbaciPlacanja as $UbaciPlacanje) {
                                    $amount = $UbaciPlacanje['amount'];
                                    $paymentType = $UbaciPlacanje['paymentType'];
                                    if ($CurrentTotal >= $amount) {
                                        if ($rowSale['tipTransakcije'] == 'Sale') {
                                            $SaleData[$paymentType] = $SaleData[$paymentType] + $amount;
                                        } else {
                                            $RefundData[$paymentType] = $RefundData[$paymentType] + $amount;
                                        }
                                    } else {
                                        if ($rowSale['tipTransakcije'] == 'Sale') {
                                            $SaleData[$paymentType] = $SaleData[$paymentType] + $CurrentTotal;
                                        } else {
                                            $RefundData[$paymentType] = $RefundData[$paymentType] + $CurrentTotal;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetStampacData) > 0) {
                        $StampacData = mysqli_fetch_array($GetStampacData);
                        if ($StampacData['tip'] == 'POSBANK80MM') {
                            $PrinterLetters = 48;
                        } else {
                            $PrinterLetters = 32;
                        }
                        $PrintString = "";
                        $PrintString .= "Presek stanja: " . date('d.m.y H:i:s') . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= str_pad("PRODAJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $UkupnoProdaja = 0;
                        foreach ($SaleData as $SaleType => $SaleTypeData) {
                            if ($SaleType == 'Cash') {
                                $PaymentPrint = "Gotovina:";
                            } elseif ($SaleType == 'Card') {
                                $PaymentPrint = "Platna kartica:";
                            } elseif ($SaleType == 'Check') {
                                $PaymentPrint = "Ček:";
                            } elseif ($SaleType == 'WireTransfer') {
                                $PaymentPrint = "Prenos na račun:";
                            } elseif ($SaleType == 'MobileMoney') {
                                $PaymentPrint = "Mobilni novac:";
                            } elseif ($SaleType == 'Voucher') {
                                $PaymentPrint = "Vaučer:";
                            } elseif ($SaleType == 'Other') {
                                $PaymentPrint = "Dr. bezgot. plaćanje:";
                            }
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                            $UkupnoProdaja = $UkupnoProdaja + $SaleTypeData;
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoProdaja, 2, '.', ''));
                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoProdaja, 2, '.', '') . "\n";

                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= str_pad("PDV", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $UkupnoVat = 0;
                        foreach ($VatData as $SaleType => $SaleTypeData) {
                            $VatValue = $Vats[$SaleType];

                            $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                            $VatCalcVal = $SaleTypeData / (1 + ($VatValue / 100));
                            $VatCalcVal = $SaleTypeData - $VatCalcVal;
                            $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                            $UkupnoVat = $UkupnoVat + $SaleTypeData;
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoVat, 2, '.', ''));
                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoVat, 2, '.', '') . "\n";

                        if (count($RefundData) > 0) {
                            $UkupnoRefundacija = 0;
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $PrintString .= str_pad("REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            foreach ($RefundData as $SaleType => $SaleTypeData) {
                                if ($SaleType == 'Cash') {
                                    $PaymentPrint = "Gotovina:";
                                } elseif ($SaleType == 'Card') {
                                    $PaymentPrint = "Platna kartica:";
                                } elseif ($SaleType == 'Check') {
                                    $PaymentPrint = "Ček:";
                                } elseif ($SaleType == 'WireTransfer') {
                                    $PaymentPrint = "Prenos na račun:";
                                } elseif ($SaleType == 'MobileMoney') {
                                    $PaymentPrint = "Mobilni novac:";
                                } elseif ($SaleType == 'Voucher') {
                                    $PaymentPrint = "Vaučer:";
                                } elseif ($SaleType == 'Other') {
                                    $PaymentPrint = "Dr. bezgot. plaćanje:";
                                }
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                $UkupnoRefundacija = $UkupnoRefundacija + $SaleTypeData;
                            }
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacija, 2, '.', ''));
                            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacija, 2, '.', '') . "\n";
                        }
                        if (count($VatRefundData)) {
                            $UkupnoRefundacijaVat = 0;
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $PrintString .= str_pad("PDV REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            foreach ($VatRefundData as $SaleType => $SaleTypeData) {
                                $VatValue = $Vats[$SaleType];
                                $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                $VatCalcVal = $SaleTypeData / (1 + ($VatValue / 100));
                                $VatCalcVal = $SaleTypeData - $VatCalcVal;
                                $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                                $UkupnoRefundacijaVat = $UkupnoRefundacijaVat + $SaleTypeData;
                            }
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacijaVat, 2, '.', ''));
                            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacijaVat, 2, '.', '') . "\n";
                        }
                        try {
                            // Enter the share name for your USB printer here
                            $NazivStampaca = $StampacData['naziv'];
                            if (strpos($NazivStampaca, "/")) {
                                $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                            } else {
                                $connector = new WindowsPrintConnector($NazivStampaca);
                            }
                            $printer = new Printer($connector);
                            $printer->pulse(1, 300, 300);
                            $printer->setPrintLeftMargin(0);
                            $printer->setJustification(Printer::JUSTIFY_LEFT);
                            $printer->text($PrintString);
                            $printer->feed();
                            $printer->cut();
                            $printer->close();
                        } catch (Exception $e) {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                            die();
                        }
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za štampu izveštaja!'));
                        die();
                    }
                } else {
                    $NazivDokumenta = 'IzvestajFIPS' . date('Y-m-d-H-i-s');
                    $doc = new DOMDocument('1.0', 'UTF-8');
                    $doc->preserveWhiteSpace = false;
                    $doc->formatOutput = true;
                    $ele = $doc->createElement('Izvestaj');
                    $ele->nodeValue = "1";
                    $doc->appendChild($ele);
                    $doc->save($SaveToReceipt . '/' . $NazivDokumenta . ' .xml');
                }
                $LogDate = date('Y-m-d');
                $LogTime = date('H:i:s');
                $LogUser = "LOGIN";
                $LogWhat = "Presek stanja poslat na stampu";
                mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!', 'Location' => '', 'Action' => '', 'UserData' => ''));
                die();
            } elseif ($StaRadi == 'POPISBLANKO') {
                $GetOdeljenja = mysqli_query($link, "SELECT * FROM kasa_odeljenje WHERE KASA_ID = '$KasaId'");
                if (mysqli_num_rows($GetOdeljenja) > 0) {
                    $OdeljenjaIn = "";
                    while ($rowOdeljenja = mysqli_fetch_array($GetOdeljenja)) {
                        if ($OdeljenjaIn == '') {
                            $OdeljenjaIn = $rowOdeljenja['ODELJENJA_ID'];
                        } else {
                            $OdeljenjaIn .= ', ' . $rowOdeljenja['ODELJENJA_ID'];
                        }
                    }
                    $GetArtikle = mysqli_query($link, "SELECT a.tip, a.name, a.JedinicaMere, ao.ODELJENJA_ID FROM artikal a, artikal_odeljenje ao WHERE ao.ARTIKLI_ID = a.id AND ao.ODELJENJA_ID IN ( $OdeljenjaIn ) ORDER BY ao.ODELJENJA_ID ASC, a.name ASC") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetArtikle) > 0) {
                        $GetOdeljenjeNaziv = mysqli_query($link, "SELECT * FROM odeljenje");
                        $OdeljenjeNaziv = [];
                        if (mysqli_num_rows($GetOdeljenjeNaziv) > 0) {
                            while ($rowOdeljenje = mysqli_fetch_array($GetOdeljenjeNaziv)) {
                                $OdeljenjeNaziv[$rowOdeljenje['id']] = $rowOdeljenje['naziv'];
                            }
                        }
                        $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje = 1 ORDER BY id ASC LIMIT 1");
                        if (mysqli_num_rows($GetStampacData) > 0) {
                            $StampacData = mysqli_fetch_array($GetStampacData);
                            if ($StampacData['tip'] == 'POSBANK80MM') {
                                $PrinterLetters = 42;
                            } else {
                                $PrinterLetters = 32;
                            }
                            $NazivRacuna = $StampacData['naziv'] . '_' . date('Y-m-d-H-i-s') . '-PopisnaLista';
                            $doc2 = new DOMDocument('1.0', 'UTF-8');
                            $doc2->preserveWhiteSpace = false;
                            $doc2->formatOutput = true;
                            $ele2 = $doc2->createElement('NefiskalnaStampa');
                            $eleH2 = $doc2->createElement('Linija');
                            $eleH2->nodeValue = FormatText(date('d.m.Y'));
                            $ele2->appendChild($eleH2);
                            $OdeljenjeId = 0;
                            while ($rowArtikle = mysqli_fetch_array($GetArtikle)) {
                                if ($rowArtikle['tip'] == 'PROD' || $rowArtikle['tip'] == 'SIRO') {
                                    if ($OdeljenjeId != $rowArtikle['ODELJENJA_ID']) {
                                        $OdeljenjeId = $rowArtikle['ODELJENJA_ID'];

                                        $eleH2 = $doc2->createElement('Linija');
                                        $eleH2->nodeValue = FormatTextLeft('==============================');
                                        $ele2->appendChild($eleH2);

                                        $eleH2 = $doc2->createElement('Linija');
                                        $eleH2->nodeValue = FormatText($OdeljenjeNaziv[$OdeljenjeId]);
                                        $ele2->appendChild($eleH2);

                                        $eleH2 = $doc2->createElement('Linija');
                                        $eleH2->nodeValue = FormatTextLeft('==============================');
                                        $ele2->appendChild($eleH2);
                                    }
                                    $eleH2 = $doc2->createElement('Linija');
                                    $eleH2->nodeValue = FormatTextHalfLeft($rowArtikle['name']) . '' . FormatTextHalfRight($rowArtikle['JedinicaMere'] . '_____');
                                    $ele2->appendChild($eleH2);
                                }
                            }
                            $doc2->appendChild($ele2);
                            $doc2->save($SaveToOrder . '/' . $NazivRacuna . '.xml');
                            $LogDate = date('Y-m-d');
                            $LogTime = date('H:i:s');
                            $LogUser = "LOGIN";
                            $LogWhat = "Štampa blanko popisa";
                            mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                            echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!', 'Location' => '', 'Action' => ''));
                            die();
                        } else {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Nema štampača za štampu izveštaja!!!', 'Location' => '', 'Action' => ''));
                            die();
                        }
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla Nema artikala...', 'Location' => '', 'Action' => ''));
                        die();
                    }
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla nema podesenih odeljenja...', 'Location' => '', 'Action' => ''));
                    die();
                }
            } elseif ($StaRadi == 'PERIODICNI') {
                $LogDate = date('Y-m-d');
                $LogTime = date('H:i:s');
                $LogUser = "LOGIN";
                $LogWhat = "Pokrenut prozor za odabir datuma periodicnog izvestaja";
                mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                echo json_encode(array('Status' => 'success', 'Message' => '', 'Location' => '', 'Action' => 'PrikaziDatume', 'UserData' => ''));
                die();
            } elseif ($StaRadi == 'IZLAZAK') {
                $LogDate = date('Y-m-d');
                $LogTime = date('H:i:s');
                $LogUser = "LOGIN";
                $LogWhat = "Izlazak iz programa";
                mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                echo json_encode(array('Status' => 'success', 'Message' => 'Gasenje programa!!!', 'Location' => '', 'Action' => 'UgasiSoftver', 'UserData' => ''));
                die();
            } elseif ($StaRadi == 'ZAKLJUCENJE') {
                $UradiKraj = 0;
                if ($KasaData['iskljucena_provera_stolova'] == 'false') {
                    $GetTables = mysqli_query($link, "SELECT * FROM racun WHERE zatvoren=0");
                    if (mysqli_num_rows($GetTables) > 0) {
                        while ($rowTables = mysqli_fetch_array($GetTables)) {
                            $RacunId = $rowTables['id'];
                            $GetArtikle = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE RACUN_ID='$RacunId'");
                            if (mysqli_num_rows($GetArtikle) > 0) {
                                $UradiKraj = 1;
                            }
                        }
                    }
                    $LogWhat = "Pokusano zatvaranje dana sa otvorenim stolovima";
                }
                if ($UradiKraj == 0) {
                    $LogDate = date('Y-m-d');
                    $LogTime = date('H:i:s');
                    $LogUser = "LOGIN";
                    $LogWhat = "Zatvoren dan";
                    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                    
                    $TipFiscala = GetSettingVal('tipFiskala');
                    if ($KasaData['prodati_artikli'] > 0) {
                        if ($TipFiscala != 'efiscal') {
                            //Prodati artikli
                            for ($i = 0; $i < $KasaData['prodati_artikli']; $i++) {
                                $NazivDokumenta = 'IzvestajAFIPA' . date('Y-m-d-H-i-s');
                                $doc = new DOMDocument('1.0', 'UTF-8');
                                $doc->preserveWhiteSpace = false;
                                $doc->formatOutput = true;
                                $ele = $doc->createElement('Izvestaj');
                                $ele->nodeValue = "2";
                                $doc->appendChild($ele);
                                $doc->save($SaveToReceipt . '/' . $NazivDokumenta . '_' . $i . '.xml');
                            }
                            sleep(2);
                        }
                    }
                    if ($KasaData['presek_stanja'] > 0) {
                        //Presek
                        for ($i = 0; $i < $KasaData['presek_stanja']; $i++) {
                            if ($TipFiscala == 'efiscal') {
                                $ZdVremeOd = "";
                                $ZdVremeDo = date('Y-m-d H:i:s');
                                $Vats = [];
                                $GetVatData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1 ORDER BY id ASC") or die(mysqli_error($link));
                                if (mysqli_num_rows($GetVatData) > 0) {
                                    while ($rowVatData = mysqli_fetch_array($GetVatData)) {
                                        $Vats[$rowVatData['oznaka']] = $rowVatData['vrednost'];
                                    }
                                }
                                $SaleData = [];
                                $RefundData = [];
                                $VatData = [];
                                $VatRefundData = [];
                                $GetZds = mysqli_query($link, "SELECT zakljucenje, pocetak FROM zd ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
                                if (mysqli_num_rows($GetZds) == 1) {

                                    $ZdIn = "";
                                    $rowZD = mysqli_fetch_array($GetZds);
                                    if ($rowZD['pocetak'] == 1) {
                                        $ZdVremeOd = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                                    } else {
                                        $ZdVremeOd = $ZdVremeDo;
                                    }
                                    $GetSaleData = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE vremeRacuna>='$ZdVremeOd' AND vremeRacuna<='$ZdVremeDo' AND tipRacuna='Normal'") or die(mysqli_error($link));
                                    if (mysqli_num_rows($GetSaleData) > 0) {
                                        while ($rowSale = mysqli_fetch_array($GetSaleData)) {
                                            $CurrentTotal = 0;
                                            $OldJournalData = unserialize($rowSale['podaciRacuna']);
                                            $OldJournalData = json_decode(json_encode($OldJournalData), true);
                                            $UbaceniArtikli = $OldJournalData['StavkeProizvoda'];
                                            foreach ($UbaceniArtikli as $UbaceniArtikal) {
                                                $Vat = $UbaceniArtikal['labels'][0];
                                                $Total = $UbaceniArtikal['totalAmount'];
                                                if ($Total < 0) {
                                                    $Total = -1 * $Total;
                                                }
                                                $VatValue = $Vats[$Vat];
                                                $CurrentTotal = $CurrentTotal + $Total;
                                                if ($rowSale['tipTransakcije'] == 'Sale') {
                                                    $VatData[$Vat] = $VatData[$Vat] + $Total;
                                                } else {
                                                    $VatRefundData[$Vat] = $VatRefundData[$Vat] + $Total;
                                                }
                                            }
                                            $UbaciPlacanja = $OldJournalData['StavkePlacanja'];
                                            foreach ($UbaciPlacanja as $UbaciPlacanje) {
                                                $amount = $UbaciPlacanje['amount'];
                                                $paymentType = $UbaciPlacanje['paymentType'];
                                                if ($CurrentTotal >= $amount) {
                                                    if ($rowSale['tipTransakcije'] == 'Sale') {
                                                        $SaleData[$paymentType] = $SaleData[$paymentType] + $amount;
                                                    } else {
                                                        $RefundData[$paymentType] = $RefundData[$paymentType] + $amount;
                                                    }
                                                } else {
                                                    if ($rowSale['tipTransakcije'] == 'Sale') {
                                                        $SaleData[$paymentType] = $SaleData[$paymentType] + $CurrentTotal;
                                                    } else {
                                                        $RefundData[$paymentType] = $RefundData[$paymentType] + $CurrentTotal;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1") or die(mysqli_error($link));
                                if (mysqli_num_rows($GetStampacData) > 0) {
                                    $StampacData = mysqli_fetch_array($GetStampacData);
                                    if ($StampacData['tip'] == 'POSBANK80MM') {
                                        $PrinterLetters = 48;
                                    } else {
                                        $PrinterLetters = 32;
                                    }
                                    $PrintString = "";
                                    $PrintString .= "Presek stanja: " . date('d.m.y H:i:s') . "\n";
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $PrintString .= str_pad("PRODAJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $UkupnoProdaja = 0;
                                    foreach ($SaleData as $SaleType => $SaleTypeData) {
                                        if ($SaleType == 'Cash') {
                                            $PaymentPrint = "Gotovina:";
                                        } elseif ($SaleType == 'Card') {
                                            $PaymentPrint = "Platna kartica:";
                                        } elseif ($SaleType == 'Check') {
                                            $PaymentPrint = "Ček:";
                                        } elseif ($SaleType == 'WireTransfer') {
                                            $PaymentPrint = "Prenos na račun:";
                                        } elseif ($SaleType == 'MobileMoney') {
                                            $PaymentPrint = "Mobilni novac:";
                                        } elseif ($SaleType == 'Voucher') {
                                            $PaymentPrint = "Vaučer:";
                                        } elseif ($SaleType == 'Other') {
                                            $PaymentPrint = "Dr. bezgot. plaćanje:";
                                        }
                                        $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                        $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                        $UkupnoProdaja = $UkupnoProdaja + $SaleTypeData;
                                    }
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoProdaja, 2, '.', ''));
                                    $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoProdaja, 2, '.', '') . "\n";

                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $PrintString .= str_pad("PDV", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $UkupnoVat = 0;
                                    foreach ($VatData as $SaleType => $SaleTypeData) {
                                        $VatValue = $Vats[$SaleType];

                                        $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                                        $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                        $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                        $VatCalcVal = $SaleTypeData / (1 + ($VatValue / 100));
                                        $VatCalcVal = $SaleTypeData - $VatCalcVal;
                                        $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                                        $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                                        $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                                        $UkupnoVat = $UkupnoVat + $SaleTypeData;
                                    }
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoVat, 2, '.', ''));
                                    $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoVat, 2, '.', '') . "\n";

                                    if (count($RefundData) > 0) {
                                        $UkupnoRefundacija = 0;
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        $PrintString .= str_pad("REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        foreach ($RefundData as $SaleType => $SaleTypeData) {
                                            if ($SaleType == 'Cash') {
                                                $PaymentPrint = "Gotovina:";
                                            } elseif ($SaleType == 'Card') {
                                                $PaymentPrint = "Platna kartica:";
                                            } elseif ($SaleType == 'Check') {
                                                $PaymentPrint = "Ček:";
                                            } elseif ($SaleType == 'WireTransfer') {
                                                $PaymentPrint = "Prenos na račun:";
                                            } elseif ($SaleType == 'MobileMoney') {
                                                $PaymentPrint = "Mobilni novac:";
                                            } elseif ($SaleType == 'Voucher') {
                                                $PaymentPrint = "Vaučer:";
                                            } elseif ($SaleType == 'Other') {
                                                $PaymentPrint = "Dr. bezgot. plaćanje:";
                                            }
                                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                            $UkupnoRefundacija = $UkupnoRefundacija + $SaleTypeData;
                                        }
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacija, 2, '.', ''));
                                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacija, 2, '.', '') . "\n";
                                    }
                                    if (count($VatRefundData)) {
                                        $UkupnoRefundacijaVat = 0;
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        $PrintString .= str_pad("PDV REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        foreach ($VatRefundData as $SaleType => $SaleTypeData) {
                                            $VatValue = $Vats[$SaleType];
                                            $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                            $VatCalcVal = $SaleTypeData / (1 + ($VatValue / 100));
                                            $VatCalcVal = $SaleTypeData - $VatCalcVal;
                                            $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                                            $UkupnoRefundacijaVat = $UkupnoRefundacijaVat + $SaleTypeData;
                                        }
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacijaVat, 2, '.', ''));
                                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacijaVat, 2, '.', '') . "\n";
                                    }
                                    try {
                                        // Enter the share name for your USB printer here
                                        $NazivStampaca = $StampacData['naziv'];
                                        if (strpos($NazivStampaca, "/")) {
                                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                                        } else {
                                            $connector = new WindowsPrintConnector($NazivStampaca);
                                        }
                                        $printer = new Printer($connector);
                                        $printer->pulse(1, 300, 300);
                                        $printer->setPrintLeftMargin(0);
                                        $printer->setJustification(Printer::JUSTIFY_LEFT);
                                        $printer->text($PrintString);
                                        $printer->feed();
                                        $printer->cut();
                                        $printer->close();
                                    } catch (Exception $e) {
                                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                                        die();
                                    }
                                } else {
                                    echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za štampu izveštaja!'));
                                    die();
                                }
                            } else {
                                $NazivDokumenta = 'IzvestajBFIPS' . date('Y-m-d-H-i-s');
                                $doc2 = new DOMDocument('1.0', 'UTF-8');
                                $doc2->preserveWhiteSpace = false;
                                $doc2->formatOutput = true;
                                $ele = $doc2->createElement('Izvestaj');
                                $ele->nodeValue = "1";
                                $doc2->appendChild($ele);
                                $doc2->save($SaveToReceipt . '/' . $NazivDokumenta . '_' . $i . '.xml');
                            }
                        }
                        sleep(2);
                    }
                    if ($KasaData['dnevni_izvestaj'] > 0) {
                        //Presek
                        for ($i = 0; $i < $KasaData['dnevni_izvestaj']; $i++) {
                            if ($TipFiscala == 'efiscal') {
                                $ZdVremeOd = "";
                                $ZdVremeDo = date('Y-m-d H:i:s');
                                $Vats = [];
                                $GetVatData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1 ORDER BY id ASC") or die(mysqli_error($link));
                                if (mysqli_num_rows($GetVatData) > 0) {
                                    while ($rowVatData = mysqli_fetch_array($GetVatData)) {
                                        $Vats[$rowVatData['oznaka']] = $rowVatData['vrednost'];
                                    }
                                }
                                $SaleData = [];
                                $RefundData = [];
                                $VatData = [];
                                $VatRefundData = [];
                                $GetZds = mysqli_query($link, "SELECT zakljucenje, pocetak, datum FROM zd ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
                                if (mysqli_num_rows($GetZds) == 1) {
                                    $ZdDatum = date('d.m.Y');
                                    $rowZD = mysqli_fetch_array($GetZds);
                                    if ($rowZD['pocetak'] == 1) {
                                        $ZdVremeOd = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                                        $ZdDatum = date('d.m.Y', strtotime($rowZD['datum']));
                                    } else {
                                        $ZdVremeOd = $ZdVremeDo;
                                    }
                                    $GetSaleData = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE vremeRacuna>='$ZdVremeOd' AND vremeRacuna<='$ZdVremeDo' AND tipRacuna='Normal'") or die(mysqli_error($link));
                                    if (mysqli_num_rows($GetSaleData) > 0) {
                                        while ($rowSale = mysqli_fetch_array($GetSaleData)) {
                                            $CurrentTotal = 0;
                                            $OldJournalData = unserialize($rowSale['podaciRacuna']);
                                            $OldJournalData = json_decode(json_encode($OldJournalData), true);
                                            $UbaceniArtikli = $OldJournalData['StavkeProizvoda'];
                                            foreach ($UbaceniArtikli as $UbaceniArtikal) {
                                                $Vat = $UbaceniArtikal['labels'][0];
                                                $Total = $UbaceniArtikal['totalAmount'];
                                                if ($Total < 0) {
                                                    $Total = -1 * $Total;
                                                }
                                                $VatValue = $Vats[$Vat];
                                                $CurrentTotal = $CurrentTotal + $Total;
                                                if ($rowSale['tipTransakcije'] == 'Sale') {
                                                    $VatData[$Vat] = $VatData[$Vat] + $Total;
                                                } else {
                                                    $VatRefundData[$Vat] = $VatRefundData[$Vat] + $Total;
                                                }
                                            }
                                            $UbaciPlacanja = $OldJournalData['StavkePlacanja'];
                                            foreach ($UbaciPlacanja as $UbaciPlacanje) {
                                                $amount = $UbaciPlacanje['amount'];
                                                $paymentType = $UbaciPlacanje['paymentType'];
                                                if ($CurrentTotal >= $amount) {
                                                    if ($rowSale['tipTransakcije'] == 'Sale') {
                                                        $SaleData[$paymentType] = $SaleData[$paymentType] + $amount;
                                                    } else {
                                                        $RefundData[$paymentType] = $RefundData[$paymentType] + $amount;
                                                    }
                                                } else {
                                                    if ($rowSale['tipTransakcije'] == 'Sale') {
                                                        $SaleData[$paymentType] = $SaleData[$paymentType] + $CurrentTotal;
                                                    } else {
                                                        $RefundData[$paymentType] = $RefundData[$paymentType] + $CurrentTotal;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1") or die(mysqli_error($link));
                                if (mysqli_num_rows($GetStampacData) > 0) {
                                    $StampacData = mysqli_fetch_array($GetStampacData);
                                    if ($StampacData['tip'] == 'POSBANK80MM') {
                                        $PrinterLetters = 48;
                                    } else {
                                        $PrinterLetters = 32;
                                    }
                                    $PrintString = "";
                                    $PrintString .= "Dnevni izveštaj: " . date('d.m.y', strtotime($ZdDatum)) . "\n";
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $PrintString .= str_pad("PRODAJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $UkupnoProdaja = 0;
                                    foreach ($SaleData as $SaleType => $SaleTypeData) {
                                        if ($SaleType == 'Cash') {
                                            $PaymentPrint = "Gotovina:";
                                        } elseif ($SaleType == 'Card') {
                                            $PaymentPrint = "Platna kartica:";
                                        } elseif ($SaleType == 'Check') {
                                            $PaymentPrint = "Ček:";
                                        } elseif ($SaleType == 'WireTransfer') {
                                            $PaymentPrint = "Prenos na račun:";
                                        } elseif ($SaleType == 'MobileMoney') {
                                            $PaymentPrint = "Mobilni novac:";
                                        } elseif ($SaleType == 'Voucher') {
                                            $PaymentPrint = "Vaučer:";
                                        } elseif ($SaleType == 'Other') {
                                            $PaymentPrint = "Dr. bezgot. plaćanje:";
                                        }
                                        $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                        $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                        $UkupnoProdaja = $UkupnoProdaja + $SaleTypeData;
                                    }
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoProdaja, 2, '.', ''));
                                    $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoProdaja, 2, '.', '') . "\n";

                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $PrintString .= str_pad("PDV", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $UkupnoVat = 0;
                                    foreach ($VatData as $SaleType => $SaleTypeData) {
                                        $VatValue = $Vats[$SaleType];

                                        $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                                        $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                        $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                        $VatCalcVal = $SaleTypeData / (1 + ($VatValue / 100));
                                        $VatCalcVal = $SaleTypeData - $VatCalcVal;
                                        $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                                        $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                                        $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                                        $UkupnoVat = $UkupnoVat + $SaleTypeData;
                                    }
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                    $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoVat, 2, '.', ''));
                                    $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoVat, 2, '.', '') . "\n";

                                    if (count($RefundData) > 0) {
                                        $UkupnoRefundacija = 0;
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        $PrintString .= str_pad("REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        foreach ($RefundData as $SaleType => $SaleTypeData) {
                                            if ($SaleType == 'Cash') {
                                                $PaymentPrint = "Gotovina:";
                                            } elseif ($SaleType == 'Card') {
                                                $PaymentPrint = "Platna kartica:";
                                            } elseif ($SaleType == 'Check') {
                                                $PaymentPrint = "Ček:";
                                            } elseif ($SaleType == 'WireTransfer') {
                                                $PaymentPrint = "Prenos na račun:";
                                            } elseif ($SaleType == 'MobileMoney') {
                                                $PaymentPrint = "Mobilni novac:";
                                            } elseif ($SaleType == 'Voucher') {
                                                $PaymentPrint = "Vaučer:";
                                            } elseif ($SaleType == 'Other') {
                                                $PaymentPrint = "Dr. bezgot. plaćanje:";
                                            }
                                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                            $UkupnoRefundacija = $UkupnoRefundacija + $SaleTypeData;
                                        }
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacija, 2, '.', ''));
                                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacija, 2, '.', '') . "\n";
                                    }
                                    if (count($VatRefundData)) {
                                        $UkupnoRefundacijaVat = 0;
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        $PrintString .= str_pad("PDV REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        foreach ($VatRefundData as $SaleType => $SaleTypeData) {
                                            $VatValue = $Vats[$SaleType];
                                            $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                            $VatCalcVal = $SaleTypeData / (1 + ($VatValue / 100));
                                            $VatCalcVal = $SaleTypeData - $VatCalcVal;
                                            $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                                            $UkupnoRefundacijaVat = $UkupnoRefundacijaVat + $SaleTypeData;
                                        }
                                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacijaVat, 2, '.', ''));
                                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacijaVat, 2, '.', '') . "\n";
                                    }
                                    try {
                                        // Enter the share name for your USB printer here
                                        $NazivStampaca = $StampacData['naziv'];
                                        if (strpos($NazivStampaca, "/")) {
                                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                                        } else {
                                            $connector = new WindowsPrintConnector($NazivStampaca);
                                        }
                                        $printer = new Printer($connector);
                                        $printer->pulse(1, 300, 300);
                                        $printer->setPrintLeftMargin(0);
                                        $printer->setJustification(Printer::JUSTIFY_LEFT);
                                        $printer->text($PrintString);
                                        $printer->feed();
                                        $printer->cut();
                                        $printer->close();
                                    } catch (Exception $e) {
                                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                                        die();
                                    }
                                } else {
                                    echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za štampu izveštaja!'));
                                    die();
                                }
                            } else {
                                $NazivDokumenta = 'IzvestajZFIDI' . date('Y-m-d-H-i-s');
                                $doc3 = new DOMDocument('1.0', 'UTF-8');
                                $doc3->preserveWhiteSpace = false;
                                $doc3->formatOutput = true;
                                $ele = $doc3->createElement('Izvestaj');
                                $ele->nodeValue = "0";
                                $doc3->appendChild($ele);
                                $doc3->save($SaveToReceipt . '/' . $NazivDokumenta . '_' . $i . '.xml');
                            }
                        }
                    }
                    if ($KasaData['softversko_zakljucenje'] == 'true') {
                        if (GetSettingVal('objekat.24h.radno.vreme') == 'true') {
                            $GetLastWd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY datum DESC LIMIT 1");
                            if (mysqli_num_rows($GetLastWd) == 1) {
                                $LastZdData = mysqli_fetch_array($GetLastWd);
                                $ZdBroj = $LastZdData['zdBroj'];
                                $OpenMax = date('Y-m-d', strtotime('+1 days'));
                                $LastZd = $LastZdData['datum'];
                                $CloseTime = date('H:i:s');
                                $OpenTime = date('H:i:s', strtotime('+1 seconds'));
                                if (strtotime($LastZd) < strtotime($OpenMax)) {
                                    while (strtotime($LastZd) < strtotime($OpenMax)) {
                                        $DateToHandle = $LastZd;
                                        $DateToOpen = date('Y-m-d', strtotime($DateToHandle . ' +1 days'));
                                        $TimeToClose = date('Y-m-d ' . $CloseTime . '', strtotime($DateToOpen));
                                        $TimeToOpen = date('Y-m-d ' . $OpenTime . '', strtotime($DateToOpen));
                                        if (strtotime($TimeToClose) > time()) {
                                            $TimeToClose = date('Y-m-d H:i:s');
                                            $TimeToOpen = date('Y-m-d H:i:s', strtotime('+1 seconds'));
                                        }
                                        $IsExist = mysqli_query($link, "SELECT * FROM zd WHERE datum='$DateToHandle' AND pocetak=0 LIMIT 1");
                                        if (mysqli_num_rows($IsExist) == 0) {
                                            mysqli_query($link, "INSERT INTO zd (datum, pocetak, zakljucenje, zdBroj) VALUES ('$DateToHandle', 0, '$TimeToClose', '$ZdBroj')");
                                        }
                                        $ZdBroj++;
                                        $IsExist2 = mysqli_query($link, "SELECT * FROM zd WHERE datum='$DateToOpen' AND pocetak=1 LIMIT 1");
                                        if (mysqli_num_rows($IsExist2) == 0) {
                                            mysqli_query($link, "INSERT INTO zd (datum, pocetak, zakljucenje, zdBroj) VALUES ('$DateToOpen', 1, '$TimeToOpen', '$ZdBroj')");
                                        }
                                        $LastZd = $DateToOpen;
                                    }
                                }
                            } else {
                                mysqli_query($link, "INSERT INTO zd (datum, pocetak, zakljucenje, zdBroj) VALUES (now(), 1, now(), '1')");
                            }
                        }
                    }
                    $GetEvidencija = mysqli_query($link, "SELECT * FROM evidencijazaposlenih WHERE odjavljen=0");
                    if (mysqli_num_rows($GetEvidencija) > 0) {
                        while ($rowEvidencija = mysqli_fetch_array($GetEvidencija)) {
                            $EvidencijaId = $rowEvidencija['id'];
                            $EvidencijaVremePrijave = $rowEvidencija['dolazak'];
                            $EvidencijaOdjavi = date('Y-m-d H:i:s', strtotime($EvidencijaVremePrijave . "  + 1 minute"));
                            mysqli_query($link, "UPDATE evidencijazaposlenih SET odjavljen=1, odlazak='$EvidencijaOdjavi' WHERE id='$EvidencijaId'");
                        }
                    }
                    echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!', 'Location' => '', 'Action' => 'UgasiSoftver', 'UserData' => ''));
                    die();
                } else {
                    $LogDate = date('Y-m-d');
                    $LogTime = date('H:i:s');
                    $LogUser = "LOGIN";
                    $LogWhat = "Pokusano zatvaranje dana sa otvorenim stolovima";
                    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                    echo json_encode(array('Status' => 'error', 'Message' => 'Najpre zatvorite otvorene stolove!!!', 'Location' => '', 'Action' => '', 'UserData' => ''));
                    die();
                }
            } elseif ($StaRadi == 'VERICA') {
                $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY datum DESC LIMIT 1");
                if (mysqli_num_rows($GetZd) == 1) {
                    $ZdData = mysqli_fetch_array($GetZd);
                    $ZdBroj = $ZdData['zdBroj'];
                    $KonobarId = 0;
                    $GetRacune = mysqli_query($link, "SELECT * FROM racun WHERE zatvoren=1 AND crnoPlacanje!='' AND crnoPlacanje!='HOTELSKI GOST' AND zdBroj='$ZdBroj'");
                    if (mysqli_num_rows($GetRacune) > 0) {
                        $BrojTureGet = mysqli_query($link, "SELECT MAX(brojTure) as brojTure FROM tura WHERE datum >= (SELECT MAX(zakljucenje) as datum FROM zd WHERE pocetak=1)");
                        if (mysqli_num_rows($BrojTureGet) > 0) {
                            $BrojTure = mysqli_fetch_array($BrojTureGet)['brojTure'] + 1;
                        } else {
                            $BrojTure = 1;
                        }
                        $GetBrojRacuna = mysqli_query($link, "SELECT MAX(brojRacuna) as broj FROM racun") or die(mysql_error());
                        if (mysqli_num_rows($GetBrojRacuna) > 0) {
                            $ResBrojRacuna = mysqli_fetch_array($GetBrojRacuna);
                            $brojRacuna = $ResBrojRacuna['broj'] + 1;
                        } else {
                            $brojRacuna = 1;
                        }
                        $datumRacuna = date('Y-m-d H:i:s');
                        $kasaId = $KasaId;
                        mysqli_query($link, "INSERT INTO racun(brojRacuna, brojStola, datum, fiskalniOdstampan, storniran, zatvoren, KASA_ID, KONOBAR_ID, popust, zdBroj)
                            VALUES('$brojRacuna', '0', '$datumRacuna', 0, 0, 1, '$kasaId', '0', '0', '$ZdBroj')") or die(mysqli_error($link) . "na upisu racuna");
                        $RacunId = mysqli_insert_id($link);
                        $VremePorudzbine = date('Y-m-d H:i:s');
                        mysqli_query($link, "INSERT INTO tura (brojStola, brojTure, datum, pripremljena, uPripremi, pocetak, REZERVACIJA_ID, napomena, RACUN_ID) 
                            VALUES ('0', '$BrojTure', '$VremePorudzbine', 0, 0, now(), 0, 'RASTAVLJANJE', '$RacunId')") or die(mysqli_error($link));
                        $IdTure = mysqli_insert_id($link);
                        $StavkeRacuna = [];
                        while ($rowRacuni = mysqli_fetch_array($GetRacune)) {
                            $OldRacunId = $rowRacuni['id'];
                            $PopustRacuna = $rowRacuni['popust'];
                            $KonobarId = $rowRacuni['KONOBAR_ID'];
                            $GetArtikle = mysqli_query($link, "SELECT sr.id, a.poreskaGrupa, sr.kolicina, sr.cena, sr.naziv, sr.ARTIKAL_ID FROM stavkaracuna sr, artikal a WHERE sr.RACUN_ID='$OldRacunId' AND a.id=sr.ARTIKAL_ID ORDER BY sr.id ASC");
                            if (mysqli_num_rows($GetArtikle) > 0) {
                                while ($rowArtikli = mysqli_fetch_array($GetArtikle)) {
                                    $NazivArtiklaRacuna = $rowArtikli['naziv'];
                                    $CenaArtiklaRacuna = $rowArtikli['cena'];
                                    if ($PopustRacuna > 0) {
                                        $Popust = $CenaArtiklaRacuna * (0 + $PopustRacuna / 100);
                                    } else {
                                        $Popust = 0;
                                    }
                                    $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                                    $poreskaGrupa = $rowArtikli['poreskaGrupa'];
                                    $StavkeRacuna[$rowArtikli['id']] = ['Naziv' => $rowArtikli['naziv'], 'Cena' => $CenaArtiklaRacuna, 'Kolicina' => $rowArtikli['kolicina'], 'PG' => $rowArtikli['poreskaGrupa']];
                                    $StavkaRacunaId = $rowArtikli['id'];
                                    mysqli_query($link, "UPDATE stavkaracuna SET RACUN_ID='$RacunId', TURA_ID='$IdTure' WHERE id='$StavkaRacunaId'");
                                }
                            }
                            mysqli_query($link, "DELETE FROM racun WHERE id='$OldRacunId'");
                        }
                        if (!empty($StavkeRacuna)) {
                            $doc = new DOMDocument('1.0', 'UTF-8');
                            $doc->preserveWhiteSpace = false;
                            $doc->formatOutput = true;
                            $ele = $doc->createElement('FiscalRecipet');
                            $NazivRacuna = 'Racun_' . date('Ymd_His');
                            $TotalRacun = 0;
                            foreach ($StavkeRacuna as $StavkaRacuna) {
                                $NazivArtiklaRacuna = $StavkaRacuna['Naziv'];
                                $CenaArtiklaRacuna = number_format($StavkaRacuna['Cena'], 2);
                                $KolicinaArtiklaRacuna = number_format($StavkaRacuna['Kolicina'], 2);
                                $poreskaGrupa = $StavkaRacuna['PG'];
                                $TotalRacun = $TotalRacun + ($StavkaRacuna['Cena'] * $StavkaRacuna['Kolicina']);
                                switch ($poreskaGrupa) {
                                    case "0":
                                        $OznakaPorez = "GRUPA_A";
                                        break;
                                    case "1":
                                        $OznakaPorez = "GRUPA_G";
                                        break;
                                    case "2":
                                        $OznakaPorez = "GRUPA_D";
                                        break;
                                    case "3":
                                        $OznakaPorez = "GRUPA_DJ";
                                        break;
                                    case "4":
                                        $OznakaPorez = "GRUPA_E";
                                        break;
                                    case "5":
                                        $OznakaPorez = "GRUPA_ZJ";
                                        break;
                                    case "6":
                                        $OznakaPorez = "GRUPA_I";
                                        break;
                                    case "7":
                                        $OznakaPorez = "GRUPA_J";
                                        break;
                                    case "8":
                                        $OznakaPorez = "GRUPA_K";
                                        break;
                                }
                                $ele2 = $doc->createElement('FiscalItem');
                                $ele3 = $doc->createElement('Naziv');
                                $ele3->nodeValue = $NazivArtiklaRacuna;
                                $ele2->appendChild($ele3);
                                $ele4 = $doc->createElement('Cena');
                                $ele4->nodeValue = $CenaArtiklaRacuna;
                                $ele2->appendChild($ele4);
                                $ele5 = $doc->createElement('Kolicina');
                                $ele5->nodeValue = $KolicinaArtiklaRacuna;
                                $ele2->appendChild($ele5);
                                $ele6 = $doc->createElement('PoreskaGrupa');
                                $ele6->nodeValue = $OznakaPorez;
                                $ele2->appendChild($ele6);
                                $ele->appendChild($ele2);
                            }
                            $ele7 = $doc->createElement('Placanje');
                            $ele8 = $doc->createElement('Kartica');
                            $ele8->nodeValue = '0.0';
                            $ele7->appendChild($ele8);
                            $ele9 = $doc->createElement('Gotovina');
                            $ele9->nodeValue = number_format($TotalRacun, 2, '.', '');
                            $ele7->appendChild($ele9);
                            $ele10 = $doc->createElement('Cek');
                            $ele10->nodeValue = '0.0';
                            $ele7->appendChild($ele10);
                            $ele->appendChild($ele7);
                            $ele11 = $doc->createElement('Konobar');
                            $GetKonobarName = mysqli_query($link, "SELECT * FROM konobar WHERE id='$KonobarId'");
                            if (mysqli_num_rows($GetKonobarName) == 1) {
                                $ele11->nodeValue = mysqli_fetch_array($GetKonobarName)['skrIme'];
                            } else {
                                $ele11->nodeValue = '';
                            }
                            $ele->appendChild($ele11);
                            $doc->appendChild($ele);
                            $doc->save($SaveToReceipt . '/' . $NazivRacuna . '.xml');
                            mysqli_query($link, "UPDATE racun SET KONOBAR_ID='$KonobarId' WHERE id='$RacunId'");
                            echo json_encode(array('Status' => 'success', 'Message' => '', 'Location' => '', 'Action' => ''));
                            RekonstrukcijaStanja($ZdBroj);
                            $LogDate = date('Y-m-d');
                            $LogTime = date('H:i:s');
                            $LogUser = "LOGIN";
                            $LogWhat = "Pokrenuta VERICA";
                            mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                            die();
                        } else {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Nema stavki za naplatu!!!', 'Location' => '', 'Action' => '', 'UserData' => ''));
                            die();
                        }
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nema racuna za naplatu!!!', 'Location' => '', 'Action' => ''));
                        die();
                    }
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nema radnog dana!!!', 'Location' => '', 'Action' => ''));
                    die();
                }
            } elseif ($StaRadi == 'CISTACICA') {
                $LogDate = date('Y-m-d');
                $LogTime = date('H:i:s');
                $LogUser = "LOGIN";
                $LogWhat = "Pokrenut prozor za odabir datuma cistacice";
                mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                echo json_encode(array('Status' => 'success', 'Message' => '', 'Location' => '', 'Action' => 'PrikaziCistacicu', 'UserData' => ''));
                die();
            } elseif ($StaRadi == 'SPREMACICA') {
                $StalniGost = GetSettingVal('faktura.firma.spremacice');
                $GetStalniGost = mysqli_query($link, "SELECT * FROM stalnigost WHERE id='$StalniGost'");
                if (mysqli_num_rows($GetStalniGost) == 1) {
                    $StalniGostData = mysqli_fetch_array($GetStalniGost);
                    $StalniGostPopust = $StalniGostData['popust'];
                    $StalniGostPlacanje = $StalniGostData['nacinPlacanja'];
                    if ($StalniGostPlacanje == '') {
                        $StalniGostPlacanje = "CEK";
                    }
                    $KomitentId = 0;
                    $GetKomitent = mysqli_query($link, "SELECT * FROM komitent WHERE SG_ID='$StalniGost'");
                    if (mysqli_num_rows($GetKomitent) == 1) {
                        $KomitentId = mysqli_fetch_array($GetKomitent)['id'];
                    }
                    $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY datum DESC LIMIT 1");
                    if (mysqli_num_rows($GetZd) == 1) {
                        $ZdData = mysqli_fetch_array($GetZd);
                        $ZdBroj = $ZdData['zdBroj'];
                        $KonobarId = 0;
                        $GetRacune = mysqli_query($link, "SELECT * FROM racun WHERE zatvoren=1 AND crnoPlacanje!='' AND crnoPlacanje!='HOTELSKI GOST' AND zdBroj='$ZdBroj'");
                        if (mysqli_num_rows($GetRacune) > 0) {
                            $BrojTureGet = mysqli_query($link, "SELECT MAX(brojTure) as brojTure FROM tura WHERE datum >= (SELECT MAX(zakljucenje) as datum FROM zd WHERE pocetak=1)");
                            if (mysqli_num_rows($BrojTureGet) > 0) {
                                $BrojTure = mysqli_fetch_array($BrojTureGet)['brojTure'] + 1;
                            } else {
                                $BrojTure = 1;
                            }
                            $GetBrojRacuna = mysqli_query($link, "SELECT MAX(brojRacuna) as broj FROM racun") or die(mysql_error());
                            if (mysqli_num_rows($GetBrojRacuna) > 0) {
                                $ResBrojRacuna = mysqli_fetch_array($GetBrojRacuna);
                                $brojRacuna = $ResBrojRacuna['broj'] + 1;
                            } else {
                                $brojRacuna = 1;
                            }
                            $datumRacuna = date('Y-m-d H:i:s');
                            $kasaId = $KasaId;
                            if ($KomitentId > 0) {
                                mysqli_query($link, "INSERT INTO racun(brojRacuna, brojStola, datum, fiskalniOdstampan, storniran, zatvoren, KASA_ID, KONOBAR_ID, popust, zdBroj, STALNIGOST_ID, KOMITENT_ID)
                            VALUES('$brojRacuna', '0', '$datumRacuna', 0, 0, 1, '$kasaId', '0', '0', '$ZdBroj', '$StalniGost', '$KomitentId')") or die(mysqli_error($link) . "na upisu racuna");
                            } else {
                                mysqli_query($link, "INSERT INTO racun(brojRacuna, brojStola, datum, fiskalniOdstampan, storniran, zatvoren, KASA_ID, KONOBAR_ID, popust, zdBroj, STALNIGOST_ID)
                            VALUES('$brojRacuna', '0', '$datumRacuna', 0, 0, 1, '$kasaId', '0', '0', '$ZdBroj', '$StalniGost')") or die(mysqli_error($link) . "na upisu racuna");
                            }
                            $RacunId = mysqli_insert_id($link);
                            $VremePorudzbine = date('Y-m-d H:i:s');
                            mysqli_query($link, "INSERT INTO tura (brojStola, brojTure, datum, pripremljena, uPripremi, pocetak, REZERVACIJA_ID, napomena, RACUN_ID) 
                            VALUES ('0', '$BrojTure', '$VremePorudzbine', 0, 0, now(), 0, 'RASTAVLJANJE', '$RacunId')") or die(mysqli_error($link));
                            $IdTure = mysqli_insert_id($link);
                            $StavkeRacuna = [];
                            while ($rowRacuni = mysqli_fetch_array($GetRacune)) {
                                $OldRacunId = $rowRacuni['id'];
                                $PopustRacuna = $StalniGostPopust;
                                $KonobarId = $rowRacuni['KONOBAR_ID'];
                                $GetArtikle = mysqli_query($link, "SELECT sr.id, a.poreskaGrupa, sr.kolicina, sr.cena, sr.naziv, sr.ARTIKAL_ID FROM stavkaracuna sr, artikal a WHERE sr.RACUN_ID='$OldRacunId' AND a.id=sr.ARTIKAL_ID ORDER BY sr.id ASC");
                                if (mysqli_num_rows($GetArtikle) > 0) {
                                    while ($rowArtikli = mysqli_fetch_array($GetArtikle)) {
                                        $NazivArtiklaRacuna = $rowArtikli['naziv'];
                                        $CenaArtiklaRacuna = $rowArtikli['cena'];
                                        if ($PopustRacuna > 0) {
                                            $Popust = $CenaArtiklaRacuna * (0 + $PopustRacuna / 100);
                                        } else {
                                            $Popust = 0;
                                        }
                                        $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                                        $poreskaGrupa = $rowArtikli['poreskaGrupa'];
                                        $StavkeRacuna[$rowArtikli['id']] = ['Naziv' => $rowArtikli['naziv'], 'Cena' => $CenaArtiklaRacuna, 'Kolicina' => $rowArtikli['kolicina'], 'PG' => $rowArtikli['poreskaGrupa']];
                                        $StavkaRacunaId = $rowArtikli['id'];
                                        mysqli_query($link, "UPDATE stavkaracuna SET RACUN_ID='$RacunId', TURA_ID='$IdTure' WHERE id='$StavkaRacunaId'");
                                    }
                                }
                                mysqli_query($link, "DELETE FROM racun WHERE id='$OldRacunId'");
                            }
                            if (!empty($StavkeRacuna)) {
                                $doc = new DOMDocument('1.0', 'UTF-8');
                                $doc->preserveWhiteSpace = false;
                                $doc->formatOutput = true;
                                $ele = $doc->createElement('FiscalRecipet');
                                $NazivRacuna = 'Racun_' . date('Ymd_His');
                                $TotalRacun = 0;
                                foreach ($StavkeRacuna as $StavkaRacuna) {
                                    $NazivArtiklaRacuna = $StavkaRacuna['Naziv'];
                                    $CenaArtiklaRacuna = number_format($StavkaRacuna['Cena'], 2);
                                    $KolicinaArtiklaRacuna = number_format($StavkaRacuna['Kolicina'], 2);
                                    $poreskaGrupa = $StavkaRacuna['PG'];
                                    $TotalRacun = $TotalRacun + ($StavkaRacuna['Cena'] * $StavkaRacuna['Kolicina']);
                                    switch ($poreskaGrupa) {
                                        case "0":
                                            $OznakaPorez = "GRUPA_A";
                                            break;
                                        case "1":
                                            $OznakaPorez = "GRUPA_G";
                                            break;
                                        case "2":
                                            $OznakaPorez = "GRUPA_D";
                                            break;
                                        case "3":
                                            $OznakaPorez = "GRUPA_DJ";
                                            break;
                                        case "4":
                                            $OznakaPorez = "GRUPA_E";
                                            break;
                                        case "5":
                                            $OznakaPorez = "GRUPA_ZJ";
                                            break;
                                        case "6":
                                            $OznakaPorez = "GRUPA_I";
                                            break;
                                        case "7":
                                            $OznakaPorez = "GRUPA_J";
                                            break;
                                        case "8":
                                            $OznakaPorez = "GRUPA_K";
                                            break;
                                    }
                                    $ele2 = $doc->createElement('FiscalItem');
                                    $ele3 = $doc->createElement('Naziv');
                                    $ele3->nodeValue = $NazivArtiklaRacuna;
                                    $ele2->appendChild($ele3);
                                    $ele4 = $doc->createElement('Cena');
                                    $ele4->nodeValue = $CenaArtiklaRacuna;
                                    $ele2->appendChild($ele4);
                                    $ele5 = $doc->createElement('Kolicina');
                                    $ele5->nodeValue = $KolicinaArtiklaRacuna;
                                    $ele2->appendChild($ele5);
                                    $ele6 = $doc->createElement('PoreskaGrupa');
                                    $ele6->nodeValue = $OznakaPorez;
                                    $ele2->appendChild($ele6);
                                    $ele->appendChild($ele2);
                                }
                                $ele7 = $doc->createElement('Placanje');
                                $ele8 = $doc->createElement('Kartica');
                                if ($StalniGostPlacanje == 'KARTICA') {
                                    $ele8->nodeValue = number_format($TotalRacun, 2, '.', '');
                                } else {
                                    $ele8->nodeValue = '0.0';
                                }
                                $ele7->appendChild($ele8);
                                $ele9 = $doc->createElement('Gotovina');
                                if ($StalniGostPlacanje == 'GOTOVINA') {
                                    $ele9->nodeValue = number_format($TotalRacun, 2, '.', '');
                                } else {
                                    $ele9->nodeValue = '0.0';
                                }
                                $ele7->appendChild($ele9);
                                $ele10 = $doc->createElement('Cek');
                                if ($StalniGostPlacanje == 'FAKTURA' || $StalniGostPlacanje == 'CEK') {
                                    $ele10->nodeValue = number_format($TotalRacun, 2, '.', '');
                                } else {
                                    $ele10->nodeValue = '0.0';
                                }
                                $ele7->appendChild($ele10);
                                $ele->appendChild($ele7);
                                $ele11 = $doc->createElement('Konobar');
                                $GetKonobarName = mysqli_query($link, "SELECT * FROM konobar WHERE id='$KonobarId'");
                                if (mysqli_num_rows($GetKonobarName) == 1) {
                                    $ele11->nodeValue = mysqli_fetch_array($GetKonobarName)['skrIme'];
                                } else {
                                    $ele11->nodeValue = '';
                                }
                                $ele->appendChild($ele11);
                                $doc->appendChild($ele);
                                $doc->save($SaveToReceipt . '/' . $NazivRacuna . '.xml');
                                mysqli_query($link, "UPDATE racun SET KONOBAR_ID='$KonobarId' WHERE id='$RacunId'");
                                echo json_encode(array('Status' => 'success', 'Message' => '', 'Location' => '', 'Action' => ''));
                                RekonstrukcijaStanja($ZdBroj);
                                $LogDate = date('Y-m-d');
                                $LogTime = date('H:i:s');
                                $LogUser = "LOGIN";
                                $LogWhat = "Pokrenuta spremacica";
                                mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                                die();
                            } else {
                                echo json_encode(array('Status' => 'error', 'Message' => 'Nema stavki za naplatu!!!', 'Location' => '', 'Action' => '', 'UserData' => ''));
                                die();
                            }
                        } else {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Nema racuna za naplatu!!!', 'Location' => '', 'Action' => '', 'UserData' => ''));
                            die();
                        }
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nema radnog dana!!!', 'Location' => '', 'Action' => '', 'UserData' => ''));
                        die();
                    }
                    echo json_encode(array('Status' => 'success', 'Message' => '', 'Location' => '', 'Action' => '', 'UserData' => ''));
                    die();
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenog stalnog gosta!', 'Location' => '', 'Action' => '', 'UserData' => ''));
                    die();
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nepoznata lozinka', 'Location' => '', 'Action' => '', 'UserData' => ''));
                die();
            }
        } else {
            $Greska = $trnetacnalozinka;
            if (isset($_COOKIE['UserId'])) {
                $past = time() - 3600;
                foreach ($_COOKIE as $key => $value) {
                    setcookie($key, $value, $past, '/');
                }
            }
            $LoginStatus = "error";
            $LoginLocation = "";
        }
    } else {
        $rowLogin = mysqli_fetch_array($LoginQuery);
        if ($ResThisPosInfo['id'] != '') {
            $ThisUserId = $rowLogin['id'];
            $ThisPosPlaceId = $ResThisPosInfo['id'];
            $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
            if (mysqli_num_rows($GetZd) == 1) {
                $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
            }
            $GetZdKonobar = mysqli_query($link, "SELECT * FROM zd_konobar WHERE ZD_BROJ='$Zd' AND KONOBAR_ID='$ThisUserId'");
            if (mysqli_num_rows($GetZdKonobar) == 0) {
                $GetFrontUser = mysqli_query($link, "SELECT * FROM konobar_kasa WHERE KONOBARI_ID = '$ThisUserId' AND KASE_ID = '$ThisPosPlaceId'") or die(mysqli_error($link));
                if (mysqli_num_rows($GetFrontUser) == 1) {
                    if (isset($_COOKIE['UserId'])) {
                        $past = time() - 3600;
                        foreach ($_COOKIE as $key => $value) {
                            setcookie($key, $value, $past, '/');
                        }
                    }
                    setcookie("UserName", $rowLogin['punoIme'], time() + 60 * 60 * 24, '/');
                    setcookie("UserId", $rowLogin['id'], time() + 60 * 60 * 24, '/');
                    setcookie("UserLevel", $rowLogin['nivo'], time() + 60 * 60 * 24, '/');
                    setcookie("UserMedjuzbir", $rowLogin['medjuzirBezSifre'], time() + 60 * 60 * 24, '/');
                    setcookie("ThisFrontId", $ThisPosPlaceId, time() + 60 * 60 * 24, '/');
                    $UserData = [];
                    $UserData['UserId'] = $rowLogin['id'];
                    $UserData['UserName'] = $rowLogin['punoIme'];
                    $UserData['UserLevel'] = $rowLogin['nivo'];
                    $UserData['UserMedjuzbir'] = $rowLogin['medjuzirBezSifre'];
                    $UserData['pregledProdajeSvih'] = $rowLogin['pregledProdajeSvih'];
                    $UserData['pregledStorna'] = $rowLogin['pregledStorna'];
                    $UserData['otvaraMeni'] = $rowLogin['otvaraMeni'];
                    $UserData['otvaraPreduzece'] = $rowLogin['otvaraPreduzece'];
                    $UserData['ponovnaStampaRacuna'] = $rowLogin['ponovnaStampaRacuna'];
                    $UserData['otvaraKomitenta'] = $rowLogin['otvaraKomitenta'];
                    $UserData['prometNaMeniPromet'] = $rowLogin['prometNaMeniPromet'];

                    $KorisnikGrafici = "";
                    $UserId = $rowLogin['id'];
                    $GetGrafike = mysqli_query($link, "SELECT g.* FROM grafiksale g, grafik_konobar gk WHERE gk.grafik_id=g.id AND gk.konobar_id='$UserId'") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetGrafike) > 0) {
                        $KorisnikGrafici = [];
                        while ($rowGrafike = mysqli_fetch_array($GetGrafike)) {
                            $KorisnikGrafici[$rowGrafike['id']] = $rowGrafike['id'];
                        }
                    } else {
                        $GetGrafikKonobar = mysqli_query($link, "SELECT g.* FROM grafiksale g, grafik_konobar gk WHERE gk.grafik_id=g.id") or die(mysqli_error($link));
                        if (mysqli_num_rows($GetGrafikKonobar) == 0) {
                            $GetGrafike = mysqli_query($link, "SELECT g.* FROM grafiksale g WHERE 1") or die(mysqli_error($link));
                            if (mysqli_num_rows($GetGrafike) > 0) {
                                $KorisnikGrafici = [];
                                while ($rowGrafike = mysqli_fetch_array($GetGrafike)) {
                                    $KorisnikGrafici[$rowGrafike['id']] = $rowGrafike['id'];
                                }
                            }
                        }
                    }
                    $UserData['grafici'] = $KorisnikGrafici;
                    $Admin = "";
                    $GetAdmin = mysqli_query($link, "SELECT * FROM konobar_admin WHERE KONOBAR_ID='$UserId'");
                    if (mysqli_num_rows($GetAdmin) > 0) {
                        while ($rowAdmin = mysqli_fetch_array($GetAdmin)) {
                            if ($Admin == "") {
                                $Admin = $rowAdmin['MENI_TIP'];
                            } else {
                                $Admin .= "," . $rowAdmin['MENI_TIP'];
                            }
                        }
                    }
                    $UserData['admin_deo'] = $Admin;
                    $LoginStatus = "success";
                    $Greska = $truspesnologovanje;
                    $LoginLocation = "./?modul=pocetna";
                    $LogDate = date('Y-m-d');
                    $LogTime = date('H:i:s');
                    $LogUser = $rowLogin['punoIme'];
                    $LogWhat = "Ulogovan korisnik " . $rowLogin['punoIme'];
                    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                } else {
                    $GetKonobarKasa = mysqli_query($link, "SELECT * FROM konobar_kasa WHERE 1");
                    if (mysqli_num_rows($GetKonobarKasa) == 0) {
                        setcookie("UserName", $rowLogin['punoIme'], time() + 60 * 60 * 24, '/');
                        setcookie("UserId", $rowLogin['id'], time() + 60 * 60 * 24, '/');
                        setcookie("UserLevel", $rowLogin['nivo'], time() + 60 * 60 * 24, '/');
                        setcookie("UserMedjuzbir", $rowLogin['medjuzirBezSifre'], time() + 60 * 60 * 24, '/');
                        setcookie("ThisFrontId", $ThisPosPlaceId, time() + 60 * 60 * 24, '/');
                        $UserData = [];
                        $UserData['UserId'] = $rowLogin['id'];
                        $UserData['UserName'] = $rowLogin['punoIme'];
                        $UserData['UserLevel'] = $rowLogin['nivo'];
                        $UserData['UserMedjuzbir'] = $rowLogin['medjuzirBezSifre'];
                        $UserData['pregledProdajeSvih'] = $rowLogin['pregledProdajeSvih'];
                        $UserData['pregledStorna'] = $rowLogin['pregledStorna'];
                        $UserData['otvaraMeni'] = $rowLogin['otvaraMeni'];
                        $UserData['otvaraPreduzece'] = $rowLogin['otvaraPreduzece'];
                        $UserData['ponovnaStampaRacuna'] = $rowLogin['ponovnaStampaRacuna'];
                        $UserData['otvaraKomitenta'] = $rowLogin['otvaraKomitenta'];
                        $UserData['prometNaMeniPromet'] = $rowLogin['prometNaMeniPromet'];
                        $KorisnikGrafici = "";
                        $UserId = $rowLogin['id'];
                        $GetGrafike = mysqli_query($link, "SELECT g.* FROM grafiksale g, grafik_konobar gk WHERE gk.grafik_id=g.id AND gk.konobar_id='$UserId'") or die(mysqli_error($link));
                        if (mysqli_num_rows($GetGrafike) > 0) {
                            $KorisnikGrafici = [];
                            while ($rowGrafike = mysqli_fetch_array($GetGrafike)) {
                                $KorisnikGrafici[$rowGrafike['id']] = $rowGrafike['id'];
                            }
                        } else {
                            $GetGrafikKonobar = mysqli_query($link, "SELECT g.* FROM grafiksale g, grafik_konobar gk WHERE gk.grafik_id=g.id") or die(mysqli_error($link));
                            if (mysqli_num_rows($GetGrafikKonobar) == 0) {
                                $GetGrafike = mysqli_query($link, "SELECT g.* FROM grafiksale g WHERE 1") or die(mysqli_error($link));
                                if (mysqli_num_rows($GetGrafike) > 0) {
                                    $KorisnikGrafici = [];
                                    while ($rowGrafike = mysqli_fetch_array($GetGrafike)) {
                                        $KorisnikGrafici[$rowGrafike['id']] = $rowGrafike['id'];
                                    }
                                }
                            }
                        }

                        $UserData['grafici'] = $KorisnikGrafici;
                        $Admin = "";
                        $GetAdmin = mysqli_query($link, "SELECT * FROM konobar_admin WHERE KONOBAR_ID='$UserId'");
                        if (mysqli_num_rows($GetAdmin) > 0) {
                            while ($rowAdmin = mysqli_fetch_array($GetAdmin)) {
                                if ($Admin == "") {
                                    $Admin = $rowAdmin['MENI_TIP'];
                                } else {
                                    $Admin .= "," . $rowAdmin['MENI_TIP'];
                                }
                            }
                        }
                        $UserData['admin_deo'] = $Admin;
                        $LoginStatus = "success";
                        $Greska = $truspesnologovanje;
                        $LoginLocation = "./?modul=pocetna";
                        $LogDate = date('Y-m-d');
                        $LogTime = date('H:i:s');
                        $LogUser = $rowLogin['punoIme'];
                        $LogWhat = "Ulogovan korisnik " . $rowLogin['punoIme'];
                        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
                    } else {
                        if (isset($_COOKIE['UserId'])) {
                            $past = time() - 3600;
                            foreach ($_COOKIE as $key => $value) {
                                setcookie($key, $value, $past, '/');
                            }
                        }
                        $Greska = $trpristupkasa;
                        $LoginStatus = "error";
                        $LoginLocation = "";
                    }
                }
            } else {
                if (isset($_COOKIE['UserId'])) {
                    $past = time() - 3600;
                    foreach ($_COOKIE as $key => $value) {
                        setcookie($key, $value, $past, '/');
                    }
                }
                $Greska = $trpristupzd;
                $LoginStatus = "error";
                $LoginLocation = "";
            }
        } else {
            /* ovde ide login za podesavanja */
        }
    }
    echo json_encode(array('Status' => $LoginStatus, 'Message' => $Greska, 'Location' => $LoginLocation, 'Action' => '', 'UserData' => $UserData));
    die();
} else {
    $past = time() - 3600;
    foreach ($_COOKIE as $key => $value) {
        setcookie($key, $value, $past, '/');
    }
}
$TipFiscala = GetSettingVal('tipFiskala');
$VerFile = 163;
?>
<!DOCTYPE html>
<html lang="sr-RS">
    <head>
        <meta name="viewport" content="width=device-width, user-scalable=no">
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE = edge, chrome = 1">
        <meta http-equiv="cleartype" content="on">
        <meta name="HandheldFriendly" content="True">
        <meta name="MobileOptimized" content="320">
        <title><?php Echo $SiteName; ?></title>
        <link rel="icon" href="./asets/favicon.png" />
        <link rel="apple-touch-icon-precomposed" href="./assets/favicon.png" />
        <meta name="msapplication-TileImage" content="./assets/favicon.png" />
        <script src="./assets/js/jquery.min.js?v<?php Echo $VerFile; ?>" type="text/javascript"></script>
        <script src="./assets/js/jqueryui.min.js?<?php Echo $VerFile; ?>" type="text/javascript"></script>
        <script src="./assets/js/common.min.js?v<?php Echo $VerFile; ?>" type="text/javascript"></script>
        <script src="./assets/js/login.min.js?v<?php Echo $VerFile; ?>" type="text/javascript"></script>
        <link href="./assets/css/font-awesome.min.css?v<?php Echo $VerFile; ?>" rel="stylesheet" type="text/css"/>
        <link href="./assets/css/jqueryui.min.css?v<?php Echo $VerFile; ?>" rel="stylesheet" type="text/css"/>
        <link href="./assets/css/common.min.css?v<?php Echo $VerFile; ?>" rel="stylesheet" type="text/css"/>        
        <link href="./assets/css/login.css?v<?php Echo $VerFile; ?>" rel="stylesheet" type="text/css"/>         
        <link href="./assets/css/front.css?v<?php Echo $VerFile; ?>" rel="stylesheet" type="text/css"/>  
        <script src="./assets/js/front.js?v<?php Echo $VerFile; ?>" type="text/javascript"></script>     
    </head>
    <?php
    $BackGroundImage = './assets/images/overlay.jpg?' . time();
    ?>
    <?php
    $ClassFront = "";
    if ($KasaData['tipFronta'] == 'brzaNaplata') {
        $ClassFront = ' brzaNaplata';
    }
    ?>
    <body class="<?php Echo $ClassFront; ?>">
        <?php
        include('partials/parts/loader.php');
        ?>
        <div class="LoginScreen" style="background: #eee url(<?php Echo $BackGroundImage;
        ?>) no-repeat center center / cover fixed;width: 100%;height: 100vh;" class="RestaurantColors">
            <span class="CloseProgram" onclick="CloseWindowNow()">
                <i class="fa fa-close"></i>
            </span>
            <div class="TehnickaPodrska">
                <?php Echo $trtehnickapodrska; ?>
            </div>
            <div class="LoginContentAdmin">
                <div class='Stabilize'>
                    <img src="./assets/images/bmaster.svg" alt="<?php Echo $SiteName; ?>" class="NazivSajtaAdmin">
                    <div class="LoginVertical">
                        <form method="POST" class="LoginFormAdmin">
                            <h2><?php Echo $trsignin; ?></h2>
                            <div class="ErrorLogin"></div>
                            <label class='LoginLabel'>
                                <i class="fa fa-key"></i>
                                <input type="password" placeholder="<?php Echo $trpin; ?>" name="lozinka" class="LoginInput" required="" autocomplete="off">
                            </label>
                            <button type="submit" class="LoginButton">
                                <i class="fa fa-check"></i>
                                <span><?php Echo $trsignin; ?></span>
                            </button>    
                            <?php
                            include('partials/parts/numerickeyboard.php');
                            ?>
                        </form> 
                    </div>
                    <div class="DateTime">
                        <div id="Time"></div>
                        <div id="Date"></div>
                    </div>
                    <div class="LoginOptions">
                        <div class="LoginOption" data-option="Login" onclick="ToggleLogin()">
                            <img src="./assets/images/prijava.png" alt="Prijava">
                        </div>
                        <div class="LoginOption" data-option="Support">
                            <a href="http://get.teamviewer.com/petcom" target="_blank">
                                <img src="./assets/images/podrska.png" alt="Podrska">
                            </a>
                        </div>
                        <div class="LoginOption" data-option="Numeric" onclick="ToggleKeyboard()">
                            <img src="./assets/images/numeric.png" alt="Numeric">
                        </div>
                    </div>
                </div>
            </div>
            <div class="SelectDates">
                <div class="SelectDatesInner">
                    <div class="PopUpTitle">Odaberite period:</div>
                    <form class='PeriodicForm'>
                        <div class="InlineLabel">
                            <span>Od datuma:</span>
                            <input type='text' readonly="" required="" value="<?php Echo date('d.m.Y'); ?>" class='DatePicker' id='DateFrom'>
                        </div>
                        <div class="InlineLabel">
                            <span>Od datuma:</span>
                            <input type='text' readonly="" required="" value="<?php Echo date('d.m.Y'); ?>" class='DatePicker' id='DateTo'>
                        </div>
                        <div class='CancelDates'>Odustani</div>
                        <button class='ConfirmDates'>Potvrdi</button>
                    </form>
                </div>
            </div>
            <div class="Cleaner">
                <div class="CleanerInner">
                    <div class="PopUpTitle">Odaberite datum:</div>
                    <form class='CleanerForm'>
                        <div class="BlockLabel">
                            <span>Do datuma:</span>
                            <input type='text' readonly="" required="" value="<?php Echo date('d.m.Y'); ?>" class='DatePicker' id='CleanerDate'>
                        </div>
                        <div class='CancelCleaner'>Odustani</div>
                        <button class='ConfirmDates'>Potvrdi</button>
                    </form>
                </div>
            </div>
            <div class="EvidencijaZaposlenih">
                <div class="EvidencijaZaposlenihInner">
                    <div class="PopUpTitle">Unesite lozinku</div>
                    <form class='EvidencijaZaposlenihForm'>
                        <div class="BlockLabel">
                            <span>Unesite lozinku:</span>
                            <input type='password' required="" value="" id='EvidencijaInput'>
                        </div>
                        <div class='CancelEvidencija'>Odustani</div>
                        <button class='ConfirmEvidencija'>Potvrdi</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="FrontScreen">
            <?php
            $IsMeni = GetSettingVal('meni');
            $IsDostava = GetSettingVal('dostava');
            $Grafici = [];
            $GraficiIn = "";
            $KasaGrafik = [];
            $GetKasaGrafik = mysqli_query($link, "SELECT * FROM kasa_grafici WHERE kasaID='$KasaId'");
            if (mysqli_num_rows($GetKasaGrafik) > 0) {
                $ShowKasaGrafik = 0;
                while ($rowKasaGrafik = mysqli_fetch_array($GetKasaGrafik)) {
                    $KasaGrafik[$rowKasaGrafik['grafikID']] = $rowKasaGrafik['grafikID'];
                }
            } else {
                $ShowKasaGrafik = 1;
            }
            $Stolovi = [];
            $GetGrafike = mysqli_query($link, "SELECT g.* FROM grafiksale g WHERE 1") or die(mysqli_error($link));
            if (mysqli_num_rows($GetGrafike) > 0) {
                while ($rowGrafike = mysqli_fetch_array($GetGrafike)) {
                    if ($ShowKasaGrafik == 1 || $KasaGrafik[$rowGrafike['id']] == $rowGrafike['id']) {
                        $Grafici[$rowGrafike['id']]['Name'] = $rowGrafike['naziv'];
                        if ($rowGrafike['slika'] != '') {
                            if (file_exists($rowGrafike['slika'])) {
                                $imageData = file_get_contents($rowGrafike['slika']);
                                if ($imageData != '') {
                                    $im = imagecreatefromstring($imageData);
                                    if ($im !== false) {
                                        imagejpeg($im, 'grafik/' . $rowGrafike['id'] . '.jpg', 100);
                                        imagedestroy($im);
                                    }
                                }
                            }
                        }
                        if ($GraficiIn == "") {
                            $GraficiIn = $rowGrafike['id'];
                        } else {
                            $GraficiIn .= ', ' . $rowGrafike['id'];
                        }
                    }
                }
                $GraficiIn;
                $StoloviIn = "";
                $GetStolove = mysqli_query($link, "SELECT * FROM stoprikaz WHERE GRAFIK_ID IN ( $GraficiIn )") or die(mysqli_error($link));
                if (mysqli_num_rows($GetStolove) > 0) {
                    while ($rowStolovi = mysqli_fetch_array($GetStolove)) {
                        $Stolovi[$rowStolovi['broj']] = $rowStolovi;
                        $Stolovi[$rowStolovi['broj']]['naziv'] = $rowStolovi['broj'];
                        if ($StoloviIn == "") {
                            $StoloviIn = $rowStolovi['broj'];
                        } else {
                            $StoloviIn .= ', ' . $rowStolovi['broj'];
                        }
                    }
                    $GetStoNaziv = mysqli_query($link, "SELECT * FROM stonaziv WHERE broj IN ( $StoloviIn )") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetStoNaziv) > 0) {
                        while ($rowStoNaziv = mysqli_fetch_array($GetStoNaziv)) {
                            $Stolovi[$rowStoNaziv['broj']]['naziv'] = $rowStoNaziv['naziv'];
                        }
                    }
                }
            }
            if ($KasaData['tipFronta'] == 'brzaNaplata') {
                include('parts/grafici.php');
                include('parts/porudzbina.php');
                if ($IsDostava == 'true') {
                    include('parts/dostava.php');
                }
                if ($IsDostava == 'true') {
                    include('parts/staredostave.php');
                }
				include('parts/rastavljanjeSifra.php');
                include('parts/storno.php');
                include('parts/naplata.php');
                include('parts/stalnigost.php');
                include('parts/gotovinski.php');
                include('parts/admin.php');
                include('parts/faktura.php');
                if ($IsMeni == 'true') {
                    include('parts/meni.php');
                }
                include('parts/artikliExpander.php');
                include('parts/opis.php');
            } else {
                include('parts/grafici.php');
                if ($IsDostava == 'true') {
                    include('parts/dostava.php');
                }
                include('parts/porudzbina.php');
                if ($IsDostava == 'true') {
                    include('parts/staredostave.php');
                }
                include('parts/rastavljanje.php');
				include('parts/rastavljanjeSifra.php');
                include('parts/storno.php');
                include('parts/naplata.php');
                include('parts/stalnigost.php');
                include('parts/gotovinski.php');
                include('parts/promenaoperatera.php');
                include('parts/admin.php');
                include('parts/faktura.php');
                if ($IsMeni == 'true') {
                    include('parts/meni.php');
                }
                include('parts/artikliExpander.php');
                include('parts/aktivnistolovi.php');
                include('parts/opis.php');
            }
            ?>
        </div>
        <audio style="display: none;" enablejavascript="true">
            <source id="source" src="./assets/beep.mp3" type="audio/mpeg">
            Your browser does not support the audio element.
        </audio>
        <div class="InsertPin">
            <div class="InsertPinInner">
                <div class="InsertPinTitle">Unos PIN-a</div>
                <form class="InsertPinForm">
                    <input type="password" name="InsertPinInput" class="InsertPinInput">
                    <div class="InsertPinKeyboard">
                        <div class="InsertPinKey" promena-key="1">
                            <span>1</span>
                        </div>
                        <div class="InsertPinKey" promena-key="2">
                            <span>2</span>
                        </div>
                        <div class="InsertPinKey" promena-key="3">
                            <span>3</span>
                        </div>
                        <div class="InsertPinKey" promena-key="4">
                            <span>4</span>
                        </div>
                        <div class="InsertPinKey" promena-key="5">
                            <span>5</span>
                        </div>
                        <div class="InsertPinKey" promena-key="6">
                            <span>6</span>
                        </div>
                        <div class="InsertPinKey" promena-key="7">
                            <span>7</span>
                        </div>
                        <div class="InsertPinKey" promena-key="8">
                            <span>8</span>
                        </div>
                        <div class="InsertPinKey" promena-key="9">
                            <span>9</span>
                        </div>
                        <div class="InsertPinKey YellowLetters" promena-key="Odustani">
                            <span>Odustani</span>
                        </div>
                        <div class="InsertPinKey" promena-key="0">
                            <span>0</span>
                        </div>
                        <div class="InsertPinKey" promena-key="Delete">
                            <span><i class="fa fa-backward"></i></span>
                        </div>
                        <div class="InsertPinKey" promena-key="Potvrdi">
                            <span>Potvrdi</span>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </body>
    <script>
        window.UserId = "";
        window.UserName = "";
        window.UserLevel = "";
        window.UserMedjuzbir = "";
        window.otvaraMeni = "";
        window.otvaraPreduzece = "";
        window.pregledProdajeSvih = "";
        window.pregledStorna = "";
        window.ponovnaStampaRacuna = "";
        window.otvaraKomitenta = "";
        window.prometNaMeniPromet = "";
        window.grafici = "";
        window.admin_deo = "";
<?php
foreach ($KasaData as $KasaDataKey => $KasaDataValue) {
    ?>
            window.<?php Echo $KasaDataKey; ?> = "<?php Echo $KasaDataValue; ?>";
    <?php
}
?>
        window.polaporcije = "<?php Echo GetSettingVal('artikal.polaporcije.procenatcene'); ?>";
    </script>
    <style>
        .PodGrupa, .Grupa{
            font-size: <?php Echo $KasaData['velicina_fonta_podgrupa']; ?>px;
        }
        .Artikal{
            font-size: <?php Echo $KasaData['velicina_fonta_artikala']; ?>px;
        }
    </style>
</html>