<?php
function clean($text)
{
    $utf8 = array(
        '/č/' => 'c',
        '/ć/' => 'c',
        '/Č/' => 'C',
        '/Ć/' => 'C',
        '/ž/' => 'z',
        '/đ/' => 'd',
        '/š/' => 's',
        '/Ž/' => 'Z',
        '/Đ/' => 'D',
        '/Š/' => 'S',
        '/€/' => 'EUR',
    );
    return preg_replace(array_keys($utf8), array_values($utf8), $text);
}

function GetSettingVal($Name)
{
    global $link;
    $Get = mysqli_query($link, "SELECT actual FROM setting WHERE name='$Name' ORDER BY id DESC LIMIT 1");
    if (mysqli_num_rows($Get) > 0) {
        return mysqli_fetch_array($Get)['actual'];
    } else {
        mysqli_query($link, "INSERT INTO setting (name, actual) VALUES ('$Name', '')");
        return "";
    }
}

function GetLicenseCode($Mac, $Pib)
{
    $KeyMap = ["1" => "M", "2" => "N", "3" => "B", "4" => "V", "5" => "C", "6" => "X", "7" => "Z", "8" => "L", "9" => "K", "0" => "J", "Q" => "H", "W" => "G", "E" => "F", "R" => "D", "T" => "S", "Y" => "A", "U" => "P", "I" => "O", "O" => "I", "P" => "U", "A" => "Y", "S" => "T", "D" => "R", "F" => "E", "G" => "W", "H" => "Q", "J" => "0", "K" => "9", "L" => "8", "Z" => "7", "X" => "6", "C" => "5", "V" => "4", "B" => "3", "N" => "2", "M" => "1"];
    $KeyPosition = [14, 11, 9, 1, 6, 8, 13, 0, 3, 7, 12, 10, 2, 15, 4, 5];
    $MacArray = explode(':', $Mac);
    $Inc = 0;
    foreach ($MacArray as $Key => $MacNo) {
        if ($Key > 0 && $Key < 5) {
            $MacKey[$Inc] = $MacNo;
            $Inc++;
        }
    }
    if (strlen($Pib) == 9) {
        $PibArray = str_split($Pib);
        $PibKey = [];
        $Inc = 0;
        foreach ($PibArray as $Key => $PibNo) {
            $PibKey[$Inc] = $PibNo;
            $Inc++;
        }
        //Echo "<br>PIB: " . implode($PibKey);
        $LicenseKey = mb_substr(implode($MacKey), 0, 7, 'UTF-8') . "" . implode($PibKey);
        $LicArray = str_split($LicenseKey);
        $LicKey = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($LicArray as $Key => $KeyNo) {
            $KeyPos = $KeyPosition[$Key];
            $LicKey[$KeyPos] = $KeyMap[$KeyNo];
        }
        return implode($LicKey);
    } else {
        return "GreskaPIB!";
    }
}

function GetLicense($Kod)
{
    if ($Kod == 'GreskaPIB!') {
        return 'nema';
    } else {
        $url = 'http://licence.petcom.rs/preuzmilicencu32.php?ZaKljuc=' . $Kod . '&Time=' . time();
        $cURL = curl_init();
        curl_setopt($cURL, CURLOPT_URL, $url);
        curl_setopt($cURL, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cURL, CURLOPT_HTTPGET, true);
        curl_setopt($cURL, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Accept: application/json'
        ));
        $result = curl_exec($cURL);
        $error_msg = "";
        if (curl_errno($cURL)) {
            $error_msg = curl_error($cURL);
            error_log('Greska pri uzimanju licence: ' . $error_msg);
        }
        if ($error_msg == "" && !empty($result)) {
            $json = json_decode($result, true);
            if ($json['licenca'] == 'nemakreiranihlicenca') {
                return 'nema';
            } else {
                $myfile = fopen("licenca.txt", "w");
                $Lic = $json['licenca'];
                fwrite($myfile, $Lic);
                fclose($myfile);
                return $json['licenca'];
            }
        } else {
            $LicenseFile = file_get_contents('http://localhost:99/front/licenca.txt');
            if ($LicenseFile != '') {
                return $LicenseFile;
            } else {
                return 'nema';
            }
        }
    }
}

function FormatText($Word)
{
    global $PrinterLetters;
    $WordLength = strlen($Word);
    if ($WordLength < $PrinterLetters) {
        $NewWord = str_pad($Word, $PrinterLetters, " ", STR_PAD_BOTH);
        return $NewWord;
    } else {
        return $Word;
    }
}

function FormatTextLeft($Word)
{
    global $PrinterLetters;
    $WordLength = strlen($Word);
    if ($WordLength < $PrinterLetters) {
        $NewWord = str_pad($Word, $PrinterLetters, " ", STR_PAD_RIGHT);
        return $NewWord;
    } else {
        $Word = mb_substr($Word, 0, number_format($PrinterLetters), 'UTF-8');
        return $Word;
    }
}

function FormatTextHalf($Word)
{
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters / 2;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_BOTH);
        return $NewWord;
    } else {
        $Word = mb_substr($Word, 0, number_format($NewPrinterLetters), 'UTF-8');
        return $Word;
    }
}

function FormatTextHalfLeft($Word)
{
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters / 2;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_RIGHT);
        return $NewWord;
    } else {
        $Word = mb_substr($Word, 0, number_format($NewPrinterLetters), 'UTF-8');
        return $Word;
    }
}

function FormatTextHalfRight($Word)
{
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters / 2;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_LEFT);
        return $NewWord;
    } else {
        $Word = mb_substr($Word, 0, number_format($NewPrinterLetters), 'UTF-8');
        return $Word;
    }
}

function FormatTextFourth($Word)
{
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters / 4;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_BOTH);
        return $NewWord;
    } else {
        $Word = mb_substr($Word, 0, number_format($NewPrinterLetters), 'UTF-8');
        return $Word;
    }
}

function FormatTextRight($Word)
{
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_LEFT);
        return $NewWord;
    } else {
        $Word = mb_substr($Word, 0, number_format($NewPrinterLetters), 'UTF-8');
        return $Word;
    }
}

function brojsrpski($para)
{
    $broj = number_format($para, 2, '.', '');
    // razdvaja broj na dinare i pare.
    if (strpos($broj, ".")) {
        $Razbijeno = explode('.', $broj);
        $Para = $Razbijeno[1];
        $Dinara = $Razbijeno[0];
        if ($Para == '') {
            $Para = "00";
        }
    } else {
        $Dinara = $broj;
        $Para = "00";
    }
    $slovima = '';
    $slovima_final = '';
    $prilog = $Para . '/100';

    if ($Dinara == 0) {
        return "nula dinara";
    } elseif ($Dinara > 99999999) {
        return "van opsega";
    } else {
        $jedinice = array('', 'jedan', 'dva', 'tri', 'četiri', 'pet', 'šest', 'sedam', 'osam', 'devet', 'deset', 'jedanaest', 'dvanaest', 'trinaest', 'četrnaest', 'petnaest', 'šesnaest', 'sedamnaest', 'osamnaest', 'devetnaest');
        $jedinice2 = array('', 'jedna', 'dve', 'tri', 'četiri', 'pet', 'šest', 'sedam', 'osam', 'devet', 'deset', 'jedanaest', 'dvanaest', 'trinaest', 'četrnaest', 'petnaest', 'šesnaest', 'sedamnaest', 'osamnaest', 'devetnaest');
        $desetice = array('', 'deset', 'dvadeset', 'trideset', 'četrdeset', 'pedeset', 'šezdeset', 'sedamdeset', 'osamdeset', 'devedeset');
        $stotine = array('', 'sto', 'dvesta', 'trista', 'četirsto', 'petsto', 'šesto', 'sedamsto', 'osamsto', 'devetsto');
        $hiljade = array('', 'hiljada', 'hiljade', 'hiljade', 'hiljade', 'hiljada', 'hiljada', 'hiljada', 'hiljada', 'hiljada');
        $milioni = array('', 'milion', 'miliona', 'miliona', 'miliona', 'miliona', 'miliona', 'miliona', 'miliona', 'miliona');

        $Duzina = strlen($Dinara);
        if ($Duzina == 8) {
            $PrvaDva = substr($Dinara, 0, 2);
            $Prvi = substr($Dinara, 0, 1);
            $Drugi = substr($Dinara, 1, 1);
            if ($PrvaDva < 20) {
                $slovima = $jedinice[number_format($PrvaDva)] . 'miliona';
                $Duzina = 6;
                $Dinara = substr($Dinara, 2, 6);
            } else {
                $slovima = $desetice[$Prvi];
                $Duzina = 7;
                $Dinara = substr($Dinara, 1, 7);
            }
        }
        if ($Duzina == 7) {
            $Prvi = substr($Dinara, 0, 1);
            $slovima .= $jedinice[$Prvi];
            if ($Prvi == 1) {
                $slovima .= 'milion';
            } else {
                $slovima .= 'miliona';
            }
            $Duzina = 6;
            $Dinara = substr($Dinara, 1, 6);
        }
        if ($Duzina == 6) {
            $Prvi = substr($Dinara, 0, 1);
            $slovima .= $stotine[$Prvi];
            $Duzina = 5;
            $Dinara = substr($Dinara, 1, 5);
        }
        if ($Duzina == 5) {
            $PrvaDva = substr($Dinara, 0, 2);
            $Prvi = substr($Dinara, 0, 1);
            $Drugi = substr($Dinara, 1, 1);
            if ($PrvaDva < 20) {
                $slovima .= $jedinice[number_format($PrvaDva, 0)] . 'hiljada';
                $Duzina = 3;
                $Dinara = substr($Dinara, 2, 3);
            } else {
                $slovima .= $desetice[$Prvi];
                $Duzina = 4;
                $Dinara = substr($Dinara, 1, 4);
            }
        }
        if ($Duzina == 4) {
            $Prvi = substr($Dinara, 0, 1);
            $slovima .= $jedinice2[$Prvi];
            $Duzina = 3;
            $Dinara = substr($Dinara, 1, 3);
            if ($Prvi > 1 && $Prvi < 5) {
                $slovima .= 'hiljade';
            } else {
                $slovima .= 'hiljada';
            }
        }
        if ($Duzina == 3) {
            $Prvi = substr($Dinara, 0, 1);
            $slovima .= $stotine[$Prvi];
            $Duzina = 2;
            $Dinara = substr($Dinara, 1, 2);
        }
        if ($Duzina == 2) {
            $PrvaDva = substr($Dinara, 0, 2);
            $Prvi = substr($Dinara, 0, 1);
            $Drugi = substr($Dinara, 1, 1);
            if ($PrvaDva < 20) {
                $slovima .= $jedinice[number_format($PrvaDva)];
                $Duzina = 0;
                $Dinara = '';
            } else {
                $slovima .= $desetice[$Prvi];
                $Duzina = 1;
                $Dinara = substr($Dinara, 1, 1);
            }
        }
        if ($Duzina == 1) {
            $slovima .= $jedinice[$Dinara];
        }
        $slovima_final .= $slovima . ',' . $prilog;
        $slovima = '';
        $prilog = '';
        return $slovima_final;
    }
}

function RekonstrukcijaRacun($RacunId, $ZdBroj)
{
    global $link;
    if ($RacunId > 0) {
        $GetItems = mysqli_query($link, "select ARTIKAL_ID, ROUND(sum(kolicina*putaotkuc*mera), 4) as kolicina, ODELJENJA_ID, dodatno,
        coalesce((select komadBPDV from trebovanjestavka ts
        left join trebovanje t on ts.TREBOVANJE_ID = t.id
        where ts.ARTIKAL_ID = trt.ARTIKAL_ID and trt.tip not in ('SLOZ', 'DODA') and
        t.datumTrebovanja = (SELECT max(t2.datumTrebovanja) from trebovanje t2
        left join trebovanjestavka ts2 on ts2.TREBOVANJE_ID = t2.id
        where ts2.artikal_ID = trt.ARTIKAL_ID) limit 1), 0) as nabavnaCena
        from (
        select sr.artikal_id, sr.kolicina, a.mera,
        1 as putaotkuc, ao.ODELJENJA_ID, '0' as ttip, sr.id, a.tip,
        (case WHEN coalesce(r.crnoPlacanje, '') != '' and
        r.naOsnovno = 0 then 1 else 0 end) as dodatno
        from stavkaracuna sr
        left join artikal a on a.id = sr.artikal_id
        left join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id and ao.ODELJENJA_ID > 1
        left join racun r on r.id = sr.RACUN_ID
        left join kasa k on k.id = r.KASA_ID
        left join kasa_odeljenje ko on ko.KASA_ID = k.id
        where r.id = $RacunId and
        ao.ODELJENJA_ID = ko.ODELJENJA_ID and coalesce(r.id, 0) != 0 and
        a.tip not in ('SLOZ', 'DODA')
        UNION
        select i.sastojak_id, i.kolicina, 1 as mera, sr.kolicina as putaotkuc, ao.ODELJENJA_id,
        '1' as ttip, sr.id, a.tip,
        (case WHEN coalesce(r.crnoPlacanje, '') != '' and
        r.naOsnovno = 0 then 1 else 0 end) as dodatno
        from normativ i
        left join artikal a on a.id = i.sastojak_id
        left join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id and ao.ODELJENJA_ID > 1
        left join stavkaracuna sr on sr.artikal_id = i.artikal_id
        left join artikal a2 on a2.id = sr.artikal_id
        left join racun r on r.id = sr.RACUN_ID
        left join normativartikal na on i.NORMATIVARTIKAL_ID = na.id
        where r.id = $RacunId and a2.tip != 'POLU' and
        ao.ODELJENJA_ID = i.ODELJENJE_ID and coalesce(r.id, 0) != 0 and
        na.id = coalesce((SELECT naa.id
        FROM normativartikal naa
        where naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and
        TIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0
        ORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ), 0)
        UNION
        select ii.sastojak_id, ii.kolicina, 1 as mera, (i.kolicina * sr.kolicina) as putaotkuc, ao.ODELJENJA_id,
        '2' as ttip, sr.id, a.tip,
        (case WHEN coalesce(r.crnoPlacanje, '') != '' and
        r.naOsnovno = 0 then 1 else 0 end) as dodatno
        from normativ i
        left join stavkaracuna sr on sr.artikal_id = i.artikal_id
        left join normativ ii on i.sastojak_id = ii.artikal_id
        left join artikal a on a.id = ii.sastojak_id
        left join artikal a3 on a3.id = i.sastojak_id
        left join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id and ao.ODELJENJA_ID > 1
        left join racun r on r.id = sr.RACUN_ID
        left join normativartikal na on ii.NORMATIVARTIKAL_ID = na.id
        left join normativartikal na2 on i.NORMATIVARTIKAL_ID = na2.id
        where r.id = $RacunId and a3.tip != 'POLU' and
        ao.ODELJENJA_ID = ii.ODELJENJE_ID and coalesce(r.id, 0) != 0 and ii.SASTOJAK_ID is not null and
        na.id = coalesce((SELECT naa.id
        FROM normativartikal naa
        where naa.ARTIKAL_ID = ii.ARTIKAL_ID and naa.aktivan = 1 and
        TIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0
        ORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ), 0) and
        na2.id = coalesce((SELECT naa.id
        FROM normativartikal naa
        where naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and
        TIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0
        ORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ), 0)
        UNION
        select iii.sastojak_id, iii.kolicina, 1 as mera, (i.kolicina * ii.kolicina * sr.kolicina) as putaotkuc, ao.ODELJENJA_id,
        '3' as ttip, sr.id, a.tip,
        (case WHEN coalesce(r.crnoPlacanje, '') != '' and
        r.naOsnovno = 0 then 1 else 0 end) as dodatno
        from normativ i
        left join stavkaracuna sr on sr.artikal_id = i.artikal_id
        left join normativ ii on i.sastojak_id = ii.artikal_id
        left join normativ iii on ii.sastojak_id = iii.artikal_id
        left join artikal a on a.id = iii.sastojak_id
        left join artikal a2 on a2.id = ii.sastojak_id
        left join artikal a3 on a3.id = i.sastojak_id
        left join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id and ao.ODELJENJA_ID > 1
        left join racun r on r.id = sr.RACUN_ID
        left join normativartikal na on iii.NORMATIVARTIKAL_ID = na.id
        left join normativartikal na2 on ii.NORMATIVARTIKAL_ID = na2.id
        left join normativartikal na3 on i.NORMATIVARTIKAL_ID = na3.id
        where r.id = $RacunId and a2.tip != 'POLU' and
        a3.tip != 'POLU' and
        iii.ODELJENJE_ID = ao.ODELJENJA_ID and coalesce(r.id, 0) != 0 and iii.SASTOJAK_ID is not null and
        na.id = coalesce((SELECT naa.id
        FROM normativartikal naa
        where naa.ARTIKAL_ID = iii.ARTIKAL_ID and naa.aktivan = 1 and
        TIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0
        ORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ), 0) and
        na2.id = coalesce((SELECT naa.id
        FROM normativartikal naa
        where naa.ARTIKAL_ID = ii.ARTIKAL_ID and naa.aktivan = 1 and
        TIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0
        ORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ), 0) and
        na3.id = coalesce((SELECT naa.id
        FROM normativartikal naa
        where naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and
        TIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0
        ORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ), 0)
        ) as trt
        where tip not in ('SLOZ', 'DODA')
        group by artikal_id, odeljenja_id, dodatno, nabavnaCena") or die(mysqli_error($link));
        if (mysqli_num_rows($GetItems) > 0) {
            while ($rowItems = mysqli_fetch_array($GetItems)) {
                $ArtikalId = $rowItems['ARTIKAL_ID'];
                $Kolicina = $rowItems['kolicina'];
                $OdeljenjaId = $rowItems['ODELJENJA_ID'];
                $Dodatno = $rowItems['dodatno'];
                $NabavnaCena = $rowItems['nabavnaCena'];
                $IsExist = mysqli_query($link, "SELECT * FROM dnevniutrosak WHERE dodatno=$Dodatno AND zdBroj='$ZdBroj' AND ARTIKAL_ID='$ArtikalId' AND ODELJENJE_ID='$OdeljenjaId'") or die(mysqli_error($link));
                if (mysqli_num_rows($IsExist) == 1) {
                    $OldData = mysqli_fetch_array($IsExist);
                    $OldId = $OldData['id'];
                    $OldKolicina = $OldData['kolicina'];
                    $Kolicina = $Kolicina + $OldKolicina;
                    mysqli_query($link, "UPDATE dnevniutrosak SET kolicina='$Kolicina' WHERE id='$OldId'") or die(mysqli_error($link));
                } else {
                    mysqli_query($link, "INSERT INTO dnevniutrosak (dodatno, kolicina, nabavnaCena, zdBroj, ARTIKAL_ID, ODELJENJE_ID) 
                    VALUES ($Dodatno, '$Kolicina', '$NabavnaCena', '$ZdBroj', '$ArtikalId', '$OdeljenjaId')") or die(mysqli_error($link));
                }
            }
        }
    }
    return true;
}

function RekonstrukcijaStanja($ZdBroj)
{
    global $link;
    $GetRacunId = mysqli_query($link, "SELECT * FROM racun WHERE zdBroj='$ZdBroj' AND zatvoren=1");
    if (mysqli_num_rows($GetRacunId) > 0) {
        mysqli_query($link, "DELETE FROM dnevniutrosak WHERE zdBroj='$ZdBroj'");
        while ($rowRacuni = mysqli_fetch_array($GetRacunId)) {
            $RacunId = $rowRacuni['id'];
            RekonstrukcijaRacun($RacunId, $ZdBroj);
        }
    }
    return true;
}

function UpdateBaze($TableName)
{
    global $link;
    $GetKasaDataTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'kasadata' LIMIT 1;");
    if (mysqli_num_rows($GetKasaDataTable) != 1) {
        mysqli_query($link, "CREATE TABLE `kasadata` (
            `kasaDataId` int(11) NOT NULL AUTO_INCREMENT,
            `kasaDataMeta` varchar(30) DEFAULT NULL,
            `kasaDataValue` varchar(100) DEFAULT NULL,
            `kasaId` int(11) NOT NULL,
            PRIMARY KEY (`kasaDataId`)
          ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;");
    }
    $GetNotifikacijeTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'notifikacije' LIMIT 1;");
    if (mysqli_num_rows($GetNotifikacijeTable) != 1) {
        mysqli_query($link, "CREATE TABLE `notifikacije` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `vreme` datetime DEFAULT NULL,
                `tekst` text,
                `zatvoren` datetime DEFAULT NULL,
                `zatvorio` varchar(30) DEFAULT NULL,
                PRIMARY KEY (`id`)
              ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;");
    }
    $GetkonobarZdTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'zd_konobar' LIMIT 1;");
    if (mysqli_num_rows($GetkonobarZdTable) != 1) {
        mysqli_query($link, "CREATE TABLE `zd_konobar` (
            `ZD_BROJ` int(11) DEFAULT NULL,
            `KONOBAR_ID` int(11) DEFAULT NULL
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8;");
    }
    $GetDostavaTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'dostava' LIMIT 1;");
    if (mysqli_num_rows($GetDostavaTable) != 1) {
        mysqli_query($link, "CREATE TABLE `dostava` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `naziv` varchar(50) DEFAULT NULL,
            `telefon` varchar(30) DEFAULT NULL,
            PRIMARY KEY (`id`)
          ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;");
    }
    $GetDostavaAdresaTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'dostava_adresa' LIMIT 1;");
    if (mysqli_num_rows($GetDostavaAdresaTable) != 1) {
        mysqli_query($link, "CREATE TABLE `dostava_adresa` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `adresa` varchar(100) DEFAULT NULL,
            `mesto` varchar(50) DEFAULT NULL,
            `broj` varchar(20) DEFAULT NULL,
            `sprat` varchar(20) DEFAULT NULL,
            `interfon` varchar(50) DEFAULT NULL,
            `napomena` varchar(255) DEFAULT NULL,
            `DOSTAVA_ID` int(11) DEFAULT NULL,
            PRIMARY KEY (`id`)
          ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;");
    }
    $GetRacunKanalTable = mysqli_query($link, "SELECT * 
            FROM information_schema.COLUMNS 
            WHERE 
            TABLE_SCHEMA = '$TableName' 
            AND TABLE_NAME = 'racun' 
            AND COLUMN_NAME = 'kanalProdaje'");
    if (mysqli_num_rows($GetRacunKanalTable) != 1) {
        mysqli_query($link, "ALTER TABLE racun ADD kanalProdaje varchar(30);");
    }
    $GetKonobarTable = mysqli_query($link, "SELECT * 
            FROM information_schema.COLUMNS 
            WHERE 
            TABLE_SCHEMA = '$TableName' 
            AND TABLE_NAME = 'konobar' 
            AND COLUMN_NAME = 'ponovnaStampaRacuna'");
    if (mysqli_num_rows($GetKonobarTable) != 1) {
        mysqli_query($link, "ALTER TABLE konobar ADD ponovnaStampaRacuna tinyint(1);");
        mysqli_query($link, "ALTER TABLE konobar ADD pregledProdajeSvih tinyint(1);");
        mysqli_query($link, "ALTER TABLE konobar ADD pregledStorna tinyint(1);");
    }
    $GetKonobarTableDostava = mysqli_query($link, "SELECT * 
            FROM information_schema.COLUMNS 
            WHERE 
            TABLE_SCHEMA = '$TableName' 
            AND TABLE_NAME = 'konobar' 
            AND COLUMN_NAME = 'prijemDostave'");
    if (mysqli_num_rows($GetKonobarTableDostava) != 1) {
        mysqli_query($link, "ALTER TABLE konobar ADD prijemDostave tinyint(1);");
    }
    $GetRacunDostavaTable = mysqli_query($link, "SELECT * 
            FROM information_schema.COLUMNS 
            WHERE 
            TABLE_SCHEMA = '$TableName' 
            AND TABLE_NAME = 'racun' 
            AND COLUMN_NAME = 'DOSTAVA_ID'");
    if (mysqli_num_rows($GetRacunDostavaTable) != 1) {
        mysqli_query($link, "ALTER TABLE racun ADD DOSTAVA_ID int(11);");
    }
    $GetRacunDostavaAdresaTable = mysqli_query($link, "SELECT * 
            FROM information_schema.COLUMNS 
            WHERE 
            TABLE_SCHEMA = '$TableName' 
            AND TABLE_NAME = 'racun' 
            AND COLUMN_NAME = 'DOSTAVAADRESA_ID'");
    if (mysqli_num_rows($GetRacunDostavaAdresaTable) != 1) {
        mysqli_query($link, "ALTER TABLE racun ADD DOSTAVAADRESA_ID int(11);");
    }
    $GetRacunStavkaGostTable = mysqli_query($link, "SELECT * 
            FROM information_schema.COLUMNS 
            WHERE 
            TABLE_SCHEMA = '$TableName' 
            AND TABLE_NAME = 'stavkaracuna' 
            AND COLUMN_NAME = 'gostbroj'");
    if (mysqli_num_rows($GetRacunStavkaGostTable) != 1) {
        mysqli_query($link, "ALTER TABLE stavkaracuna ADD gostbroj int(11) DEFAULT 1;");
    }
    if (GetSettingVal('dostava') == 'unknown') {
        mysqli_query($link, "INSERT INTO setting (name, actual) VALUES('dostava', 'true')");
    }
    $GetLogTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'logrecord' LIMIT 1;");
    if (mysqli_num_rows($GetLogTable) != 1) {
        mysqli_query($link, "CREATE TABLE `logrecord` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `dan` date NOT NULL,
    `logLevel` varchar(255) DEFAULT NULL,
    `message` varchar(255) DEFAULT NULL,
    `tag` varchar(255) DEFAULT NULL,
    `uname` varchar(255) NOT NULL,
    `vreme` time NOT NULL,
    `what` varchar(1024) NOT NULL,
    PRIMARY KEY (`id`)
  ) ENGINE=InnoDB AUTO_INCREMENT=90930 DEFAULT CHARSET=utf8;");
    }
    $GetStopeTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'poreske_stope' LIMIT 1;");
    if (mysqli_num_rows($GetStopeTable) != 1) {
        mysqli_query($link, "CREATE TABLE `poreske_stope` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `oznaka` varchar(255) DEFAULT NULL,
    `vrednost` decimal(14,2) DEFAULT NULL,
    `aktivna` tinyint(1) DEFAULT NULL,
    PRIMARY KEY (`id`)
  ) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;");
        mysqli_query($link, "INSERT INTO `poreske_stope` VALUES ('0', 'GRUPA_A', '0.00', '1');");
        mysqli_query($link, "INSERT INTO `poreske_stope` VALUES ('1', 'GRUPA_G', '0.00', '1');");
        mysqli_query($link, "INSERT INTO `poreske_stope` VALUES ('3', 'GRUPA_DJ', '20.00', '1');");
        mysqli_query($link, "INSERT INTO `poreske_stope` VALUES ('4', 'GRUPA_E', '10.00', '1');");
    }
    $GetKonobarAdminTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'konobar_admin' LIMIT 1;");
    if (mysqli_num_rows($GetKonobarAdminTable) != 1) {
        mysqli_query($link, "CREATE TABLE `konobar_admin` (
        `MENI_TIP` varchar(20) DEFAULT NULL,
        `KONOBAR_ID` int(11) DEFAULT NULL
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8;");
        $GetKonobare = mysqli_query($link, "SELECT * FROM konobar WHERE blokiranje=0");
        if (mysqli_num_rows($GetKonobare) > 0) {
            while ($rowKonobar = mysqli_fetch_array($GetKonobare)) {
                $KonobarId = $rowKonobar['id'];
                mysqli_query($link, "INSERT INTO `konobar_admin` VALUES ('admin_admin', '$KonobarId');");
                mysqli_query($link, "INSERT INTO `konobar_admin` VALUES ('izv_razduzenje', '$KonobarId');");
                mysqli_query($link, "INSERT INTO `konobar_admin` VALUES ('izv_poperater', '$KonobarId');");
                mysqli_query($link, "INSERT INTO `konobar_admin` VALUES ('izv_pstorno', '$KonobarId');");
                mysqli_query($link, "INSERT INTO `konobar_admin` VALUES ('izv_pstanja', '$KonobarId');");
                mysqli_query($link, "INSERT INTO `konobar_admin` VALUES ('izv_periodicni', '$KonobarId');");
                mysqli_query($link, "INSERT INTO `konobar_admin` VALUES ('izv_zd', '$KonobarId');");
                mysqli_query($link, "INSERT INTO `konobar_admin` VALUES ('izv_bpl', '$KonobarId');");
            }
        }
    }
    $GetEfiskalTable = mysqli_query($link, "SELECT * FROM information_schema.tables WHERE table_schema = '$TableName' AND table_name = 'racun_fiskal' LIMIT 1;");
    if (mysqli_num_rows($GetEfiskalTable) != 1) {
        mysqli_query($link, "CREATE TABLE `racun_fiskal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `RACUN_ID` int(11) DEFAULT NULL,
  `brojRacuna` varchar(50) DEFAULT NULL,
  `tipRacuna` varchar(20) DEFAULT NULL,
  `tipTransakcije` varchar(20) DEFAULT NULL,
  `KONOBAR_ID` int(11) DEFAULT NULL,
  `vremeRacuna` datetime DEFAULT NULL,
  `podaciRacuna` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");
    }
}
