/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.trgovina.sap;

import functions.rfc.sap.document.sap_com.ZRETAIL_PRICE_LIST_LINE;
import functions.rfc.sap.document.sap_com.ZRETAIL_PRICE_LIST_SERVICEProxy;
import functions.rfc.sap.document.sap_com.ZRETAIL_SALE_ITEMS_LINE;
import functions.rfc.sap.document.sap_com.ZRETAIL_SALE_LINE;
import functions.rfc.sap.document.sap_com.ZRETAIL_SALE_SERVICEProxy;
import functions.rfc.sap.document.sap_com.holders.ZRETAIL_MAT_EXP_TTHolder;
import functions.rfc.sap.document.sap_com.holders.ZRETAIL_PRICE_LIST_TTHolder;
import functions.rfc.sap.document.sap_com.holders.ZRETAIL_SALE_ITEMS_TTHolder;
import functions.rfc.sap.document.sap_com.material.ZRETAIL_MATERIAL_EXPORT_SERVProxy;
import functions.rfc.sap.document.sap_com.material.ZRETAIL_MAT_EXP_LINE;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import javax.xml.rpc.holders.StringHolder;
import org.apache.axis.AxisFault;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.product.Product;

public class KWSSAPCommunicator {
    String endpoint;
    FileHandler fh;
    Logger log = Logger.getLogger("MyLog");
    private static final Logger LOGGER = Logger.getLogger("global");

    public List<Product> getMaterialListFromSAP() {
        LOGGER.info("getMaterialListFromSAP");
        this.endpoint = "http://kwsvk110.sap.kws.com:8033/sap/bc/srt/rfc/sap/zretail_material_export_serv/100/zretail_material_export_serv/100_binding";
        ZRETAIL_MATERIAL_EXPORT_SERVProxy pr = new ZRETAIL_MATERIAL_EXPORT_SERVProxy(this.endpoint);
        StringHolder stringHolder = new StringHolder();
        ZRETAIL_MAT_EXP_TTHolder responseHolder = new ZRETAIL_MAT_EXP_TTHolder();
        StringBuilder sBuilder = new StringBuilder();
        try {
            pr.ZRETAIL_MATERIAL_EXPORT(responseHolder, stringHolder);
            ZRETAIL_MAT_EXP_LINE[] materials = responseHolder.value;
            String output = "";
            for (ZRETAIL_MAT_EXP_LINE material : materials) {
                output = output + material.toString();
            }
            List<Product> pdd = this.generateMaterialListDtos(materials);
            LOGGER.info("USPESNA METODA getMessagePricelist1" + output);
            return pdd;
        }
        catch (RemoteException e) {
            AxisFault af = (AxisFault)e;
            sBuilder.append(af.getFaultActor() + "\r\n");
            sBuilder.append(af.getFaultCode());
            LOGGER.info("Neuspesna komunikacija sa SAPom. Error: " + sBuilder.toString());
            return null;
        }
    }

    private List<Product> generateMaterialListDtos(ZRETAIL_MAT_EXP_LINE[] materials) {
        ArrayList<Product> result = new ArrayList<Product>();
        for (ZRETAIL_MAT_EXP_LINE row : materials) {
            if (row == null) continue;
            Product item = new Product();
            item.setProductCategoryID(1);
            item.setVatID(4);
            item.setMeasurable(true);
            item.setUnitID(1);
            item.setProductTypeID(1);
            row.getMATNR();
            item.setName(row.getMAKTX());
            item.setShortName(row.getMAKTX());
            item.setCode(row.getEAN11());
            item.setBarcode(row.getEAN11());
            row.getMEINS();
            row.getLVORM();
            row.getMATKL();
            item.setProductID(new Long(item.getBarcode()).longValue());
            result.add(item);
        }
        return result;
    }

    public List<PriceListDetailes> getPricelistDetailsFromSAP() {
        LOGGER.info("getPricelistDetailsFromSAP; endpoint:" + this.endpoint);
        this.endpoint = "http://kwsvk110.sap.kws.com:8033/sap/bc/srt/rfc/sap/zretail_price_list_service/100/zretail_price_list_service/100_binding";
        ZRETAIL_PRICE_LIST_SERVICEProxy pr = new ZRETAIL_PRICE_LIST_SERVICEProxy(this.endpoint);
        ZRETAIL_PRICE_LIST_TTHolder PRICE_LIST = new ZRETAIL_PRICE_LIST_TTHolder();
        StringBuilder sBuilder = new StringBuilder();
        try {
            StringHolder MESSAGE = new StringHolder();
            pr.ZRETAIL_PRICE_LIST(MESSAGE, PRICE_LIST);
            ZRETAIL_PRICE_LIST_LINE[] priceListValues = PRICE_LIST.value;
            LOGGER.info("USPESNA METODA pricelist" + MESSAGE.value + priceListValues);
            List<PriceListDetailes> pdd = this.generatePriceListDtos(priceListValues);
            LOGGER.info("USPESNA METODA getMessagePricelist1" + pdd.toString());
            return pdd;
        }
        catch (RemoteException e) {
            AxisFault af = (AxisFault)e;
            sBuilder.append(af.getFaultActor() + "\r\n");
            sBuilder.append(af.getFaultCode());
            LOGGER.info("Neuspesna komunikacija sa SAPom. Error: " + sBuilder.toString());
            return null;
        }
    }

    private List<PriceListDetailes> generatePriceListDtos(ZRETAIL_PRICE_LIST_LINE[] priceListValues) {
        ArrayList<PriceListDetailes> result = new ArrayList<PriceListDetailes>();
        for (ZRETAIL_PRICE_LIST_LINE row : priceListValues) {
            if (row == null) continue;
            LOGGER.info(row.toString());
            PriceListDetailes item = new PriceListDetailes();
            item.setPriceListID(Long.valueOf(1L));
            item.setPrice(Double.valueOf(row.getKBETR().doubleValue()));
            item.setDate(new Date());
            result.add(item);
            item.setCode(row.getMATNR());
        }
        return result;
    }

    public List<PriceListDetailes> testGetMessagePricelist() {
        ZRETAIL_PRICE_LIST_LINE[] priceListValues = new ZRETAIL_PRICE_LIST_LINE[2];
        ZRETAIL_PRICE_LIST_LINE mock1 = new ZRETAIL_PRICE_LIST_LINE();
        mock1.setKMEIN("KG");
        mock1.setKONWA("CSD");
        mock1.setMATNR("213786");
        mock1.setKBETR(new BigDecimal(100.0));
        mock1.setKPEIN(new BigDecimal("1"));
        priceListValues[0] = mock1;
        ZRETAIL_PRICE_LIST_LINE mock2 = new ZRETAIL_PRICE_LIST_LINE();
        mock2.setKMEIN("UN");
        mock2.setKONWA("CSD");
        mock2.setMATNR("235660");
        mock2.setKBETR(new BigDecimal(5400.0));
        mock2.setKPEIN(new BigDecimal(1));
        priceListValues[1] = mock2;
        List<PriceListDetailes> priceList = this.generatePriceListDtos(priceListValues);
        return priceList;
    }

    public List<Product> testGetMessageMaterials() {
        ZRETAIL_MAT_EXP_LINE[] priceListValues = new ZRETAIL_MAT_EXP_LINE[2];
        ZRETAIL_MAT_EXP_LINE mock1 = new ZRETAIL_MAT_EXP_LINE();
        mock1.setMATNR("207456");
        mock1.setEAN11("4050738074565");
        mock1.setLVORM("");
        mock1.setMAKTX("Kermes Maxim 25TK");
        mock1.setMATKL("2323");
        priceListValues[0] = mock1;
        ZRETAIL_MAT_EXP_LINE mock2 = new ZRETAIL_MAT_EXP_LINE();
        mock2.setMATNR("209614");
        mock2.setEAN11("4050738096147");
        mock2.setLVORM("");
        mock2.setMAKTX("RonalDINIO seme, fertil");
        mock2.setMATKL("2505");
        priceListValues[1] = mock2;
        return this.generateMaterialListDtos(priceListValues);
    }

    public ZRETAIL_SALE_ITEMS_LINE[] getSaleResponseFromSAP(List<Object> entryList, StringHolder MESSAGE, StringHolder RECEIPT_DOCUMENT) {
        String endpoint = "http://kwsvk110.sap.kws.com:8033/sap/bc/srt/rfc/sap/zretail_sale_service/100/zretail_sale_service/100_binding";
        LOGGER.info("getSaleResponseFromSAP; endpoint:" + endpoint);
        StringBuilder sBuilder = new StringBuilder();
        StringHolder STATUS = new StringHolder();
        ZRETAIL_SALE_ITEMS_TTHolder SALE_ITEMS = new ZRETAIL_SALE_ITEMS_TTHolder();
        ZRETAIL_SALE_SERVICEProxy pr = new ZRETAIL_SALE_SERVICEProxy(endpoint);
        try {
            ZRETAIL_SALE_LINE[] RETAIL_DATA = this.generateSaleRequestForSAP(entryList);
            pr.ZRETAIL_SALE(RETAIL_DATA, MESSAGE, RECEIPT_DOCUMENT, SALE_ITEMS, STATUS);
            if (!STATUS.value.equalsIgnoreCase("ok")) {
                return null;
            }
        }
        catch (RemoteException e) {
            AxisFault af = (AxisFault)e;
            sBuilder.append(af.getFaultActor() + "\r\n");
            sBuilder.append(af.getFaultCode());
            LOGGER.info("Neuspesna komunikacija sa SAPom. Error: " + sBuilder.toString());
        }
        LOGGER.info("USPESNA METODA getSaleResponseFromSAP");
        return SALE_ITEMS.value;
    }

    private ZRETAIL_SALE_LINE[] generateSaleRequestForSAP(List<Object> list) {
        int n = list.size();
        int i = 0;
        ZRETAIL_SALE_LINE[] RETAIL_DATA = new ZRETAIL_SALE_LINE[n];
        for (Object o : list) {
            ZRETAIL_SALE_LINE line = new ZRETAIL_SALE_LINE();
            line.setITEM("0010");
            line.setEAN11("4050738356609");
            line.setZZLICHA("0453-KWS-20");
            line.setQUANTITY(new BigDecimal(2));
            line.setUOM("UN");
            RETAIL_DATA[i++] = line;
        }
        return RETAIL_DATA;
    }
}

