/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.trgovina.controller;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.TilePane;
import javafx.scene.text.Text;
import javafx.stage.Screen;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.commons.collections4.ListUtils;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.KWS.QRCodeReaderKWS;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.AuthorisationScreenController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.CustomerDispaly;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.FinancialDiscount;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.OfferPriceDetailes;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Present;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Round;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.person.GiftCard;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.LoyaltyLimit;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Description;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.dal.product.QuickGroup;
import rs.petcom.master.fical.FiscalPrinter;
import rs.petcom.master.gui.ProductButton;
import rs.petcom.master.gui.QuickGroupButton;
import rs.petcom.master.gui.trgovina.BillSummaryItemTrgovina;
import rs.petcom.master.gui.trgovina.BillSummaryPaneTrgovina;
import rs.petcom.master.gui.trgovina.BillSummaryRoundTrgovina;
import rs.petcom.trgovina.Main;
import rs.petcom.trgovina.comunicators.SerialPortComunicator;
import rs.petcom.trgovina.sap.KWSSAPCommunicator;

public class TrgovinaController
implements ControlledScreen {
    private final SimpleDateFormat formatClock = new SimpleDateFormat("HH:mm:ss");
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private Timeline timerSat;
    private BillSummaryPaneTrgovina summaryPane;
    private ScreensController controller;
    private ObservableList<OfferPriceDetailes> offerPriceDetailsByProduct;
    private ObservableList<QuickGroupButton> quickGroupButtonList = FXCollections.observableArrayList();
    private List<List<QuickGroup>> listaListi = FXCollections.observableArrayList();
    private int brojStrana = 0;
    private ArrayList<ProductButton> additionalButtonList = new ArrayList();
    private double vrednostBodova = 0.0;
    private NumberFormat nf = NumberFormat.getNumberInstance();
    private static boolean isSAPUpdateOngoing = true;
    private static boolean isSAPUpdateAlreadyMade = false;
    private KWSSAPCommunicator communicator = new KWSSAPCommunicator();
    private static final Logger LOGGER = Logger.getLogger("global");
    @FXML
    private TableView<Product> tableProducts;
    @FXML
    private TableColumn<Product, String> colCode;
    @FXML
    private TableColumn<Product, String> colName;
    @FXML
    private TableColumn<Product, String> colBarcode;
    @FXML
    private TableColumn<Product, String> colPLUcode;
    @FXML
    private TableColumn<Product, Double> colStock;
    @FXML
    private TableColumn<Product, Double> colPrice;
    @FXML
    private ImageView ivLogo;
    private boolean numberClicked = false;
    private boolean numAndMultiplyClicked;
    private boolean tableDoubleClick;
    private boolean codeClicked;
    private boolean weightCode;
    private String textAfterMultiply = "";
    private String textBeforeMultiply = "";
    private String textFofFiltering = "";
    private double weight;
    private Bill lastBill;
    private int billId = 1;
    private int itemId = 0;
    private HashMap<Long, ObservableList<Long>> hashMap;
    private String productCategoryIDS = "-1";
    private String vatIDS = "-1";
    private String popustDozvoljen = "-1";
    private String merljiv = "-1";
    private String tezinski = "-1";
    public Label labelBillInfo;
    private FadeTransition billInfoAnimation;
    private boolean doStock;
    private boolean KWSActive;
    private boolean tMasterLight;
    private Description description;
    private ObservableList<Product> currentTableList = FXCollections.observableArrayList();
    private ObservableList<QuickGroup> quickGrroupList = FXCollections.observableArrayList();
    EventHandler<KeyEvent> eventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (TrgovinaController.this.KWSActive && isSAPUpdateOngoing) {
                TrgovinaController.this.controller.alert("Obave\u0161tenje", "U toku je a\u017euriranje materijala i cena.", TrgovinaController.this.rootPane.getScene().getWindow());
            }
            if (!TrgovinaController.this.tfFilter.isFocused()) {
                switch (event.getCode()) {
                    case ENTER: {
                        if (TrgovinaController.this.summaryPane.getSelectedItemIndex() != -1) {
                            if (TrgovinaController.this.infoText.getText().contains("*")) {
                                TrgovinaController.this.summaryPane.setSelectedItemIndex(-1);
                                TrgovinaController.this.summaryPane.refresh(TrgovinaController.this.controller);
                            }
                        } else {
                            if (TrgovinaController.this.infoText.getText().contains("*")) {
                                TrgovinaController.this.summaryPane.unselectAll();
                                TrgovinaController.this.codeClicked = false;
                                TrgovinaController.this.textBeforeMultiply = TrgovinaController.this.infoText.getText().substring(0, TrgovinaController.this.infoText.getText().indexOf("*"));
                                if (TrgovinaController.this.textBeforeMultiply.equals("0")) {
                                    TrgovinaController.this.infoText.setText("");
                                    break;
                                }
                                TrgovinaController.this.textAfterMultiply = TrgovinaController.this.infoText.getText().substring(TrgovinaController.this.infoText.getText().indexOf("*") + 1, TrgovinaController.this.infoText.getText().length());
                                if (TrgovinaController.this.checkIfNumber(TrgovinaController.this.textBeforeMultiply)) {
                                    TrgovinaController.this.numberClicked = true;
                                    TrgovinaController.this.numAndMultiplyClicked = true;
                                } else {
                                    TrgovinaController.this.numberClicked = false;
                                    TrgovinaController.this.numAndMultiplyClicked = false;
                                }
                                if (!TrgovinaController.this.checkIfNumber(TrgovinaController.this.textAfterMultiply) || TrgovinaController.this.textAfterMultiply.equals("")) {
                                    TrgovinaController.this.tableProducts.getSelectionModel().clearSelection();
                                }
                                if (TrgovinaController.this.numAndMultiplyClicked || TrgovinaController.this.codeClicked) {
                                    TrgovinaController.this.turnOnFilter(TrgovinaController.this.textAfterMultiply);
                                }
                            } else if (!TrgovinaController.this.infoText.getText().trim().equals("")) {
                                TrgovinaController.this.numAndMultiplyClicked = false;
                                TrgovinaController.this.turnOnFilter(TrgovinaController.this.infoText.getText());
                                if (TrgovinaController.this.checkIfInteger(TrgovinaController.this.infoText.getText()) || Boolean.parseBoolean(TrgovinaController.this.controller.getSettings().getActualByName("barcode.front.slova"))) {
                                    TrgovinaController.this.codeClicked = true;
                                }
                                TrgovinaController.this.numberClicked = true;
                            }
                            if (TrgovinaController.this.isEmptyinfoText()) {
                                TrgovinaController.this.tableProducts.getSelectionModel().clearSelection();
                            }
                        }
                        try {
                            if (TrgovinaController.this.summaryPane.getSelectedItemIndex() != -1 && !TrgovinaController.this.isEmptyinfoText()) {
                                TrgovinaController.this.editQuantityProductItemIntoBill();
                                TrgovinaController.this.gridPane.requestFocus();
                            } else if (TrgovinaController.this.checkIfWeightCode(TrgovinaController.this.infoText.getText())) {
                                if (TrgovinaController.this.btnPretraga.isVisible()) {
                                    TrgovinaController.this.textFofFiltering = TrgovinaController.this.infoText.getText().substring(2, 7);
                                    TrgovinaController.this.insertProductItemIntoBill(TrgovinaController.this.weight);
                                    TrgovinaController.this.weightCode = false;
                                    TrgovinaController.this.infoText.setText("");
                                }
                            } else if (TrgovinaController.this.tableProducts.getSelectionModel().getSelectedItem() != null) {
                                TrgovinaController.this.codeClicked = true;
                                TrgovinaController.this.productItemClicked();
                                TrgovinaController.this.gridPane.requestFocus();
                            } else if (TrgovinaController.this.numAndMultiplyClicked || TrgovinaController.this.codeClicked) {
                                TrgovinaController.this.productItemClicked();
                                TrgovinaController.this.gridPane.requestFocus();
                            } else if (TrgovinaController.this.isEmptyinfoText() && TrgovinaController.this.tableProducts.getSelectionModel().getSelectedItem() == null && TrgovinaController.this.summaryPane.getSelectedItemIndex() == -1 && !TrgovinaController.this.controller.getCurrentBill().getLastRound().getItemList().isEmpty()) {
                                TrgovinaController.this.postClicked();
                            }
                            TrgovinaController.this.summaryPane.unselectAll();
                            event.consume();
                        }
                        catch (IndexOutOfBoundsException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case BACK_SPACE: {
                        if (TrgovinaController.this.infoText.isFocused()) break;
                        TrgovinaController.this.keyboardNumClicked(event);
                        break;
                    }
                    case DECIMAL: {
                        TrgovinaController.this.keyboardNumClicked(event);
                        break;
                    }
                    case PERIOD: {
                        TrgovinaController.this.keyboardNumClicked(event);
                        break;
                    }
                    case COMMA: {
                        TrgovinaController.this.keyboardNumClicked(event);
                        break;
                    }
                    case PLUS: {
                        TrgovinaController.this.keyboardNumClicked(event);
                        break;
                    }
                    case MULTIPLY: {
                        TrgovinaController.this.keyboardNumClicked(event);
                        TrgovinaController.this.numberClicked = false;
                        break;
                    }
                    case ESCAPE: {
                        event.consume();
                        TrgovinaController.this.infoText.setText("");
                        TrgovinaController.this.tfFilter.setText("");
                        TrgovinaController.this.numAndMultiplyClicked = false;
                        TrgovinaController.this.numberClicked = false;
                        TrgovinaController.this.summaryPane.refresh(TrgovinaController.this.controller);
                        TrgovinaController.this.gridPane.requestFocus();
                        break;
                    }
                    case DELETE: {
                        TrgovinaController.this.cancelButtonClick();
                        break;
                    }
                    case P: {
                        if (Boolean.parseBoolean(TrgovinaController.this.controller.getSettings().getSetting("barcode.front.slova", null))) {
                            if (event.isControlDown()) {
                                TrgovinaController.this.tableProducts.getSelectionModel().clearSelection();
                                TrgovinaController.this.popustClicked();
                            } else {
                                TrgovinaController.this.keyboardNumClicked(event);
                            }
                        } else {
                            TrgovinaController.this.tableProducts.getSelectionModel().clearSelection();
                            TrgovinaController.this.popustClicked();
                        }
                        event.consume();
                        break;
                    }
                    case UP: {
                        TrgovinaController.this.summaryPane.decreaseSelected();
                        TrgovinaController.this.billSummaryPaneClicked();
                        break;
                    }
                    case DOWN: {
                        TrgovinaController.this.summaryPane.increaseSelected();
                        TrgovinaController.this.billSummaryPaneClicked();
                        break;
                    }
                    case F1: {
                        event.consume();
                        TrgovinaController.this.toggleSearchTable();
                        break;
                    }
                    case F2: {
                        event.consume();
                        TrgovinaController.this.openCashBox();
                        break;
                    }
                    case F3: {
                        event.consume();
                        TrgovinaController.this.getScaleWeight();
                        break;
                    }
                    case SPACE: {
                        event.consume();
                        try {
                            TrgovinaController.this.summaryPane.addEventHandler(KeyEvent.KEY_PRESSED, TrgovinaController.this.eventHandler);
                            ((BillSummaryItemTrgovina)((BillSummaryRoundTrgovina)TrgovinaController.this.summaryPane.getRoundList().get(0)).getItemsList().get(((BillSummaryRoundTrgovina)TrgovinaController.this.summaryPane.getRoundList().get(0)).getItemsList().size() - 1)).setSelected(true);
                            TrgovinaController.this.summaryPane.locateSelected();
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        break;
                    }
                    default: {
                        if (Boolean.parseBoolean(TrgovinaController.this.controller.getSettings().getSetting("barcode.front.slova", null))) {
                            if (TrgovinaController.this.tfFilter.isFocused()) break;
                            TrgovinaController.this.keyboardNumClicked(event);
                            TrgovinaController.this.numberClicked = true;
                            break;
                        }
                        if (!event.getCode().isDigitKey() || TrgovinaController.this.tfFilter.isFocused()) break;
                        TrgovinaController.this.keyboardNumClicked(event);
                        TrgovinaController.this.numberClicked = true;
                    }
                }
                event.consume();
            }
        }
    };
    protected boolean vidljivo = true;
    Task<ObservableList<ProductDepartment>> fillingTableTask;
    Thread fillingTableThread;
    @FXML
    private BorderPane rootPane;
    @FXML
    private BorderPane quickButtonPane;
    @FXML
    private BorderPane billSummaryPane;
    @FXML
    private BorderPane borderPaneKeyboard;
    @FXML
    private BorderPane bpNumeric;
    @FXML
    private TilePane quickButtonTilePane;
    @FXML
    private Label infoLabel;
    @FXML
    private Label userLabel;
    @FXML
    private Label lokacijaLabel;
    @FXML
    private Label labelGuest;
    @FXML
    private Label clockLabel;
    @FXML
    private Label warningLabel;
    @FXML
    private TextField infoText;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfOrderCombination;
    @FXML
    private GridPane aditionalDescriptionalPane;
    @FXML
    private GridPane gridPane;
    @FXML
    private GridPane gridPaneLabel;
    @FXML
    private GridPane gridPaneTableSearch;
    @FXML
    private GridPane gridPaneKeyboard;
    @FXML
    private GridPane gridPanePretraga;
    @FXML
    private GridPane gridPaneQuckButton;
    @FXML
    private ToggleButton group0;
    @FXML
    private ToggleButton group1;
    @FXML
    private ToggleButton group2;
    @FXML
    private ToggleButton group3;
    @FXML
    private ToggleButton group4;
    @FXML
    private HBox hBoxNewBill;
    @FXML
    private Button numpad0;
    @FXML
    private Button numpad1;
    @FXML
    private Button numpad2;
    @FXML
    private Button numpad3;
    @FXML
    private Button numpad4;
    @FXML
    private Button numpad5;
    @FXML
    private Button numpad6;
    @FXML
    private Button numpad7;
    @FXML
    private Button numpad8;
    @FXML
    private Button numpad9;
    @FXML
    private Button numpadDecimal;
    @FXML
    private Button numpadDel;
    @FXML
    private Button numpadMultiply;
    @FXML
    private Button btnPretraga;
    @FXML
    private Button numpadEnter;
    @FXML
    private Button btnPopust;
    @FXML
    private Button logoutButton;
    @FXML
    private Button btnBrziArtikli;
    @FXML
    private Button brziArtikal1;
    @FXML
    private Button brziArtikal2;
    @FXML
    private Button brziArtikal3;
    @FXML
    private Button brziArtikal4;
    @FXML
    private Button brziArtikal5;
    @FXML
    private Button brziArtikal6;
    @FXML
    private Button brziArtikal7;
    @FXML
    private Button brziArtikal8;
    @FXML
    private Button brziArtikal9;
    @FXML
    private Button brziArtikal10;
    @FXML
    private Button brziArtikal11;
    @FXML
    private Button brziArtikal12;
    @FXML
    private Button brziArtikal13;
    @FXML
    private Button brziArtikal14;
    @FXML
    private Button brziArtikal15;
    @FXML
    private Button brziArtikal16;
    @FXML
    private Button brziArtikal17;
    @FXML
    private Button brziArtikal18;
    @FXML
    private Button brziArtikalNazad;
    @FXML
    private Button brziArtikalNapred;
    @FXML
    private Button nextBill;
    @FXML
    private Button keyQ;
    @FXML
    private Button keyW;
    @FXML
    private Button keyE;
    @FXML
    private Button keyR;
    @FXML
    private Button keyT;
    @FXML
    private Button keyY;
    @FXML
    private Button keyU;
    @FXML
    private Button keyI;
    @FXML
    private Button keyO;
    @FXML
    private Button keyP;
    @FXML
    private Button keyA;
    @FXML
    private Button keyS;
    @FXML
    private Button keyD;
    @FXML
    private Button keyF;
    @FXML
    private Button keyG;
    @FXML
    private Button keyH;
    @FXML
    private Button keyJ;
    @FXML
    private Button keyK;
    @FXML
    private Button keyL;
    @FXML
    private Button keyZ;
    @FXML
    private Button keyX;
    @FXML
    private Button keyC;
    @FXML
    private Button keyV;
    @FXML
    private Button keyB;
    @FXML
    private Button keyN;
    @FXML
    private Button keyM;
    @FXML
    private Button keySpace;
    @FXML
    private Button keyEnter;
    @FXML
    private Button keyBackspace;
    @FXML
    private Button key0;
    @FXML
    private Button key1;
    @FXML
    private Button key2;
    @FXML
    private Button key3;
    @FXML
    private Button key4;
    @FXML
    private Button key5;
    @FXML
    private Button key6;
    @FXML
    private Button key7;
    @FXML
    private Button key8;
    @FXML
    private Button key9;
    @FXML
    private Button keyLine;
    @FXML
    private Button cancelButton;
    @FXML
    private Button adminButton;
    @FXML
    private Button loyalityButton;
    @FXML
    private Button btnToggleNumeric;
    @FXML
    private Button quickButton0;
    @FXML
    private Button quickButton7;
    @FXML
    private Button quickButton14;
    @FXML
    private Button post;
    @FXML
    private Button billButton;
    @FXML
    private Button btnDetaljnaPretraga;
    @FXML
    private Button btnReservation;
    @FXML
    private Button btnScales;
    @FXML
    private QuickGroupButton quickButton1;
    @FXML
    private QuickGroupButton quickButton2;
    @FXML
    private QuickGroupButton quickButton3;
    @FXML
    private QuickGroupButton quickButton4;
    @FXML
    private QuickGroupButton quickButton5;
    @FXML
    private QuickGroupButton quickButton6;
    @FXML
    private QuickGroupButton quickButton8;
    @FXML
    private QuickGroupButton quickButton9;
    @FXML
    private QuickGroupButton quickButton10;
    @FXML
    private QuickGroupButton quickButton11;
    @FXML
    private QuickGroupButton quickButton12;
    @FXML
    private QuickGroupButton quickButton13;
    @FXML
    private QuickGroupButton quickButton15;
    @FXML
    private QuickGroupButton quickButton16;
    @FXML
    private QuickGroupButton quickButton17;
    @FXML
    private QuickGroupButton quickButton18;
    @FXML
    private QuickGroupButton quickButton19;
    @FXML
    private QuickGroupButton quickButton20;
    private double discountDisplay;
    private ObservableList<Product> stockList = FXCollections.observableArrayList();

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
        this.summaryPane = new BillSummaryPaneTrgovina(AditionalField.getFrontBack((boolean)true, (Connection)this.controller.getSettings().getConnection()));
        this.KWSActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("KWS.aktivan"));
        this.tMasterLight = Boolean.parseBoolean(this.controller.getSettings().getActualByName("tmaster.light"));
    }

    public void setParameter(java.lang.Object parameter) {
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        new ArrayList();
        Executors.newCachedThreadPool(runnable -> {
            Thread t = new Thread(runnable);
            t.setDaemon(true);
            return t;
        });
        this.warningLabel.setVisible(true);
        this.warningLabel.setOpacity(0.0);
        this.timerSat = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TrgovinaController.this.clockLabel.setText(TrgovinaController.this.formatClock.format(new Date()));
            }
        }, new KeyValue[0])});
        this.timerSat.setCycleCount(-1);
        this.timerSat.play();
        new Timeline();
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.tableProducts.getItems() != null && this.tableProducts.getItems().size() > 0 && !newValue.equals("")) {
                this.loadProductsNew((String)newValue);
            }
        });
        this.tfFilter.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((java.lang.Object)KeyCode.ENTER)) {
                    TrgovinaController.this.currentTableList = Product.getNewTrgovinaList((ScreensController)TrgovinaController.this.controller, (String)"10000000", (String)"Sve", (String)TrgovinaController.this.tfFilter.getText().trim(), (boolean)TrgovinaController.this.doStock);
                    TrgovinaController.this.fillTable();
                    TrgovinaController.this.loadProductsNew(TrgovinaController.this.tfFilter.getText().trim());
                }
                if (ke.getCode().equals((java.lang.Object)KeyCode.ESCAPE) || ke.getCode().equals((java.lang.Object)KeyCode.F1)) {
                    TrgovinaController.this.tfFilter.setText("");
                    ke.consume();
                    TrgovinaController.this.toggleSearchTable();
                    TrgovinaController.this.gridPane.requestFocus();
                    TrgovinaController.this.summaryPane.refresh(TrgovinaController.this.controller);
                }
                if (ke.getCode().equals((java.lang.Object)KeyCode.UP)) {
                    TrgovinaController.this.selectUpperProduct();
                    TrgovinaController.this.tableProducts.requestFocus();
                }
                if (ke.getCode().equals((java.lang.Object)KeyCode.DOWN)) {
                    TrgovinaController.this.selectDownProduct();
                    TrgovinaController.this.tableProducts.requestFocus();
                }
                if (ke.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && TrgovinaController.this.tfFilter.getText().equals("")) {
                    TrgovinaController.this.tableProducts.setItems(null);
                    TrgovinaController.this.toggleSearchTable();
                    TrgovinaController.this.gridPane.requestFocus();
                }
            }
        });
        this.tfFilter.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    TrgovinaController.this.tfFilter.setText("");
                    if (TrgovinaController.this.infoText.getText().contains("*") || TrgovinaController.this.infoText.getText().contains("+")) {
                        TrgovinaController.this.infoText.setText(TrgovinaController.this.infoText.getText().substring(0, TrgovinaController.this.infoText.getText().indexOf("*") + 1));
                    } else {
                        TrgovinaController.this.infoText.setText("");
                    }
                }
                if (oldValue.booleanValue()) {
                    TrgovinaController.this.gridPane.removeEventHandler(KeyEvent.KEY_PRESSED, TrgovinaController.this.eventHandler);
                    TrgovinaController.this.gridPane.addEventHandler(KeyEvent.KEY_PRESSED, TrgovinaController.this.eventHandler);
                    TrgovinaController.this.btnPretraga.setVisible(true);
                    TrgovinaController.this.summaryPane.refresh(TrgovinaController.this.controller);
                }
            }
        });
        this.infoText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TrgovinaController.this.tfFilter.setText("");
                TrgovinaController.this.tableProducts.getSelectionModel().clearSelection();
            }
        });
        this.infoText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    TrgovinaController.this.gridPane.requestFocus();
                }
            }
        });
        this.tableProducts.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Product>(){

            public void onChanged(ListChangeListener.Change<? extends Product> c) {
                TrgovinaController.this.tableProducts.getSelectionModel().getSelectedItem();
            }
        });
        this.tableProducts.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.tableDoubleClick = true;
                    this.productItemClicked();
                    this.btnPretraga.setVisible(true);
                    this.tfFilter.setText("");
                    event.consume();
                    this.toggleSearchTable();
                    this.gridPane.removeEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
                    this.gridPane.addEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
                    this.gridPane.requestFocus();
                }
            });
            return row;
        });
        this.tableProducts.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.ENTER)) {
                    TrgovinaController.this.codeClicked = true;
                    TrgovinaController.this.productItemClicked();
                    TrgovinaController.this.tfFilter.setText("");
                    TrgovinaController.this.toggleSearchTable();
                    event.consume();
                    TrgovinaController.this.gridPane.removeEventHandler(KeyEvent.KEY_PRESSED, TrgovinaController.this.eventHandler);
                    TrgovinaController.this.gridPane.addEventHandler(KeyEvent.KEY_PRESSED, TrgovinaController.this.eventHandler);
                    TrgovinaController.this.gridPane.requestFocus();
                }
                if (event.getCode().equals((java.lang.Object)KeyCode.ESCAPE)) {
                    event.consume();
                    TrgovinaController.this.tableProducts.getSelectionModel().clearSelection();
                    TrgovinaController.this.gridPane.removeEventHandler(KeyEvent.KEY_PRESSED, TrgovinaController.this.eventHandler);
                    TrgovinaController.this.gridPane.addEventHandler(KeyEvent.KEY_PRESSED, TrgovinaController.this.eventHandler);
                    TrgovinaController.this.gridPane.requestFocus();
                }
                if (event.getCode().equals((java.lang.Object)KeyCode.LEFT)) {
                    event.consume();
                    TrgovinaController.this.tableProducts.getSelectionModel().clearSelection();
                    TrgovinaController.this.summaryPane.setSelectedItemIndex(0);
                    TrgovinaController.this.summaryPane.setSelectedItemSelected();
                    TrgovinaController.this.gridPane.requestFocus();
                }
            }
        });
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            String css = "";
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)("rs/petcom/trgovina/css/trgovina" + css + ".css"));
            if (css.equals("")) {
                this.ivLogo.setImage(new Image(Main.class.getResource("/rs/petcom/master/img/T_Master_Logotipi.png").toExternalForm()));
            } else {
                this.ivLogo.setImage(new Image(Main.class.getResource("/rs/petcom/master/img/T_Master_Logotipi crni.png").toExternalForm()));
            }
        }
        this.doStock = !this.controller.getSettings().isSellWithoutStock() || this.controller.getSettings().isKolStanje();
        this.btnReservation.setVisible(Boolean.parseBoolean(this.controller.getSettings().getActualByName("rezervacija.front.vidljivo.dugme")));
        this.btnScales.setVisible(Boolean.parseBoolean(this.controller.getSettings().getActualByName("scale.button.is.visible")));
        this.controller.getSettings().setSellWithoutStock(Boolean.parseBoolean(this.controller.getSettings().getSetting("sell.without.stock", null)));
        if (this.controller.getSettings().isKolStanje() && this.controller.isStockRefresh()) {
            this.stockList = Product.getNewProductStockList((ScreensController)this.controller);
            this.controller.setStockRefresh(false);
        }
        this.infoText.requestFocus();
        this.gridPaneTableSearch.setVisible(false);
        this.gridPaneKeyboard.setVisible(true);
        this.borderPaneKeyboard.setVisible(false);
        if (!QuickGroup.getList((ScreensController)this.controller).isEmpty()) {
            this.quickButton0.setVisible(true);
            this.quickButton7.setVisible(true);
            this.quickButton14.setVisible(true);
        }
        this.tfFilter.setVisible(false);
        this.setNumericVisibility(this.controller.getSettings().isNumerikUkljucen());
        GridPane.setRowSpan((Node)this.billSummaryPane, (Integer)(this.controller.getSettings().isNumerikUkljucen() ? 6 : 9));
        this.billSummaryPane.setVisible(true);
        this.infoText.setVisible(true);
        this.vrednostBodova = 0.0;
        if (this.controller.getBillList().isEmpty()) {
            this.post.setDisable(true);
            this.btnPopust.setDisable(true);
        }
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setGroupingUsed(true);
        this.checkIfWorkDayTooLong();
        this.checkIfBillPrinted();
        if (this.controller.getSettings().isAutomatskoZatvaranjeDana()) {
            this.closeWorkDayAutomaticly();
        }
        this.summaryPane.setAdditionalColNames(AditionalField.getFrontBack((boolean)true, (Connection)this.controller.getSettings().getConnection()));
        if (this.controller.getSettings().isFullscreen()) {
            this.rootPane.setPrefWidth(Screen.getPrimary().getBounds().getWidth());
            this.rootPane.setPrefHeight(Screen.getPrimary().getBounds().getHeight());
        }
        if (this.controller.getUser().hasRole("loyalty")) {
            this.loyalityButton.setVisible(true);
        } else {
            this.loyalityButton.setVisible(false);
        }
        if (this.controller.getUser().hasRole("discount")) {
            this.btnPopust.setVisible(true);
        } else {
            this.btnPopust.setVisible(false);
        }
        if (!this.controller.getUser().hasRole("sell.without.stock") && !this.controller.getSettings().isSellWithoutStock()) {
            this.colStock.setVisible(this.controller.getSettings().isKolStanje());
        }
        for (int i = 0; i < this.additionalButtonList.size(); ++i) {
            this.additionalButtonList.get(i).setWrapText(true);
        }
        if (this.controller.getUser().hasRole("vise.racuna")) {
            this.billButton.setVisible(true);
        }
        Bill bill = new Bill(this.controller.getUser());
        Round round = new Round();
        bill.getRoundList().add(round);
        if (this.controller.getBillList().isEmpty()) {
            this.controller.getBillList().add(bill);
        }
        this.controller.setActiveBill(this.itemId);
        try {
            this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
        }
        catch (IndexOutOfBoundsException e) {
            this.controller.setActiveBill(this.controller.getActiveBill() - 1);
            this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
            if (this.controller.getBillList().size() <= 1) {
                this.hBoxNewBill.getChildren().clear();
                this.controller.setActiveBill(0);
            }
            this.hBoxNewBill.getChildren().remove(this.billId - 1);
        }
        this.summaryPane.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                TrgovinaController.this.summaryPane.setPaneWidth(TrgovinaController.this.summaryPane.getWidth());
            }
        });
        this.billSummaryPane.setCenter((Node)this.summaryPane);
        this.setKeyboardBtnUnfocused();
        this.userLabel.setText(this.controller.getUser().getUserName());
        this.userLabel.setStyle("-fx-background-color: #21252e;-fx-text-fill:white;");
        if (this.controller.getSettings().isTrainingMode()) {
            this.userLabel.setText(this.controller.getUser().getUserName() + "- OBUKA");
            this.userLabel.setStyle("-fx-background-color: #FFBF00;-fx-text-fill:black;-fx-font-weight: bold; -fx-margin: 10 10 10 10;");
        }
        this.lokacijaLabel.setText(this.controller.getPointOfSale().getName());
        this.clockLabel.setText(this.formatClock.format(new Date()));
        this.populateLableGuest();
        this.infoText.setText(String.format("%d", this.controller.getSettings().getDefaultQuantity()));
        this.infoText.setText("");
        this.adminButton.setVisible(this.controller.getUser().hasRole("posadmin"));
        this.loyalityButton.setDisable(false);
        if (!this.controller.isProductsAlreadyLoaded()) {
            this.populateTable();
            this.controller.setProductsAlreadyLoaded(true);
        }
        this.gridPane.removeEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
        this.gridPane.addEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
        BillSummaryPaneTrgovina.getBss().getlBillDiscountValue();
        if (this.KWSActive && !isSAPUpdateAlreadyMade) {
            LOGGER.info("Azuriraj artikle i cene SAP");
            try {
                this.azurirajArtikleICeneSAP();
            }
            catch (Exception e) {
                LOGGER.info("Neuspelo azuriranje artikala i cena! Greska!");
            }
            isSAPUpdateAlreadyMade = true;
        }
    }

    private boolean checkIfWeightCode(String text) {
        this.weightCode = false;
        if (!(text.length() != 13 || text.contains("*") || text.contains(new DecimalFormatSymbols().getDecimalSeparator() + "") && Integer.parseInt(text.substring(text.length() - 1, text.length())) == 2 || Integer.parseInt(text.substring(0, 2)) != this.controller.getSettings().getTezinskiBarKod())) {
            this.weight = Double.parseDouble(text.substring(7, text.length() - 1)) / 1000.0;
            this.weightCode = true;
        }
        return this.weightCode;
    }

    public boolean numAndMyltiplyClicked(String text) {
        if (text.contains("*")) {
            return this.checkIfNumber(text.substring(0, text.length() - 1));
        }
        return false;
    }

    public boolean codeClicked(String text) {
        if (text.contains("*")) {
            return false;
        }
        return this.checkIfInteger(text);
    }

    private void populateTable() {
        if (this.tableProducts.getItems() != null) {
            this.tableProducts.setItems(null);
        }
        this.tableProducts.getColumns().clear();
        this.colCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.colCode.setVisible(true);
        this.colPLUcode.setCellValueFactory((Callback)new PropertyValueFactory("plucode"));
        this.colPLUcode.setVisible(this.controller.getSettings().isKolPlukod());
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tableProducts.getColumns().addAll((java.lang.Object[])new TableColumn[]{this.colCode, this.colPLUcode, this.colName});
        for (final AditionalField af : AditionalField.getFrontBack((boolean)true, (Connection)this.controller.getSettings().getConnection())) {
            TableColumn afColumn = new TableColumn(af.getName());
            afColumn.setResizable(true);
            afColumn.setMaxWidth(400.0);
            afColumn.setMinWidth(Double.NEGATIVE_INFINITY);
            afColumn.setPrefWidth(-1.0);
            afColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Product, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<Product, String> param) {
                    if (((Product)param.getValue()).getListAditionalFieldDetailsProduct() != null) {
                        for (AditionalFieldDetailsProduct afdp : ((Product)param.getValue()).getListAditionalFieldDetailsProduct()) {
                            if (afdp.getAditionalFieldID() != af.getAditionalFieldID()) continue;
                            return new SimpleStringProperty(afdp.getAditionalFieldDetails().getName());
                        }
                    }
                    return null;
                }
            });
            afColumn.setCellFactory(tc -> {
                TableCell cell = new TableCell();
                Text textColumn = new Text();
                cell.setGraphic((Node)textColumn);
                cell.setPrefHeight(-1.0);
                textColumn.wrappingWidthProperty().bind((ObservableValue)afColumn.widthProperty());
                textColumn.textProperty().bind((ObservableValue)cell.itemProperty());
                textColumn.setStyle("-fx-text-fill: #7CB72A;\r\n    -fx-font-size: 15.0px;\r\n    -fx-fill: #7CB72A;\r\n    -fx-text-wrap: true;\r\n    -fx-text-alignment:center;");
                return cell;
            });
            afColumn.setStyle("-fx-alignment: CENTER-LEFT;");
            this.tableProducts.getColumns().add((java.lang.Object)afColumn);
        }
        this.colBarcode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.colBarcode.setStyle("-fx-alignment: CENTER;");
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colPrice.getStyleClass().add((java.lang.Object)"priceStyle");
        this.colPrice.setStyle("-fx-alignment: CENTER-RIGHT;");
        this.colPrice.setMaxWidth(120.0);
        this.colPrice.setMinWidth(60.0);
        this.colPrice.setPrefWidth(60.0);
        this.colPrice.setCellFactory((Callback)new Callback<TableColumn<Product, Double>, TableCell<Product, Double>>(){

            public TableCell<Product, Double> call(TableColumn<Product, Double> param) {
                return new TableCell<Product, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((java.lang.Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                        }
                    }
                };
            }
        });
        if (this.controller.getSettings().isKolStanje()) {
            this.colStock.setCellValueFactory((Callback)new PropertyValueFactory("Stock"));
            this.colStock.setStyle("-fx-alignment: CENTER-RIGHT;");
            this.colStock.setCellFactory((Callback)new Callback<TableColumn<Product, Double>, TableCell<Product, Double>>(){

                public TableCell<Product, Double> call(TableColumn<Product, Double> param) {
                    return new TableCell<Product, Double>(){

                        protected void updateItem(Double item, boolean empty) {
                            super.updateItem((java.lang.Object)item, empty);
                            if (item == null) {
                                this.setText(null);
                            } else {
                                this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                            }
                        }
                    };
                }
            });
            this.tableProducts.getColumns().addAll((java.lang.Object[])new TableColumn[]{this.colStock, this.colBarcode, this.colPrice});
        } else {
            this.tableProducts.getColumns().addAll((java.lang.Object[])new TableColumn[]{this.colBarcode, this.colPrice});
        }
        if (!this.hBoxNewBill.getChildren().isEmpty() && this.controller.getBillList().size() != this.hBoxNewBill.getChildren().size()) {
            if (this.controller.getBillList().size() == 1) {
                this.hBoxNewBill.getChildren().clear();
            } else {
                this.hBoxNewBill.getChildren().remove(this.hBoxNewBill.getChildren().size() - 1);
            }
        }
    }

    private void loadProductsNew(String filter) {
        if (!this.tableProducts.getItems().isEmpty()) {
            FilteredList filteredData = new FilteredList(this.tableProducts.getItems(), p -> true);
            this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(product -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (product.getName() != null && product.getName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                if (product.getBarcode() != null && product.getBarcode().toLowerCase().startsWith(lowerCaseFilter)) {
                    return true;
                }
                if (product.getCode() != null && product.getCode().toLowerCase().startsWith(lowerCaseFilter)) {
                    return true;
                }
                if (product.getListAditionalFieldDetailsProduct() != null) {
                    for (AditionalFieldDetailsProduct aditionalFieldDetailsProduct : product.getListAditionalFieldDetailsProduct()) {
                        if (aditionalFieldDetailsProduct.getAditionalFieldDetails().getName() == null || !aditionalFieldDetailsProduct.getAditionalFieldDetails().getName().toLowerCase().contains(lowerCaseFilter)) continue;
                        return true;
                    }
                }
                return false;
            }));
            SortedList sortedData = new SortedList((ObservableList)filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.tableProducts.comparatorProperty());
            this.tableProducts.setItems((ObservableList)sortedData);
        }
    }

    @FXML
    private void logout() {
        this.controller.setReservationDocument(null);
        try {
            if (((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().size() == 0 || this.controller.getUser().hasRole("storno")) {
                Log.logOut((long)this.controller.getUser().getUserID(), (int)this.controller.getPointOfSale().getPointOfSaleID(), (Connection)this.controller.getSettings().getConnection());
                this.controller.setUser(null);
                this.controller.getBillList().clear();
                this.hBoxNewBill.getChildren().clear();
                this.itemId = 0;
                ((RowConstraints)this.gridPane.getRowConstraints().get(2)).setMinHeight(10.0);
                ((RowConstraints)this.gridPane.getRowConstraints().get(7)).setMinHeight(60.0);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                int standardWidth = 1920;
                int standardHeight = 1080;
                Dimension screenSize = toolkit.getScreenSize();
                double screenWidth = screenSize.getWidth();
                double screenHeight = screenSize.getHeight();
                double widthPercentage = screenWidth / (double)standardWidth * 100.0;
                double heightPercentage = screenHeight / (double)standardHeight * 100.0;
                System.out.println("\u0160irina ekrana je " + widthPercentage + "% standardne rezolucije.");
                System.out.println("Visina ekrana je " + heightPercentage + "% standardne rezolucije.");
                int dpi = toolkit.getScreenResolution();
                System.out.println("DPI (ta\u010daka po in\u010du): " + dpi);
                double scale = (double)dpi / 96.0;
                System.out.println("Faktor skaliranja: " + scale + screenSize.getHeight());
                if (screenSize.getHeight() > 900.0 && scale == 1.0) {
                    this.controller.getScreen(ScreensController.SCREEN_LOGIN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_BACKOFFICE);
                } else {
                    this.controller.getScreen(ScreensController.SCREEN_LOGIN_TRGOVINA1, this.controller.getRoot(), ScreensController.SCREEN_BACKOFFICE);
                }
                return;
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void toggleSearchTable() {
        this.tableProducts.setItems(null);
        this.gridPaneTableSearch.setVisible(!this.gridPaneTableSearch.isVisible());
        this.billSummaryPane.setVisible(!this.billSummaryPane.isVisible());
        if (!this.controller.getSettings().isNumerikUkljucen()) {
            this.borderPaneKeyboard.setVisible(false);
        } else {
            this.borderPaneKeyboard.setVisible(!this.borderPaneKeyboard.isVisible());
        }
        this.quickButtonPane.setVisible(!this.quickButtonPane.isVisible());
        this.btnDetaljnaPretraga.setVisible(!this.btnDetaljnaPretraga.isVisible());
        this.tfFilter.setVisible(!this.tfFilter.isVisible());
        this.infoText.setVisible(!this.infoText.isVisible());
        this.tfFilter.setText("");
        this.tfFilter.requestFocus();
        if (this.gridPaneTableSearch.isVisible()) {
            this.gridPane.removeEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
            this.post.setDisable(true);
            this.btnPopust.setDisable(true);
        } else if (((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().isEmpty()) {
            this.post.setDisable(true);
            this.btnPopust.setDisable(true);
        } else {
            this.post.setDisable(false);
            this.btnPopust.setDisable(false);
        }
        if (!this.gridPaneTableSearch.isVisible()) {
            this.gridPane.requestFocus();
            this.tableProducts.getSelectionModel().clearSelection();
        }
        if (this.controller.getSettings().isNumerikUkljucen()) {
            GridPane.setRowSpan((Node)this.gridPaneTableSearch, (Integer)6);
            GridPane.setRowSpan((Node)this.billSummaryPane, (Integer)6);
        } else {
            GridPane.setRowSpan((Node)this.gridPaneTableSearch, (Integer)8);
            GridPane.setRowSpan((Node)this.billSummaryPane, (Integer)9);
            this.setNumericVisibility(false);
        }
    }

    @FXML
    private void toggleNumeric() {
        this.setNumericVisibility(!this.numpad0.isVisible());
        GridPane.setRowSpan((Node)this.billSummaryPane, (Integer)(this.numpad0.isVisible() ? 6 : 9));
        if (this.gridPaneTableSearch.isVisible()) {
            this.gridPaneTableSearch.setVisible(false);
            this.borderPaneKeyboard.setVisible(false);
            this.tfFilter.setVisible(false);
            this.infoText.setVisible(true);
            this.billSummaryPane.setVisible(true);
            this.gridPane.requestFocus();
        }
    }

    private void setNumericVisibility(boolean isVisible) {
        this.numpad0.setVisible(isVisible);
        this.numpad1.setVisible(isVisible);
        this.numpad2.setVisible(isVisible);
        this.numpad3.setVisible(isVisible);
        this.numpad4.setVisible(isVisible);
        this.numpad5.setVisible(isVisible);
        this.numpad6.setVisible(isVisible);
        this.numpad7.setVisible(isVisible);
        this.numpad8.setVisible(isVisible);
        this.numpad9.setVisible(isVisible);
        this.numpadDel.setVisible(isVisible);
        this.numpadEnter.setVisible(isVisible);
        this.numpadDecimal.setVisible(isVisible);
        this.numpadMultiply.setVisible(isVisible);
    }

    private void fillArticalButton(QuickGroupButton button, QuickGroup quickGroup) {
        button.setVisible(true);
        button.setQuickGroup(quickGroup);
        button.setText(quickGroup.getName());
        if (quickGroup.getProduct() == null) {
            button.getStyleClass().add((java.lang.Object)"quickButtonGroup");
        } else {
            button.getStyleClass().removeIf(style -> style.equals("quickButtonGroup"));
        }
    }

    private void prikaziGrupe(ObservableList<QuickGroup> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.popuniDugmeGrupe(i, (QuickGroup)list.get(i));
        }
    }

    private void prikaziGrupeArtikala(ObservableList<QuickGroup> list) {
        this.disableQuickButton();
        for (int i = 0; i < list.size(); ++i) {
            this.popuniDugmeGrupe(i, (QuickGroup)list.get(i));
        }
    }

    @FXML
    private void actionBackToGroup(ActionEvent event) {
        this.disableQuickButton();
        this.quickGrroupList.clear();
        this.listaListi = ListUtils.partition((List)QuickGroup.getList((ScreensController)this.controller), (int)18);
        this.brojStrana = 0;
        this.quickGrroupList.addAll((Collection)this.listaListi.get(this.brojStrana));
        try {
            if (((QuickGroupButton)event.getSource()).getQuickGroup().getParentId() == 0L || (QuickGroupButton)event.getSource() == null) {
                this.prikaziGrupe(this.quickGrroupList);
            } else {
                this.prikaziGrupeArtikala(this.quickGrroupList);
            }
        }
        catch (ClassCastException e) {
            this.prikaziGrupe(this.quickGrroupList);
        }
    }

    @FXML
    public void addNewBill() {
        boolean praznaLista = false;
        for (Bill bill : this.controller.getBillList()) {
            if (!((Round)bill.getRoundList().get(0)).getItemList().isEmpty()) {
                praznaLista = true;
                ((RowConstraints)this.gridPane.getRowConstraints().get(2)).setMinHeight(40.0);
                ((RowConstraints)this.gridPane.getRowConstraints().get(7)).setMinHeight(25.0);
                continue;
            }
            praznaLista = false;
            ((RowConstraints)this.gridPane.getRowConstraints().get(2)).setMinHeight(25.0);
            ((RowConstraints)this.gridPane.getRowConstraints().get(7)).setMinHeight(40.0);
        }
        if (praznaLista) {
            Round round;
            Button billButton;
            Bill bill;
            this.infoText.setText("");
            this.summaryPane.setSelectedItemIndex(-1);
            if (this.controller.getBillList().size() <= 1) {
                this.billId = 0;
                do {
                    if (this.billId == 0 && this.controller.getBillList().size() == 1) {
                        billButton = new Button();
                        billButton.setId(String.valueOf(this.billId++));
                        billButton.setText(String.valueOf(this.billId));
                        billButton.setPrefWidth(100.0);
                        billButton.setMaxHeight(this.hBoxNewBill.getPrefHeight());
                        billButton.getStyleClass().add((java.lang.Object)"billButton");
                        billButton.getStyleClass().add((java.lang.Object)"borderTopBottomLeftRight");
                        this.hBoxNewBill.getChildren().add((java.lang.Object)billButton);
                        continue;
                    }
                    billButton = new Button();
                    billButton.setId(String.valueOf(this.billId++));
                    billButton.setText(String.valueOf(this.billId));
                    billButton.setPrefWidth(100.0);
                    billButton.setMaxHeight(this.hBoxNewBill.getPrefHeight());
                    billButton.setFocusTraversable(true);
                    billButton.getStyleClass().add((java.lang.Object)"billButton");
                    billButton.getStyleClass().add((java.lang.Object)"borderTopBottomLeftRight");
                    this.hBoxNewBill.getChildren().add((java.lang.Object)billButton);
                    bill = new Bill(this.controller.getUser());
                    round = new Round();
                    bill.getRoundList().add(round);
                    this.controller.getBillList().add(bill);
                } while (this.billId <= 1);
            } else if (this.controller.getBillList().size() <= 5) {
                this.billId = this.hBoxNewBill.getChildren().size();
                billButton = new Button();
                billButton.setId(String.valueOf(this.billId++));
                billButton.setText(String.valueOf(this.billId));
                billButton.setPrefWidth(100.0);
                billButton.setMaxHeight(this.hBoxNewBill.getPrefHeight());
                billButton.getStyleClass().add((java.lang.Object)"billButton");
                billButton.getStyleClass().add((java.lang.Object)"borderTopBottomLeftRight");
                this.hBoxNewBill.getChildren().add((java.lang.Object)billButton);
                bill = new Bill(this.controller.getUser());
                round = new Round();
                bill.getRoundList().add(round);
                this.controller.getBillList().add(bill);
            }
            for (final Node button : this.hBoxNewBill.getChildren()) {
                if (!(button instanceof Button)) continue;
                ((Button)button).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        TrgovinaController.this.itemId = Integer.parseInt(button.getId());
                        TrgovinaController.this.controller.setActiveBill(TrgovinaController.this.itemId);
                        TrgovinaController.this.summaryPane.setBill((Bill)TrgovinaController.this.controller.getBillList().get(TrgovinaController.this.controller.getActiveBill()), TrgovinaController.this.controller);
                        TrgovinaController.this.populateLableGuest();
                    }
                });
            }
        }
    }

    @FXML
    private void nextAction(ActionEvent event) {
        block6: {
            if (this.quickGrroupList.size() >= 18) {
                try {
                    this.quickGrroupList.clear();
                    ++this.brojStrana;
                    this.quickGrroupList.addAll((Collection)this.listaListi.get(this.brojStrana));
                    this.disableQuickButton();
                    try {
                        if (((QuickGroupButton)event.getSource()).getQuickGroup().getParentId() == 0L || (QuickGroupButton)event.getSource() == null) {
                            this.prikaziGrupe(this.quickGrroupList);
                            break block6;
                        }
                        this.prikaziGrupeArtikala(this.quickGrroupList);
                    }
                    catch (ClassCastException e) {
                        this.prikaziGrupe(this.quickGrroupList);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @FXML
    private void backAction(ActionEvent event) {
        block6: {
            if (this.quickGrroupList.size() <= 18 && this.brojStrana > 0) {
                try {
                    this.quickGrroupList.clear();
                    --this.brojStrana;
                    this.quickGrroupList.addAll((Collection)this.listaListi.get(this.brojStrana));
                    this.disableQuickButton();
                    try {
                        if (((QuickGroupButton)event.getSource()).getQuickGroup().getParentId() == 0L || (QuickGroupButton)event.getSource() == null) {
                            this.prikaziGrupe(this.quickGrroupList);
                            break block6;
                        }
                        this.prikaziGrupeArtikala(this.quickGrroupList);
                    }
                    catch (ClassCastException e) {
                        this.prikaziGrupe(this.quickGrroupList);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void disableQuickButton() {
        for (QuickGroupButton quickGroupButton : this.quickGroupButtonList) {
            quickGroupButton.setVisible(false);
        }
        this.quickButton1.setVisible(false);
        this.quickButton2.setVisible(false);
        this.quickButton3.setVisible(false);
        this.quickButton4.setVisible(false);
        this.quickButton5.setVisible(false);
        this.quickButton6.setVisible(false);
        this.quickButton8.setVisible(false);
        this.quickButton9.setVisible(false);
        this.quickButton10.setVisible(false);
        this.quickButton11.setVisible(false);
        this.quickButton12.setVisible(false);
        this.quickButton13.setVisible(false);
        this.quickButton15.setVisible(false);
        this.quickButton16.setVisible(false);
        this.quickButton17.setVisible(false);
        this.quickButton18.setVisible(false);
        this.quickButton19.setVisible(false);
        this.quickButton20.setVisible(false);
    }

    @FXML
    private void quickButtonAction(ActionEvent event) {
        block8: {
            try {
                if (((QuickGroupButton)event.getSource()).getQuickGroup().getParentId() == 0L) {
                    this.listaListi = ListUtils.partition((List)QuickGroup.getProductList((ScreensController)this.controller, (long)((QuickGroupButton)event.getSource()).getQuickGroup().getQuickGroupId()), (int)18);
                    this.quickGrroupList.clear();
                    this.brojStrana = 0;
                    this.quickGrroupList.addAll((Collection)this.listaListi.get(this.brojStrana));
                    this.prikaziGrupeArtikala(this.quickGrroupList);
                    break block8;
                }
                if (((QuickGroupButton)event.getSource()).getQuickGroup().getProductId() != -1L) {
                    if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
                        this.insertProductItemIntoBill(1.0, ((QuickGroupButton)event.getSource()).getQuickGroup().getProduct());
                    } else {
                        try {
                            this.insertProductItemIntoBill(Double.parseDouble(this.infoText.getText().substring(0, this.infoText.getText().indexOf("*")).replace(",", ".")), ((QuickGroupButton)event.getSource()).getQuickGroup().getProduct());
                        }
                        catch (Exception e) {
                            this.insertProductItemIntoBill(1.0);
                        }
                    }
                }
                this.infoText.setText("");
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    private void popuniDugmeGrupe(int i, QuickGroup quickGroup) {
        switch (i) {
            case 0: {
                this.fillArticalButton(this.quickButton1, quickGroup);
                break;
            }
            case 1: {
                this.fillArticalButton(this.quickButton2, quickGroup);
                break;
            }
            case 2: {
                this.fillArticalButton(this.quickButton3, quickGroup);
                break;
            }
            case 3: {
                this.fillArticalButton(this.quickButton4, quickGroup);
                break;
            }
            case 4: {
                this.fillArticalButton(this.quickButton5, quickGroup);
                break;
            }
            case 5: {
                this.fillArticalButton(this.quickButton6, quickGroup);
                break;
            }
            case 6: {
                this.fillArticalButton(this.quickButton8, quickGroup);
                break;
            }
            case 7: {
                this.fillArticalButton(this.quickButton9, quickGroup);
                break;
            }
            case 8: {
                this.fillArticalButton(this.quickButton10, quickGroup);
                break;
            }
            case 9: {
                this.fillArticalButton(this.quickButton11, quickGroup);
                break;
            }
            case 10: {
                this.fillArticalButton(this.quickButton12, quickGroup);
                break;
            }
            case 11: {
                this.fillArticalButton(this.quickButton13, quickGroup);
                break;
            }
            case 12: {
                this.fillArticalButton(this.quickButton15, quickGroup);
                break;
            }
            case 13: {
                this.fillArticalButton(this.quickButton16, quickGroup);
                break;
            }
            case 14: {
                this.fillArticalButton(this.quickButton17, quickGroup);
                break;
            }
            case 15: {
                this.fillArticalButton(this.quickButton18, quickGroup);
                break;
            }
            case 16: {
                this.fillArticalButton(this.quickButton19, quickGroup);
                break;
            }
            case 17: {
                this.fillArticalButton(this.quickButton20, quickGroup);
            }
        }
    }

    private void keyboardNumClicked(KeyEvent e) {
        this.labelBillInfo.setVisible(false);
        this.labelBillInfo.setOpacity(0.0);
        System.out.println(e.getCode() + "  " + e.isShiftDown());
        if (e.getCode() == KeyCode.SHIFT && e.isShiftDown()) {
            return;
        }
        if (e.getCode() == KeyCode.MULTIPLY && this.numberClicked && !this.infoText.getText().contains("*") && !this.isLastCharacterDecimal(this.infoText.getText())) {
            this.infoText.setText(this.infoText.getText() + "*");
        }
        if (this.infoText.getText().contains("*")) {
            // empty if block
        }
        if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("barcode.front.slova"))) {
            if (e.getCode() == KeyCode.DIGIT3 && e.isShiftDown()) {
                this.infoText.setText(this.infoText.getText() + "#");
                return;
            }
            if (e.getCode() == KeyCode.DIGIT8 && e.isShiftDown()) {
                this.infoText.setText(this.infoText.getText() + "(");
                return;
            }
            if (e.getCode() == KeyCode.DIGIT9 && e.isShiftDown()) {
                this.infoText.setText(this.infoText.getText() + ")");
                return;
            }
            if (e.getCode().isDigitKey() || e.getCode().isLetterKey() || e.getCode() == KeyCode.SUBTRACT || e.getCode() == KeyCode.MINUS) {
                this.infoText.setText(this.infoText.getText() + e.getText().toUpperCase());
            }
        } else if (e.getCode().isDigitKey()) {
            this.infoText.setText(this.infoText.getText() + e.getText());
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        if (!(e.getCode() != KeyCode.DECIMAL || this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()) != null && this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()).equals("true"))) {
            if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
                this.infoText.setText("0" + dfs.getDecimalSeparator());
            } else if (!this.infoText.getText().contains(dfs.getDecimalSeparator() + "") && !this.infoText.getText().contains("*")) {
                this.infoText.setText(this.infoText.getText() + dfs.getDecimalSeparator());
            }
        }
        if (!(e.getCode() != KeyCode.PERIOD || this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()) != null && this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()).equals("true"))) {
            if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
                this.infoText.setText("0" + dfs.getDecimalSeparator());
            } else if (!this.infoText.getText().contains(dfs.getDecimalSeparator() + "") && !this.infoText.getText().contains("*")) {
                this.infoText.setText(this.infoText.getText() + dfs.getDecimalSeparator());
            }
        }
        if (!(e.getCode() != KeyCode.COMMA || this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()) != null && this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()).equals("true"))) {
            if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
                this.infoText.setText("0" + dfs.getDecimalSeparator());
            } else if (!this.infoText.getText().contains(dfs.getDecimalSeparator() + "") && !this.infoText.getText().contains("*")) {
                this.infoText.setText(this.infoText.getText() + dfs.getDecimalSeparator());
            }
        }
        if (!(e.getCode() != KeyCode.PLUS || this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()) != null && this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()).equals("true"))) {
            if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
                this.infoText.setText("0" + dfs.getDecimalSeparator());
            } else if (!this.infoText.getText().contains(dfs.getDecimalSeparator() + "")) {
                this.infoText.setText(this.infoText.getText() + dfs.getDecimalSeparator());
            }
        }
        if (!(!e.isShiftDown() || e.getCode() != KeyCode.DIGIT8 || this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()) != null && this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()).equals("true") || this.infoText.getText().equals("") && this.infoText.getText().equals("0") && this.infoText.getText().endsWith(String.valueOf(dfs.getDecimalSeparator())))) {
            if (!this.infoText.getText().contains("*")) {
                if (this.infoText.getText().equals("8")) {
                    this.infoText.setText("");
                } else {
                    this.infoText.setText(this.infoText.getText().substring(0, this.infoText.getText().length() - 1) + "*");
                }
            } else {
                this.infoText.setText(this.infoText.getText().substring(0, this.infoText.getText().length() - 1));
            }
        }
        if (e.getCode() == KeyCode.BACK_SPACE && !this.infoText.getText().equals("")) {
            this.infoText.setText(this.infoText.getText().substring(0, this.infoText.getText().length() - 1));
        }
    }

    @FXML
    private void numButtonCliclk(ActionEvent event) {
        this.labelBillInfo.setVisible(false);
        this.labelBillInfo.setOpacity(0.0);
        if ((Button)event.getSource() == this.numpad0) {
            this.infoText.setText(this.infoText.getText() + "0");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad1) {
            this.infoText.setText(this.infoText.getText() + "1");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad2) {
            this.infoText.setText(this.infoText.getText() + "2");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad3) {
            this.infoText.setText(this.infoText.getText() + "3");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad4) {
            this.infoText.setText(this.infoText.getText() + "4");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad5) {
            this.infoText.setText(this.infoText.getText() + "5");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad6) {
            this.infoText.setText(this.infoText.getText() + "6");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad7) {
            this.infoText.setText(this.infoText.getText() + "7");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad8) {
            this.infoText.setText(this.infoText.getText() + "8");
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpad9) {
            this.infoText.setText(this.infoText.getText() + "9");
            this.gridPane.requestFocus();
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        if (!((Button)event.getSource() != this.numpadDecimal || this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()) != null && this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()).equals("true"))) {
            if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
                this.infoText.setText("0" + dfs.getDecimalSeparator());
            } else if (!this.infoText.getText().contains(dfs.getDecimalSeparator() + "")) {
                this.infoText.setText(this.infoText.getText() + dfs.getDecimalSeparator());
            }
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpadDel) {
            if (!this.infoText.getText().equals("")) {
                this.infoText.setText(this.infoText.getText().substring(0, this.infoText.getText().length() - 1));
            }
            this.gridPane.requestFocus();
        }
        if ((Button)event.getSource() == this.numpadEnter) {
            if (this.summaryPane.getSelectedItemIndex() != -1) {
                if (this.checkIfNumber(this.infoText.getText())) {
                    // empty if block
                }
                if (this.infoText.getText().contains("*")) {
                    this.summaryPane.setSelectedItemIndex(-1);
                    this.summaryPane.refresh(this.controller);
                }
            } else {
                if (this.infoText.getText().contains("*")) {
                    this.summaryPane.unselectAll();
                    this.codeClicked = false;
                    this.textBeforeMultiply = this.infoText.getText().substring(0, this.infoText.getText().indexOf("*"));
                    if (this.textBeforeMultiply.equals("0")) {
                        this.infoText.setText("");
                    }
                    this.textAfterMultiply = this.infoText.getText().substring(this.infoText.getText().indexOf("*") + 1, this.infoText.getText().length());
                    if (this.checkIfNumber(this.textBeforeMultiply)) {
                        this.numberClicked = true;
                        this.numAndMultiplyClicked = true;
                    } else {
                        this.numberClicked = false;
                        this.numAndMultiplyClicked = false;
                    }
                    if (!this.checkIfNumber(this.textAfterMultiply) || this.textAfterMultiply.equals("")) {
                        this.tableProducts.getSelectionModel().clearSelection();
                    }
                } else {
                    this.numAndMultiplyClicked = false;
                    if (this.checkIfNumber(this.infoText.getText())) {
                        if (this.checkIfInteger(this.infoText.getText())) {
                            this.codeClicked = true;
                        }
                        this.numberClicked = true;
                    } else {
                        this.numberClicked = false;
                    }
                }
                if ((this.numAndMultiplyClicked || this.codeClicked) && (!this.textAfterMultiply.equals("") || this.codeClicked)) {
                    if (!this.textAfterMultiply.equals("")) {
                        this.turnOnFilter(this.textAfterMultiply);
                    } else {
                        this.turnOnFilter(this.infoText.getText());
                    }
                }
                if (this.isEmptyinfoText()) {
                    this.tableProducts.getSelectionModel().clearSelection();
                }
            }
            try {
                if (this.summaryPane.getSelectedItemIndex() != -1 && !this.isEmptyinfoText()) {
                    this.editQuantityProductItemIntoBill();
                    this.gridPane.requestFocus();
                } else if (this.checkIfWeightCode(this.infoText.getText())) {
                    if (this.btnPretraga.isVisible()) {
                        this.textFofFiltering = this.infoText.getText().substring(2, 7);
                        this.insertProductItemIntoBill(this.weight);
                        this.infoText.setText("");
                    }
                } else if (this.tableProducts.getSelectionModel().getSelectedItem() != null) {
                    this.codeClicked = true;
                    this.productItemClicked();
                    this.gridPane.requestFocus();
                } else if (this.numAndMultiplyClicked || this.codeClicked) {
                    this.productItemClicked();
                    this.gridPane.requestFocus();
                } else if (!this.isEmptyinfoText() || this.tableProducts.getSelectionModel().getSelectedItem() != null || this.summaryPane.getSelectedItemIndex() == -1) {
                    // empty if block
                }
                event.consume();
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        if ((Button)event.getSource() == this.numpadMultiply && this.checkIfNumber(this.infoText.getText()) && !this.isEmptyinfoText() && !this.infoText.getText().contains("*") && !this.isLastCharacterDecimal(this.infoText.getText())) {
            this.infoText.setText(this.infoText.getText() + "*");
        }
        this.summaryPane.refresh(this.controller);
    }

    public boolean isLastCharacterDecimal(String text) {
        return text.substring(text.length() - 1).equals(new DecimalFormatSymbols().getDecimalSeparator() + "");
    }

    private void selectUpperProduct() {
        int selectedIndex = this.tableProducts.getSelectionModel().getSelectedIndex();
        if (selectedIndex != -1) {
            this.tableProducts.getSelectionModel().select(selectedIndex - 1);
        } else {
            this.tableProducts.getSelectionModel().selectFirst();
        }
    }

    private void selectDownProduct() {
        int selectedIndex = this.tableProducts.getSelectionModel().getSelectedIndex();
        if (selectedIndex != -1) {
            this.tableProducts.getSelectionModel().select(selectedIndex + 1);
        } else {
            this.tableProducts.getSelectionModel().selectFirst();
        }
    }

    private void turnOnFilter(String infoTextFilter) {
        this.textFofFiltering = infoTextFilter;
    }

    private boolean checkIfNumber(String number) {
        try {
            this.numberFormat.parse(this.infoText.getText()).doubleValue();
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private boolean checkIfInteger(String number) {
        try {
            Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @FXML
    public void productItemClicked() {
        if (!this.infoText.getText().equals("0") && !this.infoText.getText().equals("")) {
            if (this.codeClicked) {
                if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
                    this.insertProductItemIntoBill(1.0);
                } else {
                    try {
                        this.insertProductItemIntoBill(Double.parseDouble(this.infoText.getText().substring(0, this.infoText.getText().indexOf("*")).replace(",", ".")));
                    }
                    catch (Exception e) {
                        this.insertProductItemIntoBill(1.0);
                    }
                }
            } else if (this.numAndMultiplyClicked) {
                try {
                    this.insertProductItemIntoBill(this.numberFormat.parse(this.infoText.getText()).doubleValue());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (this.tableDoubleClick && !this.codeClicked) {
                try {
                    this.insertProductItemIntoBill(Double.parseDouble(this.infoText.getText().substring(0, this.infoText.getText().indexOf("*")).replace(",", ".")));
                }
                catch (Exception e) {
                    this.insertProductItemIntoBill(1.0);
                }
            }
        } else if (this.infoText.getText().equals("") || this.infoText.getText().equals("0")) {
            if (this.codeClicked) {
                try {
                    this.insertProductItemIntoBill(this.weightCode ? this.weight : 1.0);
                }
                catch (NullPointerException e) {
                    this.infoText.setText("");
                    e.printStackTrace();
                }
            } else if (this.tableDoubleClick) {
                this.insertProductItemIntoBill(1.0);
            }
        } else if (this.tableDoubleClick && (this.infoText.getText().equals("") || this.infoText.getText().equals("0"))) {
            this.insertProductItemIntoBill(1.0);
        } else if (this.tableProducts.getSelectionModel().getSelectedItem() != null) {
            try {
                this.insertProductItemIntoBill(Double.parseDouble(this.infoText.getText().substring(0, this.infoText.getText().indexOf("*"))));
            }
            catch (Exception e) {
                this.insertProductItemIntoBill(1.0);
            }
        }
        this.infoText.setText("");
        this.tableDoubleClick = false;
        this.tfFilter.setText("");
        this.numAndMultiplyClicked = false;
        this.numberClicked = false;
        this.tableProducts.getSelectionModel().clearSelection();
        this.btnPretraga.setVisible(true);
        this.codeClicked = false;
        this.gridPane.requestFocus();
        this.tableProducts.setItems(null);
    }

    private void editQuantityProductItemIntoBill() {
        Round round = (Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0);
        boolean editProductQuantityApproved = false;
        double selectedProductStock = 0.0;
        if (!this.controller.getSettings().isSellWithoutStock() || this.controller.getSettings().isKolStanje()) {
            selectedProductStock = ((RoundItem)round.getItemList().get(this.summaryPane.getSelectedItemIndex())).getProductDepartment().getProduct().getStock();
        }
        try {
            if (selectedProductStock >= this.numberFormat.parse(this.infoText.getText()).doubleValue() + round.getSumQuantity(((RoundItem)round.getItemList().get(this.summaryPane.getSelectedItemIndex())).getProductDepartment().getProduct().getProductID()) - ((RoundItem)round.getItemList().get(this.summaryPane.getSelectedItemIndex())).getQuantity() || this.controller.getUser().hasRole("sell.without.stock")) {
                editProductQuantityApproved = true;
            }
            if (editProductQuantityApproved) {
                ((RoundItem)round.getItemList().get(this.summaryPane.getSelectedItemIndex())).setQuantity(this.numberFormat.parse(this.infoText.getText()).doubleValue());
            } else {
                this.controller.alert("Upozorenje", "Nemate ovla\u0161\u0107enje za korekciju koli\u010dine koja ne postoji na lageru.", this.rootPane.getScene().getWindow());
            }
            if ("true".equals(this.controller.getSettings().getLCD())) {
                CustomerDispaly customerDispaly = new CustomerDispaly();
                customerDispaly.setName(((RoundItem)round.getItemList().get(this.summaryPane.getSelectedItemIndex())).getQuantity() + " X " + ((RoundItem)round.getItemList().get(this.summaryPane.getSelectedItemIndex())).getProductDepartment().getProduct().getShortName());
                customerDispaly.setUnitPrice(String.valueOf(((RoundItem)round.getItemList().get(this.summaryPane.getSelectedItemIndex())).getRegularPrice()));
                customerDispaly.setPrice(String.valueOf(((RoundItem)round.getItemList().get(this.summaryPane.getSelectedItemIndex())).getSumWithDiscount()));
                CustomerDispaly.call((CustomerDispaly)customerDispaly);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (FinancialDiscount financialDiscount : FinancialDiscount.getFinancialDiscountsList((ScreensController)this.controller)) {
            if (!financialDiscount.isActive()) continue;
            if (((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout() >= financialDiscount.getValue()) {
                for (RoundItem roundItem : ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList()) {
                    roundItem.getProductDepartment().getProduct().setDiscount(financialDiscount.getDiscount());
                }
                continue;
            }
            for (RoundItem roundItem : ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList()) {
                roundItem.getProductDepartment().getProduct().setDiscount(0.0);
            }
        }
        this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
        this.summaryPane.setSelectedItemIndex(-1);
        this.summaryPane.unselectAll();
        this.summaryPane.refresh(this.controller);
        this.infoText.setText("");
    }

    private void insertProductItemIntoBill(Double quantity) {
        ProductDepartment selectedTableProductDepartment = null;
        Product selectedProduct = null;
        try {
            if (this.tableProducts.getSelectionModel().getSelectedItem() != null) {
                selectedProduct = (Product)this.tableProducts.getSelectionModel().getSelectedItem();
                selectedTableProductDepartment = ProductDepartment.get((long)selectedProduct.getProductDepartmentID(), (ScreensController)this.controller);
                selectedTableProductDepartment.setProduct(selectedProduct);
            } else if (this.textFofFiltering != null && !this.textFofFiltering.isEmpty() && !this.textFofFiltering.equals("")) {
                if (this.KWSActive) {
                    LOGGER.info("\u010ditam QRCode");
                    QRCodeReaderKWS kwsReader = new QRCodeReaderKWS();
                    String[] codeAndSeria = kwsReader.splitToCodeAndSeria(this.textFofFiltering);
                    String code = codeAndSeria[0];
                    String seria = codeAndSeria.length > 1 ? codeAndSeria[1] : "";
                    selectedProduct = (Product)Product.getNewTrgovinaList((ScreensController)this.controller, (String)"1", (String)"\u0160ifra", (String)code, (boolean)this.doStock).get(0);
                    selectedProduct.setName(selectedProduct.getName() + ":" + seria);
                    this.description = seria != null && !seria.isEmpty() ? new Description(seria, this.controller) : null;
                    LOGGER.info("Kod i Serija:" + code + seria);
                } else {
                    selectedProduct = (Product)Product.getNewTrgovinaList((ScreensController)this.controller, (String)"1", (String)"\u0160ifra", (String)this.textFofFiltering, (boolean)this.doStock).get(0);
                }
                selectedTableProductDepartment = ProductDepartment.get((long)selectedProduct.getProductDepartmentID(), (ScreensController)this.controller);
                selectedTableProductDepartment.setProduct(selectedProduct);
            }
        }
        catch (IndexOutOfBoundsException ee) {
            this.controller.alert("Obave\u0161tenje", "Artikal nije prona\u0111en", this.rootPane.getScene().getWindow());
            this.summaryPane.uncolorAll();
            return;
        }
        if (selectedTableProductDepartment != null) {
            double selectedProductStock = 0.0;
            boolean sellItemApproved = false;
            if (!this.controller.getSettings().isSellWithoutStock() || this.controller.getSettings().isKolStanje()) {
                selectedProductStock = selectedProduct.getStock() - selectedProduct.getStockReservation();
            } else {
                sellItemApproved = true;
            }
            boolean alreadyExist = false;
            int indexAlreadyExistedProductDepartment = 0;
            double quantityAlreadyExisted = 0.0;
            ArrayList roundItemList = ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList();
            for (int i = 0; i < roundItemList.size(); ++i) {
                if (selectedTableProductDepartment.getProduct().getProductID() != ((RoundItem)roundItemList.get(i)).getProductDepartment().getProductID()) continue;
                if (((RoundItem)roundItemList.get(i)).getOfferPriceDetails() != null) {
                    if ((quantity + ((RoundItem)roundItemList.get(i)).getQuantity()) % ((RoundItem)roundItemList.get(i)).getOfferPriceDetails().getQuantity() == 0.0) {
                        alreadyExist = true;
                        indexAlreadyExistedProductDepartment = i;
                        quantityAlreadyExisted += ((RoundItem)roundItemList.get(i)).getQuantity();
                        continue;
                    }
                    alreadyExist = false;
                    continue;
                }
                alreadyExist = true;
                indexAlreadyExistedProductDepartment = i;
                quantityAlreadyExisted += ((RoundItem)roundItemList.get(i)).getQuantity();
            }
            if (selectedProductStock >= quantity + quantityAlreadyExisted || selectedProduct.getProductCategoryID() == 2 || this.controller.getUser().hasRole("sell.without.stock")) {
                sellItemApproved = true;
            }
            if (sellItemApproved) {
                if (!selectedTableProductDepartment.getProduct().isMeasurable() && this.infoText.getText().contains(new DecimalFormatSymbols().getDecimalSeparator() + "")) {
                    Settings.startInfoAnimation((String)"Artikal nije merljiv", (Label)this.labelBillInfo, (int)7, (int)18);
                    this.summaryPane.uncolorAll();
                    this.infoText.setText("");
                    return;
                }
                if (alreadyExist && this.controller.getSettings().isSabiranjeArtikala()) {
                    ((RoundItem)((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().get(indexAlreadyExistedProductDepartment)).setQuantity(quantity + quantityAlreadyExisted);
                    this.controller.getCurrentBill().recalculateOfferPrices(this.controller);
                    this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
                    this.summaryPane.setColoredByIndex(indexAlreadyExistedProductDepartment);
                } else {
                    RoundItem ri = new RoundItem();
                    ri.setProductDepartment(selectedTableProductDepartment);
                    ri.setRegularPrice(selectedTableProductDepartment.getProduct().getPrice());
                    ri.setQuantity(quantity.doubleValue());
                    this.offerPriceDetailsByProduct = OfferPriceDetailes.getByProduct((long)selectedTableProductDepartment.getProduct().getProductID(), (Connection)this.controller.getSettings().getConnection());
                    if (this.offerPriceDetailsByProduct.size() > 1) {
                        this.controller.alert("Upozorenje", "Artikal ima vi\u0161e akcijskih cena.", this.rootPane.getScene().getWindow());
                    }
                    ri.setOfferPriceDetails(this.offerPriceDetailsByProduct.size() > 0 ? (OfferPriceDetailes)this.offerPriceDetailsByProduct.get(0) : null);
                    ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().add(ri);
                    ri.setDescription(this.description);
                    this.controller.getCurrentBill().recalculateOfferPrices(this.controller);
                    ObservableList presentList = Present.getPresentList((ScreensController)this.controller);
                    if (presentList != null) {
                        for (Present present : presentList) {
                            if (!present.isActiveDiscount()) continue;
                            if (present.getDiscountPercent() != 0.0) {
                                if (!(present.getBillSumFrom() <= this.controller.getCurrentBill().getSumWithDiscout()) || !(this.controller.getCurrentBill().getSumWithDiscout() <= present.getBillSumTo())) continue;
                                ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(present.getDiscountPercent());
                                continue;
                            }
                            if (!(present.getBillSumFrom() <= this.controller.getCurrentBill().getSumWithDiscout()) || !(this.controller.getCurrentBill().getSumWithDiscout() <= present.getBillSumTo())) continue;
                            ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(Settings.round((double)(100.0 * Settings.round((double)present.getDiscountMonay(), (int)2) / ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout()), (int)2));
                        }
                    }
                    for (FinancialDiscount financialDiscount : FinancialDiscount.getFinancialDiscountsList((ScreensController)this.controller)) {
                        if (!financialDiscount.isActive()) continue;
                        if (((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout() >= financialDiscount.getValue()) {
                            for (RoundItem roundItem : ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList()) {
                                roundItem.getProductDepartment().getProduct().setDiscount(financialDiscount.getDiscount());
                            }
                            continue;
                        }
                        for (RoundItem roundItem : ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList()) {
                            roundItem.getProductDepartment().getProduct().setDiscount(0.0);
                        }
                    }
                    this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
                    this.post.setDisable(false);
                    this.btnPopust.setDisable(false);
                }
                Bill currentActiveBill = (Bill)this.controller.getBillList().get(this.controller.getActiveBill());
                this.discountDisplay = this.getDiscountInRSD(((Round)currentActiveBill.getRoundList().get(0)).getItemList()) / currentActiveBill.getSumWithDiscout();
                if ("true".equals(this.controller.getSettings().getLCD())) {
                    CustomerDispaly customerDispaly = new CustomerDispaly();
                    customerDispaly.setName(quantity + " X " + selectedTableProductDepartment.getProduct().getShortName());
                    customerDispaly.setPrice(String.valueOf(currentActiveBill.getSumWithDiscout() - currentActiveBill.getSumWithDiscout() * this.discountDisplay));
                    customerDispaly.setUnitPrice(String.valueOf(quantity * selectedTableProductDepartment.getProduct().getPrice()));
                    CustomerDispaly.call((CustomerDispaly)customerDispaly);
                }
                FiscalPrinter.showProductDisplay((String)this.controller.getSettings().getFiscalFolder(), (String)selectedTableProductDepartment.getProduct().getShortName(), (double)(currentActiveBill.getSumWithDiscout() - currentActiveBill.getSumWithDiscout() * this.discountDisplay));
            } else {
                String message = "";
                message = this.controller.getSettings().isKolStanje() ? "Nemate ovla\u0161\u0107enje za prodaju proizvoda sa koli\u010dinom vecom, od stanja na lageru koje iznosi: " + (selectedProductStock + selectedProduct.getStockReservation()) + ", rezervisano: " + selectedProduct.getStockReservation() : "Nemate ovla\u0161\u0107enje za prodaju proizvoda sa koli\u010dinom vecom, od stanja na lageru.";
                this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            }
        }
        this.textFofFiltering = "";
        this.textAfterMultiply = "";
    }

    private boolean isEmptyinfoText() {
        return this.infoText.getText().equals("");
    }

    private void insertProductItemIntoBill(Double quantity, Product product) {
        Product selectedProduct = product;
        ProductDepartment selectedTableProductDepartment = null;
        try {
            selectedTableProductDepartment = ProductDepartment.getFromDB((long)selectedProduct.getProductID(), (long)Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), (ScreensController)this.controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (selectedTableProductDepartment != null) {
            double selectedProductStock = 0.0;
            boolean sellItemApproved = false;
            if (!this.controller.getSettings().isSellWithoutStock() || this.controller.getSettings().isKolStanje()) {
                selectedProductStock = selectedProduct.getStock() - selectedProduct.getStockReservation();
            } else {
                sellItemApproved = true;
            }
            boolean alreadyExist = false;
            int indexAlreadyExistedProductDepartment = 0;
            double quantityAlreadyExisted = 0.0;
            ArrayList roundItemList = ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList();
            for (int i = 0; i < roundItemList.size(); ++i) {
                if (selectedTableProductDepartment.getProduct().getProductID() != ((RoundItem)roundItemList.get(i)).getProductDepartment().getProductID()) continue;
                if (((RoundItem)roundItemList.get(i)).getOfferPriceDetails() != null) {
                    if ((quantity + ((RoundItem)roundItemList.get(i)).getQuantity()) % ((RoundItem)roundItemList.get(i)).getOfferPriceDetails().getQuantity() == 0.0) {
                        alreadyExist = true;
                        indexAlreadyExistedProductDepartment = i;
                        quantityAlreadyExisted += ((RoundItem)roundItemList.get(i)).getQuantity();
                        continue;
                    }
                    alreadyExist = false;
                    continue;
                }
                alreadyExist = true;
                indexAlreadyExistedProductDepartment = i;
                quantityAlreadyExisted += ((RoundItem)roundItemList.get(i)).getQuantity();
            }
            if (selectedProductStock >= quantity + quantityAlreadyExisted || selectedProduct.getProductCategoryID() == 2 || this.controller.getUser().hasRole("sell.without.stock")) {
                sellItemApproved = true;
            }
            if (sellItemApproved) {
                if (!selectedTableProductDepartment.getProduct().isMeasurable() && this.infoText.getText().contains(new DecimalFormatSymbols().getDecimalSeparator() + "")) {
                    Settings.startInfoAnimation((String)"Artikal nije merljiv", (Label)this.labelBillInfo, (int)7, (int)18);
                    this.summaryPane.uncolorAll();
                    this.infoText.setText("");
                    return;
                }
                if (alreadyExist && this.controller.getSettings().isSabiranjeArtikala()) {
                    ((RoundItem)((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().get(indexAlreadyExistedProductDepartment)).setQuantity(quantity + quantityAlreadyExisted);
                    this.controller.getCurrentBill().recalculateOfferPrices(this.controller);
                    this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
                    this.summaryPane.setColoredByIndex(indexAlreadyExistedProductDepartment);
                } else {
                    RoundItem ri = new RoundItem();
                    ri.setProductDepartment(selectedTableProductDepartment);
                    ri.setRegularPrice(selectedTableProductDepartment.getProduct().getPrice());
                    ri.setQuantity(quantity.doubleValue());
                    this.offerPriceDetailsByProduct = OfferPriceDetailes.getByProduct((long)selectedTableProductDepartment.getProduct().getProductID(), (Connection)this.controller.getSettings().getConnection());
                    if (this.offerPriceDetailsByProduct.size() > 1) {
                        this.controller.alert("Upozorenje", "Artikal ima vi\u0161e akcijskih cena.", this.rootPane.getScene().getWindow());
                    }
                    ri.setOfferPriceDetails(this.offerPriceDetailsByProduct.size() > 0 ? (OfferPriceDetailes)this.offerPriceDetailsByProduct.get(0) : null);
                    ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().add(ri);
                    this.controller.getCurrentBill().recalculateOfferPrices(this.controller);
                    ObservableList presentList = Present.getPresentList((ScreensController)this.controller);
                    if (presentList != null) {
                        for (Present present : presentList) {
                            if (!present.isActiveDiscount()) continue;
                            if (present.getDiscountPercent() != 0.0) {
                                if (!(present.getBillSumFrom() <= this.controller.getCurrentBill().getSumWithDiscout()) || !(this.controller.getCurrentBill().getSumWithDiscout() <= present.getBillSumTo())) continue;
                                ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(present.getDiscountPercent());
                                continue;
                            }
                            if (!(present.getBillSumFrom() <= this.controller.getCurrentBill().getSumWithDiscout()) || !(this.controller.getCurrentBill().getSumWithDiscout() <= present.getBillSumTo())) continue;
                            ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(Settings.round((double)(100.0 * Settings.round((double)present.getDiscountMonay(), (int)2) / ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout()), (int)2));
                        }
                    }
                    for (FinancialDiscount financialDiscount : FinancialDiscount.getFinancialDiscountsList((ScreensController)this.controller)) {
                        if (!financialDiscount.isActive()) continue;
                        if (((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout() >= financialDiscount.getValue()) {
                            for (RoundItem roundItem : ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList()) {
                                roundItem.getProductDepartment().getProduct().setDiscount(financialDiscount.getDiscount());
                            }
                            continue;
                        }
                        for (RoundItem roundItem : ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList()) {
                            roundItem.getProductDepartment().getProduct().setDiscount(0.0);
                        }
                    }
                    this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
                    this.post.setDisable(false);
                    this.btnPopust.setDisable(false);
                }
                Bill currentActiveBill = (Bill)this.controller.getBillList().get(this.controller.getActiveBill());
                this.discountDisplay = this.getDiscountInRSD(((Round)currentActiveBill.getRoundList().get(0)).getItemList()) / currentActiveBill.getSumWithDiscout();
                FiscalPrinter.showProductDisplay((String)this.controller.getSettings().getFiscalFolder(), (String)selectedTableProductDepartment.getProduct().getShortName(), (double)(currentActiveBill.getSumWithDiscout() - currentActiveBill.getSumWithDiscout() * this.discountDisplay));
            } else {
                String message = "";
                message = this.controller.getSettings().isKolStanje() ? "Nemate ovla\u0161\u0107enje za prodaju proizvoda sa koli\u010dinom vecom, od stanja na lageru koje iznosi: " + (selectedProductStock + selectedProduct.getStockReservation()) + ", rezervisano: " + selectedProduct.getStockReservation() : "Nemate ovla\u0161\u0107enje za prodaju proizvoda sa koli\u010dinom vecom, od stanja na lageru.";
                this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            }
        }
        this.textFofFiltering = "";
        this.textAfterMultiply = "";
    }

    @FXML
    private void popustClicked() {
        if (this.controller.getUser().hasRole("discount")) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            if (this.summaryPane.getSelectedItemIndex() != -1) {
                hm.put("billItemIndex", this.summaryPane.getSelectedItemIndex());
            } else {
                hm.put("billItemIndex", -1);
            }
            this.controller.getRoot().removeEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
            int result = this.controller.showModalDialog("Dodavanje popusta na proizvod", ScreensController.SCREEN_DISCOUNT_DETAILES, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                System.out.println(((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getDiscount());
                this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
            }
            this.gridPane.requestFocus();
            this.tableProducts.getSelectionModel().clearSelection();
        } else {
            this.controller.alert("Upozorenje", "Nemate ovla\u0161\u0107enje za davanje popusta", this.rootPane.getScene().getWindow());
            this.summaryPane.setSelectedItemIndex(-1);
            this.summaryPane.refresh(this.controller);
        }
        this.summaryPane.setSelectedItemIndex(-1);
    }

    @FXML
    private void reservationClicked() {
        if (this.KWSActive) {
            HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
            hm.put("controller", this.controller);
            int n = this.controller.showModalDialog("KWS Test", ScreensController.SCREEN_KWS, hm, this.rootPane.getScene().getWindow());
        } else {
            this.controller.setReservationDocument(null);
            this.cancelButtonClick();
            this.billSummaryPaneClicked();
            if (this.controller.getUser().hasRole("discount")) {
                HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
                hm.put("controller", this.controller);
                this.controller.getRoot().removeEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
                int result = this.controller.showModalDialog("Dodavanje popusta na proizvod", ScreensController.SCREEN_RESERVATION_DETAILES, hm, this.rootPane.getScene().getWindow());
                if (result == ScreensController.MODAL_RESULT_OK) {
                    Document document = (Document)hm.get("selectedReservation");
                    this.controller.setReservationDocument(document);
                    Person p = Person.getById((long)document.getPersonID(), (ScreensController)this.controller);
                    p.setDiscount(document.getDiscount());
                    if (p.getPersonCategoryID() == 2) {
                        if (p.getPersonTypeID() == 1) {
                            this.labelGuest.setText(" Kupac: " + p.getFirstLastName() + "\nPopust: " + Settings.getNumberFormat((int)2, (boolean)true).format(p.getDiscount()) + "%");
                        } else {
                            this.labelGuest.setText(" Kupac: " + p.getName() + "\nPopust: " + Settings.getNumberFormat((int)2, (boolean)true).format(p.getDiscount()) + "%");
                        }
                    }
                    for (DocumentDetails ddDetails : DocumentDetails.getObeservableList((long)document.getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                        if (ddDetails.isClosed()) continue;
                        if (!this.controller.getSettings().isSellWithoutStock()) {
                            for (Product product : this.stockList) {
                                if (!(ddDetails.getQuantity() > product.getStock()) || product.getProductCategoryID() == 2) continue;
                                this.controller.alert("Obavestenje", "Stanje lagera je manje od kolicine koju zelite da prodate, unesite robu na stanje ili izmenite rezervaciju", this.rootPane.getScene().getWindow());
                                return;
                            }
                        }
                        RoundItem ri = new RoundItem();
                        ProductDepartment selectedTableProductDepartment = ProductDepartment.getByProductAndDepartment((long)ddDetails.getProductID(), (int)Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), (Connection)this.controller.getSettings().getConnection());
                        ri.setProductDepartment(selectedTableProductDepartment);
                        ri.setRegularPrice(Product.getByID((long)ddDetails.getProductID(), (ScreensController)this.controller).getPrice());
                        if (ddDetails.getPriceWithDiscount() != ri.getRegularPrice()) {
                            selectedTableProductDepartment.getProduct().setDiscount(100.0 - 100.0 * ddDetails.getPriceWithDiscount() / ri.getRegularPrice());
                        }
                        ri.setQuantity(ddDetails.getQuantity());
                        this.offerPriceDetailsByProduct = OfferPriceDetailes.getByProduct((long)selectedTableProductDepartment.getProduct().getProductID(), (Connection)this.controller.getSettings().getConnection());
                        if (this.offerPriceDetailsByProduct.size() > 1) {
                            this.controller.alert("Upozorenje", "Artikal ima vi\u0161e akcijskih cena.", this.rootPane.getScene().getWindow());
                        }
                        ri.setOfferPriceDetails(this.offerPriceDetailsByProduct.size() > 0 ? (OfferPriceDetailes)this.offerPriceDetailsByProduct.get(0) : null);
                        this.controller.getCurrentBill().recalculateOfferPrices(this.controller);
                        ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().add(ri);
                    }
                    this.summaryPane.refresh(this.controller);
                    this.controller.getCurrentBill().recalculateOfferPrices(this.controller);
                    this.controller.getCurrentBill().setPerson(p);
                    this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
                    this.summaryPane.setLastColored();
                    if (!((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().isEmpty()) {
                        this.post.setDisable(false);
                        this.btnPopust.setDisable(false);
                    }
                }
                this.gridPane.requestFocus();
            } else {
                this.controller.alert("Upozorenje", "Nemate ovla\u0161\u0107enje za davanje popusta", this.rootPane.getScene().getWindow());
                this.summaryPane.setSelectedItemIndex(-1);
                this.summaryPane.refresh(this.controller);
            }
        }
    }

    @FXML
    private void postClicked() {
        Bill currentActiveBill = (Bill)this.controller.getBillList().get(this.controller.getActiveBill());
        ArrayList items = ((Round)currentActiveBill.getRoundList().get(0)).getItemList();
        double sum = 0.0;
        double price = 0.0;
        double discount = 0.0;
        for (RoundItem item : items) {
            Product p = item.getProductDepartment().getProduct();
            price = p.getPrice();
            discount = p.getDiscount();
            sum += price * (1.0 - discount / 100.0) * item.getQuantity();
        }
        if (sum < 0.0) {
            this.controller.alert("Upozorenje", "Iznos popusta je veci od 100%. Izmenite va\u0161 ra\u010dun", this.rootPane.getScene().getWindow());
            return;
        }
        this.gridPane.removeEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
        this.infoText.setText("");
        if (this.controller.getSettings().isKolStanje()) {
            this.controller.setProductsAlreadyLoaded(false);
        }
        this.controller.getScreen(ScreensController.SCREEN_PAYMENT_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_TRGOVINA);
    }

    @FXML
    private void cancelButtonClick() {
        this.summaryPane.locateSelected();
        Bill bill = (Bill)this.controller.getBillList().get(this.controller.getActiveBill());
        ArrayList<OfferPriceDetailes> offerPriceDetaileses = new ArrayList<OfferPriceDetailes>();
        for (Round r : bill.getRoundList()) {
            for (int i = 0; i < r.getItemList().size(); ++i) {
                Product product;
                OfferPriceDetailes offerPriceDetailes;
                if (i == this.summaryPane.getSelectedItemIndex()) {
                    offerPriceDetailes = new OfferPriceDetailes();
                    offerPriceDetailes.setDiscount(((RoundItem)r.getItemList().get(i)).getDiscount());
                    offerPriceDetailes.setPrice(((RoundItem)r.getItemList().get(i)).getRegularPrice());
                    offerPriceDetailes.setQuantity(((RoundItem)r.getItemList().get(i)).getQuantity());
                    product = new Product();
                    product.setName(((RoundItem)r.getItemList().get(i)).getProductDepartment().getProduct().getName());
                    product.setCode(((RoundItem)r.getItemList().get(i)).getProductDepartment().getProduct().getCode());
                    offerPriceDetailes.setProduct(product);
                    offerPriceDetaileses.add(offerPriceDetailes);
                    continue;
                }
                if (this.summaryPane.getSelectedItemIndex() != -1) continue;
                offerPriceDetailes = new OfferPriceDetailes();
                offerPriceDetailes.setDiscount(((RoundItem)r.getItemList().get(i)).getDiscount());
                offerPriceDetailes.setPrice(((RoundItem)r.getItemList().get(i)).getRegularPrice());
                offerPriceDetailes.setQuantity(((RoundItem)r.getItemList().get(i)).getQuantity());
                product = new Product();
                product.setName(((RoundItem)r.getItemList().get(i)).getProductDepartment().getProduct().getName());
                product.setCode(((RoundItem)r.getItemList().get(i)).getProductDepartment().getProduct().getCode());
                offerPriceDetailes.setProduct(product);
                offerPriceDetaileses.add(offerPriceDetailes);
            }
        }
        if (this.summaryPane.getSelectedItemIndex() < 0) {
            ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setPerson(null);
            this.vrednostBodova = 0.0;
        }
        try {
            this.controller.setAuthQuantity(this.numberFormat.parse(this.infoText.getText()).doubleValue());
        }
        catch (ParseException e) {
            this.controller.setAuthQuantity(0.0);
        }
        this.controller.setAuthorizationRequest(1);
        if (!this.controller.getUser().hasRole("storno")) {
            HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
            hm.put("controller", this.controller);
            int result = this.controller.showModalDialog("", ScreensController.SCREEN_AUTHORISATION_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
                this.infoText.setText("");
                this.summaryPane.setSelectedItemIndex(-1);
                this.controller.setAuthItem(this.summaryPane.getSelectedItemIndex());
            }
        } else {
            AuthorisationScreenController.stornoWithoutPass((ScreensController)this.controller, (long)this.controller.getUser().getUserID());
            this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
            this.infoText.setText("");
            this.summaryPane.setSelectedItemIndex(-1);
            this.controller.setAuthItem(this.summaryPane.getSelectedItemIndex());
        }
        if (this.hBoxNewBill.getChildren().size() - 1 == this.controller.getActiveBill() && ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getLastRound().getItemList().isEmpty()) {
            if (this.hBoxNewBill.getChildren().size() == 2) {
                this.hBoxNewBill.getChildren().clear();
                this.controller.getBillList().remove(this.controller.getActiveBill());
                this.controller.setActiveBill(0);
            } else {
                this.hBoxNewBill.getChildren().remove(this.controller.getActiveBill());
                this.controller.getBillList().remove(this.controller.getActiveBill());
                this.controller.setActiveBill(this.controller.getActiveBill());
            }
        }
        if (((BillSummaryRoundTrgovina)this.summaryPane.getRoundList().get(0)).hasSelectedItems()) {
            Log.writeLog((User)this.controller.getUser(), (String)("Artikal: " + ((RoundItem)((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().get(this.summaryPane.getSelectedItemIndex())).getProductDepartment().getProduct().getShortName() + ((RoundItem)((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().get(this.summaryPane.getSelectedItemIndex())).getQuantity() + " " + this.summaryPane.getSelectedItemIndex()), (Connection)this.controller.getSettings().getConnection());
            Bill.billcancellation(offerPriceDetaileses, (Connection)this.controller.getSettings().getConnection());
        } else {
            Log.writeLog((User)this.controller.getUser(), (String)("Ceo ra\u010dun poni\u0161ten " + this.controller.getPointOfSale().getName()), (Connection)this.controller.getSettings().getConnection());
            Bill.billcancellation(offerPriceDetaileses, (Connection)this.controller.getSettings().getConnection());
        }
        this.controller.getCurrentBill().recalculateOfferPrices(this.controller);
        this.summaryPane.refresh(this.controller);
        this.controller.setProductsAlreadyLoaded(false);
        this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
        if (this.controller.getBillList().size() == 1 && ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList().isEmpty()) {
            this.post.setDisable(true);
            this.btnPopust.setDisable(true);
        }
        this.populateLableGuest();
    }

    @FXML
    private void loyalityButtonClick() {
        double value = 0.0;
        double reservationValue = 0.0;
        this.controller.getCurrentBill().setPerson(null);
        this.controller.setActiveBill(0);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        hm.put("currentBill", this.controller.getBillList().get(this.controller.getActiveBill()));
        hm.put("personCategory", PersonCategory.LOYALTY);
        hm.put("saNaplate", false);
        int result = this.controller.showModalDialog("Izbor komitenta", ScreensController.DIALOG_SELECT_PERSON_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            Person p = (Person)hm.get("person");
            GiftCard gCard = (GiftCard)hm.get("giftCard");
            if (p != null) {
                BuyerOfferPrice buyerOfferPrice = BuyerOfferPrice.getOfferPrice((long)p.getBuyerOfferPriceID(), (Connection)this.controller.getSettings().getConnection());
                if (buyerOfferPrice != null && buyerOfferPrice.getBuyerOfferPriceID() != null) {
                    p.setDiscount(0.0);
                    ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setPerson(p);
                    if (p.getLoyality() == null) {
                        this.labelGuest.setText(" Kupac: " + ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getName() + "\nPopust: " + Settings.getNumberFormat((int)2, (boolean)true).format(((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getDiscount()) + "%");
                    } else {
                        this.labelGuest.setText(" Kupac: " + ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getFirstLastName() + "\nPopust: " + Settings.getNumberFormat((int)2, (boolean)true).format(((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getDiscount()) + "%");
                    }
                } else if (PersonCategory.BUYER.equals(PersonCategory.getByID((int)p.getPersonCategoryID(), (Connection)this.controller.getSettings().getConnection()).getName())) {
                    ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setPerson(p);
                    this.populateLableGuest();
                } else {
                    Loyality l = Loyality.getByPerson((Person)p, (ScreensController)this.controller);
                    if (l != null) {
                        LoyaltyLimit loyaltyLimit = LoyaltyLimit.getLoyaltyLimitByLoyaltyID((long)l.getLoyalityID(), (ScreensController)this.controller);
                        if (loyaltyLimit.isActive()) {
                            while (Settings.fromLocalDate((LocalDate)LocalDate.now()).after(loyaltyLimit.getDateTo())) {
                                loyaltyLimit.setDateTo(Settings.fromLocalDate((LocalDate)Settings.fromDate((Date)loyaltyLimit.getDateTo()).plusDays(loyaltyLimit.getNumberOfDates())));
                                loyaltyLimit.setCurrentValue(0.0);
                                loyaltyLimit.update(this.controller);
                            }
                            if (Settings.fromLocalDate((LocalDate)LocalDate.now()).before(loyaltyLimit.getDateTo())) {
                                if (loyaltyLimit.getCurrentValue() >= loyaltyLimit.getLimitValue()) {
                                    this.controller.alert("Obavestenje", "Prekoracili ste limit za lojaliti kupovinu.", this.rootPane.getScene().getWindow());
                                    return;
                                }
                                hm.put("LoyalitiName", p.getFirstLastName());
                                hm.put("LoyalityPoints", l.getPoints());
                                hm.put("LoyalityPointsValue", l.getPoints() * l.getSellingPointsValue());
                                if (this.controller.getLoyalitySettings().getActualByName(this.controller, "point.value.round").equals("true")) {
                                    int resultPoints = this.controller.showModalDialog("Izbor poena", ScreensController.DIALOG_LOYALITY_POINTS, hm, this.rootPane.getScene().getWindow());
                                    if (resultPoints == ScreensController.MODAL_RESULT_YES) {
                                        if (l.getPoints() >= 10.0) {
                                            int resultPickPoints = this.controller.showModalDialog("Izbor vrednosti bodova", ScreensController.DIALOG_LOYALITY_POINTS_PICK, hm, this.rootPane.getScene().getWindow());
                                            if (resultPickPoints == ScreensController.MODAL_RESULT_YES) {
                                                this.vrednostBodova = (Double)hm.get("vrednostBodova") * l.getSellingPointsValue();
                                            }
                                        } else {
                                            this.vrednostBodova = 0.0;
                                        }
                                    } else {
                                        l.setLoyalityID(new Long(0L));
                                    }
                                }
                                if (this.controller.getLoyalitySettings().getActualByName(this.controller, "bill.number.discount.active").equals("true") && l.getNumberEntry() == l.getCurrentNumberEntry()) {
                                    p.setDiscount(l.getDiscountEntry());
                                    this.vrednostBodova = 0.0;
                                }
                                ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setPerson(p);
                                if (this.vrednostBodova > 0.0) {
                                    double discountLoyalitySum = 100.0 - (p.getDiscount() + 100.0 * (((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout() - this.vrednostBodova) / ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout());
                                    if (this.controller.getSettings().isLoyalityPopustPrioritet()) {
                                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(discountLoyalitySum);
                                    } else {
                                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscountIfNotInOffer(discountLoyalitySum);
                                    }
                                    this.labelGuest.setText(" Gost: " + ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getFirstLastName() + "\nPopust: " + Settings.getNumberFormat((int)2, (boolean)true).format(((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getDiscount()) + "%");
                                    l.setPoints(this.vrednostBodova / l.getSellingPointsValue());
                                } else {
                                    if (this.controller.getSettings().isLoyalityPopustPrioritet()) {
                                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(p.getDiscount());
                                    } else {
                                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscountIfNotInOffer(p.getDiscount());
                                    }
                                    this.populateLableGuest();
                                    l.setPoints(this.vrednostBodova / l.getSellingPointsValue());
                                }
                                this.controller.getCurrentBill().getPerson().setLoyality(l);
                            }
                        } else {
                            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("loyalty.point.action"))) {
                                int resultPoints;
                                hm.put("LoyalitiName", p.getFirstLastName());
                                hm.put("LoyalityPoints", l.getPoints());
                                hm.put("LoyalityPointsValue", l.getPoints() * l.getSellingPointsValue());
                                if (this.controller.getLoyalitySettings().getActualByName(this.controller, "point.value.round").equals("true") && (resultPoints = this.controller.showModalDialog("Izbor poena", ScreensController.DIALOG_LOYALITY_POINTS, hm, this.rootPane.getScene().getWindow())) == ScreensController.MODAL_RESULT_YES) {
                                    this.controller.getCurrentBill().setUsingPoints(true);
                                    int resultPickPoints = this.controller.showModalDialog("Izbor vrednosti bodova", ScreensController.DIALOG_LOYALITY_POINTS_PICK, hm, this.rootPane.getScene().getWindow());
                                    if (resultPickPoints == ScreensController.MODAL_RESULT_YES) {
                                        this.vrednostBodova = (Double)hm.get("vrednostBodova") * l.getSellingPointsValue();
                                    }
                                }
                                if (this.controller.getLoyalitySettings().getActualByName(this.controller, "bill.number.discount.active").equals("true") && l.getNumberEntry() == l.getCurrentNumberEntry()) {
                                    p.setDiscount(l.getDiscountEntry());
                                    this.vrednostBodova = 0.0;
                                }
                                ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setPerson(p);
                                if (this.vrednostBodova > 0.0) {
                                    double discountLoyalitySum = 100.0 - (p.getDiscount() + 100.0 * (((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout() - this.vrednostBodova) / ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout());
                                    if (this.controller.getSettings().isLoyalityPopustPrioritet()) {
                                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(discountLoyalitySum);
                                    } else {
                                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscountIfNotInOffer(discountLoyalitySum);
                                    }
                                    this.labelGuest.setText(" Kupac: " + ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getFirstLastName() + "\nPopust: " + Settings.getNumberFormat((int)2, (boolean)true).format(((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getDiscount()) + "%");
                                    l.setPoints(this.vrednostBodova / l.getSellingPointsValue());
                                } else {
                                    if (this.controller.getSettings().isLoyalityPopustPrioritet()) {
                                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(p.getDiscount());
                                    } else {
                                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscountIfNotInOffer(p.getDiscount());
                                    }
                                    this.populateLableGuest();
                                    l.setPoints(this.vrednostBodova / l.getSellingPointsValue());
                                }
                            }
                            p.setLoyality(l);
                            value = Document.getSumBillForPeriodByLoyaltyID((Loyality)l, (ScreensController)this.controller);
                            reservationValue = Document.getActiveReservationsSumForPeriod((Loyality)l, (ScreensController)this.controller);
                            double discount = 0.0;
                            System.out.println(value);
                            discount = FinancialDiscount.getDiscountforFinancialDiscount((Loyality)l, (double)value, (double)reservationValue, (ScreensController)this.controller);
                            if (discount != 0.0) {
                                p.setDiscount(discount);
                            }
                        }
                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setPerson(p);
                        this.populateLableGuest();
                        if (((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getLoyality() != null) {
                            hm.put("person", ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson());
                            hm.put("personValue", value);
                            hm.put("reservatedValue", reservationValue);
                            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("loyalty.point.action"))) {
                                this.controller.showModalDialog("Specifikacija stalnog kupca", ScreensController.SCREEN_LOYALTY_POINTS_SPECIFICATION, hm, this.rootPane.getScene().getWindow());
                            } else {
                                this.controller.showModalDialog("Specifikacija stalnog kupca", ScreensController.SCREEN_LOYALTY_SPECIFICATION, hm, this.rootPane.getScene().getWindow());
                            }
                        }
                    } else {
                        ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setPerson(p);
                        this.populateLableGuest();
                    }
                }
            }
            if (gCard != null) {
                if (!gCard.isActive()) {
                    this.controller.alert("Upozorenje", "Izabrana kartica nije aktivna", this.rootPane.getScene().getWindow());
                } else {
                    ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setGiftCard(gCard);
                    hm.put("giftCard", gCard);
                    hm.put("giftCardBill", this.controller.getBillList().get(this.controller.getActiveBill()));
                    String iznos = null;
                    int resultPoints = this.controller.showModalDialog("Pregled Kartice", ScreensController.DIALOG_GIFT_CARD_AMOUNT, hm, this.rootPane.getScene().getWindow());
                    if (resultPoints == ScreensController.MODAL_RESULT_OK) {
                        iznos = (String)hm.get("amountUsed");
                        try {
                            this.labelGuest.setText("Poklon kartica\nVrednost: " + Double.parseDouble(iznos) + (Double.parseDouble(iznos) - ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout() < 0.0 ? ", Doplatiti: " + (Double.parseDouble(iznos) - ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout()) * -1.0 : ", Ostalo na kartici: " + (Double.parseDouble(iznos) - ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout())));
                        }
                        catch (NullPointerException e) {
                            this.labelGuest.setText("");
                        }
                    } else {
                        this.controller.getCurrentBill().setGiftCard(null);
                        hm.remove("giftCard");
                    }
                }
            }
        } else {
            ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setPerson(null);
            return;
        }
        this.summaryPane.setBill((Bill)this.controller.getBillList().get(this.controller.getActiveBill()), this.controller);
    }

    @FXML
    private void adminButtonClick() {
        if (this.listaListi.isEmpty()) {
            this.listaListi.clear();
        }
        this.controller.setReservationDocument(null);
        this.controller.setProductsAlreadyLoaded(false);
        this.btnDetaljnaPretraga.setVisible(false);
        this.summaryPane.unselectAll();
        this.summaryPane.locateSelected();
        if (this.tMasterLight) {
            this.controller.getScreen(ScreensController.SCREEN_BACKOFFICE_LIGHT, this.controller.getRoot(), ScreensController.SCREEN_TRGOVINA);
        } else {
            this.controller.getScreen(ScreensController.SCREEN_BACKOFFICE, this.controller.getRoot(), ScreensController.SCREEN_TRGOVINA);
        }
    }

    @FXML
    private void billSummaryPaneClicked() {
        this.summaryPane.locateSelected();
        this.controller.setAuthBill(this.controller.getActiveBill());
        this.controller.setAuthRound(this.summaryPane.getSelectedRoundIndex());
        this.controller.setAuthItem(this.summaryPane.getSelectedItemIndex());
    }

    @FXML
    private void keyboardButtonClick(ActionEvent event) {
        if ((Button)event.getSource() == this.key0) {
            this.tfFilter.setText(this.tfFilter.getText() + "0");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key1) {
            this.tfFilter.setText(this.tfFilter.getText() + "1");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key2) {
            this.tfFilter.setText(this.tfFilter.getText() + "2");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key3) {
            this.tfFilter.setText(this.tfFilter.getText() + "3");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key4) {
            this.tfFilter.setText(this.tfFilter.getText() + "4");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key5) {
            this.tfFilter.setText(this.tfFilter.getText() + "5");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key6) {
            this.tfFilter.setText(this.tfFilter.getText() + "6");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key7) {
            this.tfFilter.setText(this.tfFilter.getText() + "7");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key8) {
            this.tfFilter.setText(this.tfFilter.getText() + "8");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.key9) {
            this.tfFilter.setText(this.tfFilter.getText() + "9");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyQ) {
            this.tfFilter.setText(this.tfFilter.getText() + "Q");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyW) {
            this.tfFilter.setText(this.tfFilter.getText() + "W");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyE) {
            this.tfFilter.setText(this.tfFilter.getText() + "E");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyR) {
            this.tfFilter.setText(this.tfFilter.getText() + "R");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyT) {
            this.tfFilter.setText(this.tfFilter.getText() + "T");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyY) {
            this.tfFilter.setText(this.tfFilter.getText() + "Y");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyU) {
            this.tfFilter.setText(this.tfFilter.getText() + "U");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyI) {
            this.tfFilter.setText(this.tfFilter.getText() + "I");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyO) {
            this.tfFilter.setText(this.tfFilter.getText() + "O");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyP) {
            this.tfFilter.setText(this.tfFilter.getText() + "P");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyA) {
            this.tfFilter.setText(this.tfFilter.getText() + "A");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyS) {
            this.tfFilter.setText(this.tfFilter.getText() + "S");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyD) {
            this.tfFilter.setText(this.tfFilter.getText() + "D");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyF) {
            this.tfFilter.setText(this.tfFilter.getText() + "F");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyG) {
            this.tfFilter.setText(this.tfFilter.getText() + "G");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyH) {
            this.tfFilter.setText(this.tfFilter.getText() + "H");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyJ) {
            this.tfFilter.setText(this.tfFilter.getText() + "J");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyK) {
            this.tfFilter.setText(this.tfFilter.getText() + "K");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyL) {
            this.tfFilter.setText(this.tfFilter.getText() + "L");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyZ) {
            this.tfFilter.setText(this.tfFilter.getText() + "Z");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyX) {
            this.tfFilter.setText(this.tfFilter.getText() + "X");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyC) {
            this.tfFilter.setText(this.tfFilter.getText() + "C");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyV) {
            this.tfFilter.setText(this.tfFilter.getText() + "V");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyB) {
            this.tfFilter.setText(this.tfFilter.getText() + "B");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyN) {
            this.tfFilter.setText(this.tfFilter.getText() + "N");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyM) {
            this.tfFilter.setText(this.tfFilter.getText() + "M");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyBackspace && this.tfFilter.getText().length() > 0) {
            this.tfFilter.setText(this.tfFilter.getText().substring(0, this.tfFilter.getText().length() - 1));
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
        if ((Button)event.getSource() == this.keyEnter) {
            if (this.tableProducts.getSelectionModel().getSelectedItem() != null) {
                this.tableDoubleClick = true;
                this.productItemClicked();
                this.btnPretraga.setVisible(true);
                this.tfFilter.setText("");
                event.consume();
                this.toggleSearchTable();
                this.gridPane.removeEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
                this.gridPane.addEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
                this.gridPane.requestFocus();
            } else {
                this.currentTableList = Product.getNewTrgovinaList((ScreensController)this.controller, (String)"10000000", (String)"Sve", (String)this.tfFilter.getText().trim(), (boolean)this.doStock);
                this.fillTable();
                this.loadProductsNew(this.tfFilter.getText().trim());
            }
        }
        if ((Button)event.getSource() == this.keySpace) {
            this.tfFilter.setText(this.tfFilter.getText() + " ");
            this.tfFilter.positionCaret(this.tfFilter.getText().length());
        }
    }

    private void setKeyboardBtnUnfocused() {
        this.numpad0.setFocusTraversable(false);
        this.numpad1.setFocusTraversable(false);
        this.numpad2.setFocusTraversable(false);
        this.numpad3.setFocusTraversable(false);
        this.numpad4.setFocusTraversable(false);
        this.numpad5.setFocusTraversable(false);
        this.numpad6.setFocusTraversable(false);
        this.numpad7.setFocusTraversable(false);
        this.numpad8.setFocusTraversable(false);
        this.numpad9.setFocusTraversable(false);
        this.numpadDecimal.setFocusTraversable(false);
        this.numpadDel.setFocusTraversable(false);
        this.numpadMultiply.setFocusTraversable(false);
        this.billSummaryPane.setFocusTraversable(false);
        this.btnPretraga.setFocusTraversable(false);
        this.numpadEnter.setFocusTraversable(false);
        this.btnPopust.setFocusTraversable(false);
        this.infoText.setFocusTraversable(false);
        this.btnToggleNumeric.setFocusTraversable(false);
    }

    public void checkIfWorkDayTooLong() {
        try {
            WorkDay wd = WorkDay.getFromDb((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection());
            Date trenutnoVreme = new Date();
            double razlika = trenutnoVreme.getTime() - wd.getDateFrom().getTime();
            if (wd.getDateTo() == null && razlika / 1000.0 / 60.0 / 60.0 / 24.0 > 1.0) {
                this.warningLabel.setVisible(true);
                this.warningLabel.setOpacity(0.5);
                this.warningLabel.setText("Aktuelni dan je otvoren pre vi\u0161e od 24 sata!");
            } else {
                this.warningLabel.setText("");
                this.warningLabel.setVisible(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void closeWorkDayAutomaticly() {
        try {
            WorkDay wd = WorkDay.getFromDb((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection());
            Date trenutnoVreme = new Date();
            long raz = ChronoUnit.DAYS.between(wd.getDateFrom().toInstant(), trenutnoVreme.toInstant());
            if (wd.getDateTo() == null && raz > 0L) {
                int i = 0;
                while ((long)i < raz) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         */
                        @Override
                        public void run() {
                            block20: {
                                WorkDay wd = null;
                                while (WorkDay.isTableLocked((Connection)TrgovinaController.this.controller.getSettings().getConnection())) {
                                    try {
                                        Thread.sleep(10000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                wd = WorkDay.getFromDb((PointOfSale)TrgovinaController.this.controller.getPointOfSale(), (Connection)TrgovinaController.this.controller.getSettings().getConnection());
                                wd.setLockTable(true, TrgovinaController.this.controller.getSettings().getConnection());
                                wd.closeWorkDay(TrgovinaController.this.controller.getUser(), TrgovinaController.this.controller.getPointOfSale(), TrgovinaController.this.controller.getSettings().getConnection());
                                TrgovinaController.this.controller.getSettings().getConnection().setAutoCommit(false);
                                wd.saveRecap(TrgovinaController.this.controller);
                                if (!wd.isOpenInDep(TrgovinaController.this.controller.getSettings().getConnection())) {
                                    boolean uradjena = wd.createNivelation(TrgovinaController.this.controller);
                                    wd.createNivelationSellingChangePrice(TrgovinaController.this.controller);
                                    if (!uradjena && PriceList.getList((Object)TrgovinaController.this.controller.getObject(), (boolean)uradjena, (Connection)TrgovinaController.this.controller.getSettings().getConnection()).size() > 1) {
                                        wd.createNewNivelationBetweenPriceList(TrgovinaController.this.controller);
                                    }
                                }
                                TrgovinaController.this.controller.getSettings().getConnection().commit();
                                try {
                                    TrgovinaController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                    if (wd != null) {
                                        wd.setLockTable(false, TrgovinaController.this.controller.getSettings().getConnection());
                                    }
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            TrgovinaController.this.logout();
                                        }
                                    });
                                }
                                catch (SQLException e) {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            TrgovinaController.this.logout();
                                        }
                                    });
                                    e.printStackTrace();
                                }
                                break block20;
                                catch (SQLException e) {
                                    try {
                                        try {
                                            TrgovinaController.this.controller.getSettings().getConnection().rollback();
                                        }
                                        catch (SQLException e1) {
                                            e1.printStackTrace();
                                        }
                                        e.printStackTrace();
                                        Platform.runLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                e.printStackTrace();
                                                TrgovinaController.this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom upisa u bazu. Radni dan nije propisno zatvoren.", TrgovinaController.this.rootPane.getScene().getWindow());
                                            }
                                        });
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            TrgovinaController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                            if (wd != null) {
                                                wd.setLockTable(false, TrgovinaController.this.controller.getSettings().getConnection());
                                            }
                                            Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                        }
                                        catch (SQLException e2) {
                                            Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                            e2.printStackTrace();
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        TrgovinaController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                        if (wd != null) {
                                            wd.setLockTable(false, TrgovinaController.this.controller.getSettings().getConnection());
                                        }
                                        Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                    }
                                    catch (SQLException e3) {
                                        Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                        e3.printStackTrace();
                                    }
                                }
                            }
                        }
                    }.start();
                    WorkDay.openWorkDay((int)this.controller.getPointOfSale().getPointOfSaleID(), (long)this.controller.getUser().getUserID(), (Connection)this.controller.getSettings().getConnection());
                    ++i;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void checkIfBillPrinted() {
        this.labelBillInfo.setVisible(true);
        this.labelBillInfo.setOpacity(0.0);
        if (this.controller.isBillPrinted()) {
            this.lastBill = Bill.getLastInsertedBill((int)this.controller.getPointOfSale().getPointOfSaleID(), (Connection)this.controller.getSettings().getConnection());
            double kusur = 0.0;
            double razlika = 0.0;
            try {
                kusur = this.lastBill.getPaidLastBill() - this.lastBill.getSumWithDiscountLastBill();
                razlika = TimeUnit.SECONDS.convert(new Date().getTime() - this.lastBill.getDateCreatedLastBill().getTime(), TimeUnit.MILLISECONDS);
                if (razlika < 8.0) {
                    String k = Settings.getNumberFormat((int)2, (boolean)true).format(kusur);
                    this.labelBillInfo.setText("Iznos: " + Settings.getNumberFormat((int)2, (boolean)true).format(this.lastBill.getSumWithDiscountLastBill()) + " Kusur: " + k);
                    this.billInfoAnimation = new FadeTransition(Duration.millis((double)1000.0), (Node)this.labelBillInfo);
                    this.billInfoAnimation.setFromValue(0.0);
                    this.billInfoAnimation.setToValue(1.0);
                    this.billInfoAnimation.setAutoReverse(true);
                    this.billInfoAnimation.setCycleCount(8);
                    this.billInfoAnimation.play();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.controller.setBillPrinted(false);
    }

    private double getDiscountInRSD(ArrayList<RoundItem> ri) {
        this.discountDisplay = 0.0;
        for (int i = 0; i < ri.size(); ++i) {
            double pPrice = ri.get(i).getProductDepartment().getProduct().getPrice();
            double pDiscount = ri.get(i).getProductDepartment().getProduct().getDiscount() / 100.0;
            double pQuantity = ri.get(i).getQuantity();
            this.discountDisplay += pPrice * pDiscount * pQuantity;
        }
        return this.discountDisplay;
    }

    @FXML
    private void quickGroupNazad() {
    }

    @FXML
    private void detaljnaPretragaAction() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        int res = this.controller.showModalDialog("Filtriraj", ScreensController.DIALOG_FILTER_PRODUCT_NEW, hm, this.rootPane.getScene().getWindow());
        if (res == ScreensController.MODAL_RESULT_OK) {
            this.productCategoryIDS = (String)hm.get("productCategoryIDS");
            this.vatIDS = (String)hm.get("vatIDS");
            this.popustDozvoljen = (String)hm.get("popustDozvoljen");
            this.merljiv = (String)hm.get("merljiv");
            this.tezinski = (String)hm.get("tezinski");
            this.hashMap = (HashMap)hm.get("hashMap");
            this.fillProductTable();
        }
    }

    private void fillProductTable() {
        this.tableProducts.getSelectionModel().clearSelection();
        this.currentTableList = Product.getFilteredDetailsListNew((String)(this.productCategoryIDS.equals("") ? "-1" : this.productCategoryIDS.substring(0, this.productCategoryIDS.length() - 1)), (String)(this.vatIDS.equals("") ? "-1" : this.vatIDS.substring(0, this.vatIDS.length() - 1)), (String)this.popustDozvoljen, (String)this.merljiv, (String)this.tezinski, this.hashMap, (ScreensController)this.controller);
        this.populateTable();
        this.tableProducts.setItems(this.currentTableList);
        this.tfFilter.requestFocus();
    }

    private void populateLableGuest() {
        try {
            if (((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getLoyality() == null) {
                this.labelGuest.setText(" Kupac: " + ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getName() + "\n Popust: " + Settings.getNumberFormat((int)2, (boolean)true).format(((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson().getDiscount()) + "%");
            } else {
                Person person = ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson();
                double points = 0.0;
                if (person.getLoyality() != null) {
                    points = person.getLoyality().getPoints();
                }
                this.labelGuest.setText(" Kupac: " + (person.getPersonTypeID() == 2 ? person.getName() : person.getFirstLastName()) + "\n Popust: " + Settings.getNumberFormat((int)2, (boolean)true).format(person.getDiscount()) + "% \n" + (points > 0.0 ? " Bodovi :" + points : ""));
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            this.labelGuest.setText("");
        }
    }

    private void fillTable() {
        this.tableProducts.setItems(this.currentTableList);
        this.tfFilter.setText("");
    }

    private void openCashBox() {
        FiscalPrinter.openCassBox((ScreensController)this.controller);
    }

    @FXML
    private void getScaleWeight() {
        System.out.println("ajde da ga merimo");
        SerialPortComunicator portComunicator = new SerialPortComunicator("COM3");
    }

    private void azurirajArtikleICeneSAP() {
        ArrayList products;
        block22: {
            products = new ArrayList();
            try {
                List<Product> materials = this.communicator.getMaterialListFromSAP();
                if (materials == null) break block22;
                products = Product.getList((Connection)this.controller.getSettings().getConnection());
                HashSet<Product> setForInsert = new HashSet<Product>();
                boolean match = false;
                for (Product material : materials) {
                    for (Product product : products) {
                        if (material.getCode() != product.getCode()) continue;
                        match = true;
                    }
                    if (match) continue;
                    setForInsert.add(material);
                }
                if (setForInsert.isEmpty()) break block22;
                for (Product newProduct : setForInsert) {
                    Long productId = null;
                    newProduct.setActive(true);
                    if (newProduct.updateByCode(this.controller) == 0) {
                        productId = newProduct.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
                    }
                    if (productId == null) {
                        productId = newProduct.getProductID();
                    }
                    try {
                        ProductDepartment pd = new ProductDepartment();
                        pd.setDepartmentID(1);
                        pd.setProductID(productId.longValue());
                        pd.setSort(0);
                        pd.setActive(true);
                        pd.setMax(0L);
                        pd.setMin(0L);
                        pd.setWarehouseID(0);
                        pd.setPrinterID(0);
                        pd.setKitchenDisplayID(0);
                        LOGGER.info("InsertProductDepartmenta");
                        pd.insert(this.controller.getSettings().getConnection());
                    }
                    catch (Exception e) {
                        LOGGER.info("Greska prilikom inserta u productDepartment" + e.getMessage());
                    }
                    try {
                        Barcode barcode = new Barcode();
                        barcode.setBarCode(newProduct.getBarcode());
                        barcode.setProductID(new Long(newProduct.getBarcode()).longValue());
                        barcode.setIsWeight(Boolean.valueOf(false));
                        LOGGER.info("InsertBarkoda");
                        barcode.insertNewBarCode(this.controller.getSettings().getConnection());
                    }
                    catch (Exception e) {
                        LOGGER.info("Greska prilikom inserta u barcode" + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.info("Greska prilikom popunjavanja materijala");
            }
        }
        products = Product.getList((Connection)this.controller.getSettings().getConnection());
        List<PriceListDetailes> priceLists = this.communicator.getPricelistDetailsFromSAP();
        LOGGER.info("bosanova");
        if (priceLists != null) {
            ObservableList lastPriceLists = PriceListDetailes.getLastPriceList((Connection)this.controller.getSettings().getConnection());
            HashSet<PriceListDetailes> setForUpdate = new HashSet<PriceListDetailes>();
            for (PriceListDetailes lpl : lastPriceLists) {
                LOGGER.info("\nELEMENTI stare PriceListDetails:" + lpl.toString());
            }
            for (PriceListDetailes lpl : priceLists) {
                LOGGER.info("\nELEMENTI NOVE PriceListDetails:" + lpl.toString());
            }
            for (PriceListDetailes newPL : priceLists) {
                boolean identicalAsStoredInDB = false;
                for (PriceListDetailes currentPL : lastPriceLists) {
                    LOGGER.info("Da li su isti kodovi nove i stare" + newPL.getCode() + " " + currentPL.getCode());
                    if (!newPL.getCode().equals(currentPL.getCode())) continue;
                    LOGGER.info("\nIsta je kao stara po kodu");
                    if (!newPL.getPrice().equals(currentPL.getPrice())) {
                        LOGGER.info("\nNije ista po ceni - treba da je insertujemo");
                        newPL.setPriceListID(currentPL.getPriceListID());
                        newPL.setProductID(currentPL.getProductID());
                        setForUpdate.add(newPL);
                        continue;
                    }
                    LOGGER.info("\nIsta je i po ceni - ne insertujemo je");
                    identicalAsStoredInDB = true;
                    break;
                }
                if (identicalAsStoredInDB) continue;
                LOGGER.info("\nPRICELISTFORINSERT" + newPL.toString());
                for (Product p : products) {
                    if (!newPL.getCode().equals(p.getCode())) continue;
                    LOGGER.info("\ncode: " + newPL.getCode() + " productId: " + p.getProductID());
                    newPL.setProductID(new Long(p.getProductID()));
                    break;
                }
                setForUpdate.add(newPL);
            }
            if (!setForUpdate.isEmpty()) {
                for (PriceListDetailes priceDetails : setForUpdate) {
                    try {
                        LOGGER.info("\nSETFORINSERT" + priceDetails.toString());
                        PriceListDetailes.insertProductPrice((long)priceDetails.getProductID(), (double)priceDetails.getPrice(), (Connection)this.controller.getSettings().getConnection());
                    }
                    catch (Exception e) {
                        LOGGER.info("Greska prilikom inserta u pricelistdetails" + e.getMessage());
                    }
                }
            }
        }
        isSAPUpdateOngoing = false;
    }
}

