/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.reports.models;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AditionalFieldSalesReportModel {
    private String barcode;
    private String productName;
    private String aditionalField;
    private String aditionalFieldDetailName;
    private double quantity;
    private double price;
    private double value;
    private double valuePerAditionalFieldDetail;
    XSSFWorkbook articleWb;
    XSSFCellStyle style;

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getAditionalFieldDetailName() {
        return this.aditionalFieldDetailName;
    }

    public void setAditionalFieldDetailName(String aditionalFieldDetailName) {
        this.aditionalFieldDetailName = aditionalFieldDetailName;
    }

    public String getAditionalField() {
        return this.aditionalField;
    }

    public void setAditionalField(String aditionalField) {
        this.aditionalField = aditionalField;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValuePerAditionalFieldDetail() {
        return this.valuePerAditionalFieldDetail;
    }

    public void setValuePerAditionalFieldDetail(double valuePerAditionalFieldDetail) {
        this.valuePerAditionalFieldDetail = valuePerAditionalFieldDetail;
    }

    public ObservableList<AditionalFieldSalesReportModel> getAfdSumary(Connection connection, Date dateFrom, Date dateTo, String afName, String afdNames) {
        ObservableList sumary = FXCollections.observableArrayList();
        java.sql.Date from = new java.sql.Date(dateFrom.getTime());
        java.sql.Date to = new java.sql.Date(dateTo.getTime());
        String query = "SELECT afd.Name  AS afdName, \r\nsum(ROUND((dd.Quantity * dd.PriceWithDiscount),2)) AS valuePerAfd \r\nFROM  documentdetails dd \r\nJOIN document d ON dd.DocumentID = d.DocumentID \r\nJOIN product p ON dd.ProductID = p.ProductID \r\nJOIN aditionalfielddetailsproduct afdp ON dd.ProductID = afdp.ProductID \r\nJOIN aditionalfielddetails afd ON afdp.AditionalFieldDetailsID = afd.AditionalFieldDetailsID \r\nJOIN aditionalfield af ON afd.AditionalFieldID = af.AditionalFieldID WHERE d.DocumentTypeID = 3 and d.DocumentStatusID=1 \r\nAND af.Name = ?\r\nAND afd.Name IN (" + afdNames + ")\r\nAND  d.WorkDayID BETWEEN \r\n(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date >= ? order by wd.WorkDayID LIMIT 1) \r\nAND (SELECT wd.WorkDayID FROM workday wd WHERE wd.Date <= ? order BY wd.WorkDayID DESC LIMIT 1)\r\ngroup BY\tafd.Name ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, afName);
            ps.setDate(2, from);
            ps.setDate(3, to);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AditionalFieldSalesReportModel model = new AditionalFieldSalesReportModel();
                model.setAditionalFieldDetailName(rs.getString("afdName"));
                model.setValuePerAditionalFieldDetail(rs.getDouble("valuePerAfd"));
                sumary.add((Object)model);
            }
            return sumary;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ObservableList<AditionalFieldSalesReportModel> getAfdReportData(Connection connection, Date dateFrom, Date dateTo, String afName) {
        ObservableList reportData = FXCollections.observableArrayList();
        java.sql.Date from = new java.sql.Date(dateFrom.getTime());
        java.sql.Date to = new java.sql.Date(dateTo.getTime());
        String query = "SELECT \r\n(SELECT bc.BarCode FROM barcode bc WHERE bc.ProductID = dd.productId order BY bc.BarCodeID LIMIT 1) AS barcode,\r\np.Name AS productName, afd.Name AS afdName, af.Name afName, sum(dd.Quantity) AS Quantity, ROUND(dd.PriceWithDiscount,2) AS price,\r\nROUND((sum(dd.Quantity) * dd.PriceWithDiscount),2) AS sellValue \r\nFROM  documentdetails dd JOIN document d ON dd.DocumentID = d.DocumentID \r\nJOIN product p ON dd.ProductID = p.ProductID \r\nJOIN aditionalfielddetailsproduct afdp ON dd.ProductID = afdp.ProductID \r\nJOIN aditionalfielddetails afd ON afdp.AditionalFieldDetailsID = afd.AditionalFieldDetailsID \r\nJOIN aditionalfield af ON afd.AditionalFieldID = af.AditionalFieldID WHERE d.DocumentTypeID = 3 and d.DocumentStatusID=1 and \r\naf.Name =? AND  d.WorkDayID BETWEEN \r\n(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date >= ? order by wd.WorkDayID LIMIT 1) AND \r\n(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date <= ? order BY wd.WorkDayID DESC LIMIT 1)\r\ngroup BY dd.productId, dd.PriceWithDiscount\r\norder BY afd.Name";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, afName);
            ps.setDate(2, from);
            ps.setDate(3, to);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AditionalFieldSalesReportModel model = new AditionalFieldSalesReportModel();
                model.setBarcode(rs.getString("barcode"));
                model.setProductName(rs.getString("productName"));
                model.setAditionalFieldDetailName(rs.getString("afdName"));
                model.setAditionalField(rs.getString("afName"));
                model.setPrice(rs.getDouble("price"));
                model.setQuantity(rs.getDouble("Quantity"));
                model.setValue(rs.getDouble("sellValue"));
                model.setValuePerAditionalFieldDetail(0.0);
                reportData.add((Object)model);
            }
            return reportData;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

