/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.ComboBox;
import rs.petcom.master.dal.person.Person;

public class InputFilterPerson
implements ChangeListener<Person> {
    private ComboBox<Person> box;
    private FilteredList<Person> items;
    private boolean upperCase;
    private int maxLength;
    private String restriction;

    public InputFilterPerson(ComboBox<Person> box, FilteredList<Person> items, boolean upperCase, int maxLength, String restriction) {
        this.box = box;
        this.items = items;
        this.upperCase = upperCase;
        this.maxLength = maxLength;
        this.restriction = restriction;
    }

    public InputFilterPerson(ComboBox<Person> box, FilteredList<Person> items, boolean upperCase, int maxLength) {
        this(box, items, upperCase, maxLength, null);
    }

    public InputFilterPerson(ComboBox<Person> box, FilteredList<Person> items, boolean upperCase) {
        this(box, items, upperCase, -1, null);
    }

    public InputFilterPerson(ComboBox<Person> box, FilteredList<Person> items) {
        this(box, items, false);
    }

    public void changed(ObservableValue<? extends Person> observable, Person oldValue, Person newValue) {
        SimpleStringProperty value = new SimpleStringProperty(newValue.getName());
        String selected = ((Person)this.box.getSelectionModel().getSelectedItem()).getName() != null ? ((Person)this.box.getSelectionModel().getSelectedItem()).getName() : null;
        String selectedString = null;
        if (selected != null) {
            selectedString = selected;
        }
        if (this.upperCase) {
            value.set((Object)((String)value.get()).toUpperCase());
        }
        if (this.maxLength >= 0 && ((String)value.get()).length() > this.maxLength) {
            value.set((Object)oldValue.getName());
        }
        if (this.restriction != null && !((String)value.get()).matches(this.restriction + "*")) {
            value.set((Object)oldValue.getName());
        }
        if (selected != null && ((String)value.get()).equals(selectedString)) {
            Platform.runLater(() -> this.box.getEditor().end());
        } else {
            this.items.setPredicate(arg_0 -> InputFilterPerson.lambda$changed$1((StringProperty)value, arg_0));
        }
        if (!this.box.isShowing()) {
            if (!newValue.getName().equals("") && this.box.isFocused()) {
                this.box.show();
            }
        } else if (this.items.size() == 1) {
            String item;
            String comparableItem = item = ((Person)this.items.get(0)).getName();
            if (((String)value.get()).equals(comparableItem)) {
                Platform.runLater(() -> this.box.hide());
            }
        }
        this.box.getEditor().setText((String)value.get());
    }

    private static /* synthetic */ boolean lambda$changed$1(StringProperty value, Person item) {
        String itemString = item.getName();
        return itemString.toUpperCase().contains(((String)value.get()).toUpperCase());
    }
}

