/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.product.Product;

public class ComboBoxCell
extends TableCell<Object, Product> {
    private ComboBox<Product> comboBox;
    ObservableList<Product> itemsList;
    private ScreensController controller;
    private Department department;
    private String filterType;

    public ComboBoxCell(ObservableList<Product> itemsList) {
        this.itemsList = itemsList;
    }

    public void startEdit() {
        super.startEdit();
        if (this.comboBox == null) {
            this.createComboBox();
        }
        this.setGraphic((Node)this.comboBox);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
    }

    public void commitEdit(Product newValue) {
        super.commitEdit((Object)newValue);
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void updateItem(Product item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.comboBox != null) {
                this.comboBox.setValue((Object)this.getProduct());
            }
            this.setText(this.getString());
            this.setGraphic((Node)this.comboBox);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            this.setText(this.getString());
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }
    }

    private void createComboBox() {
        this.comboBox = new ComboBox(this.itemsList);
        this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.comboBox.setEditable(true);
        this.comboBox.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    ComboBoxCell.this.commitEdit((Product)ComboBoxCell.this.comboBox.getSelectionModel().getSelectedItem());
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    ComboBoxCell.this.cancelEdit();
                }
            }
        });
        new AutoCompleteCBWithoutProducts(this.comboBox, this.controller, this.department.getDepartmentID(), this.filterType, null);
    }

    private Product getProduct() {
        return this.getItem() == null ? new Product() : (Product)this.getItem();
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Product)this.getItem()).getCode() + " " + ((Product)this.getItem()).getName() + " " + ((Product)this.getItem()).getBarcodeLast();
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public void setController(ScreensController controller) {
        this.controller = controller;
    }

    public ScreensController getController() {
        return this.controller;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String getFilterType() {
        return this.filterType;
    }
}

