/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class ComboBoxAutoComplete<T> {
    private ComboBox<T> cmb;
    String filter = "";
    private ObservableList<T> originalItems;
    private TextField editor;
    private int caretPos;
    private boolean moveCaretToPos;
    ComboBoxListViewSkin<T> comboBoxListViewSkin;

    public ComboBoxAutoComplete(ComboBox<T> cmb) {
        this.cmb = cmb;
        this.originalItems = FXCollections.observableArrayList((Collection)cmb.getItems());
        this.editor = cmb.getEditor();
        this.comboBoxListViewSkin = new ComboBoxListViewSkin(cmb);
        this.comboBoxListViewSkin.getPopupContent().addEventFilter(KeyEvent.ANY, event -> {
            if (event.getCode() == KeyCode.SPACE) {
                // empty if block
            }
        });
        cmb.setSkin(this.comboBoxListViewSkin);
        cmb.getEditor().setOnKeyReleased(e -> this.handleOnKeyPressed((KeyEvent)e));
        cmb.setOnHiding(this::handleOnHiding);
        cmb.setOnShowing(this::handleOnShow);
    }

    public void handleOnKeyPressed(KeyEvent e) {
        ObservableList filteredItems = FXCollections.observableArrayList();
        if (e.getCode() == KeyCode.BACK_SPACE) {
            e.consume();
        }
        this.filter = this.editor.getText().toLowerCase();
        for (int i = 0; i < this.originalItems.size(); ++i) {
            if (!this.originalItems.get(i).toString().toLowerCase().contains(this.filter)) continue;
            filteredItems.add(this.originalItems.get(i));
        }
        this.cmb.getItems().clear();
        this.cmb.setItems(filteredItems);
        System.out.println("Pritisnuo dugme");
        System.out.println(this.cmb.getEditor().getText());
        System.out.println(e.getCode());
    }

    private void moveCaret(int textLength) {
    }

    public void handleOnHiding(Event e) {
        System.out.println("Zatvoren kombo");
        this.editor.setEditable(false);
    }

    public void handleOnShow(Event e) {
        System.out.println("Otvoren kombo");
        this.editor.positionCaret(this.cmb.getEditor().getText().length());
        this.filter = "";
        this.cmb.setEditable(true);
        this.editor.setEditable(true);
    }
}

