/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.backoffice.gui.ComboBoxCellFactory;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.BuyerOfferPriceDetailes;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Excise;
import rs.petcom.master.dal.ExciseProduct;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.WarehouseCentral;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.OtpisDetailes;
import rs.petcom.master.dal.document.PrijemnicaDetailes;
import rs.petcom.master.dal.document.VeleprodajnaFaktura;
import rs.petcom.master.dal.document.VeleprodajnaFakturaDetailes;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.AutoCompleteComboBoxListener;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class VeleprodajnaFakturaDetailesControllerTrgovina
implements DialogController {
    ScreensController controller;
    VeleprodajnaFaktura veleprodajnaFaktura;
    int modalResult;
    boolean napomenaVidljiva;
    private ExciseProduct exciseProduct;
    ArrayList<VeleprodajnaFakturaDetailes> deletedItems;
    ObservableList<VeleprodajnaFakturaDetailes> veleprodajnaFakturaDetailesList = FXCollections.observableArrayList();
    ObservableList<VeleprodajnaFakturaDetailes> data = FXCollections.observableArrayList();
    ObservableList<OtpisDetailes> prijemniceDetailsOtpisList = FXCollections.observableArrayList();
    ArrayList<Product> productList;
    BuyerOfferPrice buyerOfferPrice;
    double price = 0.0;
    double sumKolicina = 0.0;
    double sumSum = 0.0;
    double sumPriceWithDiscountWithoutPDV = 0.0;
    double sumVat = 0.0;
    double sumPriceWithDiscount = 0.0;
    Object objekat;
    Department department;
    WarehouseCentral warehouseCentral;
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    Product selectedProduct;
    VeleprodajnaFakturaDetailes vfd;
    ComboBoxCellFactory cbCellFactory;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    double ukupno = 0.0;
    @FXML
    private BorderPane rootPane;
    @FXML
    private GridPane gpNapomena;
    @FXML
    private GridPane gridPaneProduct;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfRabat;
    @FXML
    private TextField tfFakturniRabat;
    @FXML
    private TextField tfPrice;
    @FXML
    private Label labelNapomena;
    @FXML
    private Label lblSumQuantity;
    @FXML
    private Label lblSum;
    @FXML
    private Label lblSumWithDiscount;
    @FXML
    private Label lblSumVat;
    @FXML
    private Label lblRedovnaCena;
    @FXML
    private Label lblRabatUOdnosuNaRedovnuCenu;
    @FXML
    private DateTimePicker dpDate;
    @FXML
    private DateTimePicker dpDeliveryDate;
    @FXML
    private DateTimePicker dpCurrencyDate;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private ComboBox<DocumentStatus> cbStatus;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilter;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnNapomena;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnSacuvaj;
    @FXML
    private Button btnOdustani;
    @FXML
    private Button btnImportCsv;
    @FXML
    private Button btnSacuvajNovo;
    @FXML
    private Button btnNoviProizvod;
    @FXML
    private TextArea taNapomena;
    @FXML
    private TableView<VeleprodajnaFakturaDetailes> tablePrijemniceDetails;
    @FXML
    private TableColumn<java.lang.Object, Product> tcProduct;
    @FXML
    private TableColumn<java.lang.Object, Double> tcQuantity;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPrice;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPriceWithoutVat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcExcise;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPriceWithDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithOutVat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumVat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithVat;
    @FXML
    private TableColumn<PrijemnicaDetailes, String> tcJedinicaMere;
    @FXML
    private TableColumn<PrijemnicaDetailes, Product> tcVat;

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.deletedItems = new ArrayList();
        this.btnRemove.setDisable(false);
        this.controller = (ScreensController)parameter.get("controller");
        this.cbPerson.getItems().addAll((Collection)Person.getListByCategory((String)PersonCategory.BUYER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        new AutoCompleteComboBoxListener(this.cbPerson);
        this.lastDocumentLockDate = (LocalDate)parameter.get("lastDocumentLockDate");
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.cbStatus.setItems(DocumentStatus.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbStatus.setOnKeyPressed(event -> {
            if (event.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                // empty if block
            }
        });
        this.cbFilter.getItems().addAll((java.lang.Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilter.getSelectionModel().selectFirst();
        this.cbFilter.setOnAction(actionEvent -> {
            this.cbProductAutoComplete.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
            this.cbCellFactory.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
        });
        this.objekat = (Object)parameter.get("object");
        this.department = (Department)parameter.get("department");
        this.warehouseCentral = (WarehouseCentral)parameter.get("warehouseCentral");
        this.veleprodajnaFaktura = (VeleprodajnaFaktura)parameter.get("veleprodajnaFaktura");
        this.tfNumber.setText(String.valueOf(this.veleprodajnaFaktura.getNumber()));
        this.dpDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.veleprodajnaFaktura.getDate()));
        this.dpDate.valueProperty().addListener((observable, oldDate, newDate) -> {
            if (this.documentLockIsActive && (newDate.isEqual(this.lastDocumentLockDate) || newDate.isBefore(this.lastDocumentLockDate))) {
                this.dpDate.setValue((java.lang.Object)this.lastDocumentLockDate.plusDays(1L));
                this.controller.alert("Upozorenje", "Ne mo\u017eete izabrati datum za koji su zaklju\u010dani dokumenti ", this.rootPane.getScene().getWindow());
            }
            this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)28, (Department)this.department, (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDate.getValue()))));
        });
        this.dpDeliveryDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.veleprodajnaFaktura.getDeliveryDate()));
        this.dpCurrencyDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.veleprodajnaFaktura.getPaymentDate()));
        this.setBuyer(this.veleprodajnaFaktura.getBuyer());
        this.setStatus(this.veleprodajnaFaktura.getDocumentStatus());
        this.taNapomena.setText(this.veleprodajnaFaktura.getNote());
        this.vfd = new VeleprodajnaFakturaDetailes();
        this.productList = new ArrayList();
        this.cbCellFactory = new ComboBoxCellFactory((ObservableList<Product>)FXCollections.observableArrayList(this.productList), this.controller, this.department, ScreensController.FILTER_ALL);
        this.tcProduct.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcProduct.setCellFactory((Callback)this.cbCellFactory);
        this.tcProduct.setOnEditCommit(cellEditEvent -> {
            Product selectedTableProduct = (Product)cellEditEvent.getNewValue();
            VeleprodajnaFakturaDetailes selectedTablePrij = (VeleprodajnaFakturaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setProduct(selectedTableProduct);
            selectedTablePrij.setProductID(selectedTableProduct.getProductID());
            selectedTablePrij.setPrice(selectedTableProduct.getPrice());
            selectedTablePrij.setProductCode(selectedTableProduct.getCode());
            selectedTablePrij.setProductName(selectedTableProduct.getName());
            selectedTablePrij.setVatValue(selectedTableProduct.getVatValue());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.tcJedinicaMere.setCellValueFactory((Callback)new PropertyValueFactory("jedinicaMere"));
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
                this.selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
            }
            try {
                if (this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex()) != null) {
                    this.buyerOfferPrice = BuyerOfferPrice.getOfferPrice((long)((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex())).getBuyerOfferPriceID(), (Connection)this.controller.getSettings().getConnection());
                }
                if (this.buyerOfferPrice.getBuyerOfferPriceID() != null) {
                    this.price = BuyerOfferPriceDetailes.getRoundActive((long)this.selectedProduct.getProductID(), (long)this.buyerOfferPrice.getBuyerOfferPriceID(), (Connection)this.controller.getSettings().getConnection()).getPrice();
                }
                this.vfd.setProduct(this.selectedProduct);
                this.vfd.setProductID(this.selectedProduct.getProductID());
                this.vfd.setProductCode(this.selectedProduct.getCode());
                this.vfd.setProductName(this.selectedProduct.getName());
                this.vfd.setPrice(Product.getCurrentPrice((long)this.selectedProduct.getProductID(), (long)this.department.getDepartmentID(), (boolean)false, (Connection)this.controller.getSettings().getConnection()));
                this.vfd.setVatValue(this.selectedProduct.getVatValue() == 0.0 ? 1.0 : this.selectedProduct.getVatValue());
                this.vfd.setPriceWithoutVat(this.vfd.getPrice() / this.vfd.getVatValue());
                this.vfd.setPrice(this.vfd.getPriceWithoutVat());
                if (this.price != 0.0) {
                    this.vfd.setPriceWithDiscount(this.price - this.price * this.vfd.getDiscount() / 100.0);
                } else {
                    this.vfd.setPriceWithDiscount(this.vfd.getPrice() - this.vfd.getPrice() * this.vfd.getDiscount() / 100.0);
                    this.vfd.setDiscount(this.vfd.getDiscount());
                }
                this.vfd.setJedinicaMere(Unit.getUnitById((int)this.selectedProduct.getUnitID(), (Connection)this.controller.getSettings().getConnection()).getCode());
                this.exciseProduct = ExciseProduct.getByProductId((Connection)this.controller.getSettings().getConnection(), (long)this.selectedProduct.getProductID());
                this.tfPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.vfd.getPriceWithoutVat()));
                this.vfd.setExciseValue(Excise.getById((ScreensController)this.controller, (long)this.exciseProduct.getExciseId()).getValue() * this.exciseProduct.getValue());
                this.lblRedovnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.vfd.getPrice()));
                this.lblRabatUOdnosuNaRedovnuCenu.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.vfd.getDiscount()));
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        });
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, this.department.getDepartmentID(), ScreensController.FILTER_ALL, this.tfQuantity);
        this.veleprodajnaFakturaDetailesList = VeleprodajnaFakturaDetailes.getlist((VeleprodajnaFaktura)this.veleprodajnaFaktura, (long)this.department.getDepartmentID(), (ScreensController)this.controller);
        for (VeleprodajnaFakturaDetailes veleprodajnaFakturaDetailes : this.veleprodajnaFakturaDetailesList) {
            this.tablePrijemniceDetails.getItems().add((java.lang.Object)veleprodajnaFakturaDetailes);
        }
        this.calculateSum();
        this.tfQuantity.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfQuantity.setText("");
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && VeleprodajnaFakturaDetailesControllerTrgovina.this.tfQuantity.getText().equals("")) {
                    event.consume();
                    VeleprodajnaFakturaDetailesControllerTrgovina.this.cbProduct.requestFocus();
                }
            }
        });
        this.tfQuantity.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.vfd.getQuantity()) + "");
            }
        });
        this.tfQuantity.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.length() > 0) {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        this.tfQuantity.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (this.tfQuantity.isFocused()) {
                        this.vfd.setQuantity(Settings.getNumberFormat((int)4, (boolean)true).parse((String)newValue).doubleValue());
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.izracunajUkupno();
        });
        this.tfPrice.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfPrice.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && VeleprodajnaFakturaDetailesControllerTrgovina.this.tfQuantity.getText().equals("")) {
                    event.consume();
                    VeleprodajnaFakturaDetailesControllerTrgovina.this.tfQuantity.requestFocus();
                }
            }
        });
        this.tfPrice.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfPrice.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfPrice.isFocused()) {
                    this.vfd.setPrice(Settings.getNumberFormat((int)4, (boolean)true).parse((String)newValue).doubleValue());
                    this.vfd.setPriceWithoutVat(this.vfd.getPrice());
                    this.vfd.setPriceWithDiscount(this.vfd.getPrice());
                    this.vfd.setDiscount(0.0);
                    System.out.println("da li ovde ulazi");
                    this.tfRabat.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.vfd.getDiscount()) + "");
                    this.lblRedovnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.vfd.getPrice()));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfPrice.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.vfd.getPriceWithoutVat()));
                    this.vfd.setPrice(this.vfd.getPriceWithoutVat());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfFakturniRabat.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfFakturniRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfFakturniRabat.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                this.cbProduct.requestFocus();
                keyEvent.consume();
            }
        });
        this.tfFakturniRabat.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfFakturniRabat.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfFakturniRabat.isFocused()) {
                this.vfd.setDiscount(Double.parseDouble(newValue.replace(",", ".")));
                this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.vfd.getDiscount()) + "");
            }
        });
        this.tfFakturniRabat.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfFakturniRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(Double.parseDouble(this.tfFakturniRabat.getText().replace(",", "."))) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfRabat.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfRabat.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfRabat.getText().equals("")) {
                keyEvent.consume();
                this.tfPrice.requestFocus();
            }
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                this.cbProduct.requestFocus();
                this.actionAddPrijemnicaDetails(null);
                keyEvent.consume();
            }
        });
        this.tfRabat.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.vfd.getDiscount()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfRabat.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfRabat.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfRabat.isFocused()) {
                double discount = Double.parseDouble(newValue.replace(",", "."));
                if (this.price != 0.0) {
                    this.vfd.setPrice(this.price);
                    this.vfd.setPrice((this.vfd.getPriceWithDiscount() - this.vfd.getExciseValue()) * this.vfd.getVatValue());
                    this.vfd.setPriceWithDiscount(this.price - this.price * discount / 100.0);
                } else {
                    this.vfd.setPrice((this.vfd.getPriceWithDiscount() - this.vfd.getExciseValue()) * this.vfd.getVatValue());
                    this.vfd.setPriceWithDiscount(this.vfd.getPrice() - this.vfd.getPrice() * discount / 100.0);
                }
                this.vfd.setDiscount(discount);
                this.lblRabatUOdnosuNaRedovnuCenu.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.vfd.getDiscount()));
            }
            this.izracunajUkupno();
        });
        this.deletedItems.clear();
        this.taNapomena.setText(this.veleprodajnaFaktura.getNote());
        this.taNapomena.setFocusTraversable(false);
        this.btnSacuvaj.setFocusTraversable(false);
        this.dpDate.setFocusTraversable(false);
        this.btnOdustani.setFocusTraversable(false);
        this.btnAdd.setFocusTraversable(false);
        this.btnRemove.setFocusTraversable(false);
        this.btnImportCsv.setFocusTraversable(false);
        this.btnSacuvajNovo.setFocusTraversable(false);
        this.btnNoviProizvod.setFocusTraversable(false);
        this.tablePrijemniceDetails.setFocusTraversable(false);
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        this.napomenaVidljiva = true;
        this.toggleNapomena(null);
        this.calculateSum();
        Platform.runLater(() -> this.btnSacuvaj.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvaj.fire()));
        Platform.runLater(() -> this.btnSacuvajNovo.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvajNovo.fire()));
        Platform.runLater(() -> this.btnNoviProizvod.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnNoviProizvod.fire()));
        this.tfFilter.textProperty().addListener((obs, oldValue, newValue) -> this.loadDetails());
        this.cbPerson.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Person>(){

            public void changed(ObservableValue<? extends Person> observable, Person oldValue, Person newValue) {
                if (((Person)VeleprodajnaFakturaDetailesControllerTrgovina.this.cbPerson.getSelectionModel().getSelectedItem()).getPersonID() != -1L) {
                    VeleprodajnaFakturaDetailesControllerTrgovina.this.gridPaneProduct.setDisable(false);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new Date());
                    calendar.add(5, newValue.getCurrencyPaymentDays());
                    VeleprodajnaFakturaDetailesControllerTrgovina.this.dpCurrencyDate.setValue((java.lang.Object)Settings.fromDate((Date)calendar.getTime()));
                } else {
                    VeleprodajnaFakturaDetailesControllerTrgovina.this.dpCurrencyDate.setValue((java.lang.Object)LocalDate.now());
                    VeleprodajnaFakturaDetailesControllerTrgovina.this.gridPaneProduct.setDisable(true);
                }
            }
        });
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        DoubleTableCellFactory cellFactory2 = new DoubleTableCellFactory(2, true);
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit(cellEditEvent -> {
            PrijemnicaDetailes selectedTablePrij = (PrijemnicaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setQuantity(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setPriceWithDiscount(selectedTablePrij.getPurchasePrice() * selectedTablePrij.getVat());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPurchasePrice());
            selectedTablePrij.setSum(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcQuantity);
        this.tcPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcPrice.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcPrice);
        this.tcVat.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcVat.setCellFactory((Callback)new Callback<TableColumn<PrijemnicaDetailes, Product>, TableCell<PrijemnicaDetailes, Product>>(){

            public TableCell<PrijemnicaDetailes, Product> call(TableColumn<PrijemnicaDetailes, Product> param) {
                return new TableCell<PrijemnicaDetailes, Product>(){

                    protected void updateItem(Product item, boolean arg1) {
                        super.updateItem((java.lang.Object)item, arg1);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(item.getVatName());
                        }
                    }
                };
            }
        });
        this.makeHeaderWrappable(this.tcVat);
        this.tcPriceWithoutVat.setCellValueFactory((Callback)new PropertyValueFactory("priceWithoutVat"));
        this.tcPriceWithoutVat.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcPriceWithoutVat);
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)cellFactory2);
        this.tcDiscount.setOnEditCommit(cellEditEvent -> {
            VeleprodajnaFakturaDetailes selectedTablePrij = (VeleprodajnaFakturaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setDiscount(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setPriceWithDiscount(selectedTablePrij.getPrice() * selectedTablePrij.getVatValue());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPriceWithDiscount());
            selectedTablePrij.setSum(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVatValue());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcDiscount);
        this.tcExcise.setCellValueFactory((Callback)new PropertyValueFactory("Excise"));
        this.tcExcise.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcExcise);
        this.tcPriceWithDiscount.setCellValueFactory((Callback)new PropertyValueFactory("PriceWithDiscount"));
        this.tcPriceWithDiscount.setCellFactory((Callback)cellFactory2);
        this.tcPriceWithDiscount.setOnEditCommit(cellEditEvent -> {
            VeleprodajnaFakturaDetailes selectedTablePrij = (VeleprodajnaFakturaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setPriceWithDiscount(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setDiscount(selectedTablePrij.getPrice() - selectedTablePrij.getPriceWithDiscount() * 100.0 / selectedTablePrij.getPrice());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPriceWithDiscount());
            selectedTablePrij.setSum(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVatValue());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcPriceWithDiscount);
        this.tcSumWithOutVat.setCellValueFactory((Callback)new PropertyValueFactory("SumWitoutVat"));
        this.tcSumWithOutVat.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumWithOutVat);
        this.tcSumVat.setCellValueFactory((Callback)new PropertyValueFactory("SumVat"));
        this.tcSumVat.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumVat);
        this.tcSumWithVat.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcSumWithVat.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumWithVat);
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void actionSave(ActionEvent event) {
        try {
            int i;
            this.controller.getSettings().getConnection().setAutoCommit(false);
            this.veleprodajnaFaktura.setNumber(Integer.parseInt(this.tfNumber.getText()));
            this.veleprodajnaFaktura.setDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpDate.getDateTimeValue()));
            this.veleprodajnaFaktura.setDeliveryDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpDeliveryDate.getDateTimeValue()));
            this.veleprodajnaFaktura.setPaymentDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpCurrencyDate.getDateTimeValue()));
            try {
                this.veleprodajnaFaktura.setBuyer((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex()));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.controller.alert("Obavestenje", "Morate odabrati dobavljaca", this.rootPane.getScene().getWindow());
            }
            this.veleprodajnaFaktura.setDocumentStatus((DocumentStatus)this.cbStatus.getSelectionModel().getSelectedItem());
            this.veleprodajnaFaktura.setNote(this.taNapomena.getText());
            try {
                this.veleprodajnaFaktura.setSum(this.sumSum);
                this.veleprodajnaFaktura.setSumWithDiscount(this.sumPriceWithDiscount);
                this.veleprodajnaFaktura.setDiscount(this.sumSum - 100.0 * this.sumPriceWithDiscount / this.sumSum);
            }
            catch (NumberFormatException e1) {
                this.veleprodajnaFaktura.setSum(0.0);
            }
            if (this.veleprodajnaFaktura.getDocumentID() > 0L) {
                this.veleprodajnaFaktura.update(this.controller);
            } else {
                this.veleprodajnaFaktura.insert(this.controller);
            }
            for (i = 0; i < this.deletedItems.size(); ++i) {
                if (this.deletedItems.get(i).getDocumentDetailsID() > 0L) {
                    this.deletedItems.get(i).delete(this.controller);
                    continue;
                }
                this.deletedItems.remove(i);
            }
            for (i = 0; i < this.veleprodajnaFakturaDetailesList.size(); ++i) {
                VeleprodajnaFakturaDetailes tableItem = (VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i);
                if (tableItem.getDocumentDetailsID() > 0L) {
                    if (tableItem.getProduct() == null) continue;
                    tableItem.updateWithDiscount(this.controller);
                    continue;
                }
                if (tableItem.getProduct() == null) continue;
                System.out.println("popust " + tableItem.getDiscount());
                tableItem.setDocumentID(this.veleprodajnaFaktura.getDocumentID());
                tableItem.setNewPrice(tableItem.getPrice());
                tableItem.setPrice(Product.getCurrentPrice((long)tableItem.getProductID(), (long)this.department.getDepartmentID(), (boolean)false, (Connection)this.controller.getSettings().getConnection()));
                Long id = tableItem.insertWithDiscount(this.controller);
                tableItem.setDocumentDetailsID(id.longValue());
            }
            this.controller.getSettings().getConnection().commit();
            if ((Button)event.getSource() == this.btnSacuvajNovo) {
                this.modalResult = ScreensController.MODAL_RESULT_OK_NEW;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            } else {
                this.modalResult = ScreensController.MODAL_RESULT_OK;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            }
        }
        catch (SQLException e) {
            try {
                this.controller.getSettings().getConnection().rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            try {
                this.controller.getSettings().getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionAdd(ActionEvent event) {
    }

    public void actionAddPrijemnicaDetails(ActionEvent event) {
        VeleprodajnaFakturaDetailes veleprodajnaFakturaDetailes = new VeleprodajnaFakturaDetailes();
        veleprodajnaFakturaDetailes.setDocumentDetailsID(-1L);
        veleprodajnaFakturaDetailes.setProduct(this.vfd.getProduct());
        veleprodajnaFakturaDetailes.setJedinicaMere(this.vfd.getJedinicaMere());
        veleprodajnaFakturaDetailes.setProductID(this.vfd.getProductID());
        veleprodajnaFakturaDetailes.setProductCode(this.vfd.getProductCode());
        veleprodajnaFakturaDetailes.setProductName(this.vfd.getProductName());
        veleprodajnaFakturaDetailes.setQuantity(this.vfd.getQuantity());
        veleprodajnaFakturaDetailes.setPrice(this.vfd.getPrice());
        veleprodajnaFakturaDetailes.setPriceWithDiscount(this.vfd.getPriceWithDiscount());
        veleprodajnaFakturaDetailes.setSum(this.vfd.getSum());
        veleprodajnaFakturaDetailes.setDiscount(this.vfd.getDiscount());
        veleprodajnaFakturaDetailes.setExciseValue(this.vfd.getExciseValue());
        veleprodajnaFakturaDetailes.setSumWithDiscount(this.vfd.getQuantity() * this.vfd.getPriceWithDiscount());
        veleprodajnaFakturaDetailes.setVatValue(this.vfd.getVatValue());
        veleprodajnaFakturaDetailes.setPriceWithoutVat(this.vfd.getPriceWithoutVat());
        veleprodajnaFakturaDetailes.setSumWitoutVat(this.vfd.getQuantity() * this.vfd.getPriceWithoutVat() - this.vfd.getQuantity() * this.vfd.getPriceWithoutVat() * this.vfd.getDiscount() / 100.0);
        veleprodajnaFakturaDetailes.setSumVat(veleprodajnaFakturaDetailes.getSumWithDiscount() - veleprodajnaFakturaDetailes.getSumWitoutVat());
        this.veleprodajnaFakturaDetailesList.add((java.lang.Object)veleprodajnaFakturaDetailes);
        this.tfFilter.setText("");
        this.loadDetails();
        this.tablePrijemniceDetails.scrollTo(this.tablePrijemniceDetails.getItems().size() - 1);
        this.calculateSum();
        this.vfd = new VeleprodajnaFakturaDetailes();
        this.cbProduct.getSelectionModel().clearSelection();
        this.tfQuantity.setText("");
        this.vfd.setDiscount(Double.parseDouble(this.tfFakturniRabat.getText().replace(",", ".")));
        this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.vfd.getDiscount()));
        this.tfPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.lblRedovnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.lblRabatUOdnosuNaRedovnuCenu.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
    }

    @FXML
    public void actionNewProduct(ActionEvent event) {
        if (this.department != null) {
            HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
            hm2.put("controller", this.controller);
            this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm2, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.tablePrijemniceDetails.getSelectionModel().getSelectedItem() != null) {
            this.deletedItems.add((VeleprodajnaFakturaDetailes)this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
            this.veleprodajnaFakturaDetailesList.remove(this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
            this.tablePrijemniceDetails.getItems().remove(this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
        }
        this.tfFilter.setText("");
        this.loadDetails();
        this.calculateSum();
    }

    @FXML
    public void toggleNapomena(ActionEvent event) {
        boolean bl = this.napomenaVidljiva = !this.napomenaVidljiva;
        if (this.napomenaVidljiva) {
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(1)).setMaxHeight(100.0);
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(2)).setMaxHeight(10.0);
            this.tablePrijemniceDetails.setPrefHeight(200.0);
            this.taNapomena.setVisible(true);
            this.labelNapomena.setVisible(true);
        } else {
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(1)).setMaxHeight(0.0);
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(2)).setMaxHeight(0.0);
            this.tablePrijemniceDetails.setPrefHeight(300.0);
            this.taNapomena.setVisible(false);
            this.labelNapomena.setVisible(false);
        }
    }

    private void calculateSum() {
        this.sumKolicina = 0.0;
        this.sumSum = 0.0;
        this.sumPriceWithDiscount = 0.0;
        this.sumPriceWithDiscountWithoutPDV = 0.0;
        this.sumVat = 0.0;
        for (VeleprodajnaFakturaDetailes veleprodajnaFakturaDetailes : this.veleprodajnaFakturaDetailesList) {
            this.sumKolicina += veleprodajnaFakturaDetailes.getQuantity();
            this.sumSum += veleprodajnaFakturaDetailes.getPrice() * veleprodajnaFakturaDetailes.getQuantity();
            this.sumPriceWithDiscountWithoutPDV += veleprodajnaFakturaDetailes.getQuantity() * veleprodajnaFakturaDetailes.getPriceWithDiscount() / veleprodajnaFakturaDetailes.getVatValue();
            this.sumPriceWithDiscount += veleprodajnaFakturaDetailes.getQuantity() * veleprodajnaFakturaDetailes.getPriceWithDiscount();
        }
        this.sumVat += this.sumPriceWithDiscount - this.sumPriceWithDiscountWithoutPDV;
        this.lblSumQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.sumKolicina));
        this.lblSum.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.sumPriceWithDiscount));
        this.lblSumWithDiscount.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.sumPriceWithDiscountWithoutPDV));
        this.lblSumVat.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.sumVat));
    }

    private void loadDetails() {
        this.tablePrijemniceDetails.getItems().clear();
        for (int i = 0; i < this.veleprodajnaFakturaDetailesList.size(); ++i) {
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_ALL)) {
                if (!(((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getName().toLowerCase().contains(this.tfFilter.getText().toLowerCase()) || ((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getBarcodeLast() != null && ((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getBarcodeLast().contains(this.tfFilter.getText()) || ((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getCode() != null && ((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getCode().toLowerCase().contains(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
                this.tablePrijemniceDetails.getItems().add(this.veleprodajnaFakturaDetailesList.get(i));
                continue;
            }
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_BARCODE)) {
                if ((((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getBarcodeLast() == null || !((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getBarcodeLast().equals(this.tfFilter.getText())) && !this.tfFilter.getText().equals("")) continue;
                this.tablePrijemniceDetails.getItems().add(this.veleprodajnaFakturaDetailesList.get(i));
                continue;
            }
            if (!((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_CODE) || (((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getCode() == null || !((VeleprodajnaFakturaDetailes)this.veleprodajnaFakturaDetailesList.get(i)).getProduct().getCode().toLowerCase().equals(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
            this.tablePrijemniceDetails.getItems().add(this.veleprodajnaFakturaDetailesList.get(i));
        }
    }

    private void setBuyer(Person dobavlac) {
        if (dobavlac != null) {
            for (Person p : this.cbPerson.getItems()) {
                if (p.getPersonID() != this.veleprodajnaFaktura.getBuyer().getPersonID()) continue;
                this.cbPerson.getSelectionModel().select((java.lang.Object)p);
                break;
            }
        }
    }

    private void setStatus(DocumentStatus status) {
        if (this.veleprodajnaFaktura.getDocumentStatus() == null) {
            this.veleprodajnaFaktura.setDocumentStatus((DocumentStatus)this.cbStatus.getItems().get(0));
        }
        for (DocumentStatus ds : this.cbStatus.getItems()) {
            if (ds.getDocumentStatusID() != this.veleprodajnaFaktura.getDocumentStatus().getDocumentStatusID()) continue;
            this.cbStatus.getSelectionModel().select((java.lang.Object)ds);
            break;
        }
    }

    @FXML
    private void actionImport() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import prijemnice");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((java.lang.Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colQuantity = -1;
                    int colBarcode = -1;
                    int colPrice = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)VeleprodajnaFakturaDetailesControllerTrgovina.this.controller, (long)2L)) {
                                        if (csvImport.getCsvName().equals("Kolicina") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colQuantity = i;
                                        }
                                        if (csvImport.getCsvName().equals("Bar Kod") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colBarcode = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Cena") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                        colPrice = i;
                                    }
                                }
                            } else {
                                Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)VeleprodajnaFakturaDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                if (p != null) {
                                    double priceWithoutVatAndDiscount;
                                    p.getCurrentPrice((long)VeleprodajnaFakturaDetailesControllerTrgovina.this.department.getDepartmentID(), VeleprodajnaFakturaDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                    if (p.getCurrentPrice((long)VeleprodajnaFakturaDetailesControllerTrgovina.this.department.getDepartmentID(), VeleprodajnaFakturaDetailesControllerTrgovina.this.controller.getSettings().getConnection()) == 0.0) {
                                        // empty if block
                                    }
                                    double quantity = 0.0;
                                    quantity = Double.parseDouble(colNames[colQuantity].replace(",", ".").trim());
                                    try {
                                        priceWithoutVatAndDiscount = Double.parseDouble(colNames[colPrice].replace(",", "."));
                                    }
                                    catch (NumberFormatException e) {
                                        priceWithoutVatAndDiscount = Double.parseDouble(colNames[colPrice]);
                                    }
                                    VeleprodajnaFakturaDetailesControllerTrgovina.this.ukupno += quantity * priceWithoutVatAndDiscount;
                                    VeleprodajnaFakturaDetailes veleprodajnaFakturaDetailes = new VeleprodajnaFakturaDetailes();
                                    veleprodajnaFakturaDetailes.setDocumentDetailsID(-1L);
                                    veleprodajnaFakturaDetailes.setProduct(p);
                                    veleprodajnaFakturaDetailes.setProductID(p.getProductID());
                                    veleprodajnaFakturaDetailes.setProductCode(p.getCode());
                                    veleprodajnaFakturaDetailes.setProductName(p.getName());
                                    veleprodajnaFakturaDetailes.setJedinicaMere(Unit.getUnitById((int)p.getUnitID(), (Connection)VeleprodajnaFakturaDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getCode());
                                    veleprodajnaFakturaDetailes.setQuantity(quantity);
                                    veleprodajnaFakturaDetailes.setPrice(priceWithoutVatAndDiscount * p.getVatValue());
                                    veleprodajnaFakturaDetailes.setPriceWithDiscount(priceWithoutVatAndDiscount * p.getVatValue());
                                    veleprodajnaFakturaDetailes.setSum(quantity * priceWithoutVatAndDiscount);
                                    veleprodajnaFakturaDetailes.setDiscount(0.0);
                                    veleprodajnaFakturaDetailes.setSumWithDiscount(quantity * priceWithoutVatAndDiscount);
                                    veleprodajnaFakturaDetailes.setVatValue(p.getVatValue());
                                    VeleprodajnaFakturaDetailesControllerTrgovina.this.veleprodajnaFakturaDetailesList.add((java.lang.Object)veleprodajnaFakturaDetailes);
                                } else {
                                    unexistedProducts.add(colNames[colBarcode]);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.loadDetails();
                this.calculateSum();
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    public ComboBox<DocumentStatus> getCbStatus() {
        return this.cbStatus;
    }

    private void izracunajUkupno() {
        this.vfd.setSum(this.vfd.getPrice() * this.vfd.getQuantity());
        this.vfd.setSumWithDiscount(this.vfd.getSumWithDiscount() * this.vfd.getQuantity());
    }

    private void makeHeaderWrappable(TableColumn<?, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((java.lang.Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }
}

