/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.backoffice.controller.document.DocumentLocker;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.document.VeleprodajnaFaktura;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class VeleprodajnaFakturaControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Svi objekti");
    private DocumentType documentType;
    private DocumentLocker docLocker;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private TableView<VeleprodajnaFaktura> table;
    @FXML
    private TableColumn<VeleprodajnaFaktura, Integer> tcBroj;
    @FXML
    private TableColumn<VeleprodajnaFaktura, Date> tcDate;
    @FXML
    private TableColumn<VeleprodajnaFaktura, Date> tcDeliveryDate;
    @FXML
    private TableColumn<VeleprodajnaFaktura, Person> tcPerson;
    @FXML
    private TableColumn<VeleprodajnaFaktura, String> tcZakljucan;
    @FXML
    private Label lblZakljucaniDokumentiUpozorenje;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnPrintEnglish;
    @FXML
    private Button btnDelete;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        Person p = new Person();
        p.setPersonID(-1L);
        p.setName("Svi kupci");
        this.cbPerson.getItems().add((Object)p);
        this.cbPerson.getItems().addAll((Collection)Person.getListByCategory((String)PersonCategory.BUYER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        this.cbPerson.getSelectionModel().selectFirst();
        this.cbObject.getItems().add((Object)this.sviObjekti);
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((Object)this.sviObjekti);
        }
        this.dpDateFrom.setValue((Object)LocalDate.now());
        this.dpDateTo.setValue((Object)LocalDate.now());
        this.loadDocumentList();
        this.documentType = DocumentType.getByCode((String)"VPF", (Connection)this.controller.getSettings().getConnection());
    }

    public void setParameter(Object parameter) {
        this.docLocker = new DocumentLocker(this.controller);
        this.lastDocumentLockDate = this.docLocker.getLastLockedDocumentDate();
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
                VeleprodajnaFakturaControllerTrgovina.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                VeleprodajnaFakturaControllerTrgovina.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<VeleprodajnaFaktura>(){

            public void changed(ObservableValue<? extends VeleprodajnaFaktura> observable, VeleprodajnaFaktura oldValue, VeleprodajnaFaktura newValue) {
                if (newValue == null) {
                    VeleprodajnaFakturaControllerTrgovina.this.btnDelete.setDisable(true);
                    VeleprodajnaFakturaControllerTrgovina.this.btnPrint.setDisable(true);
                    VeleprodajnaFakturaControllerTrgovina.this.btnPrintEnglish.setDisable(true);
                    VeleprodajnaFakturaControllerTrgovina.this.btnEdit.setDisable(true);
                } else if (VeleprodajnaFakturaControllerTrgovina.this.documentLockIsActive && newValue.isLocked()) {
                    VeleprodajnaFakturaControllerTrgovina.this.btnDelete.setDisable(true);
                    VeleprodajnaFakturaControllerTrgovina.this.btnPrint.setDisable(false);
                    VeleprodajnaFakturaControllerTrgovina.this.btnEdit.setDisable(true);
                    VeleprodajnaFakturaControllerTrgovina.this.btnPrintEnglish.setDisable(false);
                    VeleprodajnaFakturaControllerTrgovina.this.lblZakljucaniDokumentiUpozorenje.setVisible(true);
                } else {
                    VeleprodajnaFakturaControllerTrgovina.this.btnDelete.setDisable(false);
                    VeleprodajnaFakturaControllerTrgovina.this.btnPrint.setDisable(false);
                    VeleprodajnaFakturaControllerTrgovina.this.btnPrintEnglish.setDisable(false);
                    VeleprodajnaFakturaControllerTrgovina.this.btnEdit.setDisable(false);
                    VeleprodajnaFakturaControllerTrgovina.this.lblZakljucaniDokumentiUpozorenje.setVisible(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("date"));
        this.tcDeliveryDate.setCellValueFactory((Callback)new PropertyValueFactory("paymentDate"));
        this.tcPerson.setCellValueFactory((Callback)new PropertyValueFactory("buyer"));
        this.tcDate.setCellFactory(column -> new TableCell<VeleprodajnaFaktura, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDeliveryDate.setCellFactory(column -> new TableCell<VeleprodajnaFaktura, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.actionEdit(null);
                }
            });
            return row;
        });
        this.tcZakljucan.setCellValueFactory(cellValue -> {
            boolean isLocked = ((VeleprodajnaFaktura)cellValue.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
    }

    @FXML
    public void actionNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        if (this.cbDepartment.getSelectionModel().getSelectedItem() != null) {
            VeleprodajnaFaktura veleprodajnaFaktura = new VeleprodajnaFaktura();
            veleprodajnaFaktura.setDocumentID(-1L);
            veleprodajnaFaktura.setDocumentTypeId(this.documentType.getDocumentTypeID());
            veleprodajnaFaktura.setNumber(Document.getNextNumber((int)this.documentType.getDocumentTypeID(), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDateFrom.getValue())));
            veleprodajnaFaktura.setBuyer(null);
            veleprodajnaFaktura.setDate(new Date());
            veleprodajnaFaktura.setDeliveryDate(new Date());
            veleprodajnaFaktura.setPaymentDate(new Date());
            veleprodajnaFaktura.setDepartmentID(((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            veleprodajnaFaktura.setNote("");
            hm.put("veleprodajnaFaktura", veleprodajnaFaktura);
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("lastDocumentLockDate", this.lastDocumentLockDate);
            int result = this.controller.showModalDialog("Veleprodajna faktura - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_VELEPRODAJNA_FAKTURA_DETAILES_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                this.loadDocumentList();
                this.actionNew(event);
            }
        } else {
            this.controller.alert("Obave\u0161tenje", "Izaberite odeljenje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("veleprodajnaFaktura", this.table.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Veleprodajna faktura - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_VELEPRODAJNA_FAKTURA_DETAILES_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                this.loadDocumentList();
                this.actionNew(event);
            }
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            Faktura faktura = new Faktura();
            faktura.setDocument(Document.getByID((long)((VeleprodajnaFaktura)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
            if (((VeleprodajnaFaktura)this.table.getSelectionModel().getSelectedItem()).getWithExcise(this.controller)) {
                faktura.printVeleprodajnaFaktura(this.controller, this.rootPane.getScene().getWindow());
            } else {
                faktura.printVeleprodajnaFakturaBezAkciza(this.controller, this.rootPane.getScene().getWindow());
            }
        }
    }

    @FXML
    public void actionPrintEnglish(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            Faktura faktura = new Faktura();
            faktura.setDocument(Document.getByID((long)((VeleprodajnaFaktura)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
            faktura.printEnglishVeleprodajnaFaktura(this.controller, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionPrintStickers(ActionEvent event) {
        String reportFileName = "rs/petcom/backoffice/jasper/stikeri/StikeriKalkulacija.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        Document document = Document.getByID((long)((VeleprodajnaFaktura)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        hm.put("documentId", document.getDocumentID());
        hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Stikeri", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            if (this.table.getSelectionModel().getSelectedItem() != null) {
                for (DocumentDetails dd : DocumentDetails.getList((long)((VeleprodajnaFaktura)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                    dd.delete(this.controller.getSettings().getConnection());
                }
                ((VeleprodajnaFaktura)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
            }
        }
        catch (SQLException e) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje prijemnice nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje prijemnice nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)d);
        }
        if (!this.cbDepartment.getItems().isEmpty()) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    @FXML
    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(VeleprodajnaFaktura.getList((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (long)((Person)this.cbPerson.getSelectionModel().getSelectedItem()).getPersonID(), (ScreensController)this.controller));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void actionExport() {
    }
}

