/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Person;

public class ProfakturaSelectDialogTrgovinaController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameter;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<Document> tableProfaktura;
    @FXML
    private TableColumn<Document, Integer> columnNumber;
    @FXML
    private TableColumn<Document, Long> columnPerson;
    @FXML
    private TableColumn<Document, String> columnNote;
    @FXML
    private TableColumn<Document, Double> columnValue;
    @FXML
    private TextField tfFilter;
    private Person selectedPerson;

    public void initialize() {
        this.columnNumber.setCellValueFactory((Callback)new PropertyValueFactory("number"));
        this.columnPerson.setCellValueFactory((Callback)new PropertyValueFactory("personID"));
        this.columnPerson.setCellFactory(column -> new TableCell<Document, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    Person person = Person.getById((long)item, (ScreensController)ProfakturaSelectDialogTrgovinaController.this.controller);
                    this.setText(!person.getName().equals("") ? person.getName() : person.getFirstLastName());
                }
            }
        });
        this.columnNote.setCellValueFactory((Callback)new PropertyValueFactory("note2"));
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("sumWithDiscount"));
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedPerson = (Person)parameter.get("aktivniKupac");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        for (Document doc : Document.getProfakturaToReserveList((int)DocumentType.getByCode((String)"PROF", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID(), (boolean)false, (boolean)false, (ScreensController)this.controller)) {
            if (this.selectedPerson != null) {
                if (this.selectedPerson.getPersonID() != doc.getPersonID()) continue;
                this.tableProfaktura.getItems().add((Object)doc);
                continue;
            }
            this.tableProfaktura.getItems().add((Object)doc);
        }
        this.filter();
    }

    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void confirm() {
        if (this.tableProfaktura.getSelectionModel().getSelectedItem() != null) {
            this.parameter.put("selectedProfaktura", this.tableProfaktura.getSelectionModel().getSelectedItem());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        } else {
            this.controller.alert("Obavestenje", "Odaberite profakturu iz tabele", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void cancel() {
        this.parameter.put("selectedProfaktura", null);
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tableProfaktura.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(document -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            Person person = Person.getById((long)document.getPersonID(), (ScreensController)this.controller);
            if (person != null && person.getName().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return person != null && person.getFirstLastName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableProfaktura.comparatorProperty());
        this.tableProfaktura.setItems((ObservableList)sortedData);
    }
}

