/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.sql.SQLException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.dal.product.ProductGroup;
import rs.petcom.master.dal.product.ProductGroupType;

public class ProductGroupControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    ObservableList<ProductDepartment> productDepartments;
    ObservableList<Product> products;
    ObservableList<Product> productsForPrint;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<ProductGroupType> tableGroupType;
    @FXML
    private TableColumn<ProductGroupType, Integer> tcGroupTypeID;
    @FXML
    private TableColumn<ProductGroupType, String> tcGroupTypeName;
    @FXML
    private TableView<ProductGroup> tableGroup;
    @FXML
    private TableColumn<ProductGroup, Integer> tcGroupID;
    @FXML
    private TableColumn<ProductGroup, String> tcGroupName;
    @FXML
    private Button btnDelete;
    @FXML
    private TextField tfGroup;
    @FXML
    private TextField tfGroupType;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.getItems().add((Object)this.sviObjekti);
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((Object)this.sviObjekti);
        }
        this.loadGroupType();
    }

    public void setParameter(Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
                ProductGroupControllerTrgovina.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
            }
        });
        this.productsForPrint = FXCollections.observableArrayList();
        this.tcGroupTypeID.setCellValueFactory((Callback)new PropertyValueFactory("ProductGroupTypeID"));
        this.tcGroupTypeID.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcGroupTypeName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcGroupTypeName.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcGroupID.setCellValueFactory((Callback)new PropertyValueFactory("ProductGroupID"));
        this.tcGroupID.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcGroupName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcGroupName.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tableGroupType.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<ProductGroupType>(){

            public void onChanged(ListChangeListener.Change<? extends ProductGroupType> arg0) {
                ProductGroupControllerTrgovina.this.loadGroup();
            }
        });
    }

    @FXML
    public void actionAdd(ActionEvent event) {
        if (!this.tfGroupType.getText().equals("")) {
            ProductGroupType pgt = new ProductGroupType();
            pgt.setName(this.tfGroupType.getText());
            try {
                pgt.insert(this.controller.getSettings().getConnection());
                this.refreshGroupType();
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no dodato polje", this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionAddGroup(ActionEvent event) {
        if (!this.tfGroup.getText().equals("") && this.tableGroupType.getSelectionModel().getSelectedItem() != null) {
            ProductGroup pg = new ProductGroup();
            pg.setProductGroupTypeID(((ProductGroupType)this.tableGroupType.getSelectionModel().getSelectedItem()).getProductGroupTypeID());
            pg.setName(this.tfGroup.getText());
            try {
                pg.insert(this.controller.getSettings().getConnection());
                this.refreshGroup();
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no dodata vrednost: " + e.getMessage(), this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionDeleteGroup(ActionEvent event) {
        if (this.tableGroup.getSelectionModel().getSelectedItem() != null) {
            try {
                ((ProductGroup)this.tableGroup.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.refreshGroup();
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no obrisano polje: " + e.getMessage(), this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        if (this.tableGroupType.getSelectionModel().getSelectedItem() != null) {
            try {
                ((ProductGroupType)this.tableGroupType.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.refreshGroupType();
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no obrisano polje: " + e.getMessage(), this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)d);
        }
        if (this.cbDepartment.getItems().size() == 1) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    @FXML
    private void loadGroupType() {
        this.tableGroupType.setItems(ProductGroupType.getList((Connection)this.controller.getSettings().getConnection()));
    }

    private void loadGroup() {
        this.tableGroup.getItems().clear();
        try {
            this.tableGroup.setItems(ProductGroup.getListByProductGroupTypeID((int)((ProductGroupType)this.tableGroupType.getSelectionModel().getSelectedItem()).getProductGroupTypeID(), (Connection)this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void refreshGroupType() {
        this.tfGroupType.setText("");
        this.tableGroupType.getSelectionModel().clearSelection();
        this.loadGroupType();
        this.tableGroupType.refresh();
    }

    private void refreshGroup() {
        this.tfGroup.setText("");
        this.tableGroup.getSelectionModel().clearSelection();
        this.loadGroup();
        this.tableGroup.refresh();
    }
}

