/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Year;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import rs.petcom.backoffice.controller.document.DocumentLocker;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.fical.FiscalPrinter;

public class PregledOtpremnicaTrgovinaController
implements ControlledScreen {
    private ScreensController controller;
    private DocumentType docType;
    private ObservableList<Document> documentList;
    private ObservableList<DocumentDetails> listDetailsFaktura = FXCollections.observableArrayList();
    private Document otpremnicaFaktura;
    private Document otpremnicaBill;
    private long personId;
    private long cashbuyerId;
    private HashMap<String, Object> hm;
    private PaymentMethod paymentMethod;
    private DocumentLocker docLocker;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<Document> documentsTable;
    @FXML
    private TableColumn<Document, Integer> tcDocBroj;
    @FXML
    private TableColumn<Document, Date> tcDocDatum;
    @FXML
    private TableColumn<Document, String> tcDocKomitent;
    @FXML
    private TableColumn<Document, String> tcZakljucan;
    @FXML
    private TableColumn<Document, Double> tcDocVrednost;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnInvoice;
    @FXML
    private Button btnCSV;
    @FXML
    private Button btnDelete;
    @FXML
    private TextField tfFilter;
    @FXML
    DatePicker dpWorkDayFrom;
    @FXML
    DatePicker dpWorkDayTo;
    @FXML
    private CheckBox cbFakturisaneOtpremnice;
    @FXML
    private CheckBox cbNefiskalnaStampa;
    @FXML
    private VBox actionPanel;
    @FXML
    private Label lblZakljucaniDokumentiUpozorenje;

    public void initialize() {
        this.tcDocBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDocDatum.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDocDatum.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDocKomitent.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    Person person = Person.getById((long)((Document)param.getValue()).getPersonID(), (ScreensController)PregledOtpremnicaTrgovinaController.this.controller);
                    return new JavaBeanStringPropertyBuilder().bean((Object)person).name("Name").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcZakljucan.setCellValueFactory(cellValue -> {
            boolean isLocked = ((Document)cellValue.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
        this.tcDocVrednost.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.cbFakturisaneOtpremnice.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                try {
                    if (newValue.booleanValue()) {
                        PregledOtpremnicaTrgovinaController.this.actionPanel.setVisible(false);
                        PregledOtpremnicaTrgovinaController.this.docType = null;
                        PregledOtpremnicaTrgovinaController.this.docType = DocumentType.getByCode((String)"FOT", (Connection)PregledOtpremnicaTrgovinaController.this.controller.getSettings().getConnection());
                        PregledOtpremnicaTrgovinaController.this.loadDocTable();
                    } else {
                        PregledOtpremnicaTrgovinaController.this.actionPanel.setVisible(true);
                        PregledOtpremnicaTrgovinaController.this.docType = null;
                        PregledOtpremnicaTrgovinaController.this.docType = DocumentType.getByCode((String)"OT", (Connection)PregledOtpremnicaTrgovinaController.this.controller.getSettings().getConnection());
                        PregledOtpremnicaTrgovinaController.this.loadDocTable();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.documentsTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> observable, Document oldValue, Document newValue) {
                if (newValue == null) {
                    PregledOtpremnicaTrgovinaController.this.btnCSV.setDisable(true);
                    PregledOtpremnicaTrgovinaController.this.btnDelete.setDisable(true);
                    PregledOtpremnicaTrgovinaController.this.btnInvoice.setDisable(true);
                    PregledOtpremnicaTrgovinaController.this.btnPrint.setDisable(true);
                    PregledOtpremnicaTrgovinaController.this.btnEdit.setDisable(true);
                } else if (PregledOtpremnicaTrgovinaController.this.documentLockIsActive && newValue.isLocked()) {
                    PregledOtpremnicaTrgovinaController.this.btnCSV.setDisable(false);
                    PregledOtpremnicaTrgovinaController.this.btnDelete.setDisable(true);
                    PregledOtpremnicaTrgovinaController.this.btnInvoice.setDisable(false);
                    PregledOtpremnicaTrgovinaController.this.btnPrint.setDisable(false);
                    PregledOtpremnicaTrgovinaController.this.btnEdit.setDisable(true);
                    PregledOtpremnicaTrgovinaController.this.lblZakljucaniDokumentiUpozorenje.setVisible(true);
                } else {
                    PregledOtpremnicaTrgovinaController.this.btnCSV.setDisable(false);
                    PregledOtpremnicaTrgovinaController.this.btnDelete.setDisable(false);
                    PregledOtpremnicaTrgovinaController.this.btnInvoice.setDisable(false);
                    PregledOtpremnicaTrgovinaController.this.btnPrint.setDisable(false);
                    PregledOtpremnicaTrgovinaController.this.btnEdit.setDisable(false);
                    PregledOtpremnicaTrgovinaController.this.lblZakljucaniDokumentiUpozorenje.setVisible(false);
                }
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.docType = DocumentType.getByCode((String)"OT", (Connection)this.controller.getSettings().getConnection());
        this.dpWorkDayFrom.setValue((Object)LocalDate.now());
        this.dpWorkDayTo.setValue((Object)LocalDate.now());
        this.loadDocTable();
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != null && newValue.length() < oldValue.length()) {
                    PregledOtpremnicaTrgovinaController.this.loadDocTable();
                }
                String value = newValue.toLowerCase();
                ObservableList subentries = FXCollections.observableArrayList();
                long count = PregledOtpremnicaTrgovinaController.this.documentsTable.getColumns().stream().count();
                block0: for (int i = 0; i < PregledOtpremnicaTrgovinaController.this.documentsTable.getItems().size(); ++i) {
                    int j = 0;
                    while ((long)j < count) {
                        String entry = "" + ((TableColumn)PregledOtpremnicaTrgovinaController.this.documentsTable.getColumns().get(j)).getCellData(i);
                        if (entry.toLowerCase().contains(value)) {
                            subentries.add(PregledOtpremnicaTrgovinaController.this.documentsTable.getItems().get(i));
                            continue block0;
                        }
                        ++j;
                    }
                }
                PregledOtpremnicaTrgovinaController.this.documentsTable.setItems(subentries);
            }
        });
    }

    public void setParameter(Object parameter) {
        this.docLocker = new DocumentLocker(this.controller);
        this.lastDocumentLockDate = this.docLocker.getLastLockedDocumentDate();
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.hm = (HashMap)parameter;
        this.dpWorkDayFrom.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocTable());
        this.dpWorkDayTo.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocTable());
        this.documentsTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        this.hm.put("rootPane", this.rootPane);
        this.hm.put("controller", this.controller);
        this.hm.put("otpremnica", null);
        this.hm.put("department", Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()));
        this.hm.put("lastDocumentLockDate", this.lastDocumentLockDate);
        int result = this.controller.showModalDialog("Otpremnica - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_OTPREMNICA_DETAILES, this.hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.loadDocTable();
        }
    }

    @FXML
    private void actionEdit(ActionEvent event) {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            this.hm.put("controller", this.controller);
            this.hm.put("department", Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()));
            this.hm.put("otpremnica", this.documentsTable.getSelectionModel().getSelectedItem());
            this.hm.put("selectAllProducts", true);
            int result = this.controller.showModalDialog("Po\u010detno stanje - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_OTPREMNICA_DETAILES, this.hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocTable();
            }
        }
    }

    @FXML
    private void actionPrint() {
        if (this.cbNefiskalnaStampa.isSelected()) {
            FiscalPrinter.printNonFiscalOtpremnicaPregled((ScreensController)this.controller, (Document)((Document)this.documentsTable.getSelectionModel().getSelectedItem()));
        } else if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            Faktura f = new Faktura();
            f.setDocument((Document)this.documentsTable.getSelectionModel().getSelectedItem());
            f.printProfaktura(this.controller, this.rootPane.getScene().getWindow());
        } else {
            this.controller.alert("Obavestenje", "Odaberite dokument iz tabele radi stampe", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionDelete() {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            int brojSelektovanih = this.documentsTable.getSelectionModel().getSelectedItems().size();
            try {
                for (int i = 0; i < brojSelektovanih; ++i) {
                    Document.delete((Long)((Document)this.documentsTable.getSelectionModel().getSelectedItems().get(i)).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
                }
                this.loadDocTable();
                this.tfFilter.setText("");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.controller.alert("Obavesetenje", "Morate odabrati otpremnicu za brisanje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionFaktura() {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            this.hm.put("controller", this.controller);
            this.hm.put("selectedPaymentMethodID", -1);
            int res = this.controller.showModalDialog("Odabir nacina placanja fakture", ScreensController.SCREEN_BACKOFFICE_PAYMENT_METHOD_PICKER, this.hm, this.rootPane.getScene().getWindow());
            if (res == ScreensController.MODAL_RESULT_OK) {
                this.paymentMethod = (PaymentMethod)this.hm.get("paymentMethod");
                if (this.paymentMethod.getPaymentMethodID() == PaymentMethod.getByCode((String)"F", (Connection)this.controller.getSettings().getConnection()).getPaymentMethodID()) {
                    this.listDetailsFaktura.clear();
                    this.personId = ((Document)this.documentsTable.getSelectionModel().getSelectedItems().get(0)).getPersonID();
                    this.otpremnicaFaktura = new Document();
                    this.otpremnicaFaktura.setPersonID(this.personId);
                    this.otpremnicaFaktura.setDocumentID(-1L);
                    for (Document document : this.documentsTable.getSelectionModel().getSelectedItems()) {
                        if (document.getPersonID() == this.personId) continue;
                        this.controller.alert("Obavestenje", "Izabrane otpremnice imaju razlicite kupce", this.rootPane.getScene().getWindow());
                        this.documentsTable.getSelectionModel().clearSelection();
                        return;
                    }
                    for (Document document : this.documentsTable.getSelectionModel().getSelectedItems()) {
                        for (DocumentDetails documentDetails : DocumentDetails.getObeservableList((long)document.getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                            documentDetails.setDocumentID(-1L);
                            this.listDetailsFaktura.add((Object)documentDetails);
                        }
                        try {
                            document.setDocumentTypeID(DocumentType.getByCode((String)"FOT", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
                            document.update(this.controller);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    this.createFaktura(this.otpremnicaFaktura);
                    this.loadDocTable();
                } else {
                    this.listDetailsFaktura.clear();
                    Person person = Person.getById((long)((Document)this.documentsTable.getSelectionModel().getSelectedItems().get(0)).getPersonID(), (ScreensController)this.controller);
                    try {
                        this.cashbuyerId = CashBuyer.getByPib((String)person.getPIB(), (ScreensController)this.controller).getCashBuyerID();
                    }
                    catch (NullPointerException e) {
                        CashBuyer buyer = new CashBuyer();
                        buyer.setName(person.getName());
                        buyer.setPIB(person.getPIB());
                        buyer.setAddress(person.getAddress());
                        buyer.setCity(person.getCity());
                        buyer.setZIP(person.getZIP());
                        buyer.setSysUserAddID(Long.valueOf(this.controller.getUser().getSysUserAddID()));
                        try {
                            this.cashbuyerId = buyer.insert(this.controller.getSettings().getConnection());
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                    this.otpremnicaFaktura = new Document();
                    this.otpremnicaFaktura.setCashBuyersID(this.cashbuyerId);
                    this.otpremnicaFaktura.setDocumentID(-1L);
                    for (Document document : this.documentsTable.getSelectionModel().getSelectedItems()) {
                        for (DocumentDetails documentDetails : DocumentDetails.getObeservableList((long)document.getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                            documentDetails.setDocumentID(-1L);
                            this.listDetailsFaktura.add((Object)documentDetails);
                        }
                        try {
                            document.setDocumentTypeID(DocumentType.getByCode((String)"FOT", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
                            document.update(this.controller);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    this.createGotovinski(this.otpremnicaFaktura);
                    this.loadDocTable();
                }
            }
        } else {
            this.controller.alert("Obavesetenje", "Morate odabrati barem jednu otpremnicu za fakturisanje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionExport() {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"}));
            File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
            if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
                List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
                int extensionLength = 0;
                if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                    extensionLength = 4;
                }
                if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                    extensionLength = 5;
                }
                String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
                String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
                String pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
                if (file != null) {
                    String filePath = file.getAbsolutePath();
                    if (!filePath.toUpperCase().endsWith(".CSV")) {
                        filePath = filePath + ".xml";
                    }
                    String query = "SELECT * FROM documentdetails dd where dd.DocumentID = ?";
                    try {
                        PreparedStatement ps = this.controller.getSettings().getConnection().prepareStatement(query);
                        ps.setLong(1, ((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID());
                        ResultSet rs = ps.executeQuery();
                        PrintWriter writer = new PrintWriter(filePath, "UTF-8");
                        writer.println("BarKod;Kolicina;Cena;Datum");
                        while (rs.next()) {
                            Product product = Product.getByID((long)rs.getLong("ProductID"), (ScreensController)this.controller);
                            Barcode barcode = Barcode.getBarCodeObject((long)product.getProductID(), (Connection)this.controller.getSettings().getConnection());
                            StringBuilder sBuilder = new StringBuilder();
                            String barkod = "";
                            try {
                                barkod = barcode.getBarCode();
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            writer.println(sBuilder.append(barkod).append(";").append(Settings.getNumberFormat((int)2, (boolean)false).format(rs.getDouble("Quantity"))).append(";").append(Settings.getNumberFormat((int)2, (boolean)false).format(rs.getDouble("PriceWithDiscount"))).append(";").append(new SimpleDateFormat("dd-MM-yyyy").format(rs.getDate("sysDTCreated"))).toString().replace(",", "."));
                        }
                        writer.close();
                    }
                    catch (FileNotFoundException | UnsupportedEncodingException | SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private long getBillId(double discount) {
        long documentID = 0L;
        this.otpremnicaBill = new Document();
        this.otpremnicaBill.setDocumentTypeID(DocumentType.getByCode((String)"R", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        this.otpremnicaBill.setDocumentStatusID(1);
        this.otpremnicaBill.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
        this.otpremnicaBill.setNumber(Document.getNextNumber((int)this.otpremnicaBill.getDocumentTypeID(), (long)this.otpremnicaBill.getPointOfSaleID(), (ScreensController)this.controller));
        this.otpremnicaBill.setYear(Year.now().getValue());
        this.otpremnicaBill.setDate(new Date());
        this.otpremnicaBill.setDeliveryDate(new Date());
        this.otpremnicaBill.setCurrencyDate(new Date());
        this.otpremnicaBill.setPersonID(this.personId);
        this.otpremnicaBill.setNote("");
        this.otpremnicaBill.setPlace(Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()).getCity());
        this.otpremnicaBill.setPaymentMethodID(PaymentMethod.getByCode((String)"F", (Connection)this.controller.getSettings().getConnection()).getPaymentMethodID());
        this.otpremnicaBill.setSysDTCreated(new Date());
        this.otpremnicaBill.setSysDTEdit(new Date());
        this.otpremnicaBill.setSysUserAddID(this.controller.getUser().getUserID());
        this.otpremnicaBill.setWorkDayID(WorkDay.getLastOpenWD((ScreensController)this.controller).getWorkDayID());
        documentID = this.otpremnicaBill.insert(this.controller);
        double sum = 0.0;
        for (DocumentDetails documentDetails : this.listDetailsFaktura) {
            sum += documentDetails.getPrice() * documentDetails.getQuantity();
            documentDetails.setDocumentID(documentID);
            documentDetails.setPriceWithDiscount(documentDetails.getPriceWithDiscount());
            documentDetails.setSysDTCreated(new Date());
            documentDetails.setSysUserAddID(this.otpremnicaBill.getSysUserAddID());
            documentDetails.setUnitID(1);
            documentDetails.setVatID(1);
            documentDetails.insert(this.controller.getSettings().getConnection());
        }
        try {
            this.otpremnicaBill.setDiscount(discount);
            this.otpremnicaBill.setSum(sum);
            this.otpremnicaBill.setSumWithDiscount(sum * (100.0 - this.otpremnicaBill.getDiscount()) / 100.0);
            this.otpremnicaBill.setPaid(this.otpremnicaBill.getSumWithDiscount());
            this.otpremnicaBill.update(this.controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return documentID;
    }

    private void createFaktura(Document otpremnicaFaktura) {
        long documentID = 0L;
        otpremnicaFaktura.setDocumentTypeID(DocumentType.getByCode((String)"F", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        otpremnicaFaktura.setDocumentStatusID(1);
        otpremnicaFaktura.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
        otpremnicaFaktura.setNumber(Document.getNextNumber((int)otpremnicaFaktura.getDocumentTypeID(), (long)otpremnicaFaktura.getPointOfSaleID(), (ScreensController)this.controller));
        otpremnicaFaktura.setYear(Year.now().getValue());
        otpremnicaFaktura.setDate(new Date());
        otpremnicaFaktura.setNote("");
        otpremnicaFaktura.setPlace(Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()).getCity());
        otpremnicaFaktura.setPaymentMethodID(PaymentMethod.getByCode((String)"F", (Connection)this.controller.getSettings().getConnection()).getPaymentMethodID());
        otpremnicaFaktura.setSysDTCreated(new Date());
        otpremnicaFaktura.setSysUserAddID(this.controller.getUser().getUserID());
        otpremnicaFaktura.setWorkDayID(0L);
        documentID = otpremnicaFaktura.insert(this.controller);
        double sum = 0.0;
        double sumWithDiscount = 0.0;
        for (DocumentDetails documentDetails : this.listDetailsFaktura) {
            sum += documentDetails.getPrice() * documentDetails.getQuantity();
            sumWithDiscount += documentDetails.getPriceWithDiscount() * documentDetails.getQuantity();
            if (documentDetails.getDocumentID() > 0L) {
                documentDetails.update(this.controller);
                continue;
            }
            documentDetails.setDocumentID(documentID);
            documentDetails.setPriceWithDiscount(documentDetails.getPriceWithDiscount());
            documentDetails.setSysDTCreated(new Date());
            documentDetails.setSysUserAddID(otpremnicaFaktura.getSysUserAddID());
            documentDetails.insert(this.controller.getSettings().getConnection());
        }
        try {
            otpremnicaFaktura.setSum(sum);
            otpremnicaFaktura.setSumWithDiscount(sumWithDiscount);
            otpremnicaFaktura.setDiscount(100.0 - 100.0 * otpremnicaFaktura.getSumWithDiscount() / otpremnicaFaktura.getSum());
            otpremnicaFaktura.update(this.controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        otpremnicaFaktura.insertParent(1, this.getBillId(otpremnicaFaktura.getDiscount()), this.controller.getSettings().getConnection());
    }

    private void createGotovinski(Document otpremnicaGotovinski) {
        long documentID = 0L;
        otpremnicaGotovinski.setDocumentTypeID(DocumentType.getByCode((String)"R", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        otpremnicaGotovinski.setDocumentStatusID(1);
        otpremnicaGotovinski.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
        otpremnicaGotovinski.setNumber(Document.getNextNumber((int)otpremnicaGotovinski.getDocumentTypeID(), (long)otpremnicaGotovinski.getPointOfSaleID(), (ScreensController)this.controller));
        otpremnicaGotovinski.setYear(Year.now().getValue());
        otpremnicaGotovinski.setDate(new Date());
        otpremnicaGotovinski.setDeliveryDate(new Date());
        otpremnicaGotovinski.setCurrencyDate(new Date());
        otpremnicaGotovinski.setWorkDayID(WorkDay.getFromDb((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getWorkDayID());
        otpremnicaGotovinski.setNote("");
        otpremnicaGotovinski.setPlace(Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()).getCity());
        otpremnicaGotovinski.setPaymentMethodID(PaymentMethod.getByCode((String)"CASH", (Connection)this.controller.getSettings().getConnection()).getPaymentMethodID());
        otpremnicaGotovinski.setSysDTCreated(new Date());
        otpremnicaGotovinski.setSysDTEdit(new Date());
        otpremnicaGotovinski.setSysUserAddID(this.controller.getUser().getUserID());
        documentID = otpremnicaGotovinski.insert(this.controller);
        double sum = 0.0;
        for (DocumentDetails documentDetails : this.listDetailsFaktura) {
            sum += documentDetails.getPrice() * documentDetails.getQuantity();
            documentDetails.setDocumentID(documentID);
            documentDetails.setPriceWithDiscount(documentDetails.getPriceWithDiscount());
            documentDetails.setSysDTCreated(new Date());
            documentDetails.setSysUserAddID(otpremnicaGotovinski.getSysUserAddID());
            documentDetails.setUnitID(1);
            documentDetails.setVatID(1);
            documentDetails.insert(this.controller.getSettings().getConnection());
        }
        try {
            otpremnicaGotovinski.setSum(sum);
            otpremnicaGotovinski.setSumWithDiscount(sum * (100.0 - otpremnicaGotovinski.getDiscount()) / 100.0);
            otpremnicaGotovinski.setPaid(sum);
            otpremnicaGotovinski.update(this.controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadDocTable() {
        this.documentsTable.getItems().clear();
        this.documentList = Document.getProfakturaList((int)this.docType.getDocumentTypeID(), (String)((LocalDate)this.dpWorkDayFrom.getValue()).toString(), (String)((LocalDate)this.dpWorkDayTo.getValue()).toString(), (boolean)false, (boolean)false, (ScreensController)this.controller);
        this.documentsTable.setItems(this.documentList);
    }
}

