/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategoryEnum;

public class PregledInternihPrijemnicaWarehouseTrgovinaController
implements ControlledScreen {
    ScreensController controller;
    DocumentType docType;
    ObservableList<Document> documentList;
    ObservableList<DocumentDetails> listDetailsPrijemnica = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<Department> cbPrijemnoOdeljenje;
    @FXML
    private TableView<Document> documentsTable;
    @FXML
    private TableColumn<Document, Integer> tcDocBroj;
    @FXML
    private TableColumn<Document, Date> tcDocDatum;
    @FXML
    private TableColumn<Document, String> tcDocKomitent;
    @FXML
    private TableColumn<Document, Double> tcDocVrednost;
    @FXML
    private TableColumn<Document, String> tcBI;
    @FXML
    DatePicker dpWorkDayFrom;
    @FXML
    DatePicker dpWorkDayTo;

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
            }
        });
        this.tcDocBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDocDatum.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDocDatum.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDocKomitent.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    Person person = Person.getById((long)((Document)param.getValue()).getPersonID(), (ScreensController)PregledInternihPrijemnicaWarehouseTrgovinaController.this.controller);
                    if (PersonCategoryEnum.BUYER.getPersonCategoryId() == person.getPersonCategoryID()) {
                        return new JavaBeanStringPropertyBuilder().bean((Object)person).name("Name").build();
                    }
                    return null;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcBI.setCellValueFactory((Callback)new PropertyValueFactory("FullNumber"));
        this.tcDocVrednost.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.docType = DocumentType.getByCode((String)"IPW", (Connection)this.controller.getSettings().getConnection());
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((Object)o);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.dpWorkDayFrom.setValue((Object)WorkDay.getDateFromForDep((LocalDateTime)Settings.LocalDateTimefromDate((Date)Settings.fromLocalDate((LocalDate)LocalDate.now())), (int)this.controller.getObject().getDepartmentID(((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID(), this.controller.getSettings().getConnection()), (Connection)this.controller.getSettings().getConnection()).toLocalDate());
        this.dpWorkDayTo.setValue((Object)LocalDate.now());
        this.loadDocTable();
    }

    public void setParameter(Object parameter) {
        this.dpWorkDayFrom.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocTable());
        this.dpWorkDayTo.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocTable());
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("prijemnica", null);
        int result = this.controller.showModalDialog("Interna Prijemnica - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_INTERNA_PRIJEMNICA_DETAILES, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.loadDocTable();
        }
    }

    @FXML
    private void actionEdit(ActionEvent event) {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("prijemnica", this.documentsTable.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Interna Prijemnica - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_INTERNA_PRIJEMNICA_DETAILES_SKLADISTE, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocTable();
            }
        }
    }

    @FXML
    private void actionPrint() {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            Faktura f = new Faktura();
            f.setDocument((Document)this.documentsTable.getSelectionModel().getSelectedItem());
            f.printInterno(this.controller, this.rootPane.getScene().getWindow());
        } else {
            this.controller.alert("Obavestenje", "Odaberite dokument iz tabele radi stampe", this.rootPane.getScene().getWindow());
        }
    }

    private void loadDocTable() {
        this.documentsTable.getItems().clear();
        this.documentList = Document.getObeservableList((int)this.docType.getDocumentTypeID(), (int)this.controller.getObject().getObjectID(), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpWorkDayFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpWorkDayTo.getValue())), (Connection)this.controller.getSettings().getConnection());
        this.documentsTable.setItems(this.documentList);
    }
}

