/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.awt.Toolkit;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import rs.petcom.backoffice.controller.document.DocumentLocker;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategoryEnum;

public class PregledInternihOtpremnicaTrgovinaController
implements ControlledScreen {
    private ScreensController controller;
    private DocumentType docType;
    private DocumentLocker docLocker;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private VBox vBoxRight;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private TableView<Document> documentsTable;
    @FXML
    private TableColumn<Document, Integer> tcDocBroj;
    @FXML
    private TableColumn<Document, Date> tcDocDatum;
    @FXML
    private TableColumn<Document, String> tcDocKomitent;
    @FXML
    private TableColumn<Document, String> tcZakljucan;
    @FXML
    private TableColumn<Document, Double> tcDocVrednost;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnDelete;
    @FXML
    private Label lblZakljucaniDokumentiUpozorenje;
    @FXML
    DatePicker dpWorkDayFrom;
    @FXML
    DatePicker dpWorkDayTo;

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
            }
        });
        this.tcDocBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDocDatum.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDocDatum.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDocKomitent.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    Person person = Person.getById((long)((Document)param.getValue()).getPersonID(), (ScreensController)PregledInternihOtpremnicaTrgovinaController.this.controller);
                    if (PersonCategoryEnum.INTERNAL_BUYER.getPersonCategoryId() == person.getPersonCategoryID()) {
                        return new JavaBeanStringPropertyBuilder().bean((Object)person).name("Name").build();
                    }
                    return null;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcDocVrednost.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcZakljucan.setCellValueFactory(cellValue -> {
            boolean isLocked = ((Document)cellValue.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
        this.documentsTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> observable, Document oldValue, Document newValue) {
                if (newValue == null) {
                    PregledInternihOtpremnicaTrgovinaController.this.btnDelete.setDisable(true);
                    PregledInternihOtpremnicaTrgovinaController.this.btnPrint.setDisable(true);
                    PregledInternihOtpremnicaTrgovinaController.this.btnEdit.setDisable(true);
                } else if (PregledInternihOtpremnicaTrgovinaController.this.documentLockIsActive && newValue.isLocked()) {
                    PregledInternihOtpremnicaTrgovinaController.this.btnDelete.setDisable(true);
                    PregledInternihOtpremnicaTrgovinaController.this.btnPrint.setDisable(false);
                    PregledInternihOtpremnicaTrgovinaController.this.btnEdit.setDisable(true);
                    PregledInternihOtpremnicaTrgovinaController.this.lblZakljucaniDokumentiUpozorenje.setVisible(true);
                } else {
                    PregledInternihOtpremnicaTrgovinaController.this.btnDelete.setDisable(false);
                    PregledInternihOtpremnicaTrgovinaController.this.btnPrint.setDisable(false);
                    PregledInternihOtpremnicaTrgovinaController.this.btnEdit.setDisable(false);
                    PregledInternihOtpremnicaTrgovinaController.this.lblZakljucaniDokumentiUpozorenje.setVisible(false);
                }
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.rootPane.getScene() != null) {
            this.vBoxRight.setMinWidth(this.rootPane.getScene().getWidth() * 12.0 / 100.0);
        } else {
            this.vBoxRight.setMinWidth(Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 12.0 / 100.0);
        }
        this.docType = DocumentType.getByCode((String)"IO", (Connection)this.controller.getSettings().getConnection());
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((Object)o);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.dpWorkDayFrom.setValue((Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom()));
        this.dpWorkDayTo.setValue((Object)Settings.fromDate((Date)new Date()));
        this.loadDocTable();
    }

    public void setParameter(Object parameter) {
        this.docLocker = new DocumentLocker(this.controller);
        this.lastDocumentLockDate = this.docLocker.getLastLockedDocumentDate();
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.dpWorkDayFrom.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocTable());
        this.dpWorkDayTo.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocTable());
        this.docType = DocumentType.getByCode((String)"IO", (Connection)this.controller.getSettings().getConnection());
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("otpremnica", null);
        hm.put("lastDocumentLockDate", this.lastDocumentLockDate);
        int result = this.controller.showModalDialog("Interna Otpremnica - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_INTERNA_OTPREMNICA_DETAILES, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.loadDocTable();
        }
    }

    @FXML
    private void actionEdit(ActionEvent event) {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("otpremnica", this.documentsTable.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Interna Otpremnica - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_INTERNA_OTPREMNICA_DETAILES, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocTable();
            }
        }
    }

    @FXML
    private void actionDelete() {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            try {
                Document.update((long)((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.controller.alert("Obavestenje", "Odaberite dokument iz tabele koji zelite da obrisete", this.rootPane.getScene().getWindow());
        }
        this.loadDocTable();
    }

    @FXML
    private void actionPrint() {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            Faktura f = new Faktura();
            f.setDocument((Document)this.documentsTable.getSelectionModel().getSelectedItem());
            f.printInterno(this.controller, this.rootPane.getScene().getWindow());
        } else {
            this.controller.alert("Obavestenje", "Odaberite dokument iz tabele radi stampe", this.rootPane.getScene().getWindow());
        }
    }

    private void loadDocTable() {
        this.documentsTable.getItems().clear();
        this.documentsTable.setItems(Document.getInternaOtpremnicaList((int)this.docType.getDocumentTypeID(), (int)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID(), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpWorkDayFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpWorkDayTo.getValue())), (Connection)this.controller.getSettings().getConnection()));
    }
}

