/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.backoffice.controller.document.DocumentLocker;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Prijemnica;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class PovratDobavljacuControllerTrgovina
implements ControlledScreen {
    private ScreensController controller;
    private DocumentLocker docLocker;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    Object sviObjekti = new Object(-1, "Svi objekti");
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private TableView<Prijemnica> table;
    @FXML
    private TableColumn<Prijemnica, Integer> tcBroj;
    @FXML
    private TableColumn<Prijemnica, Date> tcDate;
    @FXML
    private TableColumn<Prijemnica, Date> tcDeliveryDate;
    @FXML
    private TableColumn<Prijemnica, Person> tcPerson;
    @FXML
    private TableColumn<Prijemnica, String> tcExternalNumber;
    @FXML
    private TableColumn<Prijemnica, String> tcZakljucan;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnDelete;
    @FXML
    private Label lblZakljucaniDokumentiUpozorenje;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        Person p = new Person();
        p.setPersonID(-1L);
        p.setName("Svi dobavlja\u010di");
        this.cbPerson.getItems().add((java.lang.Object)p);
        this.cbPerson.getItems().addAll((Collection)Person.getListByCategory((String)PersonCategory.SUPPLIER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        this.cbPerson.getSelectionModel().selectFirst();
        this.cbObject.getItems().add((java.lang.Object)this.sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((java.lang.Object)this.sviObjekti);
        }
        this.dpDateFrom.setValue((java.lang.Object)LocalDate.now());
        this.dpDateTo.setValue((java.lang.Object)LocalDate.now());
        this.loadDocumentList();
    }

    public void setParameter(java.lang.Object parameter) {
        this.docLocker = new DocumentLocker(this.controller);
        this.lastDocumentLockDate = this.docLocker.getLastLockedDocumentDate();
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                PovratDobavljacuControllerTrgovina.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                PovratDobavljacuControllerTrgovina.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Prijemnica>(){

            public void changed(ObservableValue<? extends Prijemnica> observable, Prijemnica oldValue, Prijemnica newValue) {
                if (newValue == null) {
                    PovratDobavljacuControllerTrgovina.this.btnDelete.setDisable(true);
                    PovratDobavljacuControllerTrgovina.this.btnPrint.setDisable(true);
                    PovratDobavljacuControllerTrgovina.this.btnEdit.setDisable(true);
                } else if (PovratDobavljacuControllerTrgovina.this.documentLockIsActive && newValue.isLocked()) {
                    PovratDobavljacuControllerTrgovina.this.btnDelete.setDisable(true);
                    PovratDobavljacuControllerTrgovina.this.btnPrint.setDisable(false);
                    PovratDobavljacuControllerTrgovina.this.btnEdit.setDisable(true);
                    PovratDobavljacuControllerTrgovina.this.lblZakljucaniDokumentiUpozorenje.setVisible(true);
                } else {
                    PovratDobavljacuControllerTrgovina.this.btnDelete.setDisable(false);
                    PovratDobavljacuControllerTrgovina.this.btnPrint.setDisable(false);
                    PovratDobavljacuControllerTrgovina.this.btnEdit.setDisable(false);
                    PovratDobavljacuControllerTrgovina.this.lblZakljucaniDokumentiUpozorenje.setVisible(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDeliveryDate.setCellValueFactory((Callback)new PropertyValueFactory("DeliveryDate"));
        this.tcPerson.setCellValueFactory((Callback)new PropertyValueFactory("dobavljac"));
        this.tcDate.setCellFactory(column -> new TableCell<Prijemnica, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDeliveryDate.setCellFactory(column -> new TableCell<Prijemnica, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcExternalNumber.setCellValueFactory((Callback)new PropertyValueFactory("ExternalNumber"));
        this.tcZakljucan.setCellValueFactory(cellValue -> {
            boolean isLocked = ((Prijemnica)cellValue.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
    }

    @FXML
    public void actionNew(ActionEvent event) {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        if (this.cbDepartment.getSelectionModel().getSelectedItem() != null) {
            Prijemnica p = new Prijemnica();
            p.setDocumentID(-1L);
            p.setNumber(Document.getNextNumber((int)9, (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (ScreensController)this.controller, (LocalDate)LocalDate.now()));
            p.setDobavljac(null);
            p.setDate(new Date());
            p.setDeliveryDate(new Date());
            p.setPaymentDate(new Date());
            p.setDepartmentID(((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            p.setComment("");
            hm.put("prijemnica", p);
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("lastDocumentLockDate", this.lastDocumentLockDate);
            int result = this.controller.showModalDialog("Povrat - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POVRAT_DOBAVLJACU_DETAILES_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                this.loadDocumentList();
                this.actionNew(event);
            }
        } else {
            this.controller.alert("Obave\u0161tenje", "Izaberite odeljenje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("prijemnica", this.table.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Povrat - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POVRAT_DOBAVLJACU_DETAILES_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                this.loadDocumentList();
                this.actionNew(event);
            }
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        final String reportFileName = "rs/petcom/backoffice/jasper/PrijemnicaTrgovinaNew.jasper";
        final HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        Document document = Document.getByID((long)((Prijemnica)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get((Connection)this.controller.getSettings().getConnection()));
        try {
            hm.put("address", Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID((long)CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller).getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
        hm.put("documentId", document.getDocumentID());
        hm.put("document", document);
        hm.put("prijemnica", false);
        hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
        hm.put("dobavljac", Person.getById((long)document.getPersonID(), (ScreensController)this.controller));
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje kalkulacije u toku.", this.rootPane.getScene().getWindow());
        Task<JasperPrint> creatingReport = new Task<JasperPrint>(){

            protected JasperPrint call() throws Exception {
                try {
                    JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                    hm.put("REPORT_VIRTUALIZER", virtualizer);
                    JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                    JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)PovratDobavljacuControllerTrgovina.this.controller.getSettings().getConnection());
                    virtualizer.setReadOnly(true);
                    return jprint;
                }
                catch (JRException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        creatingReport.setOnSucceeded(arg_0 -> this.lambda$actionPrint$3(taskUpdateStage, event, (Task)creatingReport, arg_0));
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje kalkulacije", this.rootPane.getScene().getWindow());
        });
        creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)creatingReport).start();
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            if (this.table.getSelectionModel().getSelectedItem() != null) {
                for (DocumentDetails dd : DocumentDetails.getList((long)((Prijemnica)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                    dd.delete(this.controller.getSettings().getConnection());
                }
                ((Prijemnica)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
            }
        }
        catch (SQLException e) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje prijemnice nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje prijemnice nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (!this.cbDepartment.getItems().isEmpty()) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    @FXML
    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(Prijemnica.getPovratList((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (long)((Person)this.cbPerson.getSelectionModel().getSelectedItem()).getPersonID(), (ScreensController)this.controller));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void actionExport() {
        Prijemnica p = (Prijemnica)this.table.getSelectionModel().getSelectedItem();
        Department d = (Department)this.cbDepartment.getSelectionModel().getSelectedItem();
        p.setDepartmentID(d.getDepartmentID());
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export Prijemnice");
        fileChooser.setInitialFileName("Prijemnica-" + d.getCode() + "-" + p.getNumber() + ".xml");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("XML files (*.xml)", new String[]{"*.xml"});
        fileChooser.getExtensionFilters().add((java.lang.Object)extFilter);
        File file = fileChooser.showSaveDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            try {
                if (file.getAbsolutePath().toUpperCase().endsWith(".XML")) {
                    p.exportToXml(file.getAbsolutePath(), this.controller);
                } else {
                    p.exportToXml(file.getAbsolutePath() + ".xml", this.controller);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    private /* synthetic */ void lambda$actionPrint$3(Stage taskUpdateStage, ActionEvent event, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        if (((Button)event.getSource()).getText().equals("\u0160tampa PDF")) {
            this.controller.printFileFromPDF(this.controller.getPdfFromJasper((JasperPrint)creatingReport.getValue(), "\u0160tampa kalkulacije", "Kalkulacija"));
        } else {
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld((JasperPrint)creatingReport.getValue());
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Prijemnica", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
    }
}

