/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.backoffice.gui.ComboBoxCellFactory;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.Povrat;
import rs.petcom.master.dal.document.PovratDetailes;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.AutoCompleteComboBoxListener;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class PovratDetailesControllerTrgovina
implements DialogController {
    ScreensController controller;
    Povrat povrat;
    int modalResult;
    ArrayList<PovratDetailes> deletedItems;
    ObservableList<PovratDetailes> povratDetailsList;
    ArrayList<Product> productList;
    Object objekat;
    Department department;
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    Product selectedProduct;
    PovratDetailes pd;
    ComboBoxCellFactory cbCellFactory;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfExternalNumber;
    @FXML
    private TextField tfPlace;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfPriceWithoutVatAndDiscount;
    @FXML
    private TextField tfSum;
    @FXML
    private TextField tfDiscount;
    @FXML
    private TextField tfSumWithDiscount;
    @FXML
    private TextField tfVat;
    @FXML
    private TextField tfSumWithVat;
    @FXML
    private TextField tfSellPrice;
    @FXML
    private DateTimePicker dpDate;
    @FXML
    private DatePicker dpDeliveryDate;
    @FXML
    private DatePicker dpCurrencyDate;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private ComboBox<DocumentStatus> cbStatus;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilter;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnSacuvaj;
    @FXML
    private Button btnOdustani;
    @FXML
    private Button btnImportXml;
    @FXML
    private Button btnSacuvajNovo;
    @FXML
    private Button btnNoviProizvod;
    @FXML
    private TextArea tfNapomena;
    @FXML
    private TableView<PovratDetailes> tablePovratDetails;
    @FXML
    private TableColumn<java.lang.Object, Product> tcProduct;
    @FXML
    private TableColumn<java.lang.Object, Double> tcQuantity;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPriceWithoutVatAndDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSum;
    @FXML
    private TableColumn<java.lang.Object, Double> tcDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithDiscount;
    @FXML
    private TableColumn<PovratDetailes, Product> tcVat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithVat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSellPrice;

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.deletedItems = new ArrayList();
        this.btnRemove.setDisable(false);
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbPerson.setItems(Person.getListByCategory((String)PersonCategory.SUPPLIER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        new AutoCompleteComboBoxListener(this.cbPerson);
        this.cbStatus.setItems(DocumentStatus.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbStatus.setOnKeyPressed(event -> {
            if (event.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                // empty if block
            }
        });
        this.cbFilter.getItems().addAll((java.lang.Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilter.getSelectionModel().selectFirst();
        this.cbFilter.setOnAction(actionEvent -> {
            this.cbProductAutoComplete.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
            this.cbCellFactory.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
        });
        this.objekat = (Object)parameter.get("object");
        this.department = (Department)parameter.get("department");
        this.povrat = (Povrat)parameter.get("povrat");
        this.tfNumber.setText(String.valueOf(this.povrat.getNumber()));
        this.tfExternalNumber.setText(this.povrat.getExternalNumber());
        this.dpDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.povrat.getDate()));
        this.dpDeliveryDate.setValue((java.lang.Object)Settings.fromDate((Date)this.povrat.getDeliveryDate()));
        this.dpCurrencyDate.setValue((java.lang.Object)Settings.fromDate((Date)this.povrat.getPaymentDate()));
        this.setDobavljac(this.povrat.getDobavljac());
        this.tfPlace.setText(this.povrat.getPlace());
        this.setStatus(this.povrat.getDocumentStatus());
        this.tfPlace.setText(this.objekat.getName());
        this.tfPlace.setEditable(false);
        this.tfNapomena.setText(this.povrat.getComment());
        if (this.povrat.getDocumentID() > 0L && LocalDateTime.now().getDayOfYear() > Settings.LocalDateTimefromDate((Date)this.povrat.getDate()).getDayOfYear()) {
            this.tcSellPrice.setEditable(false);
        }
        this.pd = new PovratDetailes();
        this.productList = new ArrayList();
        this.cbCellFactory = new ComboBoxCellFactory((ObservableList<Product>)FXCollections.observableArrayList(this.productList), this.controller, this.department, ScreensController.FILTER_ALL);
        this.tcProduct.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcProduct.setCellFactory((Callback)this.cbCellFactory);
        this.tcProduct.setOnEditCommit(cellEditEvent -> {
            Product selectedTableProduct = (Product)cellEditEvent.getNewValue();
            PovratDetailes selectedTablePovrat = (PovratDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTableProduct.getCurrentPrice((long)this.department.getDepartmentID(), this.controller.getSettings().getConnection());
            selectedTableProduct.getNabavnaCena(this.controller.getSettings().getConnection());
            selectedTablePovrat.setProduct(selectedTableProduct);
            selectedTablePovrat.setProductID(selectedTableProduct.getProductID());
            selectedTablePovrat.setProductCode(selectedTableProduct.getCode());
            selectedTablePovrat.setProductName(selectedTableProduct.getName());
            selectedTablePovrat.setSellPrice(selectedTableProduct.getPrice());
            selectedTablePovrat.setNewSellPrice(selectedTableProduct.getPrice());
            selectedTablePovrat.setMargin(selectedTablePovrat.getPriceWithDiscount() > 0.0 ? selectedTableProduct.getPrice() / selectedTablePovrat.getPriceWithDiscount() * 100.0 : selectedTableProduct.getPrice() / selectedTableProduct.getNabavnaCena() * 100.0);
            selectedTablePovrat.setPurchasePrice(selectedTableProduct.getNabavnaCena());
            selectedTablePovrat.setVat(selectedTableProduct.getVatValue());
            cellEditEvent.getTableColumn().getTableView().refresh();
        });
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            this.selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
            try {
                this.selectedProduct.getCurrentPrice((long)this.department.getDepartmentID(), this.controller.getSettings().getConnection());
                this.selectedProduct.getNabavnaCena(this.controller.getSettings().getConnection());
                this.pd.setProduct(this.selectedProduct);
                this.pd.setProductID(this.selectedProduct.getProductID());
                this.pd.setProductCode(this.selectedProduct.getCode());
                this.pd.setProductName(this.selectedProduct.getName());
                this.pd.setSellPrice(this.selectedProduct.getPrice());
                this.pd.setNewSellPrice(this.selectedProduct.getPrice());
                this.pd.setVat(this.selectedProduct.getVatValue());
                this.pd.setPriceWithoutVatAndDiscount(this.selectedProduct.getNabavnaCenaBezPopusta() - this.selectedProduct.getNabavnaCenaBezPopusta() * this.selectedProduct.getVatValue3());
                this.pd.setPrice(this.selectedProduct.getNabavnaCenaBezPopusta());
                this.pd.setPriceWithDiscount(this.selectedProduct.getNabavnaCena());
                this.pd.setMargin(this.pd.getPriceWithDiscount() > 0.0 ? (this.pd.getNewSellPrice() - this.pd.getPriceWithDiscount()) / this.pd.getPriceWithDiscount() * 100.0 : (this.pd.getNewSellPrice() - this.selectedProduct.getNabavnaCena()) / this.selectedProduct.getNabavnaCena() * 100.0);
                this.pd.setPurchasePrice(this.selectedProduct.getNabavnaCena());
                this.tfPriceWithoutVatAndDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPriceWithoutVatAndDiscount()));
                this.tfVat.setText(this.selectedProduct.getVatName());
                this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.selectedProduct.getPrice()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, this.department.getDepartmentID(), ScreensController.FILTER_ALL, this.tfQuantity);
        this.povratDetailsList = PovratDetailes.getlist((Povrat)this.povrat, (long)this.department.getDepartmentID(), (ScreensController)this.controller);
        this.tablePovratDetails.setItems(this.povratDetailsList);
        this.tfQuantity.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && PovratDetailesControllerTrgovina.this.tfQuantity.getText().equals("")) {
                    event.consume();
                    PovratDetailesControllerTrgovina.this.cbProduct.requestFocus();
                }
            }
        });
        this.tfQuantity.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getQuantity()) + "");
            }
        });
        this.tfQuantity.textProperty().addListener((observable, oldValue, newValue) -> {
            this.izracunajUkupno();
            try {
                if (newValue.length() > 0) {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        this.tfQuantity.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (this.tfQuantity.isFocused()) {
                        this.pd.setQuantity(Settings.getNumberFormat((int)8, (boolean)true).parse((String)newValue).doubleValue());
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfPriceWithoutVatAndDiscount.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfPriceWithoutVatAndDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfPriceWithoutVatAndDiscount.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfPriceWithoutVatAndDiscount.getText().equals("")) {
                keyEvent.consume();
                this.tfQuantity.requestFocus();
            }
        });
        this.tfPriceWithoutVatAndDiscount.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfPriceWithoutVatAndDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPrice() / this.pd.getVat()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfPriceWithoutVatAndDiscount.textProperty().addListener((observable, oldValue, newValue) -> {
            this.izracunajUkupno();
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfPriceWithoutVatAndDiscount.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfPriceWithoutVatAndDiscount.isFocused()) {
                    this.pd.setPrice(Settings.getNumberFormat((int)5, (boolean)true).parse((String)newValue).doubleValue() * this.pd.getVat());
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfSum.setEditable(false);
        this.tfDiscount.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfDiscount.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getDiscount()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfDiscount.textProperty().addListener((observable, oldValue, newValue) -> {
            this.izracunajUkupno();
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfDiscount.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfDiscount.isFocused()) {
                    this.pd.setDiscount(Settings.getNumberFormat((int)3, (boolean)true).parse((String)newValue).doubleValue());
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfSumWithDiscount.setEditable(false);
        this.tfVat.setEditable(false);
        this.tfVat.textProperty().addListener((observable, oldValue, newValue) -> this.izracunajUkupno());
        this.tfSumWithVat.setEditable(false);
        this.tfSellPrice.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfSellPrice.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfSellPrice.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfSellPrice.isFocused()) {
                    this.pd.setNewSellPrice(Settings.getNumberFormat((int)2, (boolean)true).parse((String)newValue).doubleValue());
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfSellPrice.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getNewSellPrice()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.deletedItems.clear();
        this.tfNapomena.setText(this.povrat.getComment());
        this.tfNapomena.setFocusTraversable(false);
        this.btnSacuvaj.setFocusTraversable(false);
        this.dpDate.setFocusTraversable(false);
        this.btnOdustani.setFocusTraversable(false);
        this.btnAdd.setFocusTraversable(false);
        this.btnRemove.setFocusTraversable(false);
        this.btnImportXml.setFocusTraversable(false);
        this.tfPlace.setFocusTraversable(false);
        this.btnSacuvajNovo.setFocusTraversable(false);
        this.btnNoviProizvod.setFocusTraversable(false);
        this.tablePovratDetails.setFocusTraversable(false);
        this.tfSum.setFocusTraversable(false);
        this.tfSumWithDiscount.setFocusTraversable(false);
        this.tfSumWithVat.setFocusTraversable(false);
        this.tfVat.setFocusTraversable(false);
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        Platform.runLater(() -> this.btnSacuvaj.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvaj.fire()));
        Platform.runLater(() -> this.btnSacuvajNovo.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvajNovo.fire()));
        Platform.runLater(() -> this.btnNoviProizvod.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnNoviProizvod.fire()));
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
        DoubleTableCellFactory cellFactory2 = new DoubleTableCellFactory(2, true);
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit(cellEditEvent -> {
            PovratDetailes selectedTablePovrat = (PovratDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePovrat.setQuantity(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePovrat.setSum(selectedTablePovrat.getQuantity() * selectedTablePovrat.getPriceWithoutVatAndDiscount());
            selectedTablePovrat.setSumWithDiscount(selectedTablePovrat.getSum() - selectedTablePovrat.getSum() * selectedTablePovrat.getDiscount() / 100.0);
            selectedTablePovrat.setSumWithVat(selectedTablePovrat.getSumWithDiscount() * selectedTablePovrat.getVat());
            cellEditEvent.getTableColumn().getTableView().refresh();
        });
        this.tcPriceWithoutVatAndDiscount.setCellValueFactory((Callback)new PropertyValueFactory("PriceWithoutVatAndDiscount"));
        this.tcPriceWithoutVatAndDiscount.setCellFactory((Callback)cellFactory2);
        this.tcPriceWithoutVatAndDiscount.setOnEditCommit(cellEditEvent -> {
            PovratDetailes selectedTablePovrat = (PovratDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePovrat.setPrice((Double)cellEditEvent.getNewValue() * selectedTablePovrat.getVat());
            selectedTablePovrat.setPriceWithDiscount(selectedTablePovrat.getPrice() - selectedTablePovrat.getPrice() * selectedTablePovrat.getDiscount() / 100.0);
            selectedTablePovrat.setPriceWithoutVatAndDiscount(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePovrat.setSum(selectedTablePovrat.getQuantity() * selectedTablePovrat.getPriceWithoutVatAndDiscount());
            selectedTablePovrat.setSumWithDiscount(selectedTablePovrat.getSum() - selectedTablePovrat.getSum() * selectedTablePovrat.getDiscount() / 100.0);
            selectedTablePovrat.setSumWithVat(selectedTablePovrat.getSumWithDiscount() * selectedTablePovrat.getVat());
            selectedTablePovrat.setMargin((selectedTablePovrat.getNewSellPrice() - selectedTablePovrat.getPriceWithDiscount()) / selectedTablePovrat.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
        });
        this.tcSum.setCellValueFactory((Callback)new PropertyValueFactory("Sum"));
        this.tcSum.setCellFactory((Callback)cellFactory2);
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)cellFactory2);
        this.tcDiscount.setOnEditCommit(cellEditEvent -> {
            PovratDetailes selectedTablePovrat = (PovratDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePovrat.setDiscount(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePovrat.setPriceWithDiscount(selectedTablePovrat.getPrice() - selectedTablePovrat.getPrice() * selectedTablePovrat.getDiscount() / 100.0);
            selectedTablePovrat.setSumWithDiscount(selectedTablePovrat.getSum() - selectedTablePovrat.getSum() * selectedTablePovrat.getDiscount() / 100.0);
            selectedTablePovrat.setSumWithVat(selectedTablePovrat.getSumWithDiscount() * selectedTablePovrat.getVat());
            selectedTablePovrat.setMargin((selectedTablePovrat.getNewSellPrice() - selectedTablePovrat.getPriceWithDiscount()) / selectedTablePovrat.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
        });
        this.tcSumWithDiscount.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcSumWithDiscount.setCellFactory((Callback)cellFactory2);
        Settings.makeHeaderWrappable(this.tcSumWithDiscount);
        this.tcVat.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcVat.setCellFactory((Callback)new Callback<TableColumn<PovratDetailes, Product>, TableCell<PovratDetailes, Product>>(){

            public TableCell<PovratDetailes, Product> call(TableColumn<PovratDetailes, Product> param) {
                return new TableCell<PovratDetailes, Product>(){

                    protected void updateItem(Product item, boolean arg1) {
                        super.updateItem((java.lang.Object)item, arg1);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(item.getVatName());
                        }
                    }
                };
            }
        });
        this.tcSumWithVat.setCellValueFactory((Callback)new PropertyValueFactory("SumWithVat"));
        this.tcSumWithVat.setCellFactory((Callback)cellFactory2);
        Settings.makeHeaderWrappable(this.tcSumWithVat);
        this.tcSellPrice.setCellValueFactory((Callback)new PropertyValueFactory("NewSellPrice"));
        this.tcSellPrice.setCellFactory((Callback)cellFactory2);
        this.tcSellPrice.setOnEditCommit(cellEditEvent -> {
            PovratDetailes selectedTablePovrat = (PovratDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePovrat.setNewSellPrice(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePovrat.setMargin((selectedTablePovrat.getNewSellPrice() - selectedTablePovrat.getPriceWithDiscount()) / selectedTablePovrat.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
        });
        Settings.makeHeaderWrappable(this.tcSellPrice);
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void actionSave(ActionEvent event) {
        if (this.povrat.getDocumentID() == -1L && Povrat.exists((String)this.tfExternalNumber.getText(), (ScreensController)this.controller)) {
            this.controller.alert("Povratnica ve\u0107 postoji", "Povratnica sa unetim brojem ve\u0107 postoji", this.rootPane.getScene().getWindow());
            return;
        }
        try {
            int i;
            this.controller.getSettings().getConnection().setAutoCommit(false);
            this.povrat.setNumber(Integer.parseInt(this.tfNumber.getText()));
            this.povrat.setDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpDate.getDateTimeValue()));
            this.povrat.setDeliveryDate(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue())));
            this.povrat.setPaymentDate(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpCurrencyDate.getValue())));
            this.povrat.setDobavljac((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex()));
            this.povrat.setPlace(this.tfPlace.getText());
            this.povrat.setDocumentStatus((DocumentStatus)this.cbStatus.getSelectionModel().getSelectedItem());
            this.povrat.setComment(this.tfNapomena.getText());
            this.povrat.setExternalNumber(this.tfExternalNumber.getText());
            if (this.povrat.getDocumentID() > 0L) {
                this.povrat.update(this.controller);
            } else {
                this.povrat.insertPovrat(this.controller);
            }
            for (i = 0; i < this.deletedItems.size(); ++i) {
                if (this.deletedItems.get(i).getDocumentDetailsID() > 0L) {
                    this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
                    continue;
                }
                this.deletedItems.remove(i);
            }
            for (i = 0; i < this.tablePovratDetails.getItems().size(); ++i) {
                PovratDetailes tableItem = (PovratDetailes)this.tablePovratDetails.getItems().get(i);
                if (tableItem.getDocumentDetailsID() > 0L) {
                    if (tableItem.getProduct() == null) continue;
                    tableItem.updateWithDiscount(this.controller);
                    continue;
                }
                if (tableItem.getProduct() == null) continue;
                tableItem.setDocumentID(this.povrat.getDocumentID());
                Long id = tableItem.insertWithDiscount(this.controller);
                tableItem.setDocumentDetailsID(id.longValue());
            }
            this.controller.getSettings().getConnection().commit();
            if ((Button)event.getSource() == this.btnSacuvajNovo) {
                this.modalResult = ScreensController.MODAL_RESULT_OK_NEW;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            } else {
                this.modalResult = ScreensController.MODAL_RESULT_OK;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            }
        }
        catch (SQLException e) {
            try {
                this.controller.getSettings().getConnection().rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            try {
                this.controller.getSettings().getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionAdd(ActionEvent event) {
    }

    public void actionAddPovratDetails(ActionEvent event) {
        PovratDetailes povratDetails = new PovratDetailes();
        povratDetails.setDocumentDetailsID(-1L);
        povratDetails.setProduct(this.pd.getProduct());
        povratDetails.setProductID(this.pd.getProductID());
        povratDetails.setProductCode(this.pd.getProductCode());
        povratDetails.setProductName(this.pd.getProductName());
        povratDetails.setQuantity(this.pd.getQuantity());
        povratDetails.setPriceWithoutVatAndDiscount(this.pd.getPrice() / this.pd.getVat());
        povratDetails.setPrice(this.pd.getPrice());
        povratDetails.setPriceWithDiscount(this.pd.getPriceWithDiscount());
        povratDetails.setSum(this.pd.getSum());
        povratDetails.setDiscount(this.pd.getDiscount());
        povratDetails.setSumWithDiscount(this.pd.getSumWithDiscount());
        povratDetails.setVat(this.pd.getVat());
        povratDetails.setSumWithVat(this.pd.getSumWithVat());
        povratDetails.setNewSellPrice(this.pd.getNewSellPrice());
        povratDetails.setSellPrice(this.pd.getSellPrice());
        povratDetails.setMargin(this.pd.getMargin());
        povratDetails.setPurchasePrice(this.pd.getPurchasePrice());
        this.tablePovratDetails.getItems().add((java.lang.Object)povratDetails);
        this.pd = new PovratDetailes();
        this.cbProduct.getSelectionModel().clearSelection();
        this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfPriceWithoutVatAndDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfSum.setText("");
        this.tfDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfSumWithDiscount.setText("");
        this.tfVat.setText("");
        this.tfSumWithVat.setText("");
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
    }

    @FXML
    public void actionNewProduct(ActionEvent event) {
        if (this.department != null) {
            HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
            hm2.put("controller", this.controller);
            int result = this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm2, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                // empty if block
            }
        }
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.tablePovratDetails.getSelectionModel().getSelectedItem() != null) {
            this.deletedItems.add((PovratDetailes)this.tablePovratDetails.getSelectionModel().getSelectedItem());
            this.tablePovratDetails.getItems().remove(this.tablePovratDetails.getSelectionModel().getSelectedItem());
        }
    }

    private void setDobavljac(Person dobavlac) {
        if (dobavlac != null) {
            for (Person p : this.cbPerson.getItems()) {
                if (p.getPersonID() != this.povrat.getDobavljac().getPersonID()) continue;
                this.cbPerson.getSelectionModel().select((java.lang.Object)p);
                break;
            }
        }
    }

    private void setStatus(DocumentStatus status) {
        if (this.povrat.getDocumentStatus() == null) {
            this.povrat.setDocumentStatus((DocumentStatus)this.cbStatus.getItems().get(0));
        }
        for (DocumentStatus ds : this.cbStatus.getItems()) {
            if (ds.getDocumentStatusID() != this.povrat.getDocumentStatus().getDocumentStatusID()) continue;
            this.cbStatus.getSelectionModel().select((java.lang.Object)ds);
            break;
        }
    }

    @FXML
    private void actionImport() {
    }

    public ComboBox<DocumentStatus> getCbStatus() {
        return this.cbStatus;
    }

    private void izracunajUkupno() {
        double sum = this.pd.getQuantity() * this.pd.getPrice() / this.pd.getVat();
        double sumWithDiscount = sum - sum * this.pd.getDiscount() / 100.0;
        double sumWithVat = sumWithDiscount * this.pd.getVat();
        this.pd.setPriceWithDiscount(sumWithVat / this.pd.getQuantity());
        double margin = (this.pd.getNewSellPrice() - this.pd.getPriceWithDiscount()) / this.pd.getPriceWithDiscount() * 100.0;
        this.pd.setMargin(margin);
        this.pd.setSum(sum);
        this.pd.setSumWithDiscount(sumWithDiscount);
        this.pd.setSumWithVat(sumWithVat);
        this.tfSum.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sum));
        this.tfSumWithDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumWithDiscount));
        this.tfSumWithVat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumWithVat));
    }
}

